/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.oracle.bmc.http.client.pki.Pem;
import com.oracle.bmc.http.client.pki.PemEncryptionException;
import com.oracle.bmc.http.client.pki.PemException;
import com.oracle.bmc.http.signing.internal.KeySupplier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Optional;

class PEMStreamRSAPrivateKeySupplier
implements KeySupplier<RSAPrivateKey> {
    private final Optional<RSAPrivateKey> privateKey;

    public PEMStreamRSAPrivateKeySupplier(@Nonnull InputStream inputStream, @Nullable char[] passphrase) throws IOException {
        block16: {
            try (ReadableByteChannel channel = Channels.newChannel(inputStream);
                 Pem.Passphrase pemPassphrase = Pem.Passphrase.of((char[])passphrase);){
                PrivateKey privateKey = Pem.decoder().with(pemPassphrase).decodePrivateKey(channel);
                if (privateKey instanceof RSAPrivateKey) {
                    this.privateKey = Optional.of((RSAPrivateKey)privateKey);
                    break block16;
                }
                throw new IllegalStateException(privateKey.toString());
            }
            catch (PemEncryptionException e) {
                throw new IllegalArgumentException("The provided passphrase is incorrect.", e);
            }
            catch (PemException e) {
                throw new IllegalArgumentException("Private key must be in PEM format", e);
            }
        }
    }

    @Override
    public Optional<RSAPrivateKey> supplyKey(String keyId) {
        return this.privateKey;
    }
}

