/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.change;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.List;

public class Undo {
    private static int maximumBatches = User.getMaxUndoHistory();
    private static final List<ChangeBatch> doneList = new ArrayList<ChangeBatch>();
    private static final List<ChangeBatch> undoneList = new ArrayList<ChangeBatch>();

    public static int endChanges(Snapshot oldSnapshot, Tool tool, String activity, Snapshot newSnapshot) {
        int highlights = Job.getExtendedUserInterface().saveHighlights();
        int oldId = oldSnapshot.snapshotId;
        int newId = newSnapshot.snapshotId;
        while (!doneList.isEmpty() && Undo.doneList.get((int)(Undo.doneList.size() - 1)).newSnapshotId != oldId) {
            doneList.remove(doneList.size() - 1);
        }
        while (!undoneList.isEmpty() && Undo.undoneList.get((int)0).oldSnapshotId != oldId) {
            undoneList.remove(0);
        }
        int doneIndex = Undo.indexOf(doneList, newId);
        int undoneIndex = Undo.indexOf(undoneList, newId);
        if (doneIndex >= 0) {
            while (doneList.size() > doneIndex) {
                ChangeBatch batch = doneList.remove(doneList.size() - 1);
                System.out.println("Undoing: " + batch.activity);
                batch.preUndoHighlights = highlights;
                highlights = batch.startingHighlights;
                undoneList.add(0, batch);
            }
            Job.getExtendedUserInterface().restoreHighlights(highlights);
        } else if (undoneIndex >= 0) {
            for (int i = 0; i < undoneIndex; ++i) {
                ChangeBatch batch = undoneList.remove(0);
                System.out.println("Redoing: " + batch.activity);
                batch.startingHighlights = highlights;
                highlights = batch.preUndoHighlights;
                doneList.add(batch);
            }
            Job.getExtendedUserInterface().restoreHighlights(highlights);
        } else {
            undoneList.clear();
            doneList.add(new ChangeBatch(oldSnapshot, tool, activity, highlights, newSnapshot));
            highlights = -1;
        }
        Undo.updateUndoRedo();
        return highlights;
    }

    private static void invalidate(int snapshotId) {
        int doneIndex = Undo.indexOf(doneList, snapshotId);
        int undoneIndex = Undo.indexOf(undoneList, snapshotId);
        if (doneIndex >= 0) {
            if (doneIndex == 0) {
                doneList.clear();
            } else {
                while (doneList.size() >= doneIndex) {
                    doneList.remove(doneList.size() - 1);
                }
            }
        }
        if (undoneIndex >= 0) {
            if (undoneIndex == undoneList.size()) {
                undoneList.clear();
            } else {
                for (int i = 0; i < undoneIndex; ++i) {
                    if (undoneList.isEmpty()) continue;
                    undoneList.remove(0);
                }
            }
        }
        Undo.updateUndoRedo();
    }

    private static int indexOf(List<ChangeBatch> list, int snapshotId) {
        for (int i = 0; i < list.size(); ++i) {
            ChangeBatch batch = list.get(i);
            if (batch.oldSnapshotId == snapshotId) {
                return i;
            }
            if (batch.newSnapshotId != snapshotId) continue;
            return i + 1;
        }
        return -1;
    }

    private static void updateUndoRedo() {
        Cell cell = Job.getUserInterface().getCurrentCell();
        if (cell != null && cell.getView().isTextView()) {
            return;
        }
        Job.getExtendedUserInterface().showUndoRedoStatus(!doneList.isEmpty(), !undoneList.isEmpty());
    }

    public static String getUndoActivity() {
        if (!doneList.isEmpty()) {
            return Undo.doneList.get((int)(Undo.doneList.size() - 1)).activity;
        }
        System.out.println("Nothing left to undo");
        return "";
    }

    public static void removeLastChangeBatchTask() {
        if (!doneList.isEmpty()) {
            ChangeBatch task = doneList.get(doneList.size() - 1);
            Undo.invalidate(task.oldSnapshotId);
        }
    }

    public static void undo() {
        if (!doneList.isEmpty()) {
            new UndoJob("Undo", Undo.doneList.get((int)(Undo.doneList.size() - 1)).oldSnapshotId);
        } else {
            System.out.println("Undo failed");
        }
    }

    public static void redo() {
        if (!undoneList.isEmpty()) {
            new UndoJob("Redo", Undo.undoneList.get((int)0).newSnapshotId);
        } else {
            System.out.println("Redo failed");
        }
    }

    public static void noRedoAllowed() {
        undoneList.clear();
        Undo.updateUndoRedo();
    }

    public static int setHistoryListSize(int newSize) {
        if (newSize <= 0) {
            return maximumBatches;
        }
        int oldSize = maximumBatches;
        maximumBatches = newSize;
        if (doneList.size() > maximumBatches) {
            doneList.remove(0);
        }
        Undo.updateUndoRedo();
        return oldSize;
    }

    public static void showHistoryList() {
        ChangeBatch batch;
        int i;
        System.out.println("----------  Done batches (" + doneList.size() + ") ----------:");
        for (i = 0; i < doneList.size(); ++i) {
            batch = doneList.get(i);
            batch.describe("Done");
        }
        System.out.println("----------  Undone batches (" + undoneList.size() + ") ----------:");
        for (i = 0; i < undoneList.size(); ++i) {
            batch = undoneList.get(i);
            batch.describe("Undone");
        }
    }

    private static class ChangeBatch {
        private int oldSnapshotId;
        private int newSnapshotId;
        private Tool tool;
        private String activity;
        private int startingHighlights = -1;
        private int preUndoHighlights = -1;

        private ChangeBatch(Snapshot oldSnapshot, Tool tool, String activity, int startingHighlights, Snapshot newSnapshot) {
            this.oldSnapshotId = oldSnapshot.snapshotId;
            this.tool = tool;
            this.activity = activity;
            this.startingHighlights = startingHighlights;
            this.newSnapshotId = newSnapshot.snapshotId;
        }

        private void describe(String title) {
            Object activityFromTool = this.activity;
            if (this.tool != null) {
                activityFromTool = (String)activityFromTool + " from " + this.tool.getName() + " tool";
            }
            String message = "*** Batch '" + title + "', " + this.oldSnapshotId + "->" + this.newSnapshotId + " (" + (String)activityFromTool + ")";
            System.out.println(message);
        }
    }

    public static class UndoJob
    extends Job {
        int snapshotId;

        public UndoJob(String jobName, int snapshotId) {
            super(jobName, User.getUserTool(), Job.Type.UNDO, null, null, Job.Priority.USER);
            this.snapshotId = snapshotId;
            this.startJob();
        }

        public int getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public boolean doIt() throws JobException {
            throw new IllegalStateException();
        }

        @Override
        public void terminateFail(Throwable e) {
            Undo.invalidate(this.snapshotId);
            super.terminateFail(e);
        }
    }
}

