<?php
/**
 * $Horde: kronolith/week.php,v 1.26 2003/06/16 23:17:34 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/WeekView.php';

$week = Horde::getFormData('week');
$year = Horde::getFormData('year');
if ($timestamp = Horde::getFormData('timestamp')) {
    $year = date('Y', $timestamp);
    $week = Kronolith::weekOfYear(date('d', $timestamp), date('m', $timestamp), $year);
}

if ($prefs->getValue('week_start_monday')) {
    $weekOb = new Kronolith_WeekView($week, $year);
} else {
    $weekOb = new Kronolith_WeekView($week, $year, -1, 5);
}
$title = sprintf(_("Week %d"), $weekOb->week);

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (boolean)Horde::getFormData('print');
if ($print_view) {
    require_once $registry->getParam('templates', 'horde') . '/javascript/print.js';
} else {
    $print_link = Horde::addParameter('week.php', 'week', $week);
    $print_link = Horde::addParameter($print_link, 'year', $year);
    $print_link = Horde::addParameter($print_link, 'print', 'true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        require_once $registry->getParam('templates', 'horde') . '/javascript/open_print_win.js';
    }

    Kronolith::menu();
}

$weekOb->html(KRONOLITH_TEMPLATES);

require KRONOLITH_TEMPLATES . '/common-footer.inc';
