<?php
// $Horde: mnemo/config/prefs.php.dist,v 1.15 2003/05/08 13:38:22 chuck Exp $

// Make sure that constants are defined.
@define('MNEMO_BASE', dirname(__FILE__) . '/..');
require_once MNEMO_BASE . '/lib/Mnemo.php';

$prefGroups['language'] = array(
    'column' => _("Your Information"),
    'label' => _("Language"),
    'desc' => _("Set the your preferred display language."),
    'members' => array('language'));

$prefGroups['display'] = array(
    'column' => _("Other Options"),
    'label' => _("Display Options"),
    'desc' => _("Change your note sorting and display options."),
    'members' => array('sortby', 'sortdir', 'summary_show_colors', 'showsummaryselect'));

$prefGroups['share'] = array(
    'column' => _("Other Options"),
    'label' => _("Notepads"),
    'desc' => _("Manage multiple notepads."),
    'members' => array('notepadselect')
);
if (Auth::getAuth()) {
    $prefGroups['share']['members'][] = 'notepads_link';
}

if (Auth::getAuth()) {
    $prefGroups['category_management'] = array(
        'column'  => _("Other Options"),
        'label'   => _("Category Management"),
        'desc'    => _("Add, remove, and edit categories."),
        'members' => array('category_management', 'default_note_category')
    );
}


// user language
$_prefs['language'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Select your preferred language:"));

// user preferred sorting column
$_prefs['sortby'] = array(
    'value' => MNEMO_SORT_DESC,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(MNEMO_SORT_DESC => _("Note Text"),
                    MNEMO_SORT_CATEGORY => _("Note Category")),
    'desc' => _("Default sorting criteria:"));

// user preferred sorting direction
$_prefs['sortdir'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(MNEMO_SORT_ASCEND => _("Ascending"),
                    MNEMO_SORT_DESCEND => _("Descending")),
    'desc' => _("Default sorting direction:"));

// user note categories
$_prefs['memo_categories'] = array(
    'value' => '1:Personal|2:Business',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// category highlight colors
$_prefs['memo_colors'] = array(
    'value' => '1:#ffffff|2:#ffffff',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit',
    'desc' => _("Choose Color"));

// show highlight colors in summary
$_prefs['summary_show_colors'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show highlight colors in the summary view?"));

// allow removal of categories
$_prefs['category_management'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'special',
    'desc' => _("Category Management"));

$_prefs['default_note_category'] = array(
    'value' => '0',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Default note category"));

// default notepad selection widget
$_prefs['notepadselect'] = array('type' => 'special');

// default notepad
// Set locked to true if you don't want users to have multiple notepads.
$_prefs['default_notepad'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

$_prefs['showsummaryselect'] = array('type' => 'special');

$_prefs['summary_categories'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// Link to the notepad management
if (Auth::getAuth()) {
    $_prefs['notepads_link'] = array(
        'type' => 'link',
        'url' => 'notepads.php',
        'img' => 'mnemo.gif',
        'desc' => _("Edit your notepads.")
    );
}

// store the notepads to diplay
$_prefs['display_notepads'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');
