<?php
// $Horde: moment/config/prefs.php.dist,v 1.7 2003/03/04 20:49:04 chuck Exp $

// Make sure that constants are defined.
@define('MOMENT_BASE', dirname(__FILE__) . '/..');
require_once MOMENT_BASE . '/lib/Moment.php';

$prefGroups['language'] = array(
    'column' => _("Your Information"),
    'label' => _("Language"),
    'desc' => _("Set the your preferred display language."),
    'members' => array('language'));

$prefGroups['display_datetime'] = array(
    'column' => _("Display Options"),
    'label' => _("Date and Time Options"),
    'desc' => _("Change the way dates and times are formatted."),
    'members' => array('date_format', 'twentyFour'));

$prefGroups['display'] = array(
    'column' => _("Display Options"),
    'label' => _("View Options"),
    'desc' => _("Change what you can see."),
    'members' => array('show_legend', 'show_completed', 'sortby', 'sortdir'));

// user language
$_prefs['language'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Select your preferred language:"));


// date format
$_prefs['date_format'] = array(
    'value' => '%A %B %d, %Y',
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array('%A %B %d, %Y' => strftime('%A %B %d, %Y'),
                    '%A, %d. %B %Y' => strftime('%A, %d. %B %Y'),
                    '%A, %d %B %Y' => strftime('%A, %d %B %Y'),
                    '%x' => strftime('%x')),
    'desc' => _("Select how to display Dates:"));

// time format
$_prefs['twentyFour'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Display 24-hour times?"));

// show free busy legend?
// a value of 0 =no, 1 = yes
$_prefs['show_legend'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show legend in the schedule views?"));

// show complete/incomplete meetings?
$_prefs['show_completed'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(1 => _("All meetings"),
                    0 => _("Incomplete meetings"),
                    2 => _("Complete meetings")),
    'desc' => _("Show complete, incomplete, or all meetings in the meetings list?"));

// user preferred sorting column
$_prefs['sortby'] = array(
    'value' => MOMENT_SORT_START,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(MOMENT_SORT_TITLE => _("Meeting Name"),
                    MOMENT_SORT_LOCATION => _("Location"),
                    MOMENT_SORT_START => _("Start Time/Date")),
    'desc' => _("Default sorting criteria:"));

// user preferred sorting direction
$_prefs['sortdir'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(MOMENT_SORT_ASCEND => _("Ascending"),
                    MOMENT_SORT_DESCEND => _("Descending")),
    'desc' => _("Default sorting direction:"));

// number of seconds to cache free/busy information in cache
$_prefs['cache_time'] = array(
    'value' => 900,
    'locked' => true,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(0 => _("Never"),
                    30 => _("Every 30 seconds"),
                    60 => _("Every minute"),
                    300 => _("Every 5 minutes"),
                    900 => _("Every 15 minutes"),
                    1800 => _("Every half hour")),
    'desc' => _("Number of seconds to store free/busy info in cache:"));
