<?php
// $Horde: nag/config/prefs.php.dist,v 1.30 2003/06/04 19:29:51 chuck Exp $

// Make sure that constants are defined.
@define('NAG_BASE', dirname(__FILE__) . '/..');
require_once NAG_BASE . '/lib/Nag.php';

$prefGroups['language'] = array(
    'column' => _("General Options"),
    'label' => _("Language"),
    'desc' => _("Set the your preferred display language."),
    'members' => array('language')
);

$prefGroups['display'] = array(
    'column' => _("General Options"),
    'label' => _("Display Options"),
    'desc' => _("Change your task sorting and display options."),
    'members' => array('sortby', 'sortdir')
);

$prefGroups['summary'] = array(
    'column' => _("General Options"),
    'label' => _("Summary Options"),
    'desc' => _("Change your summary display options."),
    'members' => array('summary_show_priorities', 'summary_show_actions',
                       'summary_show_due', 'summary_show_owner',
                       'showsummaryselect','summary_due_format')
);

$prefGroups['share'] = array(
    'column' => _("Task List and Share Options"),
    'label' => _("Task Lists"),
    'desc' => _("Manage multiple task lists."),
    'members' => array('tasklistselect')
);
if (Auth::getAuth()) {
    $prefGroups['share']['members'][] = 'tasklists_link';
}

if (Auth::getAuth()) {
    $prefGroups['category_management'] = array(
        'column'  => _("Task List and Share Options"),
        'label'   => _("Category Management"),
        'desc'    => _("Allows categories to be added/removed/renamed."),
        'members' => array('category_management', 'default_task_category')
    );
}

$_show_external = array();
//if ($GLOBALS['registry']->hasMethod('getListTypes', 'whups')) {
//    $_show_external['whups'] = $GLOBALS['registry']->getParam('name', 'whups');
//}
if (count($_show_external)) {
    $prefGroups['external'] = array(
        'column'  => _("Task List and Share Options"),
        'label'   => _("External Data"),
        'desc'    => _("Show data from other applications or sources."),
        'members' => array('show_external')
    );
}

// user language
$_prefs['language'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Select your preferred language:")
);

// user preferred sorting column
$_prefs['sortby'] = array(
    'value' => NAG_SORT_PRIORITY,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(NAG_SORT_PRIORITY => _("Priority"),
                    NAG_SORT_NAME => _("Task Name"),
                    NAG_SORT_CATEGORY => _("Category"),
                    NAG_SORT_DUE => _("Due Date"),
                    NAG_SORT_COMPLETION => _("Completed?"),
                    NAG_SORT_OWNER => _("Owner")),
    'desc' => _("Default sorting criteria:")
);

// user preferred sorting direction
$_prefs['sortdir'] = array(
    'value' => NAG_SORT_ASCEND,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(NAG_SORT_ASCEND => _("Ascending"),
                    NAG_SORT_DESCEND => _("Descending")),
    'desc' => _("Default sorting direction:")
);

// show data from other applications that can be listed as tasks?
if (count($_show_external)) {
    $_prefs['show_external'] = array(
        'value' => 'a:0:{}',
        'locked' => false,
        'shared' => false,
        'type' => 'multienum',
        'enum' => $_show_external,
        'desc' => _("Show data from any of these other applications in your task list?")
    );
}

// show complete/incomplete tasks?
$_prefs['show_completed'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(1 => _("All tasks"),
                    0 => _("Incomplete tasks"),
                    2 => _("Complete tasks")),
    'desc' => _("Show complete, incomplete, or all tasks in the task list?")
);

// show priorities in summary?
$_prefs['summary_show_priorities'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show priorities in the summary view?")
);

// show actions (modify/complete task) in summary?
$_prefs['summary_show_actions'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show actions (modify/complete task) in the summary view?")
);

// show due dates in summary?
$_prefs['summary_show_due'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show due dates in the summary view?")
);

// show task list name in summary?
$_prefs['summary_show_owner'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show owner in the summary view?")
);

$_prefs['showsummaryselect'] = array('type' => 'special');

$_prefs['summary_categories'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit'
);

// user task categories
$_prefs['task_categories'] = array(
    'value' => '1:Personal|2:Business',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit'
);

// allow category management
$_prefs['category_management'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'special',
    'desc' => _("Category Management"));

// select default task category
$_prefs['default_task_category'] = array(
    'value' => '0',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Default task category")
);

// default tasklist selection widget
$_prefs['tasklistselect'] = array('type' => 'special');

// default tasklists
// Set locked to true if you don't want users to have multiple tasklists.
$_prefs['default_tasklist'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => true,
    'type' => 'implicit'
);

// Link to the task list management
if (Auth::getAuth()) {
    $_prefs['tasklists_link'] = array(
        'type' => 'link',
        'url' => 'tasklists.php',
        'img' => 'nag.gif',
        'desc' => _("Edit your task lists.")
    );
}

// store the tasklists to diplay
$_prefs['display_tasklists'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit'
);

// summary date format
$_prefs['summary_due_format'] = array(
    'value' => '%a %d %b %H:%M',
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array('%a %d %b %H:%M' => strftime('%a %d %b %H:%M'),
                    '%a %d/%m' => strftime('%a %d/%m'),
                    '%a %d/%m %H:%M' => strftime('%a %d/%m %H:%M'),
                    '%x %X' => strftime('%x %X'),
                    '%c' => strftime('%c')),
    'desc' => _("Select how to display Dates:")
);
