<?php
/* $Horde: vacation/lib/api.php,v 1.5 2003/09/01 21:37:16 jan Exp $
 *
 * Vacation external API interface.
 *
 * This file defines Vacation's external API interface. Other
 * applications can interact with Vacation through this API.
 *
 * @author  Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @author  Diego Rivera <lrivera@racsa.co.cr>
 * @version $Revision: 1.5 $
 * @package Vacation
 */

// Find the base file paths for Vacation
@define('VACATION_BASE', dirname(__FILE__) . '/..');

$_services['summary'] = array(
  'args' => array(),
  'type' => 'string'
);

function _vacation_summary()
{
    global $registry, $conf;

    // Include the necessary libraries.
    require_once VACATION_BASE . '/lib/base.php';
    require_once VACATION_BASE . '/lib/Driver.php';

    // Get the current login credentials
    $splitted = explode('@', Auth::getAuth());
    $user = @$splitted[0];
    $realm = @$splitted[1];
    $pass = Auth::getCredential('password');

    // Create the driver
    $driver = &Vacation_Driver::factory();

    // find out if it is activated or not...
    if (!isset($driver))
    {
        $content = _("Failed to create a vacation driver");
    }
    else
    {
        $content = (!$driver->isEnabled($user, $realm, $pass)
          ?  _("Vacation is not active.")
          :  _("Vacation is active.")
        );
    }

    // Build and return the html for the summary page
    $html  = '<table border="0" cellpadding="2" cellspacing="0" width="100%"><tr><td class="header">';
    $html .= Horde::link(Horde::url($registry->getInitialPage()), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a>';
    $html .= '</td></tr>';
    $html .= '<tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';
    $html .= '<tr><td class="text" nowrap="nowrap" valign="top"><b>';
    $html .= $content;
    $html .= '</b></td></tr>';
    $html .= '</table></td></tr></table>';
    return $html;
}

?>
