/**
 * Copyright Marcus Britanicus <marcusbritanicus@gmail.com>
 *
 * This file is a part of LibDesQ (https://gitlab.com/DesQ/libdesq)
 * This library contains various  Core and Gui classes which are used
 * through out the DesQ Project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * at your option, any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 **/

#pragma once

/** Current Version of DesQ */
#define DESQ_VERSION_STR    "0.0.7"

/** The root directory to which was DesQ installed */
#define InstallPrefix       "/usr/"

/** Location where system-wide shared data is available */
#define SharePath           "/usr/share/desq/"

/** Location where global config will be stored */
#define ConfigPath          "/usr/share/desq/configs/"

/** Location where plugin and other metadata will be stored */
#define MetadataPath        "/usr/share/desq/metadata/"

/** Location where plugins are installed */
#define PluginPath          "/usr/lib/desq/plugins/"

/** Location where DesQ utilities are installed */
#define UtilsPath           "/usr/lib/libexec/desq/"
