# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "servicebus topic subscription update",
)
class Update(AAZCommand):
    """Update a topic subscription.
    """

    _aaz_info = {
        "version": "2022-01-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.servicebus/namespaces/{}/topics/{}/subscriptions/{}", "2022-01-01-preview"],
        ]
    }

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.namespace_name = AAZStrArg(
            options=["--namespace-name"],
            help="The namespace name",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                max_length=50,
                min_length=6,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.subscription_name = AAZStrArg(
            options=["-n", "--name", "--subscription-name"],
            help="The subscription name.",
            required=True,
            id_part="child_name_2",
            fmt=AAZStrArgFormat(
                max_length=50,
                min_length=1,
            ),
        )
        _args_schema.topic_name = AAZStrArg(
            options=["--topic-name"],
            help="The topic name.",
            required=True,
            id_part="child_name_1",
            fmt=AAZStrArgFormat(
                min_length=1,
            ),
        )

        # define Arg Group "ClientAffineProperties"

        _args_schema = cls._args_schema
        _args_schema.client_id = AAZStrArg(
            options=["--client-id"],
            arg_group="ClientAffineProperties",
            help="Indicates the Client ID of the application that created the client-affine subscription.",
            nullable=True,
        )
        _args_schema.is_durable = AAZBoolArg(
            options=["--is-durable"],
            arg_group="ClientAffineProperties",
            help="For client-affine subscriptions, this value indicates whether the subscription is durable or not.",
            nullable=True,
        )
        _args_schema.is_shared = AAZBoolArg(
            options=["--is-shared"],
            arg_group="ClientAffineProperties",
            help="For client-affine subscriptions, this value indicates whether the subscription is shared or not.",
            nullable=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.auto_delete_on_idle = AAZDurationArg(
            options=["--auto-delete-on-idle"],
            arg_group="Properties",
            help="ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.",
            nullable=True,
        )
        _args_schema.dead_letter_on_filter_exceptions = AAZBoolArg(
            options=["-f", "--dead-letter-on-filter-exceptions"],
            arg_group="Properties",
            help="Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.",
            nullable=True,
        )
        _args_schema.enable_dead_lettering_on_message_expiration = AAZBoolArg(
            options=["--message-expiration", "--enable-dead-lettering-on-message-expiration"],
            arg_group="Properties",
            help="A value that indicates whether this queue has dead letter support when a message expires.",
            nullable=True,
        )
        _args_schema.default_message_time_to_live = AAZDurationArg(
            options=["--default-message-time-to-live"],
            arg_group="Properties",
            help="ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.",
            nullable=True,
        )
        _args_schema.duplicate_detection_history_time_window = AAZDurationArg(
            options=["-d", "--duplicate-detection-history-time-window"],
            arg_group="Properties",
            help="ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.",
            nullable=True,
        )
        _args_schema.enable_batched_operations = AAZBoolArg(
            options=["--enable-batched-operations"],
            arg_group="Properties",
            help="Value that indicates whether server-side batched operations are enabled.",
            nullable=True,
        )
        _args_schema.forward_dead_lettered_messages_to = AAZStrArg(
            options=["--forward-dead-lettered-messages-to"],
            arg_group="Properties",
            help="Queue/Topic name to forward the Dead Letter message",
            nullable=True,
        )
        _args_schema.forward_to = AAZStrArg(
            options=["--forward-to"],
            arg_group="Properties",
            help="Queue/Topic name to forward the messages",
            nullable=True,
        )
        _args_schema.is_client_affine = AAZBoolArg(
            options=["--is-client-affine"],
            arg_group="Properties",
            help="Value that indicates whether the subscription has an affinity to the client id.",
            nullable=True,
        )
        _args_schema.lock_duration = AAZDurationArg(
            options=["--lock-duration"],
            arg_group="Properties",
            help="ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.",
            nullable=True,
        )
        _args_schema.max_delivery_count = AAZIntArg(
            options=["--max-delivery-count"],
            arg_group="Properties",
            help="Number of maximum deliveries.",
            nullable=True,
        )
        _args_schema.enable_session = AAZBoolArg(
            options=["--enable-session"],
            arg_group="Properties",
            help="A value that indicates whether the queue supports the concept of sessions.",
            nullable=True,
        )
        _args_schema.status = AAZStrArg(
            options=["--status"],
            arg_group="Properties",
            help="Enumerates the possible values for the status of a messaging entity.",
            nullable=True,
            enum={"Active": "Active", "Creating": "Creating", "Deleting": "Deleting", "Disabled": "Disabled", "ReceiveDisabled": "ReceiveDisabled", "Renaming": "Renaming", "Restoring": "Restoring", "SendDisabled": "SendDisabled", "Unknown": "Unknown"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SubscriptionsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        self.SubscriptionsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SubscriptionsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "namespaceName", self.ctx.args.namespace_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionName", self.ctx.args.subscription_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "topicName", self.ctx.args.topic_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_sb_subscription_read(cls._schema_on_200)

            return cls._schema_on_200

    class SubscriptionsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "namespaceName", self.ctx.args.namespace_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionName", self.ctx.args.subscription_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "topicName", self.ctx.args.topic_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_sb_subscription_read(cls._schema_on_200)

            return cls._schema_on_200

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("autoDeleteOnIdle", AAZStrType, ".auto_delete_on_idle")
                properties.set_prop("clientAffineProperties", AAZObjectType)
                properties.set_prop("deadLetteringOnFilterEvaluationExceptions", AAZBoolType, ".dead_letter_on_filter_exceptions")
                properties.set_prop("deadLetteringOnMessageExpiration", AAZBoolType, ".enable_dead_lettering_on_message_expiration")
                properties.set_prop("defaultMessageTimeToLive", AAZStrType, ".default_message_time_to_live")
                properties.set_prop("duplicateDetectionHistoryTimeWindow", AAZStrType, ".duplicate_detection_history_time_window")
                properties.set_prop("enableBatchedOperations", AAZBoolType, ".enable_batched_operations")
                properties.set_prop("forwardDeadLetteredMessagesTo", AAZStrType, ".forward_dead_lettered_messages_to")
                properties.set_prop("forwardTo", AAZStrType, ".forward_to")
                properties.set_prop("isClientAffine", AAZBoolType, ".is_client_affine")
                properties.set_prop("lockDuration", AAZStrType, ".lock_duration")
                properties.set_prop("maxDeliveryCount", AAZIntType, ".max_delivery_count")
                properties.set_prop("requiresSession", AAZBoolType, ".enable_session")
                properties.set_prop("status", AAZStrType, ".status")

            client_affine_properties = _builder.get(".properties.clientAffineProperties")
            if client_affine_properties is not None:
                client_affine_properties.set_prop("clientId", AAZStrType, ".client_id")
                client_affine_properties.set_prop("isDurable", AAZBoolType, ".is_durable")
                client_affine_properties.set_prop("isShared", AAZBoolType, ".is_shared")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_sb_subscription_read = None

    @classmethod
    def _build_schema_sb_subscription_read(cls, _schema):
        if cls._schema_sb_subscription_read is not None:
            _schema.id = cls._schema_sb_subscription_read.id
            _schema.location = cls._schema_sb_subscription_read.location
            _schema.name = cls._schema_sb_subscription_read.name
            _schema.properties = cls._schema_sb_subscription_read.properties
            _schema.system_data = cls._schema_sb_subscription_read.system_data
            _schema.type = cls._schema_sb_subscription_read.type
            return

        cls._schema_sb_subscription_read = _schema_sb_subscription_read = AAZObjectType()

        sb_subscription_read = _schema_sb_subscription_read
        sb_subscription_read.id = AAZStrType(
            flags={"read_only": True},
        )
        sb_subscription_read.location = AAZStrType(
            flags={"read_only": True},
        )
        sb_subscription_read.name = AAZStrType(
            flags={"read_only": True},
        )
        sb_subscription_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        sb_subscription_read.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        sb_subscription_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_sb_subscription_read.properties
        properties.accessed_at = AAZStrType(
            serialized_name="accessedAt",
            flags={"read_only": True},
        )
        properties.auto_delete_on_idle = AAZStrType(
            serialized_name="autoDeleteOnIdle",
        )
        properties.client_affine_properties = AAZObjectType(
            serialized_name="clientAffineProperties",
        )
        properties.count_details = AAZObjectType(
            serialized_name="countDetails",
        )
        properties.created_at = AAZStrType(
            serialized_name="createdAt",
            flags={"read_only": True},
        )
        properties.dead_lettering_on_filter_evaluation_exceptions = AAZBoolType(
            serialized_name="deadLetteringOnFilterEvaluationExceptions",
        )
        properties.dead_lettering_on_message_expiration = AAZBoolType(
            serialized_name="deadLetteringOnMessageExpiration",
        )
        properties.default_message_time_to_live = AAZStrType(
            serialized_name="defaultMessageTimeToLive",
        )
        properties.duplicate_detection_history_time_window = AAZStrType(
            serialized_name="duplicateDetectionHistoryTimeWindow",
        )
        properties.enable_batched_operations = AAZBoolType(
            serialized_name="enableBatchedOperations",
        )
        properties.forward_dead_lettered_messages_to = AAZStrType(
            serialized_name="forwardDeadLetteredMessagesTo",
        )
        properties.forward_to = AAZStrType(
            serialized_name="forwardTo",
        )
        properties.is_client_affine = AAZBoolType(
            serialized_name="isClientAffine",
        )
        properties.lock_duration = AAZStrType(
            serialized_name="lockDuration",
        )
        properties.max_delivery_count = AAZIntType(
            serialized_name="maxDeliveryCount",
        )
        properties.message_count = AAZIntType(
            serialized_name="messageCount",
            flags={"read_only": True},
        )
        properties.requires_session = AAZBoolType(
            serialized_name="requiresSession",
        )
        properties.status = AAZStrType()
        properties.updated_at = AAZStrType(
            serialized_name="updatedAt",
            flags={"read_only": True},
        )

        client_affine_properties = _schema_sb_subscription_read.properties.client_affine_properties
        client_affine_properties.client_id = AAZStrType(
            serialized_name="clientId",
        )
        client_affine_properties.is_durable = AAZBoolType(
            serialized_name="isDurable",
        )
        client_affine_properties.is_shared = AAZBoolType(
            serialized_name="isShared",
        )

        count_details = _schema_sb_subscription_read.properties.count_details
        count_details.active_message_count = AAZIntType(
            serialized_name="activeMessageCount",
            flags={"read_only": True},
        )
        count_details.dead_letter_message_count = AAZIntType(
            serialized_name="deadLetterMessageCount",
            flags={"read_only": True},
        )
        count_details.scheduled_message_count = AAZIntType(
            serialized_name="scheduledMessageCount",
            flags={"read_only": True},
        )
        count_details.transfer_dead_letter_message_count = AAZIntType(
            serialized_name="transferDeadLetterMessageCount",
            flags={"read_only": True},
        )
        count_details.transfer_message_count = AAZIntType(
            serialized_name="transferMessageCount",
            flags={"read_only": True},
        )

        system_data = _schema_sb_subscription_read.system_data
        system_data.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        _schema.id = cls._schema_sb_subscription_read.id
        _schema.location = cls._schema_sb_subscription_read.location
        _schema.name = cls._schema_sb_subscription_read.name
        _schema.properties = cls._schema_sb_subscription_read.properties
        _schema.system_data = cls._schema_sb_subscription_read.system_data
        _schema.type = cls._schema_sb_subscription_read.type


__all__ = ["Update"]
