/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeMember;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeMethodParameter;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeModifier;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityMethod;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSParametrizedObject;
import org.jkiss.utils.CommonUtils;

public class OracleDataTypeMethod
extends OracleDataTypeMember
implements DBSEntityMethod,
DBSParametrizedObject {
    private String methodType;
    private boolean flagFinal;
    private boolean flagInstantiable;
    private boolean flagOverriding;
    private OracleDataType resultType;
    private OracleDataTypeModifier resultTypeMod;
    private final ParameterCache parameterCache;

    public OracleDataTypeMethod(OracleDataType dataType) {
        super(dataType);
        this.parameterCache = new ParameterCache();
    }

    public OracleDataTypeMethod(DBRProgressMonitor monitor, OracleDataType dataType, ResultSet dbResult) {
        super(dataType, dbResult);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"METHOD_NAME");
        this.number = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"METHOD_NO");
        this.methodType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"METHOD_TYPE");
        this.flagFinal = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"FINAL", (String)"YES");
        this.flagInstantiable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"INSTANTIABLE", (String)"YES");
        this.flagOverriding = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"OVERRIDING", (String)"YES");
        boolean hasParameters = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PARAMETERS") > 0;
        this.parameterCache = hasParameters ? new ParameterCache() : null;
        String resultTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RESULT_TYPE_NAME");
        if (!CommonUtils.isEmpty((String)resultTypeName)) {
            this.resultType = OracleDataType.resolveDataType(monitor, this.getDataSource(), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RESULT_TYPE_OWNER"), resultTypeName);
            this.resultTypeMod = OracleDataTypeModifier.resolveTypeModifier(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RESULT_TYPE_MOD"));
        }
    }

    @Property(viewable=true, editable=true, order=5)
    public String getMethodType() {
        return this.methodType;
    }

    @Property(id="dataType", viewable=true, order=6)
    public OracleDataType getResultType() {
        return this.resultType;
    }

    @Property(id="dataTypeMod", viewable=true, order=7)
    public OracleDataTypeModifier getResultTypeMod() {
        return this.resultTypeMod;
    }

    @Property(viewable=true, order=8)
    public boolean isFinal() {
        return this.flagFinal;
    }

    @Property(viewable=true, order=9)
    public boolean isInstantiable() {
        return this.flagInstantiable;
    }

    @Property(viewable=true, order=10)
    public boolean isOverriding() {
        return this.flagOverriding;
    }

    @Nullable
    @Association
    public Collection<OracleDataTypeMethodParameter> getParameters(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.parameterCache == null ? null : this.parameterCache.getAllObjects(monitor, (DBSObject)this);
    }

    private class ParameterCache
    extends JDBCObjectCache<OracleDataTypeMethod, OracleDataTypeMethodParameter> {
        private ParameterCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataTypeMethod owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT PARAM_NAME,PARAM_NO,PARAM_MODE,PARAM_TYPE_OWNER,PARAM_TYPE_NAME,PARAM_TYPE_MOD FROM ALL_METHOD_PARAMS WHERE OWNER=? AND TYPE_NAME=? AND METHOD_NAME=? AND METHOD_NO=?");
            OracleDataType dataType = OracleDataTypeMethod.this.getOwnerType();
            if (dataType.getSchema() == null) {
                dbStat.setNull(1, 12);
            } else {
                dbStat.setString(1, dataType.getSchema().getName());
            }
            dbStat.setString(2, dataType.getName());
            dbStat.setString(3, OracleDataTypeMethod.this.getName());
            dbStat.setInt(4, OracleDataTypeMethod.this.getNumber());
            return dbStat;
        }

        protected OracleDataTypeMethodParameter fetchObject(@NotNull JDBCSession session, @NotNull OracleDataTypeMethod owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleDataTypeMethodParameter(session.getProgressMonitor(), OracleDataTypeMethod.this, (ResultSet)resultSet);
        }
    }
}

