/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.editors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2ExecutionContext;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2View;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class DB2StructureAssistant
implements DBSStructureAssistant<DB2ExecutionContext> {
    private static final Log LOG = Log.getLog(DB2StructureAssistant.class);
    private static final String WITH_UR = "WITH UR";
    private static final String LF = "\n";
    private static final DBSObjectType[] SUPP_OBJ_TYPES = new DBSObjectType[]{DB2ObjectType.ALIAS, DB2ObjectType.TABLE, DB2ObjectType.VIEW, DB2ObjectType.MQT, DB2ObjectType.NICKNAME, DB2ObjectType.COLUMN, DB2ObjectType.ROUTINE, DB2ObjectType.SCHEMA};
    private static final DBSObjectType[] HYPER_LINKS_TYPES = new DBSObjectType[]{DB2ObjectType.ALIAS, DB2ObjectType.TABLE, DB2ObjectType.VIEW, DB2ObjectType.MQT, DB2ObjectType.NICKNAME, DB2ObjectType.ROUTINE};
    private static final DBSObjectType[] AUTOC_OBJ_TYPES = new DBSObjectType[]{DB2ObjectType.ALIAS, DB2ObjectType.TABLE, DB2ObjectType.VIEW, DB2ObjectType.MQT, DB2ObjectType.NICKNAME, DB2ObjectType.ROUTINE};
    private static final String SQL_COLS_ALL;
    private static final String SQL_COLS_SCHEMA;
    private final DB2DataSource dataSource;

    public DB2StructureAssistant(DB2DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return SUPP_OBJ_TYPES;
    }

    @NotNull
    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return HYPER_LINKS_TYPES;
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return AUTOC_OBJ_TYPES;
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull DB2ExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        List<DBSObjectReference> list;
        block11: {
            DB2Schema schema;
            ArrayList<DB2ObjectType> db2ObjectTypes = new ArrayList<DB2ObjectType>(params.getObjectTypes().length);
            for (DBSObjectType dbsObjectType : params.getObjectTypes()) {
                if (dbsObjectType instanceof DB2ObjectType) {
                    db2ObjectTypes.add((DB2ObjectType)dbsObjectType);
                    continue;
                }
                if (dbsObjectType != RelationalObjectType.TYPE_PROCEDURE) continue;
                db2ObjectTypes.add(DB2ObjectType.ROUTINE);
            }
            DB2Schema dB2Schema = schema = params.getParentObject() instanceof DB2Schema ? (DB2Schema)params.getParentObject() : null;
            if (schema == null && !params.isGlobalSearch()) {
                schema = executionContext.getContextDefaults().getDefaultSchema();
            }
            JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by name");
            try {
                list = this.searchAllObjects(session, schema, db2ObjectTypes, params);
                if (session == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new DBDatabaseException((Throwable)ex, (DBPDataSource)this.dataSource);
                }
            }
            session.close();
        }
        return list;
    }

    private List<DBSObjectReference> searchAllObjects(JDBCSession session, DB2Schema schema, List<DB2ObjectType> db2ObjectTypes, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws SQLException, DBException {
        ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
        String searchObjectNameMask = params.getMask();
        if (!params.isCaseSensitive()) {
            searchObjectNameMask = searchObjectNameMask.toUpperCase();
        }
        int nbResults = 0;
        int maxResults = params.getMaxResults();
        if (db2ObjectTypes.stream().anyMatch(x -> DB2StructureAssistant.isTable(x) || x == DB2ObjectType.SCHEMA)) {
            this.searchTablesAndSchemas(session, (DBPNamedObject)schema, searchObjectNameMask, db2ObjectTypes, maxResults, objects, nbResults, params.isSearchInDefinitions());
            if (nbResults >= maxResults) {
                return objects;
            }
        }
        if (db2ObjectTypes.contains((Object)DB2ObjectType.COLUMN)) {
            this.searchColumns(session, schema, searchObjectNameMask, db2ObjectTypes, maxResults, objects, nbResults);
            if (nbResults >= maxResults) {
                return objects;
            }
        }
        if (db2ObjectTypes.contains((Object)DB2ObjectType.ROUTINE)) {
            this.searchRoutines(session, (DBPNamedObject)schema, searchObjectNameMask, db2ObjectTypes, maxResults, objects, nbResults, params.isSearchInDefinitions());
        }
        return objects;
    }

    private static boolean isTable(@Nullable DB2ObjectType objectType) {
        return objectType == DB2ObjectType.ALIAS || objectType == DB2ObjectType.TABLE || objectType == DB2ObjectType.NICKNAME || objectType == DB2ObjectType.VIEW || objectType == DB2ObjectType.MQT;
    }

    private void searchTablesAndSchemas(@NotNull JDBCSession session, @Nullable DBPNamedObject schema, @NotNull String mask, @NotNull List<DB2ObjectType> db2ObjectTypes, int maxResults, @NotNull Collection<? super DBSObjectReference> objects, int nbResults, boolean searchInDefinitions) throws SQLException, DBException {
        boolean isNeedSearchSchemas;
        Object sql = schema != null ? "SELECT TABSCHEMA,TABNAME,TYPE FROM SYSCAT.TABLES\nWHERE TABSCHEMA =? AND TABNAME LIKE ? AND TYPE IN (%s)" : "SELECT TABSCHEMA,TABNAME,TYPE FROM SYSCAT.TABLES\nWHERE TABNAME LIKE ? AND TYPE IN (%s)";
        sql = this.buildTableSQL((String)sql, db2ObjectTypes);
        if (searchInDefinitions) {
            StringBuilder query = new StringBuilder("\nUNION ALL\nSELECT\n\tt.TABSCHEMA,\n\tt.TABNAME,\n\tt.\"TYPE\"\nFROM\n\t\"SYSIBM\".SYSVIEWS v\nINNER JOIN SYSCAT.TABLES t ON\n\tv.NAME = t.TABNAME\nWHERE\n\tv.TEXT LIKE ?\n\tAND TYPE IN (%s)");
            if (schema != null) {
                query.append("\n\tAND TABSCHEMA = ?");
            }
            sql = (String)sql + this.buildTableSQL(query.toString(), db2ObjectTypes);
        }
        if (isNeedSearchSchemas = db2ObjectTypes.contains((Object)DB2ObjectType.SCHEMA)) {
            sql = (String)sql + "\nUNION ALL SELECT SCHEMANAME AS TABSCHEMA, NULL AS TABNAME, 'SCHEMA' AS TYPE FROM SYSCAT.SCHEMATA\nWHERE SCHEMANAME LIKE ?";
        }
        sql = (String)sql + "\nWITH UR";
        int n = 1;
        try (JDBCPreparedStatement dbStat = session.prepareStatement((String)sql);){
            if (schema != null) {
                dbStat.setString(n++, schema.getName());
            }
            dbStat.setString(n++, mask);
            if (searchInDefinitions) {
                dbStat.setString(n++, mask);
                if (schema != null) {
                    dbStat.setString(n++, schema.getName());
                }
            }
            if (isNeedSearchSchemas) {
                dbStat.setString(n, mask);
            }
            dbStat.setFetchSize(1000);
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    if (session.getProgressMonitor().isCanceled()) {
                        break;
                    }
                    if (nbResults++ >= maxResults) {
                        break;
                    }
                    String schemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABSCHEMA");
                    String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABNAME");
                    String typeObjectFromResultSet = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE");
                    DB2Schema db2Schema = this.dataSource.getSchema(session.getProgressMonitor(), schemaName);
                    if (db2Schema == null) {
                        LOG.trace((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    if (DB2ObjectType.SCHEMA.toString().equals(typeObjectFromResultSet)) {
                        objects.add((DBSObjectReference)new DB2ObjectReference(schemaName, (DBPDataSource)this.dataSource, DB2ObjectType.SCHEMA));
                        continue;
                    }
                    DB2TableType tableType = (DB2TableType)CommonUtils.valueOf(DB2TableType.class, (String)typeObjectFromResultSet);
                    DB2ObjectType objectType = tableType.getDb2ObjectType();
                    objects.add((DBSObjectReference)new DB2ObjectReference(objectName, db2Schema, objectType));
                }
            }
        }
    }

    private void searchRoutines(@NotNull JDBCSession session, @Nullable DBPNamedObject schema, @NotNull String mask, @NotNull List<DB2ObjectType> db2ObjectTypes, int maxResults, Collection<? super DBSObjectReference> objects, int nbResults, boolean searchInDefinitions) throws SQLException, DBException {
        StringBuilder baseSQL = new StringBuilder("SELECT ROUTINESCHEMA, ROUTINENAME\nFROM SYSCAT.ROUTINES\nWHERE\n");
        if (schema != null) {
            baseSQL.append("ROUTINESCHEMA = ? AND ");
        }
        if (searchInDefinitions) {
            baseSQL.append("(TEXT LIKE ? OR ");
        }
        baseSQL.append("ROUTINENAME LIKE ?");
        if (searchInDefinitions) {
            baseSQL.append(")");
        }
        baseSQL.append("\nWITH UR");
        String sql = this.buildTableSQL(baseSQL.toString(), db2ObjectTypes);
        int n = 1;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            if (schema != null) {
                dbStat.setString(n++, schema.getName());
            }
            dbStat.setString(n++, mask);
            if (searchInDefinitions) {
                dbStat.setString(n, mask);
            }
            dbStat.setFetchSize(1000);
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    if (session.getProgressMonitor().isCanceled()) {
                        break;
                    }
                    if (nbResults++ >= maxResults) {
                        break;
                    }
                    String schemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"ROUTINESCHEMA");
                    String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINENAME");
                    DB2Schema db2Schema = this.dataSource.getSchema(session.getProgressMonitor(), schemaName);
                    if (db2Schema == null) {
                        LOG.trace((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new DB2ObjectReference(objectName, db2Schema, DB2ObjectType.ROUTINE));
                }
            }
        }
    }

    private void searchColumns(JDBCSession session, DB2Schema schema, String searchObjectNameMask, List<DB2ObjectType> objectTypes, int maxResults, List<DBSObjectReference> objects, int nbResults) throws SQLException, DBException {
        String sql = schema != null ? SQL_COLS_SCHEMA : SQL_COLS_ALL;
        int n = 1;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            if (schema != null) {
                dbStat.setString(n++, schema.getName());
            }
            dbStat.setString(n++, searchObjectNameMask);
            dbStat.setFetchSize(1000);
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (true) {
                    if (!dbResult.next()) break;
                    if (session.getProgressMonitor().isCanceled()) {
                        break;
                    }
                    if (nbResults++ >= maxResults) {
                        return;
                    }
                    String tableSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABSCHEMA");
                    String tableOrViewName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABNAME");
                    String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLNAME");
                    DB2Schema db2Schema = this.dataSource.getSchema(session.getProgressMonitor(), tableSchemaName);
                    if (db2Schema == null) {
                        LOG.trace((Object)("Schema '" + tableSchemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    DB2Table db2Table = db2Schema.getTable(session.getProgressMonitor(), tableOrViewName);
                    if (db2Table != null) {
                        objects.add((DBSObjectReference)new DB2ObjectReference(columnName, db2Table, DB2ObjectType.COLUMN));
                        continue;
                    }
                    DB2View db2View = db2Schema.getView(session.getProgressMonitor(), tableOrViewName);
                    if (db2View == null) continue;
                    objects.add((DBSObjectReference)new DB2ObjectReference(columnName, db2View, DB2ObjectType.COLUMN));
                }
            }
        }
    }

    private String buildTableSQL(String baseStatement, List<DB2ObjectType> objectTypes) {
        ArrayList<Character> listChars = new ArrayList<Character>(objectTypes.size());
        for (DB2ObjectType objectType : objectTypes) {
            if (objectType.equals((Object)DB2ObjectType.ALIAS)) {
                listChars.add(Character.valueOf(DB2TableType.A.name().charAt(0)));
            }
            if (objectType.equals((Object)DB2ObjectType.TABLE)) {
                listChars.add(Character.valueOf(DB2TableType.G.name().charAt(0)));
                listChars.add(Character.valueOf(DB2TableType.H.name().charAt(0)));
                listChars.add(Character.valueOf(DB2TableType.L.name().charAt(0)));
                listChars.add(Character.valueOf(DB2TableType.T.name().charAt(0)));
                listChars.add(Character.valueOf(DB2TableType.U.name().charAt(0)));
            }
            if (objectType.equals((Object)DB2ObjectType.VIEW)) {
                listChars.add(Character.valueOf(DB2TableType.V.name().charAt(0)));
                listChars.add(Character.valueOf(DB2TableType.W.name().charAt(0)));
            }
            if (objectType.equals((Object)DB2ObjectType.MQT)) {
                listChars.add(Character.valueOf(DB2TableType.S.name().charAt(0)));
            }
            if (!objectType.equals((Object)DB2ObjectType.NICKNAME)) continue;
            listChars.add(Character.valueOf(DB2TableType.N.name().charAt(0)));
        }
        Boolean notFirst = false;
        StringBuilder sb = new StringBuilder(64);
        for (Character letter : listChars) {
            if (notFirst.booleanValue()) {
                sb.append(",");
            } else {
                notFirst = true;
            }
            sb.append("'");
            sb.append(letter);
            sb.append("'");
        }
        return String.format(baseStatement, sb.toString());
    }

    public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        if (!(objectType instanceof DB2ObjectType)) {
            return false;
        }
        DB2ObjectType db2ObjectType = (DB2ObjectType)objectType;
        return db2ObjectType == DB2ObjectType.ROUTINE || DB2StructureAssistant.isTable(db2ObjectType);
    }

    static {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("SELECT TABSCHEMA,TABNAME,COLNAME");
        sb.append("  FROM SYSCAT.COLUMNS");
        sb.append(" WHERE TABSCHEMA = ?");
        sb.append("   AND COLNAME LIKE ?");
        sb.append(" WITH UR");
        SQL_COLS_SCHEMA = sb.toString();
        sb.setLength(0);
        sb.append("SELECT TABSCHEMA,TABNAME,COLNAME");
        sb.append("  FROM SYSCAT.COLUMNS");
        sb.append(" WHERE COLNAME LIKE ?");
        sb.append(" WITH UR");
        SQL_COLS_ALL = sb.toString();
    }

    private class DB2ObjectReference
    extends AbstractObjectReference<DBSObject> {
        private DB2ObjectReference(String objectName, DBPDataSource dataSource, DB2ObjectType objectType) {
            super(objectName, (DBSObject)dataSource, null, DB2Schema.class, (DBSObjectType)objectType);
        }

        private DB2ObjectReference(String objectName, DB2Schema db2Schema, DB2ObjectType objectType) {
            super(objectName, (DBSObject)db2Schema, null, DB2Schema.class, (DBSObjectType)objectType);
        }

        private DB2ObjectReference(String objectName, DB2Table db2Table, DB2ObjectType objectType) {
            super(objectName, (DBSObject)db2Table, null, DB2Table.class, (DBSObjectType)objectType);
        }

        private DB2ObjectReference(String objectName, DB2View db2View, DB2ObjectType objectType) {
            super(objectName, (DBSObject)db2View, null, DB2View.class, (DBSObjectType)objectType);
        }

        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
            DB2ObjectType db2ObjectType = (DB2ObjectType)this.getObjectType();
            DBSObject container = this.getContainer();
            String objectName = this.getName();
            if (container instanceof DB2DataSource) {
                DB2Schema schema = DB2StructureAssistant.this.dataSource.getSchema(monitor, objectName);
                if (schema == null) {
                    throw new DBException(String.valueOf((Object)db2ObjectType) + " '" + objectName + "' not found in datasource '" + DB2StructureAssistant.this.dataSource.getName() + "'");
                }
                return schema;
            }
            if (container instanceof DB2Schema) {
                DB2Schema db2Schema = (DB2Schema)container;
                DBSObject object = db2ObjectType.findObject(monitor, db2Schema, objectName);
                if (object == null) {
                    throw new DBException(String.valueOf((Object)db2ObjectType) + " '" + objectName + "' not found in schema '" + db2Schema.getName() + "'");
                }
                return object;
            }
            if (container instanceof DB2Table) {
                DB2Table db2Table = (DB2Table)container;
                DBSObject object = db2ObjectType.findObject(monitor, db2Table, objectName);
                if (object == null) {
                    throw new DBException(String.valueOf((Object)db2ObjectType) + " '" + objectName + "' not found in table '" + db2Table.getName() + "'");
                }
                return object;
            }
            if (container instanceof DB2View) {
                DB2View db2View = (DB2View)container;
                DBSObject object = db2ObjectType.findObject(monitor, db2View, objectName);
                if (object == null) {
                    throw new DBException(String.valueOf((Object)db2ObjectType) + " '" + objectName + "' not found in view '" + db2View.getName() + "'");
                }
                return object;
            }
            return null;
        }
    }
}

