/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

abstract class ActiveStatusMessage
extends Composite {
    private static final Log log = Log.getLog(ActiveStatusMessage.class);
    private final Image actionImage;
    private final Text messageText;
    private final ToolItem actionItem;
    private ILoadService<String> loadService;

    public ActiveStatusMessage(@NotNull Composite parent, @Nullable Image actionImage, @NotNull String actionText, @Nullable ResultSetViewer viewer) {
        super(parent, 0);
        CSSUtils.markConnectionTypeColor((Widget)this);
        this.actionImage = actionImage;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        this.setLayout((Layout)layout);
        ToolBar tb = new ToolBar((Composite)this, 0x800100);
        this.actionItem = new ToolItem(tb, 8);
        this.actionItem.setImage(actionImage);
        this.actionItem.setToolTipText(actionText);
        this.actionItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.executeAction(true)));
        this.messageText = new Text((Composite)this, 8);
        if (RuntimeUtils.isWindows()) {
            this.messageText.setBackground(null);
        } else {
            this.messageText.setBackground(parent.getBackground());
        }
        this.messageText.setLayoutData((Object)new GridData(768));
        if (viewer != null) {
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)viewer.getSite(), (Control)this.messageText);
            UIUtils.addDefaultEditActionsSupport((IServiceLocator)viewer.getSite(), (Control)this.messageText);
        }
    }

    public void setMessage(@NotNull String message) {
        if (this.messageText.isDisposed()) {
            return;
        }
        this.messageText.setText(message);
    }

    @NotNull
    public String getMessage() {
        return this.messageText.getText();
    }

    public void updateActionState() {
        if (!this.actionItem.isDisposed()) {
            this.actionItem.setEnabled(this.isActionEnabled());
        }
    }

    public void executeAction(boolean showErrors) {
        if (this.loadService != null) {
            try {
                this.loadService.cancel();
            }
            catch (InvocationTargetException e) {
                log.debug((Object)e.getTargetException());
            }
            this.loadService = null;
        }
        this.loadService = this.createLoadService();
        LoadingJob service = LoadingJob.createService(this.loadService, (ILoadVisualizer)new LoadVisualizer());
        service.setShowErrors(showErrors);
        service.schedule();
    }

    protected abstract boolean isActionEnabled();

    protected abstract ILoadService<String> createLoadService();

    private class LoadVisualizer
    implements ILoadVisualizer<String> {
        private boolean completed;

        private LoadVisualizer() {
        }

        public DBRProgressMonitor overwriteMonitor(DBRProgressMonitor monitor) {
            return monitor;
        }

        public boolean isCompleted() {
            return this.completed || ActiveStatusMessage.this.isDisposed();
        }

        public void visualizeLoading() {
            ActiveStatusMessage.this.actionItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLOSE));
        }

        public void completeLoading(String message) {
            this.completed = true;
            if (!(ActiveStatusMessage.this.messageText.isDisposed() || CommonUtils.isEmpty((String)message) || CommonUtils.equalObjects((Object)ActiveStatusMessage.this.getMessage(), (Object)message))) {
                ActiveStatusMessage.this.actionItem.setImage(ActiveStatusMessage.this.actionImage);
                ActiveStatusMessage.this.setMessage(message);
                ActiveStatusMessage.this.getParent().layout(true, true);
            }
            ActiveStatusMessage.this.loadService = null;
        }
    }
}

