/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.swt.events.VerifyEvent;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProcessor;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionSorterUI;

public class SQLContentAssistant
extends ContentAssistant {
    private final SQLEditorBase editor;
    private SQLCompletionSorterUI sorter;
    private int lastCompletionOffset = -1;
    private volatile boolean restartRequested = false;

    public SQLContentAssistant(SQLEditorBase editor) {
        this.editor = editor;
        this.enableColoredLabels(true);
    }

    public void setLastCompletionOffset(int lastCompletionOffset) {
        this.lastCompletionOffset = lastCompletionOffset;
        if (lastCompletionOffset == -1 && this.restartRequested) {
            this.restartRequested = false;
            UIUtils.asyncExec(() -> this.showPossibleCompletions());
        }
    }

    public void setSorter(SQLCompletionSorterUI sorter) {
        this.sorter = sorter;
        super.setSorter((ICompletionProposalSorter)sorter);
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        if (this.sorter != null) {
            this.sorter.refreshSettings();
        }
    }

    protected ContentAssistant.AutoAssistListener createAutoAssistListener() {
        return new SQLAutoAssistListener();
    }

    public String showContextInformation() {
        SQLCompletionProcessor.setLookupTemplates(true);
        try {
            String string = super.showPossibleCompletions();
            return string;
        }
        finally {
            SQLCompletionProcessor.setLookupTemplates(false);
        }
    }

    private class SQLAutoAssistListener
    extends ContentAssistant.AutoAssistListener {
        private SQLAutoAssistListener() {
            super((ContentAssistant)SQLContentAssistant.this);
        }

        protected void showAssist(int showStyle) {
            if (!(showStyle != 1 || SQLEditorUtils.isSQLSyntaxParserApplied(SQLContentAssistant.this.editor.getEditorInput()) && SQLContentAssistant.this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"))) {
                return;
            }
            SQLCompletionProcessor.setSimpleMode(true);
            try {
                super.showAssist(showStyle);
            }
            finally {
                SQLCompletionProcessor.setSimpleMode(false);
            }
        }

        public void verifyKey(VerifyEvent event) {
            int pos;
            if (SQLContentAssistant.this.lastCompletionOffset >= 0 && (event.character == '\b' || event.character == '\u0000' && event.keyCode == 0x1000003) && SQLContentAssistant.this.editor.getTextViewer() != null && (pos = SQLContentAssistant.this.editor.getTextViewer().getSelectedRange().x) - 1 < SQLContentAssistant.this.lastCompletionOffset) {
                SQLContentAssistant.this.restartRequested = true;
                SQLContentAssistant.this.hide();
                return;
            }
            super.verifyKey(event);
        }
    }
}

