/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.util.Collections;
import java.util.Map;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.plugin.ai.chat.AIModelSelection;

public class AIProviderConfiguration {
    private static final String AI_PROVIDER_NAME_PROPERTY = "ai_provider_name";
    private static final String AI_MODEL_NAME_PROPERTY = "ai_model_name";
    private static final String AI_SELECTED_MODEL_PROPERTY = "ai_selected_model";
    private static final String AI_OPENROUTER_SERVICE_ADDRESS_PROPERTY = "ai_openrouter_service_address";
    private static final String AI_OPENROUTER_KEY_PROPERTY = "ai_openrouter_key";
    private static final String AI_OPENROUTER_MODEL_ALLOWLIST_PROPERTY = "ai_openrouter_model_allowlist";
    private static final String AI_GEMINI_SERVICE_ADDRESS_PROPERTY = "ai_gemini_service_address";
    private static final String AI_GEMINI_KEY_PROPERTY = "ai_gemini_key";
    private static final String AI_GEMINI_MODEL_LIST_PROPERTY = "ai_gemini_model_list";
    private static final String AI_OLLAMA_SERVICE_ADDRESS_PROPERTY = "ai_ollama_service_address";
    private static final String AI_OLLAMA_API_KEY_PROPERTY = "ai_ollama_api_key";
    private static final String AI_OLLAMA_MODEL_ALLOWLIST_PROPERTY = "ai_ollama_model_allowlist";
    private final ResourceController resourceController;

    public AIProviderConfiguration() {
        this(ResourceController.getResourceController());
    }

    AIProviderConfiguration(ResourceController resourceController) {
        this.resourceController = resourceController;
    }

    public String getSelectedModelValue() {
        String selectedModelValue = this.getStoredSelectedModelValue();
        if (selectedModelValue != null) {
            return selectedModelValue;
        }
        String providerName = this.resourceController.getProperty(AI_PROVIDER_NAME_PROPERTY);
        String modelName = this.resourceController.getProperty(AI_MODEL_NAME_PROPERTY);
        if (providerName == null || providerName.isEmpty() || modelName == null || modelName.isEmpty()) {
            return null;
        }
        return AIModelSelection.createSelectionValue(providerName, modelName);
    }

    public String getStoredSelectedModelValue() {
        return this.resourceController.getProperty(AI_SELECTED_MODEL_PROPERTY);
    }

    public void setSelectedModelValue(String selectionValue) {
        this.resourceController.setProperty(AI_SELECTED_MODEL_PROPERTY, selectionValue);
    }

    public String getOpenrouterServiceAddress() {
        return this.resourceController.getProperty(AI_OPENROUTER_SERVICE_ADDRESS_PROPERTY);
    }

    public String getOpenRouterKey() {
        return this.resourceController.getProperty(AI_OPENROUTER_KEY_PROPERTY);
    }

    public String getOpenrouterModelAllowlistValue() {
        return this.resourceController.getProperty(AI_OPENROUTER_MODEL_ALLOWLIST_PROPERTY);
    }

    public String getGeminiServiceAddress() {
        return this.resourceController.getProperty(AI_GEMINI_SERVICE_ADDRESS_PROPERTY);
    }

    public String getGeminiKey() {
        return this.resourceController.getProperty(AI_GEMINI_KEY_PROPERTY);
    }

    public String getGeminiModelListValue() {
        return this.resourceController.getProperty(AI_GEMINI_MODEL_LIST_PROPERTY);
    }

    public String getOllamaServiceAddress() {
        return this.resourceController.getProperty(AI_OLLAMA_SERVICE_ADDRESS_PROPERTY);
    }

    public String getOllamaApiKey() {
        return this.resourceController.getProperty(AI_OLLAMA_API_KEY_PROPERTY);
    }

    public boolean hasOllamaServiceAddress() {
        return this.hasNonBlankText(this.getOllamaServiceAddress());
    }

    public Map<String, String> getOllamaRequestHeaders() {
        String apiKey = this.trimToEmpty(this.getOllamaApiKey());
        if (apiKey.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("Authorization", "Bearer " + apiKey);
    }

    public String getOllamaModelAllowlistValue() {
        return this.resourceController.getProperty(AI_OLLAMA_MODEL_ALLOWLIST_PROPERTY);
    }

    private boolean hasNonBlankText(String value) {
        return !this.trimToEmpty(value).isEmpty();
    }

    private String trimToEmpty(String value) {
        return value == null ? "" : value.trim();
    }
}

