/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.edit;

import java.util.List;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.ai.tools.content.NodeContentItem;
import org.freeplane.plugin.ai.tools.content.NodeContentItemReader;
import org.freeplane.plugin.ai.tools.content.NodeContentPreset;
import org.freeplane.plugin.ai.tools.edit.AiEditsMarker;
import org.freeplane.plugin.ai.tools.edit.AttributesContentEditor;
import org.freeplane.plugin.ai.tools.edit.EditOperation;
import org.freeplane.plugin.ai.tools.edit.EditedElement;
import org.freeplane.plugin.ai.tools.edit.HyperlinkContentEditor;
import org.freeplane.plugin.ai.tools.edit.IconsContentEditor;
import org.freeplane.plugin.ai.tools.edit.NodeContentEditItem;
import org.freeplane.plugin.ai.tools.edit.NodeStyleContentEditor;
import org.freeplane.plugin.ai.tools.edit.TagsContentEditor;
import org.freeplane.plugin.ai.tools.edit.TextualContentEditor;

public class NodeContentEditor {
    private final TextController textController;
    private final NodeContentItemReader nodeContentItemReader;
    private final TextualContentEditor textualContentEditor;
    private final AttributesContentEditor attributesContentEditor;
    private final TagsContentEditor tagsContentEditor;
    private final IconsContentEditor iconsContentEditor;
    private final NodeStyleContentEditor nodeStyleContentEditor;
    private final HyperlinkContentEditor hyperlinkContentEditor;
    private final AiEditsMarker aiEditsMarker;

    public NodeContentEditor(TextController textController, NodeContentItemReader nodeContentItemReader, TextualContentEditor textualContentEditor, AttributesContentEditor attributesContentEditor, TagsContentEditor tagsContentEditor, IconsContentEditor iconsContentEditor, NodeStyleContentEditor nodeStyleContentEditor, HyperlinkContentEditor hyperlinkContentEditor) {
        this.textController = textController;
        this.nodeContentItemReader = nodeContentItemReader;
        this.textualContentEditor = textualContentEditor;
        this.attributesContentEditor = attributesContentEditor;
        this.tagsContentEditor = tagsContentEditor;
        this.iconsContentEditor = iconsContentEditor;
        this.nodeStyleContentEditor = nodeStyleContentEditor;
        this.hyperlinkContentEditor = hyperlinkContentEditor;
        this.aiEditsMarker = new AiEditsMarker();
    }

    public NodeContentItem edit(NodeModel nodeModel, List<NodeContentEditItem> items) {
        if (nodeModel == null) {
            throw new IllegalArgumentException("Missing node model.");
        }
        if (items == null || items.isEmpty()) {
            return this.nodeContentItemReader.readNodeContentItem(nodeModel, NodeContentPreset.FULL);
        }
        for (NodeContentEditItem edit : items) {
            this.applyEdit(nodeModel, edit);
        }
        this.aiEditsMarker.addAiEditsMarkerWithUndo(nodeModel);
        return this.nodeContentItemReader.readNodeContentItem(nodeModel, NodeContentPreset.FULL, true, true, true);
    }

    private void applyEdit(NodeModel nodeModel, NodeContentEditItem edit) {
        if (edit == null) {
            return;
        }
        EditedElement editedElement = edit.getEditedElement();
        if (editedElement == null) {
            throw new IllegalArgumentException("Missing edited element.");
        }
        switch (editedElement) {
            case TEXT: {
                this.applyTextualContent(nodeModel, edit);
                break;
            }
            case DETAILS: {
                this.applyTextualContent(nodeModel, edit);
                break;
            }
            case NOTE: {
                this.applyTextualContent(nodeModel, edit);
                break;
            }
            case ATTRIBUTES: {
                this.applyAttributes(nodeModel, edit);
                break;
            }
            case TAGS: {
                this.applyTags(nodeModel, edit);
                break;
            }
            case ICONS: {
                this.applyIcons(nodeModel, edit);
                break;
            }
            case STYLE: {
                this.applyStyle(nodeModel, edit);
                break;
            }
            case HYPERLINK: {
                this.applyHyperlink(nodeModel, edit);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown edited element: " + String.valueOf((Object)editedElement));
            }
        }
    }

    private void applyTextualContent(NodeModel nodeModel, NodeContentEditItem edit) {
        if (edit.getOriginalContentType() == null) {
            throw new IllegalArgumentException("Missing originalContentType for textual content edits.");
        }
        String value = this.resolveTextualValue(edit);
        this.textualContentEditor.editExistingTextualContent(nodeModel, edit.getEditedElement(), edit.getOriginalContentType(), value, this.textController);
    }

    private void applyAttributes(NodeModel nodeModel, NodeContentEditItem edit) {
        this.attributesContentEditor.editExistingAttributesContent(nodeModel, edit.getOperation(), edit.getTargetKey(), edit.getIndex(), edit.getValue());
    }

    private void applyTags(NodeModel nodeModel, NodeContentEditItem edit) {
        this.tagsContentEditor.editExistingTagsContent(nodeModel, edit.getOperation(), edit.getTargetKey(), edit.getIndex(), edit.getValue());
    }

    private void applyIcons(NodeModel nodeModel, NodeContentEditItem edit) {
        this.iconsContentEditor.editExistingIconsContent(nodeModel, edit.getOperation(), edit.getTargetKey(), edit.getIndex(), edit.getValue());
    }

    private void applyStyle(NodeModel nodeModel, NodeContentEditItem edit) {
        this.nodeStyleContentEditor.editMainStyle(nodeModel, edit.getOperation(), edit.getValue());
    }

    private void applyHyperlink(NodeModel nodeModel, NodeContentEditItem edit) {
        this.hyperlinkContentEditor.editHyperlink(nodeModel, edit.getOperation(), edit.getValue());
    }

    private String resolveTextualValue(NodeContentEditItem edit) {
        EditOperation operation = edit.getOperation();
        EditedElement editedElement = edit.getEditedElement();
        if (operation == EditOperation.DELETE && (editedElement == EditedElement.DETAILS || editedElement == EditedElement.NOTE)) {
            return "";
        }
        if (operation != EditOperation.REPLACE) {
            throw new IllegalArgumentException("Only REPLACE operations are supported for this element.");
        }
        return edit.getValue();
    }
}

