---
stage: Runtime
group: Geo
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
gitlab_dedicated: no
title: Geoサイト管理者エリア
description: Geoサイトを設定します。
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

GitLab Geoサイトのさまざまな設定を構成できます。詳細については、[Geoドキュメント](geo/_index.md)を参照してください。

プライマリまたはセカンダリサイトのいずれかで:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **Geo** > **サイト**を選択します。

## 共通設定 {#common-settings}

すべてのGeoサイトには、次の設定があります:

| 設定 | 説明 |
| --------| ----------- |
| プライマリ | これは、Geoサイトを**プライマリ**サイトとしてマークします。**プライマリ**サイトは1つしか存在できません。 |
| 名前    | Geoサイトの固有識別子。名前として物理的な場所を使用することを強くお勧めします。適切な例は、`London Office`または`us-east-1`です。`primary`、`secondary`、`Geo`、`DR`のような単語は避けてください。これにより、物理的な場所は変わらないものの、Geoサイトのロールは変更できるため、フェイルオーバープロセスが容易になります。単一のGeoサイト内のすべてのノードは、同じサイト名を使用します。ノードは、PostgreSQLデータベース内のGeoサイトレコードをルックアップするために、`gitlab_rails['geo_node_name']`の`/etc/gitlab/gitlab.rb`設定を使用します。`gitlab_rails['geo_node_name']`が設定されていない場合、末尾にスラッシュが付いたノードの`external_url`がフォールバックとして使用されます。`Name`の値は大文字と小文字が区別され、ほとんどの文字が許可されています。 |
| URL     | インスタンスのユーザー向けURL。 |

### 許可されているGeo IP {#allowed-geo-ip}

**許可されているGeo IP**設定は、セカンダリサイトからプライマリサイトへのリクエストを許可するIPアドレスを制御します。プライマリサイトは、この設定を使用して検証します:

- セカンダリサイトからのGit HTTPリクエスト。
- セカンダリサイトからのGeo APIリクエスト。

この設定を表示すると、プライマリノードが最初に**プライマリサイト**として表示され、参照しているサイトが**現在**のラベルで表示されます。

**許可されているGeo IP**設定:

- セカンダリサイトには影響しません。この設定はデータベース内のセカンダリサイトにレプリケートされますが、そこでは使用されません。
- `192.168.1.1, 10.0.0.0/8, 2001:db8::/32`のような、IPアドレスとCIDRブロックのカンマ区切りリストを受け入れます。
- 任意のIPアドレスからのリクエストを許可する`0.0.0.0/0, ::/0`のデフォルト値を持ちます。
- セカンダリサイトのデータベースは読み取り専用であるため、変更できません。

## セカンダリサイトの設定 {#secondary-site-settings}

**セカンダリ**サイトには、追加の設定が多数あります:

| 設定                   | 説明 |
|---------------------------|-------------|
| 選択的同期 | この**セカンダリ**サイトに対してGeo [選択的同期](geo/replication/selective_synchronization.md)を有効にします。 |
| リポジトリ同期キャパシティ  | バックフィル時に、この**セカンダリ**サイトが**プライマリ**サイトに対して行う並行処理リクエストの数。 |
| ファイル同期キャパシティ        | ファイルのバックフィル時に、この**セカンダリ**サイトが**プライマリ**サイトに対して行う並行処理リクエストの数。 |

## Geoバックフィル {#geo-backfill}

**セカンダリ**サイトは、**プライマリ**サイトからリポジトリおよびファイルへの変更の通知を受け、常にそれらの変更を可能な限り迅速に同期しようとします。

バックフィルとは、**セカンダリ**サイトがデータベースに追加される前の**セカンダリ**サイトにリポジトリとファイルを入力する作業のことです。リポジトリとファイルの数が非常に多い可能性があるため、すべてを一度にダウンロードしようとすることは実現可能ではありません。そのため、GitLabはこれらの操作の並行処理に上限を設定します。

バックフィルにかかる時間は最大の並行処理に依存しますが、値が大きいほど**プライマリ**サイトにかかる負荷が大きくなります。制限は構成可能です。**プライマリ**サイトに十分な余剰キャパシティがある場合は、値を大きくしてバックフィルをより短い時間で完了できます。負荷が高く、バックフィルによって標準リクエストの使用可能性が低下する場合は、値を小さくすることができます。

## 内部URLを設定する {#set-up-the-internal-urls}

プライマリサイトとセカンダリサイト間の同期に別のURLを設定できます。

**プライマリ**サイトの内部URLは、**セカンダリ**サイトが連絡するために使用されます。たとえば、リポジトリを同期する場合などです。名前「内部URL」は、ユーザーが使用する[外部URL](https://docs.gitlab.com/omnibus/settings/configuration.html#configuring-the-external-url-for-gitlab)と区別されます。内部URLはプライベートアドレスである必要はありません。

**セカンダリ**サイトの内部URLは、**プライマリ**サイトからの連絡に使用されます。たとえば、**Geo** > **サイト** > **プロジェクトリポジトリ**の管理者エリアに表示するための同期または検証追跡メタデータを取得する場合などです。

内部URLはデフォルトで外部URLになります。変更するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **Geo** > **サイト**を選択します。
1. カスタマイズするサイトで**編集**を選択します。
1. 内部URLを編集します。
1. **変更を保存**を選択します。

有効にすると、Geoの**管理者**エリアには、プライマリサイトのユーザーインターフェースから直接、および有効になっている場合はGeoセカンダリプロキシを介して、各サイトのレプリケーションの詳細が表示されます。

{{< alert type="warning" >}}

Geoサイトの構成中にHTTPS接続を使用することをお勧めします。HTTPSを使用している場合に**プライマリ**サイトと**セカンダリ**サイト間の通信が中断しないようにするには、内部URLをカスタマイズして、ロードバランサーでTLSが終了するロードバランサーを指すようにします。

{{< /alert >}}
