---
stage: none
group: Documentation Guidelines
info: For assistance with this Style Guide page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: Use of AI
---

Community members can make AI-generated contributions to GitLab documentation, provided they follow the guidelines in our [DCO or our CLA terms](https://about.gitlab.com/community/contribute/dco-cla/).

GitLab team members must follow the guidelines documented in the [internal handbook](https://internal.gitlab.com/handbook/product/ai-strategy/ai-integration-effort/legal_restrictions/).

AI is a productivity multiplier and creative catalyst for the Technical Writing team at GitLab. Examples include:

- Write and refactor documentation
  - Create initial drafts from outlines and screenshots.
  - Generate ideas to restructure content for scannability.
  - Draft tutorial content.
  - Convert list items to Markdown tables.
  - Rephrase and simplify language for better readability.
  - Edit UI text to make it more succinct.
  - Suggest alternatives and improvements to error messages.
  - Restructure pages based on user feedback with specific improvement recommendations.
- Support technical tasks and automation
  - Troubleshoot failed pipelines.
  - Write Python scripts for data analysis and content auditing.
  - Help with rebasing and Git operations.
  - Troubleshoot GDK update errors.
  - Create Mermaid diagrams.
- Analysis and research
  - Analyze documentation sets and identify pain points and improvement areas.
  - Summarize long documents.
  - Generate lists of content by topic or category.
- Collaborate as a thinking partner
  - Co-develop content iteratively through conversation.
  - Challenge assumptions and explore alternatives.
  - Ask probing questions to uncover requirements, edge cases, and gaps.

All content, AI-generated or human-created, is reviewed for accuracy and readability by a GitLab team member.
