---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: アプリケーションをビルドしてテストします。
title: GitLab CI/CDのスタートガイド
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

CI/CDは、反復的なコード変更を継続的にビルド、テスト、デプロイ、監視するソフトウェア開発手法です。

この反復的なプロセスにより、バグや障害を含む過去のバージョンを基に新しいコードを開発してしまうリスクを軽減できます。GitLab CI/CDは、開発サイクルの早期にバグを検出し、本番環境にデプロイするコードが、確立されたコード標準に準拠できるようにします。

このプロセスは、以下に説明するより大きなワークフローの一部です:

![Plan、Create、Verify、Secure、Release、Monitorのステージが含まれたGitLab DevSecOpsライフサイクル](img/get_started_cicd_v16_11.png)

## ステップ1: パイプラインを設定する {#step-1-configure-your-pipeline}

GitLab CI/CDを使用するには、まずプロジェクトのルートに`.gitlab-ci.yml`ファイルを作成します。このファイルは、CI/CDパイプラインで実行するステージ、ジョブ、スクリプトを指定します。これは、独自のカスタム構文を持つYAMLファイルです。

デフォルトでは、ファイル名は`.gitlab-ci.yml`ですが、任意のファイル名を使用できます。

このファイルでは、変数、ジョブ間の依存関係を定義し、各ジョブをいつどのように実行するかを指定します。

パイプラインは`.gitlab-ci.yml`ファイルで定義され、Runnerでファイルが実行されると実行されます。

パイプラインはステージングとジョブで構成されています:

- ステージは、実行順序を定義します。一般的なステージは、`build`、`test`、`deploy`です。
- ジョブは、各ステージで実行するタスクを指定します。たとえば、ジョブでコードをコンパイルしたりテストしたりすることができます。

パイプラインは、コミットやマージなどのさまざまなイベントによってトリガーされるほか、定期的なスケジュールで起動することも可能です。また、パイプラインでは、幅広いツールやプラットフォームと連携できます。

詳細については、以下を参照してください:

- [チュートリアル: 初めてのGitLab CI/CDパイプラインを作成して実行する](quick_start/_index.md)
- [パイプライン](pipelines/_index.md)

## ステップ2: Runnerを見つけるか作成する {#step-2-find-or-create-runners}

Runnerはジョブを実行するエージェントです。これらのエージェントは、物理マシンまたは仮想インスタンスで実行できます。`.gitlab-ci.yml`ファイルでは、ジョブ実行時に使用するコンテナイメージを指定できます。Runnerは指定されたイメージを読み込み、プロジェクトのクローンを作成した上で、ローカル環境またはコンテナ内でジョブを実行します。

GitLab.comを使用する場合、Linux、Windows、macOS上ではRunnerがすでに利用可能です。必要に応じて、独自のRunnerを登録することもできます。

GitLab.comを使用しない場合は、次の選択肢があります:

- GitLab Self-Managedインスタンスに対して、Runnerを新規登録するか、すでに登録されているRunnerを使用する。
- ローカルマシンにRunnerを作成する。

詳細については、以下を参照してください:

- [独自のプロジェクトRunnerを作成、登録、実行する](../tutorials/create_register_first_runner/_index.md)

## ステップ3: CI/CD変数と式を使用する {#step-3-use-cicd-variables-and-expressions}

GitLab CI/CD変数は、パスワードやAPIキーといった設定情報や機密情報を格納してパイプラインのジョブに渡すためのキーと値のペアです。

GitLab CI/CDの式を使用すると、パイプライン設定にデータを動的に入力できます。使用できるデータは、式のコンテキストによって異なります。たとえば、`inputs`コンテキストを使用すると、設定ファイルに親ファイルから渡された情報や、新しいパイプラインの実行時に渡された情報にアクセスできます。

### CI/CD変数 {#cicd-variables}

CI/CD変数を使用すると、別の場所で定義した値をジョブから利用できるようにして、ジョブをカスタマイズすることができます。CI/CD変数は、`.gitlab-ci.yml`ファイルでハードコードする方法のほか、プロジェクト設定で設定したり、動的に生成したりすることも可能です。プロジェクト、グループ、インスタンスのいずれのレベルでも定義できます。

次の種類の変数を使用できます:

- カスタム変数: UI、API、または設定ファイルで作成および管理する変数。
- 定義済み変数: ジョブ、パイプライン、環境に関する情報を提供するためにGitLabが自動的に設定する変数。

セキュリティ設定で変数を設定できます:

- 保護された変数: 保護ブランチまたはタグ付けで実行されているジョブへのアクセスを制限します。
- マスクされた変数: 機密情報が公開されないように、ジョブログの変数値を非表示にします。

詳細については、以下を参照してください:

- [CI/CD変数](variables/_index.md)

### CI/CD式 {#cicd-expressions}

CI/CD式は`$[[ ]]`構文を使用し、パイプラインの作成時に検証されます。変更をコミットする前に、パイプラインエディタで式を検証することもできます。

式を使用すると、さまざまなコンテキストに基づいて設定を動的に行うことができます:

- **Inputs context**（入力コンテキスト）（`$[[ inputs.INPUT_NAME ]]`）: `include:inputs`で、または新しいパイプラインの実行時に、設定ファイルに渡される型指定されたパラメータにアクセスします
- **Matrix context**（マトリックスコンテキスト）（`$[[ matrix.IDENTIFIER ]]`）: ジョブの依存関係にあるマトリックス値にアクセスして、マトリックスジョブ間の1対1マッピングを作成します

詳細については、以下を参照してください:

- [CI expressions](yaml/expressions.md)

## ステップ4: CI/CDコンポーネントを使用する {#step-4-use-cicd-components}

CI/CDコンポーネントは、再利用可能なパイプライン設定単位です。CI/CDコンポーネントを使用して、パイプライン設定全体、または大規模なパイプラインの一部を設定することができます。

`include:component`を使用してパイプライン設定にコンポーネントを追加できます。

再利用可能なコンポーネントを活用することで、コードの重複を減らし、保守性を高め、プロジェクト全体で一貫性を確保できます。コンポーネントプロジェクトを作成し、CI/CDカタログに公開することで、複数のプロジェクト間でコンポーネントを共有できます。

GitLabには、一般的なタスクやインテグレーションのためのCI/CDコンポーネントテンプレートも用意されています。

詳細については、以下を参照してください:

- [CI/CDコンポーネント](components/_index.md)
