---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Gitの高度な操作
description: リベース、cherry-pick、変更の取り消し、リポジトリとファイルの管理。
---

Gitの高度な操作は、コードを維持および管理するタスクを実行するのに役立ちます。これらは、[基本的なGit操作](basics.md)を超えるより複雑なアクションです。これらの操作により、次のことが可能になります:

- コミットの履歴を書き換えます。
- 変更をリバートする、取り消す
- リモートリポジトリ接続を管理します。

これらは、次の利点を提供します:

- コード品質: クリーンでリニアなプロジェクト履歴を維持します。
- 問題解決: 間違いを修正したり、リポジトリの状態を調整したりするためのツールを提供します。
- ワークフローの最適化: 複雑な開発プロセスを効率化します。
- コラボレーション: 大規模または複雑なプロジェクトにおける円滑なチームワークを促進します。

Git操作を効果的に使用するには、リポジトリ、ブランチ、コミット、マージリクエストなどの主要な概念を理解することが重要です。詳細については、[Gitの学習を開始する](get_started.md)を参照してください。

## ベストプラクティス {#best-practices}

Gitの高度な操作を使用する場合は、次のことを行う必要があります:

- バックアップを作成するか、[別のブランチ](branch.md)で作業します。
- 共有ブランチの履歴に影響を与える操作を使用する前に、チームと連絡を取ってください。
- 履歴を書き換えるときは、[記述的なコミットメッセージ](../../tutorials/update_commit_messages/_index.md)を使用してください。
- Gitの知識を更新して、ベストプラクティスと新機能を常に把握してください。詳細については、[Gitのドキュメント](https://git-scm.com/docs)を参照してください。
- テストリポジトリで高度な操作を練習します。

## リベースしてコンフリクトを解決する {#rebase-and-resolve-conflicts}

`git rebase`コマンドは、別のブランチのコンテンツでブランチを更新します。これにより、ブランチ内の変更がターゲットブランチ内の変更と競合しないことが確認されます。[マージコンフリクト](../../user/project/merge_requests/conflicts.md)がある場合は、リベースして修正できます。

詳細については、[マージコンフリクトに対処するためのリベース](git_rebase.md)を参照してください。

## 変更をチェリーピックする {#cherry-pick-changes}

`git cherry-pick`コマンドは、あるブランチから別のブランチに特定のコミットを適用します。用途:

- デフォルトブランチから以前のリリースブランチにバグ修正をバックポートする。
- フォークからアップストリームリポジトリに変更をコピーする。
- ブランチ全体をマージせずに、特定の変更を適用します。

詳細については、[Gitを使用した変更のチェリーピック](cherry_pick.md)を参照してください。

## 変更をリバートする、取り消す {#revert-and-undo-changes}

次のGitコマンドは、変更を元に戻すために役立ちます:

- `git revert`: 以前のコミットで行われた変更を元に戻す新しいコミットを作成します。これにより、不要になった間違いまたは変更を元に戻すことができます。
- `git reset`: まだコミットされていない変更をリセットして元に戻すします。
- `git restore`: 失われた、または削除された変更を復元するします。

詳細については、[変更を元に戻す](undo.md)を参照してください。

## リポジトリのサイズを削減する {#reduce-repository-size}

Gitリポジトリのサイズは、パフォーマンスとストレージコストに大きく影響する可能性があります。圧縮、ハウスキーピング、その他の要因により、インスタンスごとに若干異なる場合があります。リポジトリサイズの詳細については、[リポジトリサイズ](../../user/project/repository/repository_size.md)を参照してください。

Gitを使用して、リポジトリの履歴からファイルをパージし、サイズを縮小できます。詳細については、[リポジトリサイズの削減](repository.md)を参照してください。

## ファイル管理 {#file-management}

Gitを使用して、リポジトリ内のファイルを管理できます。これにより、変更を追跡し、他のユーザーとコラボレーションし、大きなファイルを管理できます。次のオプションを使用できます:

- `git log`: リポジトリ内のファイルに対する変更を表示します。
- `git blame`: ファイル内のコード行を最後に変更したユーザーを特定します。
- `git lfs`: リポジトリ内のファイルを管理、追跡、およびロックします。

<!-- Include when the relevant MR is merged.

For more information, see [File management](file_management.md).

-->

## GitリモートURLを更新する {#update-git-remote-urls}

`git remote set-url`コマンドは、リモートリポジトリのURLを更新します。これは、次の場合に使用します:

- 別のGitリポジトリホストから既存のプロジェクトをインポートしました。
- 組織がプロジェクトを新しいドメイン名を持つ新しいGitLabインスタンスに移動しました。
- プロジェクトの名前が同じGitLabインスタンス内の新しいパスに変更されました。

詳細については、[GitリモートURLの更新](../../tutorials/update_git_remote_url/_index.md)を参照してください。

## 関連トピック {#related-topics}

- [はじめに](get_started.md)
- [基本的なGit操作](basics.md)
- [一般的なGitコマンド](commands.md)
