---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Intercom client secret or client ID'
---

## Description

The response body contains content that matches the pattern of an Intercom client secret or client ID was identified. Client secrets are used when allowing users to sign in to your application. Depending on the scopes requested, a malicious actor could impersonate the service to access the user's information.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). It is not possible to rotate client secret or IDs. You must delete your application and recreate it. For more information, please see [Intercom's documentation on setting up applications](https://developers.intercom.com/docs/build-an-integration/getting-started/build-an-app-for-your-messenger/sheets-app#set-up).

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.156 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
