---
stage: Security Risk Management
group: Security Policies
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 単一の集中管理された場所から、複数のグループやプロジェクトにセキュリティポリシーを適用する方法について説明します。
title: コンプライアンスとセキュリティポリシーグループ
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Self-Managed
- ステータス: ベータ{{< /details >}}

{{< history >}}

- GitLab 18.2で[導入](https://gitlab.com/groups/gitlab-org/-/epics/7622)されました（`security_policies_csp`という[機能フラグ](../../../../administration/feature_flags/_index.md)による制御）。デフォルトでは無効になっています。
- GitLab 18.3のGitLab Self-Managedで[デフォルトで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/550318)になりました。
- GitLab 18.5で[一般提供](https://gitlab.com/groups/gitlab-org/-/epics/17392)になりました。機能フラグ`security_policies_csp`は削除されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能は変更される可能性があり、本番環境での使用に対応していない場合があります。

{{< /alert >}}

一元化されたセキュリティポリシー管理により、インスタンスの管理者は、コンプライアンスとセキュリティポリシーグループを指定して、単一の集中管理された場所から、複数のグループやプロジェクトにセキュリティポリシーを適用できます。

コンプライアンスとセキュリティポリシーグループでセキュリティポリシーを作成または編集するときに、グループのスコープを設定して、次のポリシーを適用できます:

- **Specific groups and subgroups**（特定のグループとサブグループ）: 選択したグループとそのサブグループにのみポリシーを適用します。
- **Specific projects**（特定のプロジェクト）: 個々のプロジェクトにポリシーを適用します。
- **All projects in the instance**（インスタンス内のすべてのプロジェクト）: GitLabインスタンス全体にポリシーを適用します。
- **All projects with exceptions**（例外を含むすべてのプロジェクト）: 指定したものを除くすべてのプロジェクトに適用します。

コンプライアンスとセキュリティポリシーグループを一元化されたポリシー管理ハブとして指定すると、次のことができます:

- インスタンス全体に自動的に適用されるセキュリティポリシーを作成および設定します。
- 特定のグループ、プロジェクト、またはインスタンス全体にポリシーのスコープを設定します。
- 包括的なポリシーカバレッジを表示して、どのポリシーがアクティブで、どこでアクティブになっているかを把握します。
- チームが独自の追加ポリシーを作成できるようにしながら、一元管理を維持します。

## 前提要件 {#prerequisites}

- GitLab Self-Managed。
- GitLab 18.2以降。
- 管理者管理者である必要があります。
- コンプライアンスとセキュリティポリシーグループとして機能する既存のトップレベルグループが必要です。
- REST API (オプション) を使用するには、管理者アクセス権を持つトークンが必要です。

## 一元化されたセキュリティポリシー管理 {#set-up-centralized-security-policy-management}

一元化されたセキュリティポリシー管理をセットアップするには、コンプライアンスとセキュリティポリシーグループを指定し、グループにポリシーを作成します。

詳細については、[インスタンス全体のコンプライアンスとセキュリティポリシーの管理](../../../../security/compliance_security_policy_management.md)を参照してください。

### グローバル承認グループを有効にする {#enable-global-approval-groups}

インスタンス全体でグローバルに承認グループをサポートするには、次のようにする必要があります:

- [GitLabインスタンスアプリケーション設定](../../../../api/settings.md)でsecurity_policy_global_group_approvers_enabledを有効にします`security_policy_global_group_approvers_enabled`。

### コンプライアンスとセキュリティポリシーグループにセキュリティポリシーを作成します {#create-security-policies-in-the-compliance-and-security-policy-group}

ポリシーを作成するには、次の手順を実行します:

1. 指定されたコンプライアンスとセキュリティポリシーグループに移動します。
1. **セキュリティ** > **ポリシー**に移動します。
1. 通常どおり、1つ以上のセキュリティポリシーを作成します。各ポリシーを保存する前に、以下を行います:
   - **ポリシーのスコープ**セクションで、ポリシーの適用スコープを選択します:
      - **グループ**: 特定のグループとサブグループにポリシーを適用します。
      - **プロジェクト**: ポリシーを個々のプロジェクトに適用します。
      - **すべてのプロジェクト**: インスタンス全体に適用します。
      - **All projects except**（例外を除くすべてのプロジェクト）: 指定された例外を含むすべてのプロジェクトに適用します。
1. ポリシー設定を保存します。

## ポリシーのストレージと設定 {#policy-storage-and-configuration}

コンプライアンスとセキュリティポリシーグループのポリシーは、グループポリシーの管理方法と同様に、指定されたコンプライアンスとセキュリティポリシーグループのpolicy.ymlファイルに保存されます`policy.yml`。コンプライアンスとセキュリティポリシーグループで作成されたポリシーは、他のグループやプロジェクトのセキュリティポリシーと同じ設定形式を使用します。

## ポリシーの同期 {#policy-synchronization}

- スコープ内のグループとプロジェクトの数によっては、ポリシーの変更がインスタンス全体に適用されるまでに時間がかかる場合があります。
- 同期処理では、コンプライアンスとセキュリティポリシーグループを指定したり、ポリシーを作成したり、ポリシーを更新したりすると、自動的にキューに登録されるバックグラウンドジョブを使用します。
- 管理者は、**管理者エリア** > **モニタリング** > **バックグラウンドジョブ**でバックグラウンドジョブ処理を監視できます。
- ターゲットグループまたはプロジェクトでポリシーが正常に適用されたことを確認するには、グループまたはプロジェクトの**セキュリティ** > **ポリシー**に移動します。

### パフォーマンスの管理 {#managing-performance}

パフォーマンスの問題を防ぐために、ポリシー管理戦略を計画して、設定の変更数を最小限に抑えます:

- 変更を注意深く計画します: コンプライアンスとセキュリティポリシーグループの変更を何度も連続して行わないでください。
- メンテナンス期間中に変更をスケジュールします: ユーザーへの影響を最小限に抑えるために、使用率の低い期間中に変更を加えます。
- システムのパフォーマンスを監視します: 同期中に低下する可能性のあるパフォーマンスに備えてください。
- 余分な時間を取ってください: 同期処理の完了時間は、インスタンスのサイズによって異なります。

## トラブルシューティング {#troubleshooting}

**Policy does not appear in the target group or project**（ターゲットグループまたはプロジェクトにポリシーが表示されない）

- ポリシーのスコープにターゲットグループまたはプロジェクトが含まれていることを確認します。
- コンプライアンスとセキュリティポリシーグループが管理者設定で適切に指定されていることを確認します。
- コンプライアンスとセキュリティポリシーグループでポリシーが有効になっていることを確認します。
- ポリシーの変更が適用されるまでに時間がかかる場合があります。詳細については、[ポリシーの同期](#policy-synchronization)を参照してください。

**Performance concerns**（パフォーマンスに関する懸念）

- 特に大規模なスコープ設定では、ポリシーの伝達時間を監視します。
- すべてのプロジェクトにポリシーを適用する代わりに、特定のグループまたはプロジェクトにポリシーのスコープを設定することを検討してください。
- コンプライアンスセキュリティポリシーグループを変更する際のパフォーマンスへの影響を軽減するには、[パフォーマンスの管理](#managing-performance)を参照してください。

## フィードバックとサポート {#feedback-and-support}

これはベータリリースであるため、ユーザーからのフィードバックを積極的に求めています。経験、提案、および問題を以下を通して共有してください:

- [GitLab GitLabイシュー](https://gitlab.com/gitlab-org/gitlab/-/issues)。
- 通常のGitLabサポートチャンネル。
