---
stage: Software Supply Chain Security
group: Authorization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: REST API endpoints with Granular Personal Access Token support
---

<!--
  This documentation is auto-generated by a Rake task.

  Please do not edit this file directly. To update this file, run:
  `bundle exec rake gitlab:permissions:compile_docs`.

  To make changes to the output of the Rake task,
  edit `tooling/authz/permissions/docs/templates/granular_pat_rest_api_endpoints.md.erb`.
-->

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

## Granular Personal Access Token (PAT) permissions

This section lists permissions for Granular PATs and the REST API endpoints they are authorized to access, organized by resource category, and resource type:

### Application Security resources

#### Compliance Policy Setting

Grants the ability to read and update compliance policy settings.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Instance | `GET` | `/admin/security/compliance_policy_settings` |
| Update | Instance | `PUT` | `/admin/security/compliance_policy_settings` |

#### Dependency

Grants the ability to read dependencies.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/dependencies` |

#### Dependency List Export

Grants the ability to create dependency list exports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/dependency_list_exports` |
|   | Group | `POST` | `/groups/:id/dependency_list_exports` |

#### External Status Check

Grants the ability to read, retry, and update external status checks.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/merge_requests/:merge_request_iid/status_checks` |
| Retry | Project | `POST` | `/projects/:id/merge_requests/:merge_request_iid/status_checks/:external_status_check_id/retry` |
| Update | Project | `POST` | `/projects/:id/merge_requests/:merge_request_iid/status_check_responses` |

#### External Status Check Service

Grants the ability to create, read, update, and delete external status check services.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/external_status_checks` |
| Delete | Project | `DELETE` | `/projects/:id/external_status_checks/:check_id` |
| Read | Project | `GET` | `/projects/:id/external_status_checks` |
| Update | Project | `PUT` | `/projects/:id/external_status_checks/:check_id` |

#### Sbom Occurrence

Grants the ability to read SBOM occurrences.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/occurrences/vulnerabilities` |

#### Security Setting

Grants the ability to read and update security settings.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/security_settings` |
| Update | Project | `PUT` | `/projects/:id/security_settings` |
|   | Group | `PUT` | `/groups/:id/security_settings` |

#### Vulnerability

Grants the ability to create and read vulnerabilities.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/vulnerabilities` |
| Read | Project | `GET` | `/projects/:id/vulnerabilities` |

#### Vulnerability Export

Grants the ability to create vulnerability exports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/security/projects/:id/vulnerability_exports` |
|   | Group | `POST` | `/security/groups/:id/vulnerability_exports` |

### CI/CD resources

#### Artifact

Grants the ability to delete all artifacts from a project.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/artifacts` |

#### CI Config

Grants the ability to read and validate CI/CD configuration.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/ci/lint` |
| Validate | Project | `POST` | `/projects/:id/ci/lint` |

#### Catalog Version

Grants the ability to publish CI catalog versions.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Publish | Project | `POST` | `/projects/:id/catalog/publish` |

#### Cluster

Grants the ability to create, read, update, and delete clusters.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/clusters/user` |
|   | Group | `POST` | `/groups/:id/clusters/user` |
|   | Instance | `POST` | `/admin/clusters/add` |
| Delete | Project | `DELETE` | `/projects/:id/clusters/:cluster_id` |
|   | Group | `DELETE` | `/groups/:id/clusters/:cluster_id` |
|   | Instance | `DELETE` | `/admin/clusters/:cluster_id` |
| Read | Project | `GET` | `/projects/:id/clusters` |
|   |   | `GET` | `/projects/:id/clusters/:cluster_id` |
|   | Group | `GET` | `/groups/:id/clusters` |
|   |   | `GET` | `/groups/:id/clusters/:cluster_id` |
|   | Instance | `GET` | `/admin/clusters` |
|   |   | `GET` | `/admin/clusters/:cluster_id` |
| Update | Project | `PUT` | `/projects/:id/clusters/:cluster_id` |
|   | Group | `PUT` | `/groups/:id/clusters/:cluster_id` |
|   | Instance | `PUT` | `/admin/clusters/:cluster_id` |

#### Cluster Agent

Grants the ability to create, read, and delete cluster agents.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/cluster_agents` |
| Delete | Project | `DELETE` | `/projects/:id/cluster_agents/:agent_id` |
| Read | Project | `GET` | `/projects/:id/cluster_agents` |
|   |   | `GET` | `/projects/:id/cluster_agents/:agent_id` |

#### Cluster Agent Token

Grants the ability to create, read, and revoke cluster agent tokens.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/cluster_agents/:agent_id/tokens` |
| Read | Project | `GET` | `/projects/:id/cluster_agents/:agent_id/tokens` |
|   |   | `GET` | `/projects/:id/cluster_agents/:agent_id/tokens/:token_id` |
| Revoke | Project | `DELETE` | `/projects/:id/cluster_agents/:agent_id/tokens/:token_id` |

#### Cluster Agent URL Configuration

Grants the ability to create, read, and delete cluster agent URL configurations.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/cluster_agents/:agent_id/url_configurations` |
| Delete | Project | `DELETE` | `/projects/:id/cluster_agents/:agent_id/url_configurations/:url_configuration_id` |
| Read | Project | `GET` | `/projects/:id/cluster_agents/:agent_id/url_configurations` |
|   |   | `GET` | `/projects/:id/cluster_agents/:agent_id/url_configurations/:url_configuration_id` |

#### Deployments

Grants the ability to approve, create, read, update, and delete deployments.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Approve | Project | `POST` | `/projects/:id/deployments/:deployment_id/approval` |
| Create | Project | `POST` | `/projects/:id/deployments` |
| Delete | Project | `DELETE` | `/projects/:id/deployments/:deployment_id` |
| Read | Project | `GET` | `/projects/:id/deployments` |
|   |   | `GET` | `/projects/:id/deployments/:deployment_id` |
|   |   | `GET` | `/projects/:id/deployments/:deployment_id/merge_requests` |
| Update | Project | `PUT` | `/projects/:id/deployments/:deployment_id` |

#### Environment

Grants the ability to create, read, update, stop, and delete environments.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/environments` |
| Delete | Project | `DELETE` | `/projects/:id/environments/review_apps` |
|   |   | `DELETE` | `/projects/:id/environments/:environment_id` |
| Read | Project | `GET` | `/projects/:id/environments` |
|   |   | `GET` | `/projects/:id/environments/:environment_id` |
| Stop | Project | `POST` | `/projects/:id/environments/:environment_id/stop` |
|   |   | `POST` | `/projects/:id/environments/stop_stale` |
| Update | Project | `PUT` | `/projects/:id/environments/:environment_id` |

#### Job

Grants the ability to cancel, erase, play, read, and retry jobs.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `POST` | `/projects/:id/jobs/:job_id/erase` |
| Read | Project | `GET` | `/projects/:id/jobs` |
|   |   | `GET` | `/projects/:id/jobs/:job_id` |
|   |   | `GET` | `/projects/:id/jobs/:job_id/trace` |
| Run Job | Project | `POST` | `/projects/:id/jobs/:job_id/retry` |
|   |   | `POST` | `/projects/:id/jobs/:job_id/play` |
| Update | Project | `POST` | `/projects/:id/jobs/:job_id/cancel` |

#### Job Artifact

Grants the ability to delete, download, and keep job artifacts from expiring.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/jobs/:job_id/artifacts` |
| Read | Project | `GET` | `/projects/:id/jobs/artifacts/:ref_name/download` |
|   |   | `GET` | `/projects/:id/jobs/artifacts/:ref_name/raw/*artifact_path` |
|   |   | `GET` | `/projects/:id/jobs/:job_id/artifacts` |
|   |   | `GET` | `/projects/:id/jobs/:job_id/artifacts/tree` |
|   |   | `GET` | `/projects/:id/jobs/:job_id/artifacts/*artifact_path` |
| Update | Project | `POST` | `/projects/:id/jobs/:job_id/artifacts/keep` |

#### Merge Train

Grants the ability to read merge trains.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/merge_trains` |
|   |   | `GET` | `/projects/:id/merge_trains/:target_branch` |
|   |   | `GET` | `/projects/:id/merge_trains/merge_requests/:merge_request_iid` |

#### Merge Train Merge Request

Grants the ability to add merge requests to merge trains and read merge train status for a specific merge request.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Add | Project | `POST` | `/projects/:id/merge_trains/merge_requests/:merge_request_iid` |

#### Pipeline

Grants the ability to cancel, create, delete, read, and retry pipelines.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/pipeline` |
|   |   | `POST` | `/projects/:id/pipeline` |
| Delete | Project | `DELETE` | `/projects/:id/pipelines/:pipeline_id` |
|   |   | `DELETE` | `/projects/:id/pipelines/:pipeline_id` |
| Read | Project | `GET` | `/projects/:id/pipelines` |
|   |   | `GET` | `/projects/:id/pipelines/latest` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/jobs` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/bridges` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/variables` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/test_report` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/test_report_summary` |
|   |   | `GET` | `/projects/:id/pipelines` |
|   |   | `GET` | `/projects/:id/pipelines/latest` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/jobs` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/bridges` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/variables` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/test_report` |
|   |   | `GET` | `/projects/:id/pipelines/:pipeline_id/test_report_summary` |
| Update | Project | `POST` | `/projects/:id/pipelines/:pipeline_id/retry` |
|   |   | `POST` | `/projects/:id/pipelines/:pipeline_id/cancel` |
|   |   | `POST` | `/projects/:id/pipelines/:pipeline_id/retry` |
|   |   | `POST` | `/projects/:id/pipelines/:pipeline_id/cancel` |
|   |   | `PUT` | `/projects/:id/pipelines/:pipeline_id/metadata` |
|   |   | `PUT` | `/projects/:id/pipelines/:pipeline_id/metadata` |

#### Pipeline Schedule

Grants the ability to create, delete, play, read, take ownership of, and update pipeline schedules.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/pipeline_schedules` |
|   |   | `POST` | `/projects/:id/pipeline_schedules` |
| Delete | Project | `DELETE` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id` |
|   |   | `DELETE` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id` |
| Read | Project | `GET` | `/projects/:id/pipeline_schedules` |
|   |   | `GET` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id` |
|   |   | `GET` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/pipelines` |
|   |   | `GET` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables/:key` |
|   |   | `GET` | `/projects/:id/pipeline_schedules` |
|   |   | `GET` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id` |
|   |   | `GET` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/pipelines` |
|   |   | `GET` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables/:key` |
| Update | Project | `POST` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/take_ownership` |
|   |   | `POST` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/play` |
|   |   | `POST` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables` |
|   |   | `POST` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/take_ownership` |
|   |   | `POST` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/play` |
|   |   | `POST` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables` |
|   |   | `PUT` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id` |
|   |   | `PUT` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables/:key` |
|   |   | `PUT` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id` |
|   |   | `PUT` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables/:key` |
|   |   | `DELETE` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables/:key` |
|   |   | `DELETE` | `/projects/:id/pipeline_schedules/:pipeline_schedule_id/variables/:key` |

#### Protected Environment

Grants the ability to create, read, update, and delete protected environments.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/protected_environments` |
|   | Group | `POST` | `/groups/:id/protected_environments` |
| Delete | Project | `DELETE` | `/projects/:id/protected_environments/:name` |
|   | Group | `DELETE` | `/groups/:id/protected_environments/:name` |
| Read | Project | `GET` | `/projects/:id/protected_environments` |
|   |   | `GET` | `/projects/:id/protected_environments/:name` |
|   | Group | `GET` | `/groups/:id/protected_environments` |
|   |   | `GET` | `/groups/:id/protected_environments/:name` |
| Update | Project | `PUT` | `/projects/:id/protected_environments/:name` |
|   | Group | `PUT` | `/groups/:id/protected_environments/:name` |

#### Pull Mirror

Grants the ability to create, read, and update pull mirrors.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/mirror/pull` |
| Read | Project | `GET` | `/projects/:id/mirror/pull` |
| Update | Project | `PUT` | `/projects/:id/mirror/pull` |

#### Repository Storage Move

Grants the ability to create and read repository storage moves.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Manage | Project | `POST` | `/projects/:id/repository_storage_moves` |
|   | Group | `POST` | `/groups/:id/repository_storage_moves` |
| Read | Project | `GET` | `/projects/:id/repository_storage_moves` |
|   |   | `GET` | `/projects/:id/repository_storage_moves/:repository_storage_move_id` |
|   | Group | `GET` | `/groups/:id/repository_storage_moves` |
|   |   | `GET` | `/groups/:id/repository_storage_moves/:repository_storage_move_id` |

#### Resource Group

Grants the ability to read and update resource groups.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/resource_groups` |
|   |   | `GET` | `/projects/:id/resource_groups/:key` |
|   |   | `GET` | `/projects/:id/resource_groups/:key/current_job` |
|   |   | `GET` | `/projects/:id/resource_groups/:key/upcoming_jobs` |
| Update | Project | `PUT` | `/projects/:id/resource_groups/:key` |

#### Runner

Grants the ability to create, delete, and read runners.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Assign | Project | `POST` | `/projects/:id/runners` |
|   |   | `DELETE` | `/projects/:id/runners/:runner_id` |
| Create | User | `POST` | `/user/runners` |
| Read | Project | `GET` | `/projects/:id/runners` |
|   | Group | `GET` | `/groups/:id/runners` |

#### Runner Registration Token

Grants the ability to reset runner registration tokens.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Reset | Project | `POST` | `/projects/:id/runners/reset_registration_token` |
|   | Group | `POST` | `/groups/:id/runners/reset_registration_token` |

#### Secure File

Grants the ability to create, read, download, and delete secure files.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/secure_files` |
|   |   | `POST` | `/projects/:id/secure_files` |
| Delete | Project | `DELETE` | `/projects/:id/secure_files/:secure_file_id` |
|   |   | `DELETE` | `/projects/:id/secure_files/:secure_file_id` |
| Read | Project | `GET` | `/projects/:id/secure_files` |
|   |   | `GET` | `/projects/:id/secure_files/:secure_file_id` |
|   |   | `GET` | `/projects/:id/secure_files/:secure_file_id/download` |
|   |   | `GET` | `/projects/:id/secure_files` |
|   |   | `GET` | `/projects/:id/secure_files/:secure_file_id` |
|   |   | `GET` | `/projects/:id/secure_files/:secure_file_id/download` |

#### Terraform State

Grants the ability to read and manage Terraform state.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/terraform/state/:name` |
| Delete | Project | `DELETE` | `/projects/:id/terraform/state/:name` |
|   |   | `DELETE` | `/projects/:id/terraform/state/:name/versions/:serial` |
| Lock | Project | `POST` | `/projects/:id/terraform/state/:name/lock` |
|   |   | `DELETE` | `/projects/:id/terraform/state/:name/lock` |
| Read | Project | `GET` | `/projects/:id/terraform/state/:name` |
|   |   | `GET` | `/projects/:id/terraform/state/:name/versions/:serial` |

#### Trigger

Grants the ability to create, delete, read, and update pipeline triggers.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/triggers` |
| Delete | Project | `DELETE` | `/projects/:id/triggers/:trigger_id` |
| Read | Project | `GET` | `/projects/:id/triggers` |
|   |   | `GET` | `/projects/:id/triggers/:trigger_id` |
| Update | Project | `PUT` | `/projects/:id/triggers/:trigger_id` |

#### Variable

Grants the ability to create, delete, read, and update CI variables.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/variables` |
|   | Group | `POST` | `/groups/:id/variables` |
| Delete | Project | `DELETE` | `/projects/:id/variables/:key` |
|   | Group | `DELETE` | `/groups/:id/variables/:key` |
| Read | Project | `GET` | `/projects/:id/variables` |
|   |   | `GET` | `/projects/:id/variables/:key` |
|   | Group | `GET` | `/groups/:id/variables` |
|   |   | `GET` | `/groups/:id/variables/:key` |
| Update | Project | `PUT` | `/projects/:id/variables/:key` |
|   | Group | `PUT` | `/groups/:id/variables/:key` |

### Category Placeholder resources

#### Database Migration

Grants the ability to mark database migrations.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Mark | Instance | `POST` | `/admin/migrations/:timestamp/mark` |

#### Global Search

Grants the ability to use global search functionality.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Use | Project | `GET` | `/projects/:id/(-/)search` |
|   | Group | `GET` | `/groups/:id/(-/)search` |
|   | User | `GET` | `/search` |

#### Notification Setting

Grants the ability to manage notification settings.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/notification_settings` |
|   | Group | `GET` | `/groups/:id/notification_settings` |
|   | User | `GET` | `/notification_settings` |
| Update | Project | `PUT` | `/projects/:id/notification_settings` |
|   | Group | `PUT` | `/groups/:id/notification_settings` |
|   | User | `PUT` | `/notification_settings` |

### Duo resources

#### Chat Completion

Grants the ability to create chat completions.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/chat/completions` |

#### Code Suggestion Completion

Grants the ability to create code suggestion completions.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/code_suggestions/completions` |

#### Code Suggestion Connection Detail

Grants the ability to read code suggestion connection details.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `POST` | `/code_suggestions/connection_details` |

#### Code Suggestion Direct Access

Grants the ability to create code suggestion direct access.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/code_suggestions/direct_access` |

#### Code Suggestion Enabled

Grants the ability to read code suggestion enabled status.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `POST` | `/code_suggestions/enabled` |

### Groups resources

#### Admin Member Role

Grants the ability to create, delete, and read admin member roles.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Instance | `POST` | `/admin_member_roles` |
| Delete | Instance | `DELETE` | `/admin_member_roles/:member_role_id` |
| Read | Instance | `GET` | `/admin_member_roles` |

#### Avatar

Grants the ability to read avatars.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/avatar` |
|   | Group | `GET` | `/groups/:id/avatar` |
|   | User | `GET` | `/avatar` |

#### Group

Grants the ability to manage groups.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Archive | Group | `POST` | `/groups/:id/archive` |
|   |   | `POST` | `/groups/:id/unarchive` |
| Create | User | `POST` | `/groups` |
| Delete | Group | `DELETE` | `/groups/:id` |
| Read | Group | `GET` | `/groups/:id` |
|   |   | `GET` | `/groups/:id/groups/shared` |
|   |   | `GET` | `/groups/:id/invited_groups` |
|   |   | `GET` | `/groups/:id/projects/shared` |
|   |   | `GET` | `/groups/:id/subgroups` |
|   |   | `GET` | `/groups/:id/descendant_groups` |
|   |   | `GET` | `/groups/:id/transfer_locations` |
|   | User | `GET` | `/groups` |
| Share | Group | `POST` | `/groups/:id/share` |
|   |   | `DELETE` | `/groups/:id/share/:group_id` |
| Transfer | Group | `POST` | `/groups/:id/transfer` |
|   |   | `POST` | `/groups/:id/transfer_to_organization` |
| Update | Group | `POST` | `/groups/:id/restore` |
|   |   | `PUT` | `/groups/:id` |

#### Member Role

Grants the ability to create, delete, and read member roles.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/member_roles` |
|   | Instance | `POST` | `/member_roles` |
| Delete | Group | `DELETE` | `/groups/:id/member_roles/:member_role_id` |
|   | Instance | `DELETE` | `/member_roles/:member_role_id` |
| Read | Group | `GET` | `/groups/:id/member_roles` |
|   | Instance | `GET` | `/member_roles` |

#### SAML Identity

Grants the ability to read, update, and delete SAML identities.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Group | `DELETE` | `/groups/:id/saml/:uid` |
| Read | Group | `GET` | `/groups/:id/saml/identities` |
|   |   | `GET` | `/groups/:id/saml/:uid` |
| Update | Group | `PATCH` | `/groups/:id/saml/:uid` |

#### SSH Certificate

Grants the ability to create, delete, and read SSH certificates.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/ssh_certificates` |
| Delete | Group | `DELETE` | `/groups/:id/ssh_certificates/:ssh_certificates_id` |
| Read | Group | `GET` | `/groups/:id/ssh_certificates` |

#### Template

Grants the ability to read templates.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/templates/:type` |
|   |   | `GET` | `/projects/:id/templates/:type/:name` |

#### User Activity

Grants the ability to read user activity.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/user/activities` |

#### User Association

Grants the ability to read user associations.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/users/:id/associations_count` |

#### User Avatar

Grants the ability to update user avatars.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Update | User | `PUT` | `/user/avatar` |

#### User Follower

Grants the ability to read user followers.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/users/:id/followers` |

#### User Following

Grants the ability to read user following.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/users/:id/following` |

#### User Gpg Key

Grants the ability to create, read, revoke, and delete user GPG keys.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/user/gpg_keys` |
| Delete | User | `DELETE` | `/user/gpg_keys/:key_id` |
| Read | User | `GET` | `/users/:id/gpg_keys` |
|   |   | `GET` | `/users/:id/gpg_keys/:key_id` |
|   |   | `GET` | `/user/gpg_keys` |
|   |   | `GET` | `/user/gpg_keys/:key_id` |
| Revoke | User | `POST` | `/user/gpg_keys/:key_id/revoke` |

#### User Preference

Grants the ability to read and update user preferences.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/user/preferences` |
| Update | User | `PUT` | `/user/preferences` |

#### User Project Deploy Key

Grants the ability to read user project deploy keys.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/users/:user_id/project_deploy_keys` |

#### User Status

Grants the ability to read and update user status.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/users/:user_id/status` |
|   |   | `GET` | `/user/status` |
| Update | User | `PATCH` | `/user/status` |
|   |   | `PUT` | `/user/status` |

#### User Support Pin

Grants the ability to create and read user support pins.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/user/support_pin` |
| Read | User | `GET` | `/user/support_pin` |

### Note resources

#### Vulnerability Note

Grants the ability to manage vulnerability notes.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/vulnerabilities/:noteable_id/notes` |
| Delete | Project | `DELETE` | `/projects/:id/vulnerabilities/:noteable_id/notes/:note_id` |
| Read | Project | `GET` | `/projects/:id/vulnerabilities/:noteable_id/notes` |
|   |   | `GET` | `/projects/:id/vulnerabilities/:noteable_id/notes/:note_id` |
| Update | Project | `PUT` | `/projects/:id/vulnerabilities/:noteable_id/notes/:note_id` |

### Packages And Registry resources

#### Container Repository

Grants the ability to read and delete container repositories.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/registry/repositories/:repository_id` |
|   |   | `DELETE` | `/projects/:id/registry/repositories/:repository_id/tags` |
|   |   | `DELETE` | `/projects/:id/registry/repositories/:repository_id/tags/:tag_name` |
| Read | Project | `GET` | `/projects/:id/registry/repositories` |
|   |   | `GET` | `/projects/:id/registry/repositories/:repository_id/tags` |
|   |   | `GET` | `/projects/:id/registry/repositories/:repository_id/tags/:tag_name` |
|   | Group | `GET` | `/groups/:id/registry/repositories` |

#### Container Repository Protection Rule

Grants the ability to create, read, update, and delete container repository protection rules.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/registry/protection/repository/rules` |
| Delete | Project | `DELETE` | `/projects/:id/registry/protection/repository/rules/:protection_rule_id` |
| Read | Project | `GET` | `/projects/:id/registry/protection/repository/rules` |
| Update | Project | `PATCH` | `/projects/:id/registry/protection/repository/rules/:protection_rule_id` |

#### Debian Distribution

Grants the ability to read, create, update, and delete Debian distribution packages

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/debian_distributions` |
|   | Group | `POST` | `/groups/:id/-/debian_distributions` |
| Delete | Project | `DELETE` | `/projects/:id/debian_distributions/:codename` |
|   | Group | `DELETE` | `/groups/:id/-/debian_distributions/:codename` |
| Read | Project | `GET` | `/projects/:id/debian_distributions` |
|   |   | `GET` | `/projects/:id/debian_distributions/:codename` |
|   |   | `GET` | `/projects/:id/debian_distributions/:codename/key.asc` |
|   | Group | `GET` | `/groups/:id/-/debian_distributions` |
|   |   | `GET` | `/groups/:id/-/debian_distributions/:codename` |
|   |   | `GET` | `/groups/:id/-/debian_distributions/:codename/key.asc` |
| Update | Project | `PUT` | `/projects/:id/debian_distributions/:codename` |
|   | Group | `PUT` | `/groups/:id/-/debian_distributions/:codename` |

#### Dependency Proxy Cache

Grants the ability to delete dependency proxy cache.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Purge | Group | `DELETE` | `/groups/:id/dependency_proxy/cache` |

#### Package

Grants the ability to create, delete and read packages.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/packages/composer` |
|   |   | `POST` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/upload_urls` |
|   |   | `POST` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/upload_urls` |
|   |   | `POST` | `/projects/:id/packages/helm/api/:channel/charts` |
|   |   | `POST` | `/projects/:id/packages/rubygems/api/v1/gems` |
|   |   | `POST` | `/projects/:id/packages/rubygems/api/v1/gems/authorize` |
|   |   | `POST` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/upload_urls` |
|   |   | `POST` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/upload_urls` |
|   |   | `POST` | `/projects/:id/packages/pypi/authorize` |
|   |   | `POST` | `/projects/:id/packages/pypi` |
|   |   | `POST` | `/projects/:id/packages/helm/api/:channel/charts/authorize` |
|   |   | `PUT` | `/packages/npm/-/package/*package_name/dist-tags/:tag` |
|   |   | `PUT` | `/projects/:id/packages/npm/-/package/*package_name/dist-tags/:tag` |
|   |   | `PUT` | `/projects/:id/packages/npm/:package_name/authorize` |
|   |   | `PUT` | `/projects/:id/packages/npm/:package_name` |
|   |   | `PUT` | `/projects/:id/packages/nuget` |
|   |   | `PUT` | `/projects/:id/packages/nuget/authorize` |
|   |   | `PUT` | `/projects/:id/packages/nuget/symbolpackage` |
|   |   | `PUT` | `/projects/:id/packages/nuget/symbolpackage/authorize` |
|   |   | `PUT` | `/projects/:id/packages/nuget/v2` |
|   |   | `PUT` | `/projects/:id/packages/nuget/v2/authorize` |
|   |   | `PUT` | `/projects/:id/packages/terraform/modules/:module_name/:module_system/*module_version/file/authorize` |
|   |   | `PUT` | `/projects/:id/packages/terraform/modules/:module_name/:module_system/*module_version/file` |
|   |   | `PUT` | `/projects/:id/packages/maven/*path/:file_name` |
|   |   | `PUT` | `/projects/:id/packages/generic/:package_name/*package_version/(*path/):file_name` |
|   |   | `PUT` | `/projects/:id/packages/generic/:package_name/*package_version/(*path/):file_name/authorize` |
|   |   | `PUT` | `/projects/:id/packages/debian/:file_name` |
|   |   | `PUT` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files/:file_name/authorize` |
|   |   | `PUT` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files/:file_name` |
|   |   | `PUT` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files/:file_name/authorize` |
|   |   | `PUT` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files/:file_name` |
|   |   | `PUT` | `/projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` |
|   |   | `PUT` | `/projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name/authorize` |
|   |   | `PUT` | `/projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name/authorize` |
|   |   | `PUT` | `/projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` |
|   |   | `PUT` | `/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` |
|   |   | `PUT` | `/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name/authorize` |
|   |   | `PUT` | `/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name/authorize` |
|   |   | `PUT` | `/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` |
|   | Group | `POST` | `/virtual_registries/packages/maven/:id/*path/upload` |
|   |   | `PUT` | `/groups/:id/-/packages/npm/-/package/*package_name/dist-tags/:tag` |
| Delete | Project | `DELETE` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` |
|   |   | `DELETE` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` |
|   |   | `DELETE` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision` |
|   |   | `DELETE` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision` |
|   |   | `DELETE` | `/packages/npm/-/package/*package_name/dist-tags/:tag` |
|   |   | `DELETE` | `/projects/:id/packages/npm/-/package/*package_name/dist-tags/:tag` |
|   |   | `DELETE` | `/projects/:id/packages/nuget/*package_name/*package_version` |
|   |   | `DELETE` | `/projects/:id/packages/:package_id` |
|   | Group | `DELETE` | `/groups/:id/-/packages/npm/-/package/*package_name/dist-tags/:tag` |
| Read | Project | `GET` | `/projects/:id/packages/composer/archives/*package_name` |
|   |   | `GET` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/search` |
|   |   | `GET` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference` |
|   |   | `GET` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` |
|   |   | `GET` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/digest` |
|   |   | `GET` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/digest` |
|   |   | `GET` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/download_urls` |
|   |   | `GET` | `/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/download_urls` |
|   |   | `GET` | `/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` |
|   |   | `GET` | `/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/users/authenticate` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/users/check_credentials` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/search` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/search` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/digest` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/digest` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/download_urls` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/download_urls` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` |
|   |   | `GET` | `/projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/users/authenticate` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/users/check_credentials` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/search` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/search` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/latest` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files/:file_name` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/search` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/latest` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files` |
|   |   | `GET` | `/projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files/:file_name` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/Release.gpg` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/Release` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/InRelease` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/:component/debian-installer/binary-:architecture/Packages` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/:component/debian-installer/binary-:architecture/by-hash/SHA256/:file_sha256` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/:component/source/Sources` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/:component/source/by-hash/SHA256/:file_sha256` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/:component/binary-:architecture/Packages` |
|   |   | `GET` | `/projects/:id/packages/debian/dists/*distribution/:component/binary-:architecture/by-hash/SHA256/:file_sha256` |
|   |   | `GET` | `/projects/:id/packages/debian/pool/:distribution/:letter/:package_name/:package_version/:file_name` |
|   |   | `GET` | `/projects/:id/packages/generic/:package_name/*package_version/(*path/):file_name` |
|   |   | `GET` | `/projects/:id/packages/go/*module_name/@v/list` |
|   |   | `GET` | `/projects/:id/packages/go/*module_name/@v/:module_version.info` |
|   |   | `GET` | `/projects/:id/packages/go/*module_name/@v/:module_version.mod` |
|   |   | `GET` | `/projects/:id/packages/go/*module_name/@v/:module_version.zip` |
|   |   | `GET` | `/projects/:id/packages/helm/:channel/index.yaml` |
|   |   | `GET` | `/projects/:id/packages/helm/:channel/charts/:file_name.tgz` |
|   |   | `GET` | `/projects/:id/packages/maven/*path/:file_name` |
|   |   | `GET` | `/packages/npm/-/package/*package_name/dist-tags` |
|   |   | `GET` | `/projects/:id/packages/npm/-/package/*package_name/dist-tags` |
|   |   | `GET` | `/projects/:id/packages/npm/*package_name/-/*file_name` |
|   |   | `GET` | `/projects/:id/packages/npm/*package_name` |
|   |   | `GET` | `/projects/:id/packages/nuget/metadata/*package_name/index` |
|   |   | `GET` | `/projects/:id/packages/nuget/metadata/*package_name/*package_version` |
|   |   | `GET` | `/projects/:id/packages/nuget/query` |
|   |   | `GET` | `/projects/:id/packages/nuget/download/*package_name/index` |
|   |   | `GET` | `/projects/:id/packages/nuget/download/*package_name/*package_version/*package_filename` |
|   |   | `GET` | `/projects/:id/packages` |
|   |   | `GET` | `/projects/:id/packages/:package_id` |
|   |   | `GET` | `/projects/:id/packages/pypi/files/:sha256/*file_identifier` |
|   |   | `GET` | `/projects/:id/packages/pypi/simple` |
|   |   | `GET` | `/projects/:id/packages/pypi/simple/*package_name` |
|   |   | `GET` | `/projects/:id/packages/rubygems/gems/:file_name` |
|   |   | `GET` | `/projects/:id/packages/rubygems/api/v1/dependencies` |
|   |   | `GET` | `/projects/:id/packages/terraform/modules/:module_name/:module_system` |
|   |   | `GET` | `/projects/:id/packages/terraform/modules/:module_name/:module_system/*module_version` |
|   | Group | `GET` | `/group/:id/-/packages/composer/packages` |
|   |   | `GET` | `/group/:id/-/packages/composer/p/:sha` |
|   |   | `GET` | `/group/:id/-/packages/composer/p2/*package_name` |
|   |   | `GET` | `/group/:id/-/packages/composer/*package_name` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/Release.gpg` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/Release` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/InRelease` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/:component/debian-installer/binary-:architecture/Packages` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/:component/debian-installer/binary-:architecture/by-hash/SHA256/:file_sha256` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/:component/source/Sources` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/:component/source/by-hash/SHA256/:file_sha256` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/:component/binary-:architecture/Packages` |
|   |   | `GET` | `/groups/:id/-/packages/debian/dists/*distribution/:component/binary-:architecture/by-hash/SHA256/:file_sha256` |
|   |   | `GET` | `/groups/:id/packages` |
|   |   | `GET` | `/groups/:id/-/packages/maven/*path/:file_name` |
|   |   | `GET` | `/groups/:id/-/packages/npm/-/package/*package_name/dist-tags` |
|   |   | `GET` | `/groups/:id/-/packages/nuget/metadata/*package_name/index` |
|   |   | `GET` | `/groups/:id/-/packages/nuget/metadata/*package_name/*package_version` |
|   |   | `GET` | `/groups/:id/-/packages/nuget/query` |
|   |   | `GET` | `/groups/:id/-/packages/pypi/files/:sha256/*file_identifier` |
|   |   | `GET` | `/groups/:id/-/packages/pypi/simple` |
|   |   | `GET` | `/groups/:id/-/packages/pypi/simple/*package_name` |
|   |   | `GET` | `/packages/terraform/modules/v1/:module_namespace/:module_name/:module_system/versions` |
|   |   | `GET` | `/packages/terraform/modules/v1/:module_namespace/:module_name/:module_system/download` |
|   |   | `GET` | `/packages/terraform/modules/v1/:module_namespace/:module_name/:module_system` |
|   |   | `GET` | `/packages/terraform/modules/v1/:module_namespace/:module_name/:module_system/*module_version/download` |
|   |   | `GET` | `/packages/terraform/modules/v1/:module_namespace/:module_name/:module_system/*module_version/file` |
|   |   | `GET` | `/packages/terraform/modules/v1/:module_namespace/:module_name/:module_system/*module_version` |
|   |   | `GET` | `/virtual_registries/packages/maven/:id/*path` |
|   | Instance | `GET` | `/packages/conan/v1/users/authenticate` |
|   |   | `GET` | `/packages/conan/v1/users/check_credentials` |
|   |   | `GET` | `/packages/conan/v1/conans/search` |
|   |   | `GET` | `/packages/maven/*path/:file_name` |

#### Package Pipeline

Grants the ability to read package pipelines.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/packages/:package_id/pipelines` |

#### Virtual Registry

Grants the ability to create, read, update, and delete virtual registries.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/-/virtual_registries/container/registries` |
|   |   | `POST` | `/virtual_registries/container/registry_upstreams` |
|   |   | `POST` | `/virtual_registries/container/registries/:id/upstreams` |
|   |   | `POST` | `/groups/:id/-/virtual_registries/packages/maven/registries` |
|   |   | `POST` | `/virtual_registries/packages/maven/registries/:id/upstreams` |
|   |   | `POST` | `/virtual_registries/packages/maven/registry_upstreams` |
| Delete | Group | `DELETE` | `/virtual_registries/container/registries/:id` |
|   |   | `DELETE` | `/virtual_registries/container/registries/:id/cache` |
|   |   | `DELETE` | `/virtual_registries/container/registry_upstreams/:id` |
|   |   | `DELETE` | `/virtual_registries/container/upstreams/:id` |
|   |   | `DELETE` | `/virtual_registries/container/upstreams/:id/cache` |
|   |   | `DELETE` | `/virtual_registries/container/cache_entries/*id` |
|   |   | `DELETE` | `/virtual_registries/packages/maven/registries/:id` |
|   |   | `DELETE` | `/virtual_registries/packages/maven/registries/:id/cache` |
|   |   | `DELETE` | `/virtual_registries/packages/maven/upstreams/:id` |
|   |   | `DELETE` | `/virtual_registries/packages/maven/upstreams/:id/cache` |
|   |   | `DELETE` | `/virtual_registries/packages/maven/registry_upstreams/:id` |
|   |   | `DELETE` | `/virtual_registries/packages/maven/cache_entries/*id` |
| Read | Group | `GET` | `/virtual_registries/packages/maven/upstreams/:id/cache_entries` |
|   |   | `GET` | `/virtual_registries/packages/maven/upstreams/:id/test` |
|   |   | `GET` | `/virtual_registries/packages/maven/upstreams/:id` |
|   |   | `GET` | `/virtual_registries/packages/maven/registries/:id/upstreams` |
|   |   | `GET` | `/groups/:id/-/virtual_registries/packages/maven/upstreams` |
|   |   | `GET` | `/virtual_registries/packages/maven/registries/:id` |
|   |   | `GET` | `/groups/:id/-/virtual_registries/packages/maven/registries` |
|   |   | `GET` | `/virtual_registries/container/upstreams/:id/cache_entries` |
|   |   | `GET` | `/virtual_registries/container/upstreams/:id` |
|   |   | `GET` | `/virtual_registries/container/registries/:id/upstreams` |
|   |   | `GET` | `/groups/:id/-/virtual_registries/container/upstreams` |
|   |   | `GET` | `/virtual_registries/container/registries/:id` |
|   |   | `GET` | `/groups/:id/-/virtual_registries/container/registries` |
|   |   | `POST` | `/virtual_registries/container/upstreams/:id/test` |
|   |   | `POST` | `/groups/:id/-/virtual_registries/packages/maven/upstreams/test` |
|   |   | `POST` | `/groups/:id/-/virtual_registries/container/upstreams/test` |
|   |   | `POST` | `/virtual_registries/packages/maven/upstreams/:id/test` |
| Update | Group | `PATCH` | `/virtual_registries/container/registries/:id` |
|   |   | `PATCH` | `/virtual_registries/container/registry_upstreams/:id` |
|   |   | `PATCH` | `/virtual_registries/container/upstreams/:id` |
|   |   | `PATCH` | `/virtual_registries/packages/maven/registries/:id` |
|   |   | `PATCH` | `/virtual_registries/packages/maven/upstreams/:id` |
|   |   | `PATCH` | `/virtual_registries/packages/maven/registry_upstreams/:id` |

#### Virtual Registry Cleanup Policy

Grants the ability to create, read, update, and delete virtual registry cleanup policies.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/-/virtual_registries/cleanup/policy` |
| Delete | Group | `DELETE` | `/groups/:id/-/virtual_registries/cleanup/policy` |
| Read | Group | `GET` | `/groups/:id/-/virtual_registries/cleanup/policy` |
| Update | Group | `PATCH` | `/groups/:id/-/virtual_registries/cleanup/policy` |

### Project Features resources

#### Badge

Grants the ability to create, delete, read, and update badges.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/badges` |
|   | Group | `POST` | `/groups/:id/badges` |
| Delete | Project | `DELETE` | `/projects/:id/badges/:badge_id` |
|   | Group | `DELETE` | `/groups/:id/badges/:badge_id` |
| Read | Project | `GET` | `/projects/:id/badges` |
|   |   | `GET` | `/projects/:id/badges/render` |
|   |   | `GET` | `/projects/:id/badges/:badge_id` |
|   | Group | `GET` | `/groups/:id/badges` |
|   |   | `GET` | `/groups/:id/badges/render` |
|   |   | `GET` | `/groups/:id/badges/:badge_id` |
| Update | Project | `PUT` | `/projects/:id/badges/:badge_id` |
|   | Group | `PUT` | `/groups/:id/badges/:badge_id` |

#### Release

Grants the ability to create, delete, read, and update releases.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/releases` |
|   |   | `POST` | `/projects/:id/releases/:tag_name/evidence` |
| Delete | Project | `DELETE` | `/projects/:id/releases/:tag_name` |
| Read | Project | `GET` | `/projects/:id/releases` |
|   |   | `GET` | `/projects/:id/releases/:tag_name` |
|   |   | `GET` | `/projects/:id/releases/:tag_name/downloads/*direct_asset_path` |
|   |   | `GET` | `/projects/:id/releases/permalink/latest(/)(*suffix_path)` |
|   | Group | `GET` | `/groups/:id/releases` |
| Update | Project | `PUT` | `/projects/:id/releases/:tag_name` |

#### Release Link

Grants the ability to create, read, update, and delete release links.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/releases/:tag_name/assets/links` |
| Delete | Project | `DELETE` | `/projects/:id/releases/:tag_name/assets/links/:link_id` |
| Read | Project | `GET` | `/projects/:id/releases/:tag_name/assets/links` |
|   |   | `GET` | `/projects/:id/releases/:tag_name/assets/links/:link_id` |
| Update | Project | `PUT` | `/projects/:id/releases/:tag_name/assets/links/:link_id` |

#### Remote Mirror

Grants the ability to create, delete, read, sync, and update remote mirrors.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/remote_mirrors` |
| Delete | Project | `DELETE` | `/projects/:id/remote_mirrors/:mirror_id` |
| Read | Project | `GET` | `/projects/:id/remote_mirrors` |
|   |   | `GET` | `/projects/:id/remote_mirrors/:mirror_id` |
| Update | Project | `POST` | `/projects/:id/remote_mirrors/:mirror_id/sync` |
|   |   | `PUT` | `/projects/:id/remote_mirrors/:mirror_id` |

#### Remote Mirror Public Key

Grants the ability to read remote mirror public keys.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/remote_mirrors/:mirror_id/public_key` |

#### Snapshot

Grants the ability to read snapshots.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/snapshot` |

### Project Planning resources

#### Custom Attribute

Grants the ability to read, update, and delete custom attributes.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/custom_attributes/:key` |
|   | Group | `DELETE` | `/groups/:id/custom_attributes/:key` |
|   | Instance | `DELETE` | `/users/:id/custom_attributes/:key` |
| Read | Project | `GET` | `/projects/:id/custom_attributes` |
|   |   | `GET` | `/projects/:id/custom_attributes/:key` |
|   | Group | `GET` | `/groups/:id/custom_attributes` |
|   |   | `GET` | `/groups/:id/custom_attributes/:key` |
|   | Instance | `GET` | `/users/:id/custom_attributes` |
|   |   | `GET` | `/users/:id/custom_attributes/:key` |
| Update | Project | `PUT` | `/projects/:id/custom_attributes/:key` |
|   | Group | `PUT` | `/groups/:id/custom_attributes/:key` |
|   | Instance | `PUT` | `/users/:id/custom_attributes/:key` |

#### Epic Label Event

Grants the ability to read epic label events.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Group | `GET` | `/groups/:id/epics/:eventable_id/resource_label_events` |
|   |   | `GET` | `/groups/:id/epics/:eventable_id/resource_label_events/:event_id` |

#### Feature Flag

Grants the ability to create, delete, read, and update feature flags.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/feature_flags` |
| Delete | Project | `DELETE` | `/projects/:id/feature_flags/:feature_flag_name` |
| Read | Project | `GET` | `/projects/:id/feature_flags` |
|   |   | `GET` | `/projects/:id/feature_flags/:feature_flag_name` |
| Update | Project | `PUT` | `/projects/:id/feature_flags/:feature_flag_name` |

#### Feature Flag User List

Grants the ability to create, read, update, and delete feature flag user lists.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/feature_flags_user_lists` |
| Delete | Project | `DELETE` | `/projects/:id/feature_flags_user_lists/:iid` |
| Read | Project | `GET` | `/projects/:id/feature_flags_user_lists` |
|   |   | `GET` | `/projects/:id/feature_flags_user_lists/:iid` |
| Update | Project | `PUT` | `/projects/:id/feature_flags_user_lists/:iid` |

#### Freeze Period

Grants the ability to create, delete, read, and update freeze periods.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/freeze_periods` |
| Delete | Project | `DELETE` | `/projects/:id/freeze_periods/:freeze_period_id` |
| Read | Project | `GET` | `/projects/:id/freeze_periods` |
|   |   | `GET` | `/projects/:id/freeze_periods/:freeze_period_id` |
| Update | Project | `PUT` | `/projects/:id/freeze_periods/:freeze_period_id` |

#### Issue Label Event

Grants the ability to read issue label events.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/issues/:eventable_id/resource_label_events` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_label_events/:event_id` |

#### Merge Request Label Event

Grants the ability to read merge request label events.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/merge_requests/:eventable_id/resource_label_events` |
|   |   | `GET` | `/projects/:id/merge_requests/:eventable_id/resource_label_events/:event_id` |

#### Work Item

Grants the ability to read, write, and delete work items.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/issues/:issue_iid/award_emoji/:award_id` |
|   |   | `DELETE` | `/projects/:id/issues/:issue_iid/notes/:note_id/award_emoji/:award_id` |
|   |   | `DELETE` | `/projects/:id/merge_requests/:merge_request_iid/award_emoji/:award_id` |
|   |   | `DELETE` | `/projects/:id/merge_requests/:merge_request_iid/notes/:note_id/award_emoji/:award_id` |
|   |   | `DELETE` | `/projects/:id/snippets/:snippet_id/award_emoji/:award_id` |
|   |   | `DELETE` | `/projects/:id/snippets/:snippet_id/notes/:note_id/award_emoji/:award_id` |
|   |   | `DELETE` | `/projects/:id/issues/:issue_iid/links/:issue_link_id` |
|   |   | `DELETE` | `/projects/:id/issues/:issue_iid` |
|   |   | `DELETE` | `/projects/:id/boards/:board_id` |
|   |   | `DELETE` | `/projects/:id/boards/:board_id/lists/:list_id` |
|   |   | `DELETE` | `/projects/:id/issues/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `DELETE` | `/projects/:id/snippets/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `DELETE` | `/projects/:id/issues/:noteable_id/notes/:note_id` |
|   |   | `DELETE` | `/projects/:id/merge_requests/:noteable_id/notes/:note_id` |
|   |   | `DELETE` | `/projects/:id/snippets/:noteable_id/notes/:note_id` |
|   |   | `DELETE` | `/projects/:id/wiki_pages/:noteable_id/notes/:note_id` |
|   |   | `DELETE` | `/projects/:id/milestones/:milestone_id` |
|   | Group | `DELETE` | `/groups/:id/epics/:epic_iid/award_emoji/:award_id` |
|   |   | `DELETE` | `/groups/:id/epics/:epic_iid/notes/:note_id/award_emoji/:award_id` |
|   |   | `DELETE` | `/groups/:id/epics/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `DELETE` | `/groups/:id/boards/:board_id/lists/:list_id` |
|   |   | `DELETE` | `/groups/:id/labels` |
|   |   | `DELETE` | `/groups/:id/labels/:name` |
|   |   | `DELETE` | `/groups/:id/milestones/:milestone_id` |
|   |   | `DELETE` | `/groups/:id/epics/:noteable_id/notes/:note_id` |
|   |   | `DELETE` | `/groups/:id/wiki_pages/:noteable_id/notes/:note_id` |
|   |   | `DELETE` | `/groups/:id/boards/:board_id` |
|   |   | `DELETE` | `/groups/:id/(-/)epics/:epic_iid/issues/:epic_issue_id` |
|   |   | `DELETE` | `/groups/:id/(-/)epics/:epic_iid/epics/:child_epic_id` |
|   |   | `DELETE` | `/groups/:id/(-/)epics/:epic_iid` |
|   |   | `DELETE` | `/groups/:id/epics/:epic_iid/related_epics/:related_epic_link_id` |
| Read | Project | `GET` | `/projects/:id/issues/:issue_iid/award_emoji` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/award_emoji/:award_id` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/notes/:note_id/award_emoji` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/notes/:note_id/award_emoji/:award_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/award_emoji` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/award_emoji/:award_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/notes/:note_id/award_emoji` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/notes/:note_id/award_emoji/:award_id` |
|   |   | `GET` | `/projects/:id/snippets/:snippet_id/award_emoji` |
|   |   | `GET` | `/projects/:id/snippets/:snippet_id/award_emoji/:award_id` |
|   |   | `GET` | `/projects/:id/snippets/:snippet_id/notes/:note_id/award_emoji` |
|   |   | `GET` | `/projects/:id/snippets/:snippet_id/notes/:note_id/award_emoji/:award_id` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/links` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/links/:issue_link_id` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/time_stats` |
|   |   | `GET` | `/projects/:id/issues` |
|   |   | `GET` | `/projects/:id/issues_statistics` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/related_merge_requests` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/closed_by` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/participants` |
|   |   | `GET` | `/projects/:id/issues/:issue_iid/user_agent_detail` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/time_stats` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_milestone_events` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_milestone_events/:event_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:eventable_id/resource_milestone_events` |
|   |   | `GET` | `/projects/:id/merge_requests/:eventable_id/resource_milestone_events/:event_id` |
|   |   | `GET` | `/projects/:id/boards` |
|   |   | `GET` | `/projects/:id/boards/:board_id` |
|   |   | `GET` | `/projects/:id/boards/:board_id/lists` |
|   |   | `GET` | `/projects/:id/boards/:board_id/lists/:list_id` |
|   |   | `GET` | `/projects/:id/issues/:noteable_id/discussions` |
|   |   | `GET` | `/projects/:id/issues/:noteable_id/discussions/:discussion_id` |
|   |   | `GET` | `/projects/:id/issues/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `GET` | `/projects/:id/issues/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `GET` | `/projects/:id/snippets/:noteable_id/discussions` |
|   |   | `GET` | `/projects/:id/snippets/:noteable_id/discussions/:discussion_id` |
|   |   | `GET` | `/projects/:id/snippets/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `GET` | `/projects/:id/snippets/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `GET` | `/projects/:id/issues/:noteable_id/notes` |
|   |   | `GET` | `/projects/:id/issues/:noteable_id/notes/:note_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:noteable_id/notes` |
|   |   | `GET` | `/projects/:id/merge_requests/:noteable_id/notes/:note_id` |
|   |   | `GET` | `/projects/:id/snippets/:noteable_id/notes` |
|   |   | `GET` | `/projects/:id/snippets/:noteable_id/notes/:note_id` |
|   |   | `GET` | `/projects/:id/wiki_pages/:noteable_id/notes` |
|   |   | `GET` | `/projects/:id/wiki_pages/:noteable_id/notes/:note_id` |
|   |   | `GET` | `/projects/:id/milestones` |
|   |   | `GET` | `/projects/:id/milestones/:milestone_id` |
|   |   | `GET` | `/projects/:id/milestones/:milestone_id/issues` |
|   |   | `GET` | `/projects/:id/milestones/:milestone_id/merge_requests` |
|   |   | `GET` | `/projects/:id/milestones/:milestone_id/burndown_events` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_state_events` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_state_events/:event_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:eventable_id/resource_state_events` |
|   |   | `GET` | `/projects/:id/merge_requests/:eventable_id/resource_state_events/:event_id` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_weight_events` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_weight_events/:event_id` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_iteration_events` |
|   |   | `GET` | `/projects/:id/issues/:eventable_id/resource_iteration_events/:event_id` |
|   |   | `GET` | `/projects/:id/iterations` |
|   | Group | `GET` | `/groups/:id/epics/:epic_iid/award_emoji` |
|   |   | `GET` | `/groups/:id/epics/:epic_iid/award_emoji/:award_id` |
|   |   | `GET` | `/groups/:id/epics/:epic_iid/notes/:note_id/award_emoji` |
|   |   | `GET` | `/groups/:id/epics/:epic_iid/notes/:note_id/award_emoji/:award_id` |
|   |   | `GET` | `/groups/:id/issues` |
|   |   | `GET` | `/groups/:id/issues_statistics` |
|   |   | `GET` | `/groups/:id/epics/:noteable_id/discussions` |
|   |   | `GET` | `/groups/:id/epics/:noteable_id/discussions/:discussion_id` |
|   |   | `GET` | `/groups/:id/epics/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `GET` | `/groups/:id/epics/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `GET` | `/groups/:id/boards` |
|   |   | `GET` | `/groups/:id/boards/:board_id` |
|   |   | `GET` | `/groups/:id/boards/:board_id/lists` |
|   |   | `GET` | `/groups/:id/boards/:board_id/lists/:list_id` |
|   |   | `GET` | `/groups/:id/labels` |
|   |   | `GET` | `/groups/:id/labels/:name` |
|   |   | `GET` | `/groups/:id/milestones` |
|   |   | `GET` | `/groups/:id/milestones/:milestone_id` |
|   |   | `GET` | `/groups/:id/milestones/:milestone_id/issues` |
|   |   | `GET` | `/groups/:id/milestones/:milestone_id/merge_requests` |
|   |   | `GET` | `/groups/:id/milestones/:milestone_id/burndown_events` |
|   |   | `GET` | `/groups/:id/epics/:noteable_id/notes` |
|   |   | `GET` | `/groups/:id/epics/:noteable_id/notes/:note_id` |
|   |   | `GET` | `/groups/:id/wiki_pages/:noteable_id/notes` |
|   |   | `GET` | `/groups/:id/wiki_pages/:noteable_id/notes/:note_id` |
|   |   | `GET` | `/groups/:id/epics/:eventable_id/resource_state_events` |
|   |   | `GET` | `/groups/:id/epics/:eventable_id/resource_state_events/:event_id` |
|   |   | `GET` | `/groups/:id/epics/:epic_iid/issues` |
|   |   | `GET` | `/groups/:id/-/epics/:epic_iid/issues` |
|   |   | `GET` | `/groups/:id/(-/)epics/:epic_iid/epics` |
|   |   | `GET` | `/groups/:id/epics` |
|   |   | `GET` | `/groups/:id/-/epics` |
|   |   | `GET` | `/groups/:id/epics/:epic_iid` |
|   |   | `GET` | `/groups/:id/-/epics/:epic_iid` |
|   |   | `GET` | `/groups/:id/epic_boards` |
|   |   | `GET` | `/groups/:id/epic_boards/:board_id` |
|   |   | `GET` | `/groups/:id/epic_boards/:board_id/lists` |
|   |   | `GET` | `/groups/:id/epic_boards/:board_id/lists/:list_id` |
|   |   | `GET` | `/groups/:id/related_epic_links` |
|   |   | `GET` | `/groups/:id/epics/:epic_iid/related_epics` |
|   |   | `GET` | `/groups/:id/iterations` |
|   | User | `GET` | `/issues_statistics` |
|   |   | `GET` | `/issues` |
|   | Instance | `GET` | `/issues/:id` |
| Write | Project | `POST` | `/projects/:id/milestones/:milestone_id/promote` |
|   |   | `POST` | `/projects/:id/milestones` |
|   |   | `POST` | `/projects/:id/wiki_pages/:noteable_id/notes` |
|   |   | `POST` | `/projects/:id/snippets/:noteable_id/notes` |
|   |   | `POST` | `/projects/:id/merge_requests/:noteable_id/notes` |
|   |   | `POST` | `/projects/:id/issues/:noteable_id/notes` |
|   |   | `POST` | `/projects/:id/snippets/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `POST` | `/projects/:id/snippets/:noteable_id/discussions` |
|   |   | `POST` | `/projects/:id/issues/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `POST` | `/projects/:id/issues/:noteable_id/discussions` |
|   |   | `POST` | `/projects/:id/boards/:board_id/lists` |
|   |   | `POST` | `/projects/:id/boards` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/reset_spent_time` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/add_spent_time` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/reset_time_estimate` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/time_estimate` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/award_emoji` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/notes/:note_id/award_emoji` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/award_emoji` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/notes/:note_id/award_emoji` |
|   |   | `POST` | `/projects/:id/snippets/:snippet_id/award_emoji` |
|   |   | `POST` | `/projects/:id/snippets/:snippet_id/notes/:note_id/award_emoji` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/links` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/time_estimate` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/reset_time_estimate` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/clone` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/move` |
|   |   | `POST` | `/projects/:id/issues` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/reset_spent_time` |
|   |   | `POST` | `/projects/:id/issues/:issue_iid/add_spent_time` |
|   |   | `PUT` | `/projects/:id/boards/:board_id/lists/:list_id` |
|   |   | `PUT` | `/projects/:id/snippets/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `PUT` | `/projects/:id/boards/:board_id` |
|   |   | `PUT` | `/projects/:id/issues/:noteable_id/notes/:note_id` |
|   |   | `PUT` | `/projects/:id/issues/:noteable_id/discussions/:discussion_id` |
|   |   | `PUT` | `/projects/:id/merge_requests/:noteable_id/notes/:note_id` |
|   |   | `PUT` | `/projects/:id/issues/:issue_iid` |
|   |   | `PUT` | `/projects/:id/snippets/:noteable_id/notes/:note_id` |
|   |   | `PUT` | `/projects/:id/issues/:issue_iid/reorder` |
|   |   | `PUT` | `/projects/:id/wiki_pages/:noteable_id/notes/:note_id` |
|   |   | `PUT` | `/projects/:id/issues/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `PUT` | `/projects/:id/milestones/:milestone_id` |
|   | Group | `POST` | `/groups/:id/epics/:epic_iid/related_epics` |
|   |   | `POST` | `/groups/:id/(-/)epics` |
|   |   | `POST` | `/groups/:id/(-/)epics/:epic_iid/epics` |
|   |   | `POST` | `/groups/:id/(-/)epics/:epic_iid/epics/:child_epic_id` |
|   |   | `POST` | `/groups/:id/(-/)epics/:epic_iid/issues/:issue_id` |
|   |   | `POST` | `/groups/:id/boards` |
|   |   | `POST` | `/groups/:id/wiki_pages/:noteable_id/notes` |
|   |   | `POST` | `/groups/:id/epics/:noteable_id/notes` |
|   |   | `POST` | `/groups/:id/milestones` |
|   |   | `POST` | `/groups/:id/epics/:epic_iid/award_emoji` |
|   |   | `POST` | `/groups/:id/epics/:epic_iid/notes/:note_id/award_emoji` |
|   |   | `POST` | `/groups/:id/epics/:noteable_id/discussions` |
|   |   | `POST` | `/groups/:id/epics/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `POST` | `/groups/:id/boards/:board_id/lists` |
|   |   | `POST` | `/groups/:id/labels` |
|   |   | `PUT` | `/groups/:id/milestones/:milestone_id` |
|   |   | `PUT` | `/groups/:id/epics/:noteable_id/notes/:note_id` |
|   |   | `PUT` | `/groups/:id/boards/:board_id` |
|   |   | `PUT` | `/groups/:id/wiki_pages/:noteable_id/notes/:note_id` |
|   |   | `PUT` | `/groups/:id/epics/:noteable_id/discussions/:discussion_id` |
|   |   | `PUT` | `/groups/:id/(-/)epics/:epic_iid/issues/:epic_issue_id` |
|   |   | `PUT` | `/groups/:id/epics/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `PUT` | `/groups/:id/boards/:board_id/lists/:list_id` |
|   |   | `PUT` | `/groups/:id/labels/:name` |
|   |   | `PUT` | `/groups/:id/(-/)epics/:epic_iid/epics/:child_epic_id` |
|   |   | `PUT` | `/groups/:id/labels` |
|   |   | `PUT` | `/groups/:id/(-/)epics/:epic_iid` |

### Projects resources

#### Page

Grants the ability to delete, read, and update pages.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/pages` |
| Read | Project | `GET` | `/projects/:id/pages` |
| Update | Project | `PATCH` | `/projects/:id/pages` |

#### Pages Domain

Grants the ability to create, delete, read, update, and verify pages domains.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/pages/domains` |
| Delete | Project | `DELETE` | `/projects/:id/pages/domains/:domain` |
| Read | Project | `GET` | `/projects/:id/pages/domains` |
|   |   | `GET` | `/projects/:id/pages/domains/:domain` |
| Update | Project | `PUT` | `/projects/:id/pages/domains/:domain` |
| Verify | Project | `PUT` | `/projects/:id/pages/domains/:domain/verify` |

#### Project

Grants the ability to archive, create, delete, fork, import members, mark as forked, read, recalculate storage, restore, share, star, transfer, trigger repository housekeeping, unarchive, unstar, update, and view various project attributes including contributed projects, forks, groups, invited groups, languages, page access, share locations, starrers, starred projects, storage, transfer locations, and users, as well as delete project group links.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Archive | Project | `POST` | `/projects/:id/archive` |
|   |   | `POST` | `/projects/:id/unarchive` |
| Create | User | `POST` | `/projects` |
|   |   | `POST` | `/projects/user/:user_id` |
| Delete | Project | `DELETE` | `/projects/:id` |
| Fork | Project | `POST` | `/projects/:id/fork` |
|   |   | `POST` | `/projects/:id/fork/:forked_from_id` |
|   |   | `DELETE` | `/projects/:id/fork` |
| Read | Project | `GET` | `/projects/:id/share_locations` |
|   |   | `GET` | `/projects/:id` |
|   |   | `GET` | `/projects/:id/forks` |
|   |   | `GET` | `/projects/:id/pages_access` |
|   |   | `GET` | `/projects/:id/starrers` |
|   |   | `GET` | `/projects/:id/languages` |
|   |   | `GET` | `/projects/:id/users` |
|   |   | `GET` | `/projects/:id/groups` |
|   |   | `GET` | `/projects/:id/invited_groups` |
|   |   | `GET` | `/projects/:id/transfer_locations` |
|   |   | `GET` | `/projects/:id/storage` |
|   | Group | `GET` | `/groups/:id/projects` |
|   | User | `GET` | `/users/:user_id/projects` |
|   |   | `GET` | `/users/:user_id/contributed_projects` |
|   |   | `GET` | `/projects` |
| Read Starred | User | `GET` | `/users/:user_id/starred_projects` |
| Share | Project | `POST` | `/projects/:id/share` |
|   |   | `DELETE` | `/projects/:id/share/:group_id` |
| Transfer | Project | `PUT` | `/projects/:id/transfer` |
|   | Instance | `POST` | `/groups/:id/projects/:project_id` |
| Update | Project | `POST` | `/projects/:id/restore` |
|   |   | `POST` | `/projects/:id/star` |
|   |   | `POST` | `/projects/:id/unstar` |
|   |   | `POST` | `/projects/:id/import_project_members/:project_id` |
|   |   | `POST` | `/projects/:id/housekeeping` |
|   |   | `POST` | `/projects/:id/repository_size` |
|   |   | `PUT` | `/projects/:id` |

### Repository resources

#### Approval Configuration

Grants the ability to read and update approval settings.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/approvals` |
| Update | Project | `POST` | `/projects/:id/approvals` |

#### Approval Rule

Grants the ability to create, delete, read, and update approval rules.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/approval_rules` |
|   | Group | `POST` | `/groups/:id/approval_rules` |
| Delete | Project | `DELETE` | `/projects/:id/approval_rules/:approval_rule_id` |
| Read | Project | `GET` | `/projects/:id/approval_rules` |
|   |   | `GET` | `/projects/:id/approval_rules/:approval_rule_id` |
|   | Group | `GET` | `/groups/:id/approval_rules` |
| Update | Project | `PUT` | `/projects/:id/approval_rules/:approval_rule_id` |
|   | Group | `PUT` | `/groups/:id/approval_rules/:approval_rule_id` |

#### Approval Setting

Grants the ability to read and update merge request approval settings.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/merge_request_approval_setting` |
|   | Group | `GET` | `/groups/:id/merge_request_approval_setting` |
| Update | Project | `PUT` | `/projects/:id/merge_request_approval_setting` |
|   | Group | `PUT` | `/groups/:id/merge_request_approval_setting` |

#### Branch

Grants the ability to create, delete, protect, and read branches.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/repository/branches` |
| Delete | Project | `DELETE` | `/projects/:id/repository/branches/:branch` |
|   |   | `DELETE` | `/projects/:id/repository/merged_branches` |
| Protect | Project | `POST` | `/projects/:id/protected_branches` |
|   |   | `PUT` | `/projects/:id/repository/branches/:branch/protect` |
|   |   | `PUT` | `/projects/:id/repository/branches/:branch/unprotect` |
|   |   | `DELETE` | `/projects/:id/protected_branches/:name` |
|   | Group | `POST` | `/groups/:id/protected_branches` |
|   |   | `DELETE` | `/groups/:id/protected_branches/:name` |
| Read | Project | `GET` | `/projects/:id/repository/branches` |
|   |   | `GET` | `/projects/:id/repository/branches/:branch` |
|   |   | `HEAD` | `/projects/:id/repository/branches/:branch` |

#### Commit

Grants the ability to create, read, and update commits.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/repository/commits/authorize` |
|   |   | `POST` | `/projects/:id/repository/commits` |
|   |   | `POST` | `/projects/:id/repository/commits/:sha/cherry_pick` |
|   |   | `POST` | `/projects/:id/repository/commits/:sha/revert` |
|   |   | `POST` | `/projects/:id/repository/commits/:noteable_id/discussions` |
|   |   | `POST` | `/projects/:id/repository/commits/:noteable_id/discussions/:discussion_id/notes` |
| Delete | Project | `DELETE` | `/projects/:id/repository/commits/:noteable_id/discussions/:discussion_id/notes/:note_id` |
| Read | Project | `GET` | `/projects/:id/repository/commits` |
|   |   | `GET` | `/projects/:id/repository/commits/:sha` |
|   |   | `GET` | `/projects/:id/repository/commits/:sha/diff` |
|   |   | `GET` | `/projects/:id/repository/commits/:sha/comments` |
|   |   | `GET` | `/projects/:id/repository/commits/:sha/sequence` |
|   |   | `GET` | `/projects/:id/repository/commits/:sha/refs` |
|   |   | `GET` | `/projects/:id/repository/commits/:sha/merge_requests` |
|   |   | `GET` | `/projects/:id/repository/commits/:sha/signature` |
|   |   | `GET` | `/projects/:id/repository/commits/:noteable_id/discussions` |
|   |   | `GET` | `/projects/:id/repository/commits/:noteable_id/discussions/:discussion_id` |
|   |   | `GET` | `/projects/:id/repository/commits/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `GET` | `/projects/:id/repository/commits/:noteable_id/discussions/:discussion_id/notes/:note_id` |
| Update | Project | `POST` | `/projects/:id/repository/commits/:sha/comments` |
|   |   | `PUT` | `/projects/:id/repository/commits/:noteable_id/discussions/:discussion_id/notes/:note_id` |

#### Merge Request

Grants the ability to approve, reset approvals, and unapprove merge requests.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Approve | Project | `POST` | `/projects/:id/merge_requests/:merge_request_iid/approve` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/unapprove` |
|   |   | `PUT` | `/projects/:id/merge_requests/:merge_request_iid/reset_approvals` |
| Create | Project | `POST` | `/projects/:id/merge_requests` |
|   |   | `POST` | `/projects/:id/merge_requests/:noteable_id/discussions` |
|   |   | `POST` | `/projects/:id/merge_requests/:noteable_id/discussions/:discussion_id/notes` |
| Delete | Project | `DELETE` | `/projects/:id/merge_requests/:merge_request_iid` |
|   |   | `DELETE` | `/projects/:id/merge_requests/:noteable_id/discussions/:discussion_id/notes/:note_id` |
| Merge | Project | `POST` | `/projects/:id/merge_requests/:merge_request_iid/cancel_merge_when_pipeline_succeeds` |
|   |   | `PUT` | `/projects/:id/merge_requests/:merge_request_iid/merge` |
| Read | Project | `GET` | `/projects/:id/merge_requests/:merge_request_iid/draft_notes` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/draft_notes/:draft_note_id` |
|   |   | `GET` | `/projects/:id/merge_requests` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/participants` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/reviewers` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/commits` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/context_commits` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/changes` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/diffs` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/raw_diffs` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/pipelines` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/merge_ref` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/closes_issues` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/related_issues` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/versions` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/versions/:version_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:noteable_id/discussions` |
|   |   | `GET` | `/projects/:id/merge_requests/:noteable_id/discussions/:discussion_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:noteable_id/discussions/:discussion_id/notes` |
|   |   | `GET` | `/projects/:id/merge_requests/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   | Group | `GET` | `/groups/:id/merge_requests` |
|   | User | `GET` | `/merge_requests` |
| Update | Project | `POST` | `/projects/:id/merge_requests/:merge_request_iid/draft_notes` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/draft_notes/bulk_publish` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/context_commits` |
|   |   | `POST` | `/projects/:id/merge_requests/:merge_request_iid/pipelines` |
|   |   | `PUT` | `/projects/:id/merge_requests/:merge_request_iid/draft_notes/:draft_note_id` |
|   |   | `PUT` | `/projects/:id/merge_requests/:merge_request_iid/draft_notes/:draft_note_id/publish` |
|   |   | `PUT` | `/projects/:id/merge_requests/:merge_request_iid` |
|   |   | `PUT` | `/projects/:id/merge_requests/:merge_request_iid/rebase` |
|   |   | `PUT` | `/projects/:id/merge_requests/:noteable_id/discussions/:discussion_id/notes/:note_id` |
|   |   | `PUT` | `/projects/:id/merge_requests/:noteable_id/discussions/:discussion_id` |
|   |   | `DELETE` | `/projects/:id/merge_requests/:merge_request_iid/draft_notes/:draft_note_id` |
|   |   | `DELETE` | `/projects/:id/merge_requests/:merge_request_iid/context_commits` |

#### Merge Request Approval Rule

Grants the ability to create, delete, read, and update merge request approval rules.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/merge_requests/:merge_request_iid/approval_rules` |
| Delete | Project | `DELETE` | `/projects/:id/merge_requests/:merge_request_iid/approval_rules/:approval_rule_id` |
| Read | Project | `GET` | `/projects/:id/merge_requests/:merge_request_iid/approval_rules` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/approval_rules/:approval_rule_id` |
| Update | Project | `PUT` | `/projects/:id/merge_requests/:merge_request_iid/approval_rules/:approval_rule_id` |

#### Merge Request Approval State

Grants the ability to read merge request approval state.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/merge_requests/:merge_request_iid/approvals` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/approval_state` |

#### Merge Request Dependency

Grants the ability to create, delete, and read merge request dependencies.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/merge_requests/:merge_request_iid/blocks` |
| Delete | Project | `DELETE` | `/projects/:id/merge_requests/:merge_request_iid/blocks/:block_id` |
| Read | Project | `GET` | `/projects/:id/merge_requests/:merge_request_iid/blocks` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/blocks/:block_id` |
|   |   | `GET` | `/projects/:id/merge_requests/:merge_request_iid/blockees` |

#### Protected Branch

Grants the ability to create, delete, read, and update protected branches.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/protected_branches` |
|   |   | `GET` | `/projects/:id/protected_branches/:name` |
|   | Group | `GET` | `/groups/:id/protected_branches` |
|   |   | `GET` | `/groups/:id/protected_branches/:name` |
| Update | Project | `PATCH` | `/projects/:id/protected_branches/:name` |
|   | Group | `PATCH` | `/groups/:id/protected_branches/:name` |

#### Protected Tag

Grants the ability to create, delete, and read protected tags.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/protected_tags` |
|   |   | `GET` | `/projects/:id/protected_tags/:name` |
|   |   | `GET` | `/projects/:id/protected_tags` |
|   |   | `GET` | `/projects/:id/protected_tags/:name` |

#### Push Rule

Grants the ability to create, delete, read, and update push rules.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/push_rule` |
|   | Group | `POST` | `/groups/:id/push_rule` |
| Delete | Project | `DELETE` | `/projects/:id/push_rule` |
|   | Group | `DELETE` | `/groups/:id/push_rule` |
| Read | Project | `GET` | `/projects/:id/push_rule` |
|   | Group | `GET` | `/groups/:id/push_rule` |
| Update | Project | `PUT` | `/projects/:id/push_rule` |
|   | Group | `PUT` | `/groups/:id/push_rule` |

#### Repository

Grants the ability to create and read repositories.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/repository/files/:file_path` |
|   |   | `POST` | `/projects/:id/repository/changelog` |
| Delete | Project | `DELETE` | `/projects/:id/repository/files/:file_path` |
| Read | Project | `GET` | `/projects/:id/repository/files/:file_path/blame` |
|   |   | `GET` | `/projects/:id/repository/files/:file_path/raw` |
|   |   | `GET` | `/projects/:id/repository/files/:file_path` |
|   |   | `GET` | `/projects/:id/repository/tree` |
|   |   | `GET` | `/projects/:id/repository/blobs/:sha/raw` |
|   |   | `GET` | `/projects/:id/repository/blobs/:sha` |
|   |   | `GET` | `/projects/:id/repository/archive` |
|   |   | `GET` | `/projects/:id/repository/compare` |
|   |   | `GET` | `/projects/:id/repository/health` |
|   |   | `GET` | `/projects/:id/repository/contributors` |
|   |   | `GET` | `/projects/:id/repository/merge_base` |
|   |   | `GET` | `/projects/:id/repository/changelog` |
|   |   | `HEAD` | `/projects/:id/repository/files/:file_path/blame` |
|   |   | `HEAD` | `/projects/:id/repository/files/:file_path` |
| Update | Project | `PUT` | `/projects/:id/repository/files/:file_path` |

#### Repository Submodule

Grants the ability to update repository submodules.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Update | Project | `PUT` | `/projects/:id/repository/submodules/:submodule` |

#### Repository Tag

Grants the ability to create, delete, and read repository tags.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/repository/tags` |
|   |   | `POST` | `/projects/:id/repository/tags` |
| Delete | Project | `DELETE` | `/projects/:id/repository/tags/:tag_name` |
|   |   | `DELETE` | `/projects/:id/repository/tags/:tag_name` |
| Read | Project | `GET` | `/projects/:id/repository/tags` |
|   |   | `GET` | `/projects/:id/repository/tags/:tag_name` |
|   |   | `GET` | `/projects/:id/repository/tags/:tag_name/signature` |
|   |   | `GET` | `/projects/:id/repository/tags` |
|   |   | `GET` | `/projects/:id/repository/tags/:tag_name` |
|   |   | `GET` | `/projects/:id/repository/tags/:tag_name/signature` |

#### Tag

Grants the ability to create, delete, and read tags.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Protect | Project | `POST` | `/projects/:id/protected_tags` |
|   |   | `POST` | `/projects/:id/protected_tags` |
|   |   | `DELETE` | `/projects/:id/protected_tags/:name` |
|   |   | `DELETE` | `/projects/:id/protected_tags/:name` |

### System Access resources

#### Access Request

Grants the ability to approve, delete, and read access requests.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Approve | Project | `PUT` | `/projects/:id/access_requests/:user_id/approve` |
|   | Group | `PUT` | `/groups/:id/access_requests/:user_id/approve` |
| Create | User | `POST` | `/groups/:id/access_requests` |
|   |   | `POST` | `/projects/:id/access_requests` |
| Delete | Project | `DELETE` | `/projects/:id/access_requests/:user_id` |
|   | Group | `DELETE` | `/groups/:id/access_requests/:user_id` |
|   | User | `DELETE` | `/groups/:id/access_requests/:user_id` |
|   |   | `DELETE` | `/projects/:id/access_requests/:user_id` |
| Read | Project | `GET` | `/projects/:id/access_requests` |
|   | Group | `GET` | `/groups/:id/access_requests` |

#### Application Appearance

Grants the ability to read and update application appearance settings.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Instance | `GET` | `/application/appearance` |
| Update | Instance | `PUT` | `/application/appearance` |

#### Deploy Key

Grants the ability to create, read, update, enable, and delete deploy keys.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/deploy_keys` |
|   | Instance | `POST` | `/deploy_keys` |
| Delete | Project | `DELETE` | `/projects/:id/deploy_keys/:key_id` |
| Enable | Project | `POST` | `/projects/:id/deploy_keys/:key_id/enable` |
| Read | Project | `GET` | `/projects/:id/deploy_keys` |
|   |   | `GET` | `/projects/:id/deploy_keys/:key_id` |
|   | Instance | `GET` | `/deploy_keys` |
| Update | Project | `PUT` | `/projects/:id/deploy_keys/:key_id` |

#### Deploy Token

Grants the ability to create, read, and delete deploy tokens.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/deploy_tokens` |
|   | Group | `POST` | `/groups/:id/deploy_tokens` |
| Delete | Project | `DELETE` | `/projects/:id/deploy_tokens/:token_id` |
|   | Group | `DELETE` | `/groups/:id/deploy_tokens/:token_id` |
| Read | Project | `GET` | `/projects/:id/deploy_tokens` |
|   |   | `GET` | `/projects/:id/deploy_tokens/:token_id` |
|   | Group | `GET` | `/groups/:id/deploy_tokens` |
|   |   | `GET` | `/groups/:id/deploy_tokens/:token_id` |
|   | Instance | `GET` | `/deploy_tokens` |

#### Enterprise User

Grants the ability to read, update, delete, and disable two-factor authentication for enterprise users.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Group | `DELETE` | `/groups/:id/enterprise_users/:user_id` |
| Disable Two Factor | Group | `PATCH` | `/groups/:id/enterprise_users/:user_id/disable_two_factor` |
| Read | Group | `GET` | `/groups/:id/enterprise_users` |
|   |   | `GET` | `/groups/:id/enterprise_users/:user_id` |
| Update | Group | `PATCH` | `/groups/:id/enterprise_users/:user_id` |

#### Invitation

Grants the ability to create, read, update, and delete invitations.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/invitations` |
|   | Group | `POST` | `/groups/:id/invitations` |
| Delete | Project | `DELETE` | `/projects/:id/invitations/:email` |
|   | Group | `DELETE` | `/groups/:id/invitations/:email` |
| Read | Project | `GET` | `/projects/:id/invitations` |
|   | Group | `GET` | `/groups/:id/invitations` |
| Update | Project | `PUT` | `/projects/:id/invitations/:email` |
|   | Group | `PUT` | `/groups/:id/invitations/:email` |

#### Job Token Scope

Grants the ability to read and update job token scope.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/job_token_scope` |
| Update | Project | `PATCH` | `/projects/:id/job_token_scope` |

#### Job Token Scope Allowlist

Grants the ability to create, read, and delete job token scope allowlist entries.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/job_token_scope/allowlist` |
|   |   | `POST` | `/projects/:id/job_token_scope/groups_allowlist` |
| Delete | Project | `DELETE` | `/projects/:id/job_token_scope/groups_allowlist/:target_group_id` |
|   |   | `DELETE` | `/projects/:id/job_token_scope/allowlist/:target_project_id` |
| Read | Project | `GET` | `/projects/:id/job_token_scope/allowlist` |
|   |   | `GET` | `/projects/:id/job_token_scope/groups_allowlist` |

#### LDAP Group Link

Grants the ability to create, read, and delete LDAP group links.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/ldap_group_links` |
| Delete | Group | `DELETE` | `/groups/:id/ldap_group_links/:cn` |
|   |   | `DELETE` | `/groups/:id/ldap_group_links/:provider/:cn` |
|   |   | `DELETE` | `/groups/:id/ldap_group_links` |
| Read | Group | `GET` | `/groups/:id/ldap_group_links` |

#### Member

Grants the ability to create, delete, read, and update members.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/members` |
|   | Group | `POST` | `/groups/:id/members` |
| Delete | Project | `DELETE` | `/projects/:id/members/:user_id` |
|   | Group | `DELETE` | `/groups/:id/members/:user_id` |
|   |   | `DELETE` | `/groups/:id/billable_members/:user_id` |
| Read | Project | `GET` | `/projects/:id/members` |
|   |   | `GET` | `/projects/:id/members/all` |
|   |   | `GET` | `/projects/:id/members/:user_id` |
|   |   | `GET` | `/projects/:id/members/all/:user_id` |
|   | Group | `GET` | `/groups/:id/members` |
|   |   | `GET` | `/groups/:id/members/all` |
|   |   | `GET` | `/groups/:id/members/:user_id` |
|   |   | `GET` | `/groups/:id/members/all/:user_id` |
|   |   | `GET` | `/groups/:id/pending_members` |
|   |   | `GET` | `/groups/:id/billable_members` |
|   |   | `GET` | `/groups/:id/billable_members/:user_id/memberships` |
|   |   | `GET` | `/groups/:id/billable_members/:user_id/indirect` |
| Update | Project | `PUT` | `/projects/:id/members/:user_id` |
|   | Group | `POST` | `/groups/:id/members/:user_id/override` |
|   |   | `POST` | `/groups/:id/members/approve_all` |
|   |   | `PUT` | `/groups/:id/members/:user_id` |
|   |   | `PUT` | `/groups/:id/members/:member_id/approve` |
|   |   | `PUT` | `/groups/:id/members/:user_id/state` |
|   |   | `DELETE` | `/groups/:id/members/:user_id/override` |

#### Metadata

Grants the ability to read instance metadata.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Instance | `GET` | `/metadata` |
|   |   | `GET` | `/version` |

#### OAuth Application

Grants the ability to create, read, update, renew secret, and delete OAuth applications.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Instance | `POST` | `/applications` |
| Delete | Instance | `DELETE` | `/applications/:id` |
| Read | Instance | `GET` | `/applications` |
| Renew Secret | Instance | `POST` | `/applications/:id/renew-secret` |

#### Personal Access Token

Grants the ability to read, revoke, and rotate personal access tokens.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/personal_access_tokens` |
|   |   | `GET` | `/personal_access_tokens/:id` |
| Revoke | User | `DELETE` | `/personal_access_tokens/:id` |
| Rotate | User | `POST` | `/personal_access_tokens/:id/rotate` |

#### Plan Limit

Grants the ability to view and modify plan limits.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Instance | `GET` | `/application/plan_limits` |
| Update | Instance | `PUT` | `/application/plan_limits` |

#### Resource Access Token

Grants the ability to create, read, rotate, and delete resource access tokens.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/access_tokens` |
|   | Group | `POST` | `/groups/:id/access_tokens` |
| Delete | Project | `DELETE` | `/projects/:id/access_tokens/:token_id` |
|   | Group | `DELETE` | `/groups/:id/access_tokens/:token_id` |
| Read | Project | `GET` | `/projects/:id/access_tokens` |
|   |   | `GET` | `/projects/:id/access_tokens/:token_id` |
|   | Group | `GET` | `/groups/:id/access_tokens` |
|   |   | `GET` | `/groups/:id/access_tokens/:token_id` |
| Rotate | Project | `POST` | `/projects/:id/access_tokens/self/rotate` |
|   |   | `POST` | `/projects/:id/access_tokens/:token_id/rotate` |
|   | Group | `POST` | `/groups/:id/access_tokens/self/rotate` |
|   |   | `POST` | `/groups/:id/access_tokens/:token_id/rotate` |

#### SAML Group Link

Grants the ability to create, read, and delete SAML group links.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/saml_group_links` |
| Delete | Group | `DELETE` | `/groups/:id/saml_group_links/:saml_group_name` |
| Read | Group | `GET` | `/groups/:id/saml_group_links` |
|   |   | `GET` | `/groups/:id/saml_group_links/:saml_group_name` |

#### SSH Key

Grants the ability to view SSH keys by ID or fingerprint.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Instance | `GET` | `/keys/:id` |
|   |   | `GET` | `/keys` |

#### Scim Identity

Grants the ability to read, update, and delete SCIM identities.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Group | `DELETE` | `/groups/:id/scim/:uid` |
| Read | Group | `GET` | `/groups/:id/scim/identities` |
|   |   | `GET` | `/groups/:id/scim/:uid` |
| Update | Group | `PATCH` | `/groups/:id/scim/:uid` |

#### Service Account

Grants the ability to create, delete, read, and update service accounts.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/service_accounts` |
|   | Instance | `POST` | `/service_accounts` |
| Delete | Group | `DELETE` | `/groups/:id/service_accounts/:user_id` |
| Read | Group | `GET` | `/groups/:id/service_accounts` |
|   | Instance | `GET` | `/service_accounts` |
| Update | Group | `PATCH` | `/groups/:id/service_accounts/:user_id` |
|   | Instance | `PATCH` | `/service_accounts/:user_id` |

#### Service Account Personal Access Token

Grants the ability to create, read, revoke, and rotate service account personal access tokens.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/groups/:id/service_accounts/:user_id/personal_access_tokens` |
| Read | Group | `GET` | `/groups/:id/service_accounts/:user_id/personal_access_tokens` |
| Revoke | Group | `DELETE` | `/groups/:id/service_accounts/:user_id/personal_access_tokens/:token_id` |
| Rotate | Group | `POST` | `/groups/:id/service_accounts/:user_id/personal_access_tokens/:token_id/rotate` |

#### Statistic

Grants the ability to read statistics.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Project | `GET` | `/projects/:id/statistics` |

#### User

Grants the ability to read, follow, and unfollow users.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Follow | User | `POST` | `/users/:id/follow` |
| Read | User | `GET` | `/users/:id` |
|   |   | `GET` | `/user` |
| Unfollow | User | `POST` | `/users/:id/unfollow` |

#### User Counts

Grants the ability to read user counts.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | User | `GET` | `/user_counts` |

#### User Email

Grants the ability to create, read, and delete user emails.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/user/emails` |
| Delete | User | `DELETE` | `/user/emails/:email_id` |
| Read | User | `GET` | `/user/emails` |
|   |   | `GET` | `/user/emails/:email_id` |

#### User Personal Access Token

Grants the ability to create user personal access tokens.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/user/personal_access_tokens` |

#### User SSH Key

Grants the ability to create, read, and delete user SSH keys.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/user/keys` |
| Delete | User | `DELETE` | `/user/keys/:key_id` |
| Read | User | `GET` | `/users/:user_id/keys` |
|   |   | `GET` | `/users/:id/keys/:key_id` |
|   |   | `GET` | `/user/keys` |
|   |   | `GET` | `/user/keys/:key_id` |

### System Migration And Integration resources

#### Bitbucket Import

Grants the ability to create Bitbucket imports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Group | `POST` | `/import/bitbucket` |
|   | User | `POST` | `/import/bitbucket` |

#### Bitbucket Server Import

Grants the ability to create Bitbucket Server imports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Instance | `POST` | `/import/bitbucket_server` |

#### Bulk Import

Grants the ability to create, read, and cancel bulk imports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Cancel | Instance | `POST` | `/bulk_imports/:import_id/cancel` |
| Create | Instance | `POST` | `/bulk_imports` |
| Read | Instance | `GET` | `/bulk_imports` |
|   |   | `GET` | `/bulk_imports/:import_id` |

#### Bulk Import Entity

Grants the ability to read bulk import entities.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Instance | `GET` | `/bulk_imports/entities` |
|   |   | `GET` | `/bulk_imports/:import_id/entities` |
|   |   | `GET` | `/bulk_imports/:import_id/entities/:entity_id` |

#### Bulk Import Entity Failure

Grants the ability to read bulk import entity failures.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Read | Instance | `GET` | `/bulk_imports/:import_id/entities/:entity_id/failures` |

#### GitHub Gist Import

Grants the ability to import gists from GitHub

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | User | `POST` | `/import/github/gists` |

#### GitHub Import

Grants the ability to create and cancel GitHub project imports

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Cancel | User | `POST` | `/import/github/cancel` |
| Create | Group | `POST` | `/import/github` |
|   | User | `POST` | `/import/github` |

#### Group Export

Grants the ability to start and download group exports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Download | Group | `GET` | `/groups/:id/export/download` |
| Start | Group | `POST` | `/groups/:id/export` |

#### Group Import

Grants the ability to authorize and create group imports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Authorize | Instance | `POST` | `/groups/import/authorize` |
| Create | Instance | `POST` | `/groups/import` |

#### Placeholder Reassignment

Grants the ability to authorize, create, and read placeholder reassignments.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Authorize | Group | `POST` | `/groups/:id/placeholder_reassignments/authorize` |
| Create | Group | `POST` | `/groups/:id/placeholder_reassignments` |
| Read | Group | `GET` | `/groups/:id/placeholder_reassignments` |

#### Project Export

Grants the ability to create, read, and download project exports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/export` |
| Download | Project | `GET` | `/projects/:id/export/download` |
| Read | Project | `GET` | `/projects/:id/export` |

#### Project Import

Grants the ability to authorize and create project imports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Authorize | Instance | `POST` | `/projects/import/authorize` |
| Create | Group | `POST` | `/projects/import` |
|   |   | `POST` | `/projects/remote-import` |
|   |   | `POST` | `/projects/remote-import-s3` |
|   | User | `POST` | `/projects/import` |
|   |   | `POST` | `/projects/remote-import` |
|   |   | `POST` | `/projects/remote-import-s3` |
| Read | Project | `GET` | `/projects/:id/import` |

#### Project Relation Export

Grants the ability to create, read, and download project relation exports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/export_relations` |
| Download | Project | `GET` | `/projects/:id/export_relations/download` |
| Read | Project | `GET` | `/projects/:id/export_relations/status` |

#### Project Relation Import

Grants the ability to authorize, create, and read project relation imports.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Authorize | Instance | `POST` | `/projects/import-relation/authorize` |
| Create | Project | `POST` | `/projects/import-relation` |
| Read | Project | `GET` | `/projects/:id/relation-imports` |

#### Webhook

Grants the ability to create, read, update, test, and delete webhooks.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/hooks` |
|   | Group | `POST` | `/groups/:id/hooks` |
|   | Instance | `POST` | `/hooks` |
| Delete | Project | `DELETE` | `/projects/:id/hooks/:hook_id` |
|   | Group | `DELETE` | `/groups/:id/hooks/:hook_id` |
|   | Instance | `DELETE` | `/hooks/:hook_id` |
| Read | Project | `GET` | `/projects/:id/hooks` |
|   |   | `GET` | `/projects/:id/hooks/:hook_id` |
|   |   | `GET` | `/projects/:id/hooks/:hook_id/events` |
|   | Group | `GET` | `/groups/:id/hooks` |
|   |   | `GET` | `/groups/:id/hooks/:hook_id` |
|   |   | `GET` | `/groups/:id/hooks/:hook_id/events` |
|   | Instance | `GET` | `/hooks` |
|   |   | `GET` | `/hooks/:hook_id` |
| Test | Project | `POST` | `/projects/:id/hooks/:hook_id/test/:trigger` |
|   | Group | `POST` | `/groups/:id/hooks/:hook_id/test/:trigger` |
| Update | Project | `PUT` | `/projects/:id/hooks/:hook_id` |
|   | Group | `PUT` | `/groups/:id/hooks/:hook_id` |
|   | Instance | `PUT` | `/hooks/:hook_id` |

#### Webhook Custom Header

Grants the ability to update and delete webhook custom headers.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/hooks/:hook_id/custom_headers/:key` |
|   | Group | `DELETE` | `/groups/:id/hooks/:hook_id/custom_headers/:key` |
|   | Instance | `DELETE` | `/hooks/:hook_id/custom_headers/:key` |
| Update | Project | `PUT` | `/projects/:id/hooks/:hook_id/custom_headers/:key` |
|   | Group | `PUT` | `/groups/:id/hooks/:hook_id/custom_headers/:key` |
|   | Instance | `PUT` | `/hooks/:hook_id/custom_headers/:key` |

#### Webhook Event

Grants the ability to resend webhook events.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Resend | Project | `POST` | `/projects/:id/hooks/:hook_id/events/:hook_log_id/resend` |
|   | Group | `POST` | `/groups/:id/hooks/:hook_id/events/:hook_log_id/resend` |

#### Webhook URL variable

Grants the ability to update and delete webhook URL variables.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Delete | Project | `DELETE` | `/projects/:id/hooks/:hook_id/url_variables/:key` |
|   | Group | `DELETE` | `/groups/:id/hooks/:hook_id/url_variables/:key` |
|   | Instance | `DELETE` | `/hooks/:hook_id/url_variables/:key` |
| Update | Project | `PUT` | `/projects/:id/hooks/:hook_id/url_variables/:key` |
|   | Group | `PUT` | `/groups/:id/hooks/:hook_id/url_variables/:key` |
|   | Instance | `PUT` | `/hooks/:hook_id/url_variables/:key` |

### Wiki resources

#### Markdown Upload

Grants the ability to authorize, create, delete, and read Markdown uploads.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Authorize | Project | `POST` | `/projects/:id/uploads/authorize` |
| Create | Project | `POST` | `/projects/:id/uploads` |
| Delete | Project | `DELETE` | `/projects/:id/uploads/:upload_id` |
|   |   | `DELETE` | `/projects/:id/uploads/:secret/:filename` |
|   | Group | `DELETE` | `/groups/:id/uploads/:upload_id` |
|   |   | `DELETE` | `/groups/:id/uploads/:secret/:filename` |
| Read | Project | `GET` | `/projects/:id/uploads` |
|   |   | `GET` | `/projects/:id/uploads/:upload_id` |
|   |   | `GET` | `/projects/:id/uploads/:secret/:filename` |
|   | Group | `GET` | `/groups/:id/uploads` |
|   |   | `GET` | `/groups/:id/uploads/:upload_id` |
|   |   | `GET` | `/groups/:id/uploads/:secret/:filename` |

#### Wiki

Grants the ability to create, delete, edit, read, and update wikis.

| Action | Access | Method | Path |
| ------ | ------ | ------ | ---- |
| Create | Project | `POST` | `/projects/:id/wikis` |
|   | Group | `POST` | `/groups/:id/wikis` |
| Delete | Project | `DELETE` | `/projects/:id/wikis/:slug` |
|   | Group | `DELETE` | `/groups/:id/wikis/:slug` |
| Read | Project | `GET` | `/projects/:id/wikis` |
|   |   | `GET` | `/projects/:id/wikis/:slug` |
|   | Group | `GET` | `/groups/:id/wikis` |
|   |   | `GET` | `/groups/:id/wikis/:slug` |
| Update | Project | `POST` | `/projects/:id/wikis/attachments` |
|   |   | `PUT` | `/projects/:id/wikis/:slug` |
|   | Group | `POST` | `/groups/:id/wikis/attachments` |
|   |   | `PUT` | `/groups/:id/wikis/:slug` |
