# frozen_string_literal: true

module Gitlab
  module Ci
    module Pipeline
      module Chain
        class KeywordUsage < Chain::Base
          include Gitlab::InternalEventsTracking

          def perform!
            track_keyword_usage
          end

          def break?
            false
          end

          private

          def track_keyword_usage
            track_keyword_usage_for('run', command.yaml_processor_result.uses_keyword?(:run))
            track_keyword_usage_for('only', command.yaml_processor_result.uses_keyword?(:only))
            track_keyword_usage_for('except', command.yaml_processor_result.uses_keyword?(:except))
            track_keyword_usage_for('artifacts_reports_junit',
              command.yaml_processor_result.uses_nested_keyword?(%i[artifacts reports junit]))
            track_keyword_usage_for('job_inputs', command.yaml_processor_result.uses_keyword?(:inputs))
            track_keyword_usage_for('inputs', command.yaml_processor_result.uses_inputs?)
            track_keyword_usage_for('input_rules', command.yaml_processor_result.uses_input_rules?)
          end

          def track_keyword_usage_for(keyword, used)
            return unless used

            track_internal_event(
              "use_#{keyword}_keyword_in_cicd_yaml",
              project: @pipeline.project,
              user: @pipeline.user
            )
          end
        end
      end
    end
  end
end
