/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmIrAttributesKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLowering;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.JsInteropFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u0014*\u00060\u001fj\u0002` 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010!\u001a\u00020\"*\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+J(\u00100\u001a\u00020\"2\u0006\u0010*\u001a\u00020-2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\"H\u0002J.\u00105\u001a\u00020\u00142\u0006\u0010*\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\"J\u000e\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u001aJ\u000e\u0010<\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010=\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ(\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u0002072\u0006\u0010@\u001a\u00020\"2\u0006\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020\"H\u0002J\u0010\u0010C\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020DH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010,\u001a\u00020%*\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010.R\u0018\u0010/\u001a\u00020%*\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010.\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCurrentFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "setCurrentFile", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "addedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getAddedDeclarations", "()Ljava/util/List;", "lower", "", "irFile", "processExternalDeclaration", "declaration", "lowerExternalClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "processExternalProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "appendExternalClassReference", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toSavePropertyAccess", "", "receiver", "isTopLevel", "", "processExternalConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "processExternalSimpleFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isSetOperator", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isGetOperator", "createJsCodeForFunction", "numDefaultParameters", "", "isConstructor", "jsFunctionReference", "processFunctionOrConstructor", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateExternalObjectInstanceGetter", "obj", "generateInstanceCheckForExternalClass", "generateGetClassForExternalClass", "createExternalJsFunction", "originalName", "suffix", "resultType", "jsCode", "referenceTopLevelExternalDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,593:1\n230#2,2:594\n1740#2,3:597\n774#2:600\n865#2,2:601\n774#2:603\n865#2,2:604\n1869#2,2:606\n1#3:596\n*S KotlinDebug\n*F\n+ 1 ComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering\n*L\n161#1:594,2\n247#1:597,3\n286#1:600\n286#1:601,2\n351#1:603\n351#1:604,2\n371#1:606,2\n*E\n"})
public final class ComplexExternalDeclarationsToTopLevelFunctionsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    public IrFile currentFile;
    @NotNull
    private final List<IrDeclaration> addedDeclarations;

    public ComplexExternalDeclarationsToTopLevelFunctionsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.addedDeclarations = new ArrayList();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFile getCurrentFile() {
        IrFile irFile = this.currentFile;
        if (irFile != null) {
            return irFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentFile");
        return null;
    }

    public final void setCurrentFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"<set-?>");
        this.currentFile = irFile;
    }

    @NotNull
    public final List<IrDeclaration> getAddedDeclarations() {
        return this.addedDeclarations;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.setCurrentFile(irFile);
        for (IrDeclaration declaration : irFile.getDeclarations()) {
            if (!IrUtilsKt.isEffectivelyExternal(declaration)) continue;
            this.processExternalDeclaration(declaration);
        }
        CollectionsKt.addAll((Collection)irFile.getDeclarations(), (Iterable)this.addedDeclarations);
        this.addedDeclarations.clear();
    }

    public final void processExternalDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrVisitorsKt.acceptVoid((IrElement)declaration, new IrVisitorVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                throw new IllegalStateException(("Unknown external element " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
            }

            public void visitTypeParameter(IrTypeParameter declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            }

            public void visitValueParameter(IrValueParameter declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrVisitorsKt.acceptChildrenVoid((IrElement)declaration, this);
                declaration.getFactory().getStageController().restrictTo(declaration, () -> processExternalDeclaration.1.visitClass$lambda$0(this.this$0, declaration));
            }

            public void visitProperty(IrProperty declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                declaration.getFactory().getStageController().restrictTo(declaration, () -> processExternalDeclaration.1.visitProperty$lambda$1(this.this$0, declaration));
            }

            public void visitConstructor(IrConstructor declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                declaration.getFactory().getStageController().restrictTo(declaration, () -> processExternalDeclaration.1.visitConstructor$lambda$2(this.this$0, declaration));
            }

            public void visitSimpleFunction(IrSimpleFunction declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                declaration.getFactory().getStageController().restrictTo(declaration, () -> processExternalDeclaration.1.visitSimpleFunction$lambda$3(this.this$0, declaration));
            }

            private static final Unit visitClass$lambda$0(ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0, IrClass $declaration) {
                this$0.lowerExternalClass($declaration);
                return Unit.INSTANCE;
            }

            private static final Unit visitProperty$lambda$1(ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0, IrProperty $declaration) {
                this$0.processExternalProperty($declaration);
                return Unit.INSTANCE;
            }

            private static final Unit visitConstructor$lambda$2(ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0, IrConstructor $declaration) {
                this$0.processExternalConstructor($declaration);
                return Unit.INSTANCE;
            }

            private static final Unit visitSimpleFunction$lambda$3(ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0, IrSimpleFunction $declaration) {
                this$0.processExternalSimpleFunction($declaration);
                return Unit.INSTANCE;
            }
        });
    }

    public final void lowerExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.getKind() == ClassKind.OBJECT) {
            this.generateExternalObjectInstanceGetter(klass);
        }
        if (klass.getKind() != ClassKind.INTERFACE) {
            this.generateInstanceCheckForExternalClass(klass);
            this.generateGetClassForExternalClass(klass);
        }
    }

    public final void processExternalProperty(@NotNull IrProperty property2) {
        block6: {
            Object element$iv2;
            IrSimpleFunction setter2;
            IrSimpleFunction res2;
            block5: {
                String jsCode;
                IrValueParameter dispatchReceiver;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                if (property2.isFakeOverride()) {
                    return;
                }
                String string = AnnotationUtilsKt.getJsNameOrKotlinName(property2).getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                String propName = string;
                IrSimpleFunction irSimpleFunction = property2.getGetter();
                if (irSimpleFunction != null) {
                    IrSimpleFunction getter2 = irSimpleFunction;
                    boolean bl = false;
                    dispatchReceiver = getter2.getDispatchReceiverParameter();
                    jsCode = dispatchReceiver == null ? "() => " + this.referenceTopLevelExternalDeclaration(property2) : "(_this) => " + ComplexExternalDeclarationsToTopLevelFunctionsLowering.toSavePropertyAccess$default(this, propName, "_this", false, 2, null);
                    res2 = this.createExternalJsFunction(property2.getName(), "_$external_prop_getter", getter2.getReturnType(), jsCode);
                    if (dispatchReceiver != null) {
                        DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
                    }
                    WasmIrAttributesKt.setTopLevelFunctionForNestedExternal(getter2, res2);
                }
                IrSimpleFunction irSimpleFunction2 = property2.getSetter();
                if (irSimpleFunction2 == null) break block6;
                setter2 = irSimpleFunction2;
                boolean bl = false;
                dispatchReceiver = setter2.getDispatchReceiverParameter();
                jsCode = dispatchReceiver == null ? "(v) => " + this.referenceTopLevelExternalDeclaration(property2) + " = v" : "(_this, v) => " + ComplexExternalDeclarationsToTopLevelFunctionsLowering.toSavePropertyAccess$default(this, propName, "_this", false, 2, null) + " = v";
                res2 = this.createExternalJsFunction(property2.getName(), "_$external_prop_setter", setter2.getReturnType(), jsCode);
                if (dispatchReceiver != null) {
                    DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
                }
                Iterable $this$first$iv = setter2.getParameters();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv2;
                    boolean bl2 = false;
                    if (!(it.getKind() == IrParameterKind.Regular)) continue;
                    break block5;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrType setterParameter = ((IrValueParameter)element$iv2).getType();
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "v", setterParameter, null, 4, null);
            WasmIrAttributesKt.setTopLevelFunctionForNestedExternal(setter2, res2);
        }
    }

    private final void appendExternalClassReference(StringBuilder $this$appendExternalClassReference, IrClass klass) {
        StringBuilder stringBuilder;
        IrDeclarationParent parent2 = klass.getParent();
        if (parent2 instanceof IrClass) {
            if (IrUtilsKt.isInterface((IrClass)parent2)) {
                $this$appendExternalClassReference.append("({})");
                return;
            }
            this.appendExternalClassReference($this$appendExternalClassReference, (IrClass)parent2);
            if (klass.isCompanion()) {
                return;
            }
            String string = AnnotationUtilsKt.getJsNameOrKotlinName(klass).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
            stringBuilder = $this$appendExternalClassReference.append(ComplexExternalDeclarationsToTopLevelFunctionsLowering.toSavePropertyAccess$default(this, string, null, false, 1, null));
        } else {
            stringBuilder = $this$appendExternalClassReference.append(this.referenceTopLevelExternalDeclaration(klass));
        }
    }

    private final String toSavePropertyAccess(String $this$toSavePropertyAccess, String receiver, boolean isTopLevel) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$toSavePropertyAccess_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$toSavePropertyAccess_u24lambda_u240.append(receiver);
        if (IdentifierPolicyKt.isValidES5Identifier($this$toSavePropertyAccess)) {
            if (!isTopLevel) {
                $this$toSavePropertyAccess_u24lambda_u240.append('.');
            }
            stringBuilder = $this$toSavePropertyAccess_u24lambda_u240.append($this$toSavePropertyAccess);
        } else {
            if (isTopLevel) {
                $this$toSavePropertyAccess_u24lambda_u240.append("globalThis");
            }
            $this$toSavePropertyAccess_u24lambda_u240.append("['");
            $this$toSavePropertyAccess_u24lambda_u240.append(StringsKt.replace$default((String)$this$toSavePropertyAccess, (String)"'", (String)"\\'", (boolean)false, (int)4, null));
            stringBuilder = $this$toSavePropertyAccess_u24lambda_u240.append("']");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String toSavePropertyAccess$default(ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2, String string, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = "";
        }
        if ((n2 & 2) != 0) {
            bl = ((CharSequence)string2).length() == 0;
        }
        return complexExternalDeclarationsToTopLevelFunctionsLowering2.toSavePropertyAccess(string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void processExternalConstructor(@NotNull IrConstructor constructor) {
        void $this$processExternalConstructor_u24lambda_u240;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        IrClass klass = AdditionalIrUtilsKt.getConstructedClass(constructor);
        if (IrUtilsKt.isInterface(klass)) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = true;
        IrType irType = IrUtilsKt.getDefaultType(klass);
        Name name2 = klass.getName();
        IrFunction irFunction = constructor;
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        boolean bl2 = false;
        this.appendExternalClassReference((StringBuilder)$this$processExternalConstructor_u24lambda_u240, klass);
        Unit unit = Unit.INSTANCE;
        complexExternalDeclarationsToTopLevelFunctionsLowering2.processFunctionOrConstructor(irFunction, name2, irType, bl, stringBuilder.toString());
    }

    public final void processExternalSimpleFunction(@NotNull IrSimpleFunction function2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (AnnotationsKt.getWasmImportDescriptor(function2) != null) {
            return;
        }
        String jsFun = AnnotationsKt.getJsFunAnnotation(function2);
        if (jsFun != null) {
            boolean bl;
            block11: {
                Iterable $this$all$iv = function2.getParameters();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (it.getDefaultValue() == null && it.getVarargElementType() == null) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl && AnnotationUtilsKt.getJsQualifier(this.getCurrentFile()) == null && AnnotationUtilsKt.getJsModule(this.getCurrentFile()) == null) {
                return;
            }
        }
        if (function2.isFakeOverride()) {
            return;
        }
        if (jsFun != null) {
            string = '(' + jsFun + ')';
        } else if (IrUtilsKt.isTopLevelDeclaration(function2)) {
            string = this.referenceTopLevelExternalDeclaration(function2);
        } else {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(function2).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
            string = ComplexExternalDeclarationsToTopLevelFunctionsLowering.toSavePropertyAccess$default(this, string2, null, false, 1, null);
        }
        String jsFunctionReference = string;
        this.processFunctionOrConstructor(function2, function2.getName(), function2.getReturnType(), false, jsFunctionReference);
    }

    private final boolean isSetOperator(IrFunction $this$isSetOperator) {
        return $this$isSetOperator instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isSetOperator).isOperator() && Intrinsics.areEqual((Object)$this$isSetOperator.getName().asString(), (Object)"set");
    }

    private final boolean isGetOperator(IrFunction $this$isGetOperator) {
        return $this$isGetOperator instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isGetOperator).isOperator() && Intrinsics.areEqual((Object)$this$isGetOperator.getName().asString(), (Object)"get");
    }

    /*
     * WARNING - void declaration
     */
    private final String createJsCodeForFunction(IrFunction function2, int numDefaultParameters, boolean isConstructor, String jsFunctionReference) {
        int n2;
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        IrValueParameter dispatchReceiver = function2.getDispatchReceiverParameter();
        Iterable $this$filter$iv = function2.getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrValueParameter it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == IrParameterKind.Regular)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valueParameters = (List)destination$iv$iv;
        int numValueParameters = valueParameters.size();
        StringBuilder $this$createJsCodeForFunction_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createJsCodeForFunction_u24lambda_u241.append("(");
        if (dispatchReceiver != null) {
            $this$createJsCodeForFunction_u24lambda_u241.append("_this, ");
        }
        JsInteropFunctionsLoweringKt.appendParameterList$default($this$createJsCodeForFunction_u24lambda_u241, numValueParameters, null, numDefaultParameters == 0, 2, null);
        JsInteropFunctionsLoweringKt.appendParameterList($this$createJsCodeForFunction_u24lambda_u241, numDefaultParameters, "isDefault", true);
        $this$createJsCodeForFunction_u24lambda_u241.append(") => ");
        if (isConstructor) {
            $this$createJsCodeForFunction_u24lambda_u241.append("new ");
        }
        if (dispatchReceiver != null) {
            $this$createJsCodeForFunction_u24lambda_u241.append("_this");
        }
        $this$createJsCodeForFunction_u24lambda_u241.append(jsFunctionReference);
        $this$createJsCodeForFunction_u24lambda_u241.append("(");
        int numNonDefaultParameters = numValueParameters - numDefaultParameters;
        for (n2 = 0; n2 < numNonDefaultParameters; ++n2) {
            int it = n2;
            boolean bl2 = false;
            if (AdditionalIrUtilsKt.isVararg((IrValueParameter)valueParameters.get(it))) {
                $this$createJsCodeForFunction_u24lambda_u241.append("...");
            }
            $this$createJsCodeForFunction_u24lambda_u241.append("" + 'p' + it);
            if (numDefaultParameters == 0 && it + 1 >= numNonDefaultParameters) continue;
            $this$createJsCodeForFunction_u24lambda_u241.append(", ");
        }
        for (n2 = 0; n2 < numDefaultParameters; ++n2) {
            int it = n2;
            boolean bl3 = false;
            StringBuilder stringBuilder2 = AdditionalIrUtilsKt.isVararg((IrValueParameter)valueParameters.get(numNonDefaultParameters + it)) ? $this$createJsCodeForFunction_u24lambda_u241.append("...") : $this$createJsCodeForFunction_u24lambda_u241.append("isDefault" + it + " ? undefined : ");
            $this$createJsCodeForFunction_u24lambda_u241.append("" + 'p' + (numNonDefaultParameters + it) + ", ");
        }
        $this$createJsCodeForFunction_u24lambda_u241.append(")");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void processFunctionOrConstructor(@NotNull IrFunction function2, @NotNull Name name2, @NotNull IrType returnType, boolean isConstructor, @NotNull String jsFunctionReference) {
        IrValueParameter it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)jsFunctionReference, (String)"jsFunctionReference");
        IrValueParameter dispatchReceiver = function2.getDispatchReceiverParameter();
        Iterable $this$filter$iv = function2.getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == IrParameterKind.Regular)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valueParameters = (List)destination$iv$iv;
        int numDefaultParameters = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.access$numDefaultParametersForExternalFunction(function2);
        String jsCode = this.isSetOperator(function2) ? "(_this, i, value) => _this[i] = value" : (this.isGetOperator(function2) ? "(_this, i) => _this[i]" : this.createJsCodeForFunction(function2, numDefaultParameters, isConstructor, jsFunctionReference));
        IrSimpleFunction res2 = this.createExternalJsFunction(name2, "_$external_fun", returnType, jsCode);
        if (dispatchReceiver != null) {
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
        }
        Iterable $this$forEach$iv = valueParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter irValueParameter;
            it = (IrValueParameter)element$iv;
            boolean bl = false;
            IrValueParameter $this$processFunctionOrConstructor_u24lambda_u241_u240 = irValueParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, it.getName(), IrTypePredicatesKt.isPrimitiveType(it.getType(), false) ? it.getType() : IrTypesKt.makeNullable(it.getType()), null, 4, null);
            boolean bl2 = false;
            $this$processFunctionOrConstructor_u24lambda_u241_u240.setVarargElementType(it.getVarargElementType());
        }
        int n2 = 0;
        while (n2 < numDefaultParameters) {
            int it2 = n2++;
            boolean bl = false;
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "isDefault" + it2, this.context.getIrBuiltIns().getIntType(), null, 4, null);
        }
        WasmIrAttributesKt.setTopLevelFunctionForNestedExternal(function2, res2);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateExternalObjectInstanceGetter(@NotNull IrClass obj) {
        void $this$generateExternalObjectInstanceGetter_u24lambda_u240;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        IrType irType = IrUtilsKt.getDefaultType(obj);
        String string = "_$external_object_getInstance";
        Name name2 = obj.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrClass irClass = obj;
        boolean bl = false;
        $this$generateExternalObjectInstanceGetter_u24lambda_u240.append("() => ");
        this.appendExternalClassReference((StringBuilder)$this$generateExternalObjectInstanceGetter_u24lambda_u240, obj);
        Unit unit = Unit.INSTANCE;
        WasmIrAttributesKt.setGetInstanceFunctionForExternalObject(irClass, complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string, irType, stringBuilder.toString()));
    }

    /*
     * WARNING - void declaration
     */
    public final void generateInstanceCheckForExternalClass(@NotNull IrClass klass) {
        void it;
        Object $this$generateInstanceCheckForExternalClass_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Object object = new StringBuilder();
        StringBuilder stringBuilder = object;
        IrType irType = this.context.getIrBuiltIns().getBooleanType();
        String string = "_$external_class_instanceof";
        Name name2 = klass.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrClass irClass = klass;
        boolean bl = false;
        String jsPrimitiveType = AnnotationsKt.getJsPrimitiveType(klass);
        if (jsPrimitiveType != null) {
            ((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u240).append("(x) => typeof x === '" + jsPrimitiveType + '\'');
        } else {
            ((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u240).append("(x) => x instanceof ");
            this.appendExternalClassReference((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u240, klass);
        }
        Unit unit = Unit.INSTANCE;
        $this$generateInstanceCheckForExternalClass_u24lambda_u240 = object = complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string, irType, ((StringBuilder)object).toString());
        boolean bl2 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)it, "x", this.context.getIrBuiltIns().getAnyType(), null, 4, null);
        WasmIrAttributesKt.setInstanceCheckForExternalClass(irClass, (IrSimpleFunction)object);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateGetClassForExternalClass(@NotNull IrClass klass) {
        void $this$generateGetClassForExternalClass_u24lambda_u240;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        IrType irType = IrTypesKt.makeNullable(this.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType());
        String string = "_$external_class_get";
        Name name2 = klass.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrClass irClass = klass;
        boolean bl = false;
        $this$generateGetClassForExternalClass_u24lambda_u240.append("() => ");
        this.appendExternalClassReference((StringBuilder)$this$generateGetClassForExternalClass_u24lambda_u240, klass);
        Unit unit = Unit.INSTANCE;
        WasmIrAttributesKt.setGetJsClassForExternalClass(irClass, complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string, irType, stringBuilder.toString()));
    }

    private final IrSimpleFunction createExternalJsFunction(Name originalName, String suffix, IrType resultType, String jsCode) {
        IrSimpleFunction res2 = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this.context, originalName, suffix, resultType, jsCode);
        res2.setParent(this.getCurrentFile());
        ((Collection)this.addedDeclarations).add(res2);
        return res2;
    }

    private final String referenceTopLevelExternalDeclaration(IrDeclarationWithName declaration) {
        String string;
        String module2;
        String name2 = null;
        name2 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).getIdentifier();
        String qualifier = AnnotationUtilsKt.getJsQualifier(this.getCurrentFile());
        String string2 = AnnotationUtilsKt.getJsModule(this.getCurrentFile());
        if (string2 == null) {
            String string3 = AnnotationUtilsKt.getJsModule(declaration);
            if (string3 != null) {
                String string4;
                String it = string4 = string3;
                boolean bl = false;
                name2 = declaration instanceof IrClass && IrUtilsKt.isObject((IrClass)declaration) ? null : "default";
                string2 = string4;
            } else {
                string2 = module2 = null;
            }
        }
        if (qualifier == null && module2 == null) {
            if (!(name2 != null)) {
                boolean bl = false;
                String string5 = "Unexpected null inside declaration Name identifier ";
                throw new IllegalArgumentException(string5.toString());
            }
            return ComplexExternalDeclarationsToTopLevelFunctionsLowering.toSavePropertyAccess$default(this, name2, null, false, 3, null);
        }
        JsModuleAndQualifierReference qualifierReference = new JsModuleAndQualifierReference(module2, qualifier);
        if (module2 != null) {
            ((Collection)this.context.getFileContext(this.getCurrentFile()).getJsModuleAndQualifierReferences()).add(qualifierReference);
        }
        if ((string = name2) == null || (string = ComplexExternalDeclarationsToTopLevelFunctionsLowering.toSavePropertyAccess$default(this, string, qualifierReference.getJsQualifierReferenceIdentifier(), false, 2, null)) == null) {
            string = qualifierReference.getJsQualifierReferenceIdentifier();
        }
        return string;
    }
}

