/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class OrcaReader
extends AtomSetCollectionReader {
    private String chargeTag;
    private int atomCount;
    private boolean xyzBohr;

    @Override
    protected void initializeReader() throws Exception {
        this.chargeTag = this.checkAndRemoveFilterKey("CHARGE=LOW") ? "LOEW" : "MULL";
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("! Bohrs")) {
            this.xyzBohr = true;
            return true;
        }
        if (this.line.startsWith("* xyz") || this.line.startsWith("*xyz")) {
            this.processInputFile();
            this.continuing = false;
            return false;
        }
        if (this.line.indexOf("CARTESIAN COORDINATES (ANG") >= 0) {
            this.processCoordinates();
            return true;
        }
        if (this.line.indexOf("ATOMIC CHARGES") >= 0 && this.line.indexOf(this.chargeTag) >= 0) {
            this.processAtomicCharges();
            return true;
        }
        if (this.line.startsWith("Total Energy")) {
            this.processEnergyLine();
            return true;
        }
        return true;
    }

    private void processEnergyLine() {
        String[] tokens = this.getTokens();
        this.asc.setAtomSetEnergy(tokens[3], Float.parseFloat(tokens[3]));
    }

    private void processInputFile() throws Exception {
        while (this.rd() != null) {
            while (this.line.trim().length() == 0 || this.line.startsWith("#")) {
                this.rd();
            }
            if (this.line.indexOf("*") >= 0) break;
            String[] tokens = this.getTokens();
            Atom a = this.addAtomXYZSymName(tokens, 1, tokens[0], null);
            if (!this.xyzBohr) continue;
            a.scale(0.5291772f);
        }
    }

    void processCoordinates() throws Exception {
        String[] tokens;
        this.asc.newAtomSet();
        this.baseAtomIndex = this.asc.ac;
        this.rd();
        while (this.rd() != null && (tokens = this.getTokens()).length == 4) {
            this.addAtomXYZSymName(tokens, 1, tokens[0], null);
        }
        if (this.baseAtomIndex == 0) {
            this.atomCount = this.asc.ac;
        }
    }

    void processAtomicCharges() throws Exception {
        this.rd();
        for (int i = 0; i < this.atomCount; ++i) {
            this.rd();
            this.asc.atoms[i + this.baseAtomIndex].partialCharge = Float.parseFloat(this.line.substring(this.line.indexOf(":") + 1));
        }
    }
}

