/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEvent;

public interface OrganizationModel {
    public static final String ORGANIZATION_ATTRIBUTE = "kc.org";
    public static final String ORGANIZATION_NAME_ATTRIBUTE = "kc.org.name";
    public static final String ORGANIZATION_DOMAIN_ATTRIBUTE = "kc.org.domain";
    public static final String ALIAS = "alias";

    public String getId();

    public void setName(String var1);

    public String getName();

    public String getAlias();

    public void setAlias(String var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public String getDescription();

    public void setDescription(String var1);

    public String getRedirectUrl();

    public void setRedirectUrl(String var1);

    public Map<String, List<String>> getAttributes();

    public void setAttributes(Map<String, List<String>> var1);

    public Stream<OrganizationDomainModel> getDomains();

    public void setDomains(Set<OrganizationDomainModel> var1);

    public Stream<IdentityProviderModel> getIdentityProviders();

    public boolean isManaged(UserModel var1);

    public boolean isMember(UserModel var1);

    public static interface OrganizationMemberLeaveEvent
    extends OrganizationMembershipEvent {
        public static void fire(final OrganizationModel organization, final UserModel user, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new OrganizationMemberLeaveEvent(){

                @Override
                public UserModel getUser() {
                    return user;
                }

                @Override
                public OrganizationModel getOrganization() {
                    return organization;
                }

                @Override
                public KeycloakSession getSession() {
                    return session;
                }
            });
        }
    }

    public static interface OrganizationMemberJoinEvent
    extends OrganizationMembershipEvent {
        public static void fire(final OrganizationModel organization, final UserModel user, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new OrganizationMemberJoinEvent(){

                @Override
                public UserModel getUser() {
                    return user;
                }

                @Override
                public OrganizationModel getOrganization() {
                    return organization;
                }

                @Override
                public KeycloakSession getSession() {
                    return session;
                }
            });
        }
    }

    public static interface OrganizationMembershipEvent
    extends ProviderEvent {
        public OrganizationModel getOrganization();

        public UserModel getUser();

        public KeycloakSession getSession();
    }

    public static enum IdentityProviderRedirectMode {
        EMAIL_MATCH("kc.org.broker.redirect.mode.email-matches");

        private final String key;

        private IdentityProviderRedirectMode(String key) {
            this.key = key;
        }

        public boolean isSet(IdentityProviderModel broker) {
            return Boolean.parseBoolean(broker.getConfig().get(this.key));
        }

        public String getKey() {
            return this.key;
        }
    }
}

