/*
 * Decompiled with CFR 0.152.
 */
package com.github.jgonian.ipmath;

import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Optional<?> ABSENT = new Absent();

    public static <T> Optional<T> of(T value) {
        return value != null ? new Present(value) : Optional.absent();
    }

    public static <T> Optional<T> absent() {
        return ABSENT;
    }

    public static <T> T getOrNull(Optional<T> optional) {
        return optional.isPresent() ? (T)optional.get() : null;
    }

    public abstract T get();

    public abstract boolean isPresent();

    public boolean isAbsent() {
        return !this.isPresent();
    }

    public static final class Absent<T>
    extends Optional<T> {
        private Absent() {
        }

        @Override
        public T get() {
            throw new NoSuchElementException("Absent.get");
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        public String toString() {
            return "Absent";
        }
    }

    public static final class Present<T>
    extends Optional<T> {
        private final T value;

        private Present(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Present present = (Present)o;
            return this.value.equals(present.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return String.format("Present(%s)", this.value);
        }
    }
}

