/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        super(passPhrase, s2kDigestCalculator);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase) {
        this(passPhrase, new SHA1PGPDigestCalculator());
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        super(passPhrase, s2kDigestCalculator, s2kCount);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, int s2kCount) {
        super(passPhrase, new SHA1PGPDigestCalculator(), s2kCount);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, S2K.Argon2Params params) {
        super(passPhrase, params);
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        super.setSecureRandom(random);
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(int encAlgorithm, byte[] key, byte[] sessionInfo) throws PGPException {
        try {
            String cName = PGPUtil.getSymmetricCipherName(encAlgorithm);
            Cipher c = this.helper.createCipher(cName + "/CFB/NoPadding");
            SecretKeySpec sKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            c.init(1, (Key)sKey, new IvParameterSpec(new byte[c.getBlockSize()]));
            return c.doFinal(sessionInfo, 0, sessionInfo.length);
        }
        catch (IllegalBlockSizeException e) {
            throw new PGPException("illegal block size: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new PGPException("bad padding: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PGPException("IV invalid: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("key invalid: " + e.getMessage(), e);
        }
    }

    @Override
    protected byte[] generateV6KEK(int kekAlgorithm, byte[] ikm, byte[] info) {
        return JceAEADUtil.generateHKDFBytes(ikm, null, info, SymmetricKeyUtils.getKeyLengthInOctets(kekAlgorithm));
    }

    @Override
    protected byte[] getEskAndTag(int kekAlgorithm, int aeadAlgorithm, byte[] sessionKey, byte[] key, byte[] iv, byte[] info) throws PGPException {
        String algorithm = JcePBEKeyEncryptionMethodGenerator.getBaseAEADAlgorithm(kekAlgorithm);
        Cipher aeadCipher = this.createAEADCipher(algorithm, aeadAlgorithm);
        try {
            aeadCipher.init(1, (Key)new SecretKeySpec(key, algorithm), (AlgorithmParameterSpec)new AEADParameterSpec(iv, 128, info));
            int outLen = aeadCipher.getOutputSize(sessionKey.length);
            byte[] eskAndTag = new byte[outLen];
            int len = aeadCipher.update(sessionKey, 0, sessionKey.length, eskAndTag, 0);
            len += aeadCipher.doFinal(eskAndTag, len);
            if (len < eskAndTag.length) {
                byte[] rv = new byte[len];
                System.arraycopy(eskAndTag, 0, rv, 0, len);
                return rv;
            }
            return eskAndTag;
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot encrypt session info", e);
        }
    }

    private static String getBaseAEADAlgorithm(int encAlgorithm) throws PGPException {
        if (encAlgorithm == 7 || encAlgorithm == 8 || encAlgorithm == 9) {
            return "AES";
        }
        if (encAlgorithm == 11 || encAlgorithm == 12 || encAlgorithm == 13) {
            return "Camellia";
        }
        throw new PGPException("AEAD only supported for AES and Camellia based algorithms");
    }

    private Cipher createAEADCipher(String algorithm, int aeadAlgorithm) throws PGPException {
        switch (aeadAlgorithm) {
            case 1: {
                return this.helper.createCipher(algorithm + "/EAX/NoPadding");
            }
            case 2: {
                return this.helper.createCipher(algorithm + "/OCB/NoPadding");
            }
            case 3: {
                return this.helper.createCipher(algorithm + "/GCM/NoPadding");
            }
        }
        throw new PGPException("unrecognised AEAD algorithm: " + aeadAlgorithm);
    }
}

