/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcPeeringConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcPeeringConnection> {
    private static final SdkField<VpcPeeringConnectionVpcInfo> ACCEPTER_VPC_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccepterVpcInfo").getter(VpcPeeringConnection.getter(VpcPeeringConnection::accepterVpcInfo)).setter(VpcPeeringConnection.setter(Builder::accepterVpcInfo)).constructor(VpcPeeringConnectionVpcInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterVpcInfo").unmarshallLocationName("accepterVpcInfo").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(VpcPeeringConnection.getter(VpcPeeringConnection::expirationTime)).setter(VpcPeeringConnection.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").unmarshallLocationName("expirationTime").build()}).build();
    private static final SdkField<VpcPeeringConnectionVpcInfo> REQUESTER_VPC_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequesterVpcInfo").getter(VpcPeeringConnection.getter(VpcPeeringConnection::requesterVpcInfo)).setter(VpcPeeringConnection.setter(Builder::requesterVpcInfo)).constructor(VpcPeeringConnectionVpcInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterVpcInfo").unmarshallLocationName("requesterVpcInfo").build()}).build();
    private static final SdkField<VpcPeeringConnectionStateReason> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(VpcPeeringConnection.getter(VpcPeeringConnection::status)).setter(VpcPeeringConnection.setter(Builder::status)).constructor(VpcPeeringConnectionStateReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VpcPeeringConnection.getter(VpcPeeringConnection::tags)).setter(VpcPeeringConnection.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcPeeringConnectionId").getter(VpcPeeringConnection.getter(VpcPeeringConnection::vpcPeeringConnectionId)).setter(VpcPeeringConnection.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("vpcPeeringConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTER_VPC_INFO_FIELD, EXPIRATION_TIME_FIELD, REQUESTER_VPC_INFO_FIELD, STATUS_FIELD, TAGS_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcPeeringConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VpcPeeringConnectionVpcInfo accepterVpcInfo;
    private final Instant expirationTime;
    private final VpcPeeringConnectionVpcInfo requesterVpcInfo;
    private final VpcPeeringConnectionStateReason status;
    private final List<Tag> tags;
    private final String vpcPeeringConnectionId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.accepterVpcInfo = builder.accepterVpcInfo;
        this.expirationTime = builder.expirationTime;
        this.requesterVpcInfo = builder.requesterVpcInfo;
        this.status = builder.status;
        this.tags = builder.tags;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public final VpcPeeringConnectionVpcInfo accepterVpcInfo() {
        return this.accepterVpcInfo;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final VpcPeeringConnectionVpcInfo requesterVpcInfo() {
        return this.requesterVpcInfo;
    }

    public final VpcPeeringConnectionStateReason status() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accepterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection)obj;
        return Objects.equals(this.accepterVpcInfo(), other.accepterVpcInfo()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.requesterVpcInfo(), other.requesterVpcInfo()) && Objects.equals(this.status(), other.status()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public final String toString() {
        return ToString.builder((String)"VpcPeeringConnection").add("AccepterVpcInfo", (Object)this.accepterVpcInfo()).add("ExpirationTime", (Object)this.expirationTime()).add("RequesterVpcInfo", (Object)this.requesterVpcInfo()).add("Status", (Object)this.status()).add("Tags", this.hasTags() ? this.tags() : null).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccepterVpcInfo": {
                return Optional.ofNullable(clazz.cast(this.accepterVpcInfo()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "RequesterVpcInfo": {
                return Optional.ofNullable(clazz.cast(this.requesterVpcInfo()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccepterVpcInfo", ACCEPTER_VPC_INFO_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("RequesterVpcInfo", REQUESTER_VPC_INFO_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("VpcPeeringConnectionId", VPC_PEERING_CONNECTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringConnection, T> g) {
        return obj -> g.apply((VpcPeeringConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VpcPeeringConnectionVpcInfo accepterVpcInfo;
        private Instant expirationTime;
        private VpcPeeringConnectionVpcInfo requesterVpcInfo;
        private VpcPeeringConnectionStateReason status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            this.accepterVpcInfo(model.accepterVpcInfo);
            this.expirationTime(model.expirationTime);
            this.requesterVpcInfo(model.requesterVpcInfo);
            this.status(model.status);
            this.tags(model.tags);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final VpcPeeringConnectionVpcInfo.Builder getAccepterVpcInfo() {
            return this.accepterVpcInfo != null ? this.accepterVpcInfo.toBuilder() : null;
        }

        public final void setAccepterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo != null ? accepterVpcInfo.build() : null;
        }

        @Override
        public final Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final VpcPeeringConnectionVpcInfo.Builder getRequesterVpcInfo() {
            return this.requesterVpcInfo != null ? this.requesterVpcInfo.toBuilder() : null;
        }

        public final void setRequesterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo != null ? requesterVpcInfo.build() : null;
        }

        @Override
        public final Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
            return this;
        }

        public final VpcPeeringConnectionStateReason.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(VpcPeeringConnectionStateReason.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(VpcPeeringConnectionStateReason status) {
            this.status = status;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcPeeringConnection> {
        public Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo var1);

        default public Builder accepterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> accepterVpcInfo) {
            return this.accepterVpcInfo((VpcPeeringConnectionVpcInfo)((VpcPeeringConnectionVpcInfo.Builder)VpcPeeringConnectionVpcInfo.builder().applyMutation(accepterVpcInfo)).build());
        }

        public Builder expirationTime(Instant var1);

        public Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo var1);

        default public Builder requesterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> requesterVpcInfo) {
            return this.requesterVpcInfo((VpcPeeringConnectionVpcInfo)((VpcPeeringConnectionVpcInfo.Builder)VpcPeeringConnectionVpcInfo.builder().applyMutation(requesterVpcInfo)).build());
        }

        public Builder status(VpcPeeringConnectionStateReason var1);

        default public Builder status(Consumer<VpcPeeringConnectionStateReason.Builder> status) {
            return this.status((VpcPeeringConnectionStateReason)((VpcPeeringConnectionStateReason.Builder)VpcPeeringConnectionStateReason.builder().applyMutation(status)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vpcPeeringConnectionId(String var1);
    }
}

