/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.DRBGUtils;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.SP80090DRBG;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class HMacSP800DRBG
implements SP80090DRBG {
    private static final long RESEED_MAX = 0x800000000000L;
    private static final int MAX_BITS_REQUEST = 262144;
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedKats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedValues = new HashMap<String, byte[][]>();
    private WorkingBuffer workingBuf = new WorkingBuffer();
    private long _reseedCounter;
    private EntropySource _entropySource;
    private Mac _hMac;
    private int _securityStrength;
    private byte[] _personalizationString;

    public HMacSP800DRBG(Mac mac, int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this.init(mac, n, entropySource, byArray, byArray2);
    }

    private void init(Mac mac, int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n > DRBGUtils.getMaxSecurityStrength(mac)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < n) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this._securityStrength = n;
        this._entropySource = entropySource;
        this._hMac = mac;
        this._personalizationString = Arrays.clone(byArray);
        WorkingBuffer.access$102(this.workingBuf, new byte[mac.getMacSize()]);
        WorkingBuffer.access$202(this.workingBuf, new byte[mac.getMacSize()]);
        Arrays.fill(this.workingBuf._V, (byte)1);
        byte[] byArray3 = this.getEntropy();
        byte[] byArray4 = Arrays.concatenate(byArray3, byArray2, byArray);
        Arrays.fill(byArray3, (byte)0);
        this.reseedFromSeedMaterial(byArray4);
    }

    private void hmac_DRBG_Update(byte[] byArray) {
        this.hmac_DRBG_Update_Func(byArray, (byte)0);
        if (byArray != null) {
            this.hmac_DRBG_Update_Func(byArray, (byte)1);
        }
    }

    private void hmac_DRBG_Update_Func(byte[] byArray, byte by) {
        this._hMac.init(new KeyParameterImpl(this.workingBuf._K));
        this._hMac.update(this.workingBuf._V, 0, this.workingBuf._V.length);
        this._hMac.update(by);
        if (byArray != null) {
            this._hMac.update(byArray, 0, byArray.length);
        }
        this._hMac.doFinal(this.workingBuf._K, 0);
        this._hMac.init(new KeyParameterImpl(this.workingBuf._K));
        this._hMac.update(this.workingBuf._V, 0, this.workingBuf._V.length);
        this._hMac.doFinal(this.workingBuf._V, 0);
    }

    @Override
    public int getBlockSize() {
        return this.workingBuf._V.length * 8;
    }

    @Override
    public int getSecurityStrength() {
        return this._securityStrength;
    }

    @Override
    public byte[] getPersonalizationString() {
        return Arrays.clone(this._personalizationString);
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = byArray.length * 8;
        if (n > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (bl) {
            this.reseed(byArray2);
            byArray2 = null;
        }
        if (this._reseedCounter > 0x800000000000L) {
            return -1;
        }
        if (byArray2 != null) {
            this.hmac_DRBG_Update(byArray2);
        }
        byte[] byArray3 = new byte[byArray.length];
        int n2 = byArray.length / this.workingBuf._V.length;
        this._hMac.init(new KeyParameterImpl(this.workingBuf._K));
        for (int i = 0; i < n2; ++i) {
            this._hMac.update(this.workingBuf._V, 0, this.workingBuf._V.length);
            this._hMac.doFinal(this.workingBuf._V, 0);
            System.arraycopy(this.workingBuf._V, 0, byArray3, i * this.workingBuf._V.length, this.workingBuf._V.length);
        }
        if (n2 * this.workingBuf._V.length < byArray3.length) {
            this._hMac.update(this.workingBuf._V, 0, this.workingBuf._V.length);
            this._hMac.doFinal(this.workingBuf._V, 0);
            System.arraycopy(this.workingBuf._V, 0, byArray3, n2 * this.workingBuf._V.length, byArray3.length - n2 * this.workingBuf._V.length);
        }
        this.hmac_DRBG_Update(byArray2);
        ++this._reseedCounter;
        System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
        return n;
    }

    @Override
    public void reseed(byte[] byArray) {
        byte[] byArray2 = this.getEntropy();
        byte[] byArray3 = Arrays.concatenate(byArray2, byArray);
        Arrays.fill(byArray2, (byte)0);
        this.reseedFromSeedMaterial(byArray3);
    }

    private void reseedFromSeedMaterial(byte[] byArray) {
        try {
            this.hmac_DRBG_Update(byArray);
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
        this._reseedCounter = 1L;
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray == null || byArray.length < (this._securityStrength + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    protected void finalize() throws Throwable {
        try {
            Arrays.fill(this.workingBuf._K, (byte)0);
            Arrays.fill(this.workingBuf._V, (byte)0);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public VariantInternalKatTest createSelfTest(FipsAlgorithm fipsAlgorithm) {
        return new VariantInternalKatTest(fipsAlgorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void evaluate() throws Exception {
                byte[] byArray = HMacSP800DRBG.this.workingBuf._K;
                byte[] byArray2 = HMacSP800DRBG.this.workingBuf._V;
                byte[] byArray3 = HMacSP800DRBG.this._personalizationString;
                long l = HMacSP800DRBG.this._reseedCounter;
                EntropySource entropySource = HMacSP800DRBG.this._entropySource;
                try {
                    int n;
                    byte[] byArray4;
                    byte[] byArray5;
                    block16: {
                        block15: {
                            block14: {
                                byArray5 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                                byArray4 = Hex.decode("2021222324");
                                n = DRBGUtils.getMaxSecurityStrength(HMacSP800DRBG.this._hMac);
                                byte[][] byArray6 = (byte[][])kats.get(this.algorithm.getName());
                                HMacSP800DRBG.this.init(HMacSP800DRBG.this._hMac, HMacSP800DRBG.this._securityStrength, new DRBGUtils.KATEntropyProvider().get(n), byArray5, byArray4);
                                byte[] byArray7 = new byte[byArray6[0].length];
                                HMacSP800DRBG.this.generate(byArray7, null, true);
                                if (!Arrays.areEqual(byArray6[0], byArray7)) {
                                    this.fail("DRBG Block 1 KAT failure");
                                }
                                byArray7 = new byte[byArray6[1].length];
                                HMacSP800DRBG.this.generate(byArray7, null, true);
                                if (!Arrays.areEqual(byArray6[1], byArray7)) {
                                    this.fail("DRBG Block 2 KAT failure");
                                }
                                try {
                                    HMacSP800DRBG.this.init(HMacSP800DRBG.this._hMac, HMacSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(n), byArray5, byArray4);
                                    this.fail("DRBG LyingEntropySource not detected in init");
                                }
                                catch (IllegalStateException illegalStateException) {
                                    if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block14;
                                    this.fail("DRBG self test failed init entropy check");
                                }
                            }
                            try {
                                HMacSP800DRBG.this.init(HMacSP800DRBG.this._hMac, HMacSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(20), byArray5, byArray4);
                                this.fail("DRBG insufficient EntropySource not detected");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (illegalArgumentException.getMessage().equals("Not enough entropy for security strength required")) break block15;
                                this.fail("DRBG self test failed init entropy check");
                            }
                        }
                        try {
                            HMacSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(n);
                            HMacSP800DRBG.this.reseed(null);
                            this.fail("DRBG LyingEntropySource not detected in reseed");
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block16;
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                    try {
                        HMacSP800DRBG.this.init(HMacSP800DRBG.this._hMac, n + 1, new DRBGUtils.KATEntropyProvider().get(n), byArray5, byArray4);
                        this.fail("DRBG successful initialise with too high security strength");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!illegalArgumentException.getMessage().equals("Requested security strength is not supported by the derivation function")) {
                            this.fail("DRBG self test failed init security strength check");
                        }
                    }
                }
                finally {
                    WorkingBuffer.access$102(HMacSP800DRBG.this.workingBuf, byArray);
                    WorkingBuffer.access$202(HMacSP800DRBG.this.workingBuf, byArray2);
                    HMacSP800DRBG.access$402(HMacSP800DRBG.this, byArray3);
                    HMacSP800DRBG.this._reseedCounter = l;
                    HMacSP800DRBG.this._entropySource = entropySource;
                }
            }
        };
    }

    @Override
    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm fipsAlgorithm) {
        return new VariantInternalKatTest(fipsAlgorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void evaluate() throws Exception {
                byte[] byArray = HMacSP800DRBG.this.workingBuf._K;
                byte[] byArray2 = HMacSP800DRBG.this.workingBuf._V;
                byte[] byArray3 = HMacSP800DRBG.this._personalizationString;
                long l = HMacSP800DRBG.this._reseedCounter;
                EntropySource entropySource = HMacSP800DRBG.this._entropySource;
                try {
                    byte[] byArray4 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                    int n = DRBGUtils.getMaxSecurityStrength(HMacSP800DRBG.this._hMac);
                    byte[][] byArray5 = (byte[][])reseedKats.get(this.algorithm.getName());
                    byte[][] byArray6 = (byte[][])reseedValues.get(this.algorithm.getName());
                    WorkingBuffer.access$102(HMacSP800DRBG.this.workingBuf, Arrays.clone(byArray6[0]));
                    WorkingBuffer.access$202(HMacSP800DRBG.this.workingBuf, Arrays.clone(byArray6[1]));
                    HMacSP800DRBG.this._entropySource = new DRBGUtils.KATEntropyProvider().get(n);
                    HMacSP800DRBG.this.reseed(byArray4);
                    if (HMacSP800DRBG.this._reseedCounter != 1L) {
                        this.fail("DRBG reseedCounter failed to reset");
                    }
                    byte[] byArray7 = new byte[byArray5[0].length];
                    HMacSP800DRBG.this.generate(byArray7, null, false);
                    if (!Arrays.areEqual(byArray5[0], byArray7)) {
                        this.fail("DRBG Block 1 reseed KAT failure");
                    }
                    byArray7 = new byte[byArray5[1].length];
                    HMacSP800DRBG.this.generate(byArray7, null, false);
                    if (!Arrays.areEqual(byArray5[1], byArray7)) {
                        this.fail("DRBG Block 2 reseed KAT failure");
                    }
                    try {
                        HMacSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(n);
                        HMacSP800DRBG.this.reseed(null);
                        this.fail("DRBG LyingEntropySource not detected");
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) {
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                }
                finally {
                    WorkingBuffer.access$102(HMacSP800DRBG.this.workingBuf, byArray);
                    WorkingBuffer.access$202(HMacSP800DRBG.this.workingBuf, byArray2);
                    HMacSP800DRBG.access$402(HMacSP800DRBG.this, byArray3);
                    HMacSP800DRBG.this._reseedCounter = l;
                    HMacSP800DRBG.this._entropySource = entropySource;
                }
            }
        };
    }

    static /* synthetic */ byte[] access$402(HMacSP800DRBG hMacSP800DRBG, byte[] byArray) {
        hMacSP800DRBG._personalizationString = byArray;
        return byArray;
    }

    static {
        kats.put("SHA-1/HMAC", new byte[][]{Hex.decode("09e8e2eab9b4acfcea6fc8f8e98a25ff0481ced2ad65e9682e347965529c421b0ee65f1af7f06657"), Hex.decode("7982a3a8c3a737407ca1f6f3821f1d1ed1d1acfbf3e6a2d830ee702063ef42992de2b4f5c3157310")});
        kats.put("SHA-224/HMAC", new byte[][]{Hex.decode("24eff5d06816cd3da66f7888ca2c80d4416ed1adb35040492b8d1a06cf280382fcd4008f0e7809db"), Hex.decode("d014b676e03610a8addf59b25ccf227758b72c7fb218e3308336188352acbe12ac3e4d43837e7320")});
        kats.put("SHA-256/HMAC", new byte[][]{Hex.decode("c8eb1ed8c27c86fad174c8445b1a8401735cabd847a533ddf75bb43fe1bed58916ed222d10715dd5"), Hex.decode("67cf599a5a80d7cdf6113468e6f1dd66bd4e9864511f5913749511ac56a3f3a75fb0b68c5502444d")});
        kats.put("SHA-384/HMAC", new byte[][]{Hex.decode("7a70bad84ceeb34ddfae4fe0e7911f3772b9bcdc95fc373254be4c64282e517e8b5346440d73e6b6"), Hex.decode("7d68e490dbc4c0043eb3510ec1cee55b4718bfcfc4e93f3341fa3bbc0513e92ef38f40f2ffe04b4b")});
        kats.put("SHA-512/HMAC", new byte[][]{Hex.decode("7223e2b58fb4b987cbd25f0b01a19135ca5cd78ccc16e8e5f8c6efd33fe2a71a97c3c8456fba6507"), Hex.decode("e90ee5626d5266cf6b70d118b07a0d4dd06ff0db4a65248628eadb88d9994f8e59a093b4ad217a83")});
        kats.put("SHA-512(224)/HMAC", new byte[][]{Hex.decode("0c1563ed502a9e9b33fc3beb8adced92f7440b346f311ffd3727a14d461f9199a6ef3c827a5199fb"), Hex.decode("40dc8b5b304cf82ddd4d47c69ba0743b242bddabf393353ed78867b947b2f8e6a553605253b62356")});
        kats.put("SHA-512(256)/HMAC", new byte[][]{Hex.decode("a9c1c62095292f475eb8a2a80890f9b3d77b9b42d4ef446881315d3531eccb5430c6659a4fc3c63b"), Hex.decode("1c0d60c8a99603ef18588d5c441c9ed2db93b682f810af39dc60296d8ea102505004f9b9fdf3cbc6")});
        reseedValues.put("SHA-1/HMAC", new byte[][]{Hex.decode("7bedcd650a8ddbb58b3d3e931c258b11ef0405ab"), Hex.decode("8d95ddbc7ccc68982e5885b3ff0124cf22997231")});
        reseedValues.put("SHA-224/HMAC", new byte[][]{Hex.decode("dc23db9b7f9f20b47c5f66a20a3e814062761a85813d513fa68fffb6"), Hex.decode("da520ecafcbd13c1af9d6882a98c13e906b9497b4c6b0ce97f3cf6f4")});
        reseedValues.put("SHA-256/HMAC", new byte[][]{Hex.decode("d4f6183d6bc347533ce1d35bb15b0827516d13c7596f08be8640ede806f11558"), Hex.decode("035efd9db053cd09a42c5386c6cee390a24de11de7d0ab447bfaa89e4cf1ea5c")});
        reseedValues.put("SHA-384/HMAC", new byte[][]{Hex.decode("1b6b3e7460776ddb5a6cb339f3b8e4184543e53a9067a20317866ccf437eca98802058612fbd926770653221917e3208"), Hex.decode("dccd578a26ca50c2e65a5812e049f79fa90e5fa01ce2542a34bbe4fb35e2ef1955d1d48b823b69ff45e67e7757b75a98")});
        reseedValues.put("SHA-512/HMAC", new byte[][]{Hex.decode("394c512894673b146c3539f2ad708d49658fbb0cc305e06e2311267b0d97fc2daf76483d0b7824cf70b7dc035ee2cb206168f5616abc162976d970ba912cb45a"), Hex.decode("2269652d19f62a7da40a3a2e67cad2065209f26268fab3ff924fff91afef349a70bdb63599013936fbe98f1d7267cbc1ae6817264bfb8aead91c421b4a2f344f")});
        reseedValues.put("SHA-512(224)/HMAC", new byte[][]{Hex.decode("46a8083d5553f1372297d1915e848e0c94f508fd39fc3937dde0f719"), Hex.decode("6d61dd2447807e8a630468383f5b59393e8a0b2860f614198aa03f7a")});
        reseedValues.put("SHA-512(256)/HMAC", new byte[][]{Hex.decode("93c284295b6ba606037d63f8912ba22036f6e40c19d872935b71f944c323209e"), Hex.decode("e499e4e92dabcb0efd6d99cc5798f85cafc114f8fd9dc895b6212b92026fecc0")});
        reseedKats.put("SHA-1/HMAC", new byte[][]{Hex.decode("9d27edc5b266cdaeb53e1cbff2c7f45375a64bdb4c0494bf270ea0123f392dbfa7579ae28ca26b4e"), Hex.decode("ffbf224df85dbaa8bf456cf77d2119cb5e7f96d9a16f2193d7bf222be9c367ea7365d8d380ac8df8")});
        reseedKats.put("SHA-224/HMAC", new byte[][]{Hex.decode("78db8e7652435e8658ca8489939d503a717faeaf65a417ab56f152fe34f22adca2257ba7391c7b95"), Hex.decode("29124d827d159924f7c1a92558cd035c07efc26d244215a03cdbfcf83be2977ca52694f395de9792")});
        reseedKats.put("SHA-256/HMAC", new byte[][]{Hex.decode("2855b533c124d5acd070dcadfd9105d74aae4ceecfc0d848559e35b5860c10facb021ba31b216dbc"), Hex.decode("08d4e9daf7265a606af90c7b661468e96f097734de89f23bda6b6e4f3308c31714ca200d7b0ddd2e")});
        reseedKats.put("SHA-384/HMAC", new byte[][]{Hex.decode("a18f64766084ab908389dc1ed23485b67f6383278b436ccdf335a495572dc11c338e65bad9a09ec4"), Hex.decode("dacaf121aac01c68e8171a0926e974e2008ea5403230c133258ac1f99a349bdc185ad500983ee988")});
        reseedKats.put("SHA-512/HMAC", new byte[][]{Hex.decode("80530aa6df83038ee721f28da155be91780f5aefb3278d048102b9e1d18ad3ef8b9ced43da3e2b5c"), Hex.decode("104a35b8b289f49658521d2f408633fe677bea064ff7673d3d844d060239fd9f8db9681b11c42d8a")});
        reseedKats.put("SHA-512(224)/HMAC", new byte[][]{Hex.decode("046157b89fe2d0e98f0d403e8b7b6764c6c441c63dd6b1a4977a427810812e01733460e2d0eeeee5"), Hex.decode("ba49668623438e669d1a4764a33611467517d83ad266aa6be086fced53c8d5508c77ae6d34b7080d")});
        reseedKats.put("SHA-512(256)/HMAC", new byte[][]{Hex.decode("90965e6618c74e5ee1a7ee4b7e6d9b7d1dd791cb57d7f255a50ef6571731ad6e20e373e222bdc3f4"), Hex.decode("ec3fde0e481624700da0e355daa9b75585bc1d973a03e85ee3887afa6d40b9231c7f9ebe09bfe97c")});
    }

    private static class WorkingBuffer {
        private byte[] _K;
        private byte[] _V;

        private WorkingBuffer() {
        }

        protected void finalize() throws Throwable {
            try {
                Arrays.fill(this._K, (byte)0);
                Arrays.fill(this._V, (byte)0);
            }
            finally {
                super.finalize();
            }
        }

        static /* synthetic */ byte[] access$102(WorkingBuffer workingBuffer, byte[] byArray) {
            workingBuffer._K = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$202(WorkingBuffer workingBuffer, byte[] byArray) {
            workingBuffer._V = byArray;
            return byArray;
        }
    }
}

