/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.hadoop.shaded.org.apache.kerby.util.ByteArrayReadLine;
import org.apache.hadoop.shaded.org.apache.kerby.util.HostPort;
import org.apache.hadoop.shaded.org.apache.kerby.util.IPAddressParser;

public class Util {
    public static final int SIZE_KEY = 0;
    public static final int LAST_READ_KEY = 1;

    public static boolean equals(KeyStore ks1, KeyStore ks2) throws KeyStoreException {
        Set<String> aliases2;
        if (ks1 == null || ks2 == null) {
            return ks1 == null && ks2 == null;
        }
        Set<String> aliases1 = Util.aliases(ks1);
        if (aliases1.equals(aliases2 = Util.aliases(ks2))) {
            for (String s2 : aliases1) {
                Certificate c2;
                Object[] cc2;
                if (ks1.isCertificateEntry(s2) != ks2.isCertificateEntry(s2)) {
                    return false;
                }
                if (ks1.isKeyEntry(s2) != ks2.isKeyEntry(s2)) {
                    return false;
                }
                if (!ks1.isCertificateEntry(s2)) continue;
                Object[] cc1 = ks1.getCertificateChain(s2);
                if (!Arrays.equals(cc1, cc2 = ks2.getCertificateChain(s2))) {
                    return false;
                }
                Certificate c1 = ks1.getCertificate(s2);
                if (c1.equals(c2 = ks2.getCertificate(s2))) continue;
                return false;
            }
        }
        return true;
    }

    private static Set<String> aliases(KeyStore ks) throws KeyStoreException {
        TreeSet<String> aliases = new TreeSet<String>();
        Enumeration<String> en = ks.aliases();
        while (en.hasMoreElements()) {
            aliases.add(en.nextElement());
        }
        return aliases;
    }

    public static boolean isYes(String yesString) {
        if (yesString == null) {
            return false;
        }
        String s2 = yesString.trim().toUpperCase();
        return "1".equals(s2) || "YES".equals(s2) || "TRUE".equals(s2) || "ENABLE".equals(s2) || "ENABLED".equals(s2) || "Y".equals(s2) || "ON".equals(s2);
    }

    public static String trim(String s2) {
        if (s2 == null || "".equals(s2)) {
            return s2;
        }
        int i = 0;
        int j = s2.length() - 1;
        while (Util.isWhiteSpace(s2.charAt(i))) {
            ++i;
        }
        while (Util.isWhiteSpace(s2.charAt(j))) {
            --j;
        }
        return j >= i ? s2.substring(i, j + 1) : "";
    }

    public static boolean isWhiteSpace(char c) {
        switch (c) {
            case '\u0000': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static void pipeStream(InputStream in, OutputStream out) throws IOException {
        Util.pipeStream(in, out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipeStream(InputStream in, OutputStream out, boolean autoClose) throws IOException {
        byte[] buf = new byte[8192];
        IOException ioe = null;
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                if (bytesRead > 0) {
                    out.write(buf, 0, bytesRead);
                }
                bytesRead = in.read(buf);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            if (autoClose) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public static byte[] fileToBytes(File f) throws IOException {
        return Util.streamToBytes(Files.newInputStream(f.toPath(), new OpenOption[0]));
    }

    public static byte[] streamToBytes(ByteArrayInputStream in, int maxLength) {
        byte[] buf = new byte[maxLength];
        int[] status = Util.fill(buf, 0, in);
        int size = status[0];
        if (buf.length != size) {
            byte[] smallerBuf = new byte[size];
            System.arraycopy(buf, 0, smallerBuf, 0, size);
            buf = smallerBuf;
        }
        return buf;
    }

    public static byte[] streamToBytes(InputStream in, int maxLength) throws IOException {
        byte[] buf = new byte[maxLength];
        int[] status = Util.fill(buf, 0, in);
        int size = status[0];
        if (buf.length != size) {
            byte[] smallerBuf = new byte[size];
            System.arraycopy(buf, 0, smallerBuf, 0, size);
            buf = smallerBuf;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamToBytes(InputStream in) throws IOException {
        byte[] buf = new byte[4096];
        try {
            int[] status = Util.fill(buf, 0, in);
            int size = status[0];
            int lastRead = status[1];
            while (lastRead != -1) {
                buf = Util.resizeArray(buf);
                status = Util.fill(buf, size, in);
                size = status[0];
                lastRead = status[1];
            }
            if (buf.length != size) {
                byte[] smallerBuf = new byte[size];
                System.arraycopy(buf, 0, smallerBuf, 0, size);
                buf = smallerBuf;
            }
        }
        finally {
            in.close();
        }
        return buf;
    }

    public static byte[] streamToBytes(ByteArrayInputStream in) {
        byte[] buf = new byte[4096];
        int[] status = Util.fill(buf, 0, in);
        int size = status[0];
        int lastRead = status[1];
        while (lastRead != -1) {
            buf = Util.resizeArray(buf);
            status = Util.fill(buf, size, in);
            size = status[0];
            lastRead = status[1];
        }
        if (buf.length != size) {
            byte[] smallerBuf = new byte[size];
            System.arraycopy(buf, 0, smallerBuf, 0, size);
            buf = smallerBuf;
        }
        return buf;
    }

    public static int[] fill(byte[] buf, int offset, InputStream in) throws IOException {
        int read;
        int lastRead = read = in.read(buf, offset, buf.length - offset);
        if (read == -1) {
            read = 0;
        }
        while (lastRead != -1 && read + offset < buf.length) {
            lastRead = in.read(buf, offset + read, buf.length - read - offset);
            if (lastRead == -1) continue;
            read += lastRead;
        }
        return new int[]{offset + read, lastRead};
    }

    public static int[] fill(byte[] buf, int offset, ByteArrayInputStream in) {
        int read;
        int lastRead = read = in.read(buf, offset, buf.length - offset);
        if (read == -1) {
            read = 0;
        }
        while (lastRead != -1 && read + offset < buf.length) {
            lastRead = in.read(buf, offset + read, buf.length - read - offset);
            if (lastRead == -1) continue;
            read += lastRead;
        }
        return new int[]{offset + read, lastRead};
    }

    public static byte[] resizeArray(byte[] bytes) {
        byte[] biggerBytes = new byte[bytes.length * 2];
        System.arraycopy(bytes, 0, biggerBytes, 0, bytes.length);
        return biggerBytes;
    }

    public static String pad(String s2, int length, boolean left) {
        int diff;
        if (s2 == null) {
            s2 = "";
        }
        if ((diff = length - s2.length()) == 0) {
            return s2;
        }
        if (diff > 0) {
            int i;
            StringBuilder sb = new StringBuilder();
            if (left) {
                for (i = 0; i < diff; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(s2);
            if (!left) {
                for (i = 0; i < diff; ++i) {
                    sb.append(' ');
                }
            }
            return sb.toString();
        }
        return s2;
    }

    public static HostPort toAddress(String target, int defaultPort) throws UnknownHostException {
        String host = target;
        int port = defaultPort;
        StringTokenizer st = new StringTokenizer(target, ":");
        if (st.hasMoreTokens()) {
            host = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            port = Integer.parseInt(st.nextToken().trim());
        }
        if (st.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid host: " + target);
        }
        return new HostPort(host, port);
    }

    public static String cipherToAuthType(String cipher) {
        if (cipher == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(cipher.trim(), "_");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            String tok = st.nextToken();
            StringBuilder buf = new StringBuilder();
            buf.append(tok);
            if (st.hasMoreTokens()) {
                tok = st.nextToken();
                while (!"WITH".equalsIgnoreCase(tok)) {
                    buf.append('_');
                    buf.append(tok);
                    tok = st.nextToken();
                }
            }
            return buf.toString();
        }
        throw new IllegalArgumentException("not a valid cipher: " + cipher);
    }

    public static InetAddress toInetAddress(String s2) throws UnknownHostException {
        byte[] ip = IPAddressParser.parseIPv4Literal(s2);
        if (ip == null) {
            ip = IPAddressParser.parseIPv6Literal(s2);
        }
        if (ip != null) {
            return InetAddress.getByAddress(s2, ip);
        }
        return InetAddress.getByName(s2);
    }

    public static void main(String[] args) throws Exception {
        String s2 = "line1\n\rline2\n\rline3";
        ByteArrayInputStream in = new ByteArrayInputStream(s2.getBytes(Charset.forName("UTF-8")));
        ByteArrayReadLine readLine = new ByteArrayReadLine(in);
        String line = readLine.next();
        while (line != null) {
            System.out.println(line);
            line = readLine.next();
        }
        System.out.println("--------- test 2 ----------");
        s2 = "line1\n\rline2\n\rline3\n\r\n\r";
        in = new ByteArrayInputStream(s2.getBytes(StandardCharsets.UTF_8));
        readLine = new ByteArrayReadLine(in);
        line = readLine.next();
        while (line != null) {
            System.out.println(line);
            line = readLine.next();
        }
    }
}

