/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.util.ClassDefinitionExtractor;
import org.protege.editor.owl.model.util.ObjectPropertyDefinitionExtractor;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class DefinitionExtractor {
    @Nonnull
    private OWLEntity entity;
    @Nonnull
    private OWLOntology ontology;
    @Nonnull
    private OWLDataFactory dataFactory;

    public DefinitionExtractor(@Nonnull OWLEntity entity, @Nonnull OWLOntology ontology, @Nonnull OWLDataFactory dataFactory) {
        this.entity = (OWLEntity)Preconditions.checkNotNull((Object)entity);
        this.ontology = (OWLOntology)Preconditions.checkNotNull((Object)ontology);
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
    }

    public Set<OWLAxiom> getDefiningAxioms() {
        return (Set)this.entity.accept((OWLEntityVisitorEx)new OWLEntityVisitorEx<Set<OWLAxiom>>(){

            @Nonnull
            public Set<OWLAxiom> visit(@Nonnull OWLClass cls) {
                return new ClassDefinitionExtractor(cls, DefinitionExtractor.this.ontology, DefinitionExtractor.this.dataFactory).getDefiningAxioms();
            }

            @Nonnull
            public Set<OWLAxiom> visit(@Nonnull OWLObjectProperty property) {
                return new ObjectPropertyDefinitionExtractor(property, DefinitionExtractor.this.ontology, DefinitionExtractor.this.dataFactory).getDefiningAxioms();
            }

            @Nonnull
            public Set<OWLAxiom> visit(@Nonnull OWLDataProperty property) {
                return Collections.emptySet();
            }

            @Nonnull
            public Set<OWLAxiom> visit(@Nonnull OWLNamedIndividual individual) {
                return Collections.emptySet();
            }

            @Nonnull
            public Set<OWLAxiom> visit(@Nonnull OWLDatatype datatype) {
                return Collections.emptySet();
            }

            @Nonnull
            public Set<OWLAxiom> visit(@Nonnull OWLAnnotationProperty property) {
                return Collections.emptySet();
            }
        });
    }

    public List<OWLOntologyChange> getChangesToRemoveDefinition() {
        return (List)this.entity.accept((OWLEntityVisitorEx)new OWLEntityVisitorEx<List<OWLOntologyChange>>(){

            @Nonnull
            public List<OWLOntologyChange> visit(@Nonnull OWLClass cls) {
                return new ClassDefinitionExtractor(cls, DefinitionExtractor.this.ontology, DefinitionExtractor.this.dataFactory).getChangesToRemoveDefinition();
            }

            @Nonnull
            public List<OWLOntologyChange> visit(@Nonnull OWLObjectProperty property) {
                return new ObjectPropertyDefinitionExtractor(property, DefinitionExtractor.this.ontology, DefinitionExtractor.this.dataFactory).getChangesToRemoveDefinition();
            }

            @Nonnull
            public List<OWLOntologyChange> visit(@Nonnull OWLDataProperty property) {
                return Collections.emptyList();
            }

            @Nonnull
            public List<OWLOntologyChange> visit(@Nonnull OWLNamedIndividual individual) {
                return Collections.emptyList();
            }

            @Nonnull
            public List<OWLOntologyChange> visit(@Nonnull OWLDatatype datatype) {
                return Collections.emptyList();
            }

            @Nonnull
            public List<OWLOntologyChange> visit(@Nonnull OWLAnnotationProperty property) {
                return Collections.emptyList();
            }
        });
    }
}

