/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.utils.SortedListModel;

public class ManageTagsDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JComboBox<String> txtTagAdd = null;
    private JButton btnAdd = null;
    private JButton btnDelete = null;
    private JButton btnSave = null;
    private JButton btnCancel = null;
    private JList<String> tagList = null;
    private SortedListModel<String> tagListModel = null;
    private HistoryReference historyRef;
    private JScrollPane jScrollPane = null;
    private SortedComboBoxModel<String> tagAddModel = null;

    public ManageTagsDialog() throws HeadlessException {
        this.initialize();
    }

    public ManageTagsDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("history.managetags.title"));
        this.setContentPane(this.getJPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints00 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints00.gridy = 0;
            gridBagConstraints00.gridx = 0;
            gridBagConstraints00.fill = 2;
            gridBagConstraints00.weightx = 1.0;
            gridBagConstraints00.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints10.gridy = 1;
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints11.anchor = 13;
            gridBagConstraints20.gridy = 2;
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints30.weightx = 1.0;
            gridBagConstraints30.weighty = 1.0;
            gridBagConstraints30.fill = 1;
            gridBagConstraints30.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints30.gridy = 3;
            gridBagConstraints30.gridx = 0;
            gridBagConstraints30.anchor = 18;
            gridBagConstraints30.ipadx = 0;
            gridBagConstraints30.ipady = 10;
            gridBagConstraints31.gridy = 3;
            gridBagConstraints31.gridx = 1;
            gridBagConstraints31.fill = 2;
            gridBagConstraints31.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints31.anchor = 12;
            gridBagConstraints40.gridy = 4;
            gridBagConstraints40.gridx = 0;
            gridBagConstraints40.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints40.anchor = 13;
            gridBagConstraints41.gridy = 4;
            gridBagConstraints41.gridx = 1;
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints41.anchor = 13;
            this.jPanel.add((Component)new JLabel(Constant.messages.getString("history.managetags.label.addtag")), gridBagConstraints00);
            this.jPanel.add(this.getTxtTagAdd(), gridBagConstraints10);
            this.jPanel.add((Component)this.getBtnAdd(), gridBagConstraints11);
            this.jPanel.add((Component)new JLabel(Constant.messages.getString("history.managetags.label.currenttags")), gridBagConstraints20);
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints30);
            this.jPanel.add((Component)this.getBtnDelete(), gridBagConstraints31);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints40);
            this.jPanel.add((Component)this.getBtnSave(), gridBagConstraints41);
        }
        return this.jPanel;
    }

    private JList<String> getTagList() {
        if (this.tagList == null) {
            this.tagList = new JList();
            this.tagList.setLayoutOrientation(0);
            this.tagList.setSelectionMode(2);
            this.tagListModel = new SortedListModel();
            this.tagList.setModel(this.tagListModel);
        }
        return this.tagList;
    }

    public void setTags(List<String> tags) {
        this.tagListModel.clear();
        for (String tag : tags) {
            this.tagListModel.addElement(tag);
            this.getAllTagsModel().removeElement(tag);
        }
    }

    private void addTag(String tag) {
        if (tag != null && tag.length() > 0 && !this.tagListModel.contains(tag)) {
            this.tagListModel.addElement(tag);
            this.getAllTagsModel().removeElement(tag);
        }
    }

    private void deleteTags(List<String> tags) {
        for (String tag : tags) {
            this.tagListModel.removeElement(tag);
            this.getAllTagsModel().addElement(tag);
        }
    }

    private JComboBox<String> getTxtTagAdd() {
        if (this.txtTagAdd == null) {
            this.txtTagAdd = new JComboBox();
            this.txtTagAdd.setEditable(true);
            this.tagAddModel = this.getAllTagsModel();
            this.txtTagAdd.setModel(this.tagAddModel);
        }
        return this.txtTagAdd;
    }

    private SortedComboBoxModel<String> getAllTagsModel() {
        if (this.tagAddModel == null) {
            this.tagAddModel = new SortedComboBoxModel();
        }
        return this.tagAddModel;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setText(Constant.messages.getString("history.managetags.button.add"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageTagsDialog.this.addTag(ManageTagsDialog.this.getTxtTagAdd().getSelectedItem().toString());
                    ManageTagsDialog.this.getTxtTagAdd().setSelectedIndex(0);
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(Constant.messages.getString("history.managetags.button.delete"));
            this.btnDelete.setEnabled(true);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageTagsDialog.this.deleteTags(ManageTagsDialog.this.tagList.getSelectedValuesList());
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(Constant.messages.getString("history.managetags.button.save"));
            this.btnSave.setEnabled(true);
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageTagsDialog.this.historyRef.setTags(Collections.list(ManageTagsDialog.this.tagListModel.elements()));
                    ManageTagsDialog.this.dispose();
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.setEnabled(true);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageTagsDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setViewportView(this.getTagList());
        }
        return this.jScrollPane;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyRef) {
        this.historyRef = historyRef;
    }

    public void setAllTags(List<String> allTags) {
        this.getAllTagsModel().removeAllElements();
        this.getAllTagsModel().addElement("");
        for (String tag : allTags) {
            this.getAllTagsModel().addElement(tag);
        }
    }
}

