﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/medialive/MediaLive_EXPORTS.h>

namespace Aws {
namespace MediaLive {
namespace Model {
enum class DvbSubDestinationAlignment { NOT_SET, CENTERED, LEFT, SMART };

namespace DvbSubDestinationAlignmentMapper {
AWS_MEDIALIVE_API DvbSubDestinationAlignment GetDvbSubDestinationAlignmentForName(const Aws::String& name);

AWS_MEDIALIVE_API Aws::String GetNameForDvbSubDestinationAlignment(DvbSubDestinationAlignment value);
}  // namespace DvbSubDestinationAlignmentMapper
}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
