/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleXid
implements Xid,
Serializable {
    private int formatId;
    private byte[] gtrid = null;
    private byte[] bqual = null;
    private byte[] txctx = null;
    private int m_hashCode = 0;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private int state;

    public OracleXid(int fId, byte[] gId, byte[] bId) throws XAException {
        this(fId, gId, bId, null);
    }

    public OracleXid(int fId, byte[] gId, byte[] bId, byte[] context) throws XAException {
        this.formatId = fId;
        if (gId != null && gId.length > 64) {
            throw (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
        }
        this.gtrid = gId;
        if (bId != null && bId.length > 64) {
            throw (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
        }
        this.bqual = bId;
        this.txctx = context;
        this.state = 0;
        this.m_hashCode = this.computeHashCode();
    }

    public void setState(int k) {
        this.state = k;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public byte[] getTxContext() {
        return this.txctx;
    }

    public void setTxContext(byte[] context) {
        this.txctx = context;
    }

    public static final boolean isLocalTransaction(Xid xid) {
        byte[] gtrid = xid.getGlobalTransactionId();
        if (gtrid == null) {
            return true;
        }
        for (int i = 0; i < gtrid.length; ++i) {
            if (gtrid[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object xid) {
        if (this == xid) {
            return true;
        }
        if (xid == null || !(xid instanceof Xid)) {
            return false;
        }
        Xid _xid = (Xid)xid;
        return this.getFormatId() == _xid.getFormatId() && Arrays.equals(this.getGlobalTransactionId(), _xid.getGlobalTransactionId()) && Arrays.equals(this.getBranchQualifier(), _xid.getBranchQualifier());
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    private int computeHashCode() {
        int i;
        int total = 0;
        byte[] xid1Gtrid = this.getGlobalTransactionId();
        byte[] xid1Bqual = this.getBranchQualifier();
        total += this.getFormatId();
        if (xid1Gtrid == null) {
            total += 0;
        } else {
            for (i = 0; i < xid1Gtrid.length; ++i) {
                total += xid1Gtrid[i];
            }
        }
        if (xid1Bqual == null) {
            total += 0;
        } else {
            for (i = 0; i < xid1Bqual.length; ++i) {
                total += xid1Bqual[i];
            }
        }
        return total;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

