# SPDX-FileCopyrightText: © 2023 Christian BUHTZ <c.buhtz@posteo.jp>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of the program "Back In Time" which is released under GNU
# General Public License v2 (GPLv2). See LICENSES directory or go to
# <https://spdx.org/licenses/GPL-2.0-or-later.html>.
#
# Generated at Tue Feb 10 15:49:56 2026 with help
# of package "babel" and "polib".
# https://babel.pocoo.org
# https://github.com/python-babel/babel
# pylint: disable=too-many-lines,missing-module-docstring
names = {
    'ar': {
        '_native': 'العربية',
        'zh_CN': '阿拉伯语',
        'is': 'arabíska',
        'et': 'araabia',
        'sr': 'арапски',
        'nl': 'Arabisch',
        'sl': 'arabščina',
        'fa': 'عربی',
        'zh_TW': '阿拉伯文',
        'bg': 'арабски',
        'gl': 'árabe',
        'lt': 'arabų',
        'eu': 'arabiera',
        'he': 'ערבית',
        'pl': 'arabski',
        'sk': 'arabčina',
        'cs': 'arabština',
        'ka': 'არაბული',
        'de': 'Arabisch',
        'hu': 'arab',
        'ca': 'àrab',
        'ar': 'العربية',
        'ro': 'arabă',
        'fo': 'arabiskt',
        'tr': 'Arapça',
        'nb': 'arabisk',
        'pt': 'árabe',
        'it': 'arabo',
        'uk': 'арабська',
        'fi': 'arabia',
        'ko': '아랍어',
        'hr': 'arapski',
        'vi': 'Tiếng Ả Rập',
        'pt_BR': 'árabe',
        'el': 'Αραβικά',
        'ru': 'арабский',
        'eo': 'araba',
        'ja': 'アラビア語',
        'sr_Latn': 'arapski',
        'sv': 'arabiska',
        'da': 'arabisk',
        'id': 'Arab',
        'fr': 'arabe',
        'es': 'árabe',
        'nn': 'arabisk',
        'en': 'Arabic',
    },
    'bg': {
        '_native': 'български',
        'zh_CN': '保加利亚语',
        'is': 'búlgarska',
        'et': 'bulgaaria',
        'sr': 'бугарски',
        'nl': 'Bulgaars',
        'sl': 'bolgarščina',
        'fa': 'بلغاری',
        'zh_TW': '保加利亞文',
        'bg': 'български',
        'gl': 'búlgaro',
        'lt': 'bulgarų',
        'eu': 'bulgariera',
        'he': 'בולגרית',
        'pl': 'bułgarski',
        'sk': 'bulharčina',
        'cs': 'bulharština',
        'ka': 'ბულგარული',
        'de': 'Bulgarisch',
        'hu': 'bolgár',
        'ca': 'búlgar',
        'ar': 'البلغارية',
        'ro': 'bulgară',
        'fo': 'bulgarskt',
        'tr': 'Bulgarca',
        'nb': 'bulgarsk',
        'pt': 'búlgaro',
        'it': 'bulgaro',
        'uk': 'болгарська',
        'fi': 'bulgaria',
        'ko': '불가리아어',
        'hr': 'bugarski',
        'vi': 'Tiếng Bulgaria',
        'pt_BR': 'búlgaro',
        'el': 'Βουλγαρικά',
        'ru': 'болгарский',
        'eo': 'bulgara',
        'ja': 'ブルガリア語',
        'sr_Latn': 'bugarski',
        'sv': 'bulgariska',
        'da': 'bulgarsk',
        'id': 'Bulgaria',
        'fr': 'bulgare',
        'es': 'búlgaro',
        'nn': 'bulgarsk',
        'en': 'Bulgarian',
    },
    'ca': {
        '_native': 'català',
        'zh_CN': '加泰罗尼亚语',
        'is': 'katalónska',
        'et': 'katalaani',
        'sr': 'каталонски',
        'nl': 'Catalaans',
        'sl': 'katalonščina',
        'fa': 'کاتالان',
        'zh_TW': '加泰蘭文',
        'bg': 'каталонски',
        'gl': 'catalán',
        'lt': 'katalonų',
        'eu': 'katalana',
        'he': 'קטלאנית',
        'pl': 'kataloński',
        'sk': 'katalánčina',
        'cs': 'katalánština',
        'ka': 'კატალანური',
        'de': 'Katalanisch',
        'hu': 'katalán',
        'ca': 'català',
        'ar': 'الكتالانية',
        'ro': 'catalană',
        'fo': 'katalani',
        'tr': 'Katalanca',
        'nb': 'katalansk',
        'pt': 'catalão',
        'it': 'catalano',
        'uk': 'каталонська',
        'fi': 'katalaani',
        'ko': '카탈로니아어',
        'hr': 'katalonski',
        'vi': 'Tiếng Catalan',
        'pt_BR': 'catalão',
        'el': 'Καταλανικά',
        'ru': 'каталанский',
        'eo': 'kataluna',
        'ja': 'カタロニア語',
        'sr_Latn': 'katalonski',
        'sv': 'katalanska',
        'da': 'catalansk',
        'id': 'Katalan',
        'fr': 'catalan',
        'es': 'catalán',
        'nn': 'katalansk',
        'en': 'Catalan',
    },
    'cs': {
        '_native': 'čeština',
        'zh_CN': '捷克语',
        'is': 'tékkneska',
        'et': 'tšehhi',
        'sr': 'чешки',
        'nl': 'Tsjechisch',
        'sl': 'češčina',
        'fa': 'چکی',
        'zh_TW': '捷克文',
        'bg': 'чешки',
        'gl': 'checo',
        'lt': 'čekų',
        'eu': 'txekiera',
        'he': 'צ׳כית',
        'pl': 'czeski',
        'sk': 'čeština',
        'cs': 'čeština',
        'ka': 'ჩეხური',
        'de': 'Tschechisch',
        'hu': 'cseh',
        'ca': 'txec',
        'ar': 'التشيكية',
        'ro': 'cehă',
        'fo': 'kekkiskt',
        'tr': 'Çekçe',
        'nb': 'tsjekkisk',
        'pt': 'tcheco',
        'it': 'ceco',
        'uk': 'чеська',
        'fi': 'tšekki',
        'ko': '체코어',
        'hr': 'češki',
        'vi': 'Tiếng Séc',
        'pt_BR': 'tcheco',
        'el': 'Τσεχικά',
        'ru': 'чешский',
        'eo': 'ĉeĥa',
        'ja': 'チェコ語',
        'sr_Latn': 'češki',
        'sv': 'tjeckiska',
        'da': 'tjekkisk',
        'id': 'Ceko',
        'fr': 'tchèque',
        'es': 'checo',
        'nn': 'tsjekkisk',
        'en': 'Czech',
    },
    'da': {
        '_native': 'dansk',
        'zh_CN': '丹麦语',
        'is': 'danska',
        'et': 'taani',
        'sr': 'дански',
        'nl': 'Deens',
        'sl': 'danščina',
        'fa': 'دانمارکی',
        'zh_TW': '丹麥文',
        'bg': 'датски',
        'gl': 'dinamarqués',
        'lt': 'danų',
        'eu': 'daniera',
        'he': 'דנית',
        'pl': 'duński',
        'sk': 'dánčina',
        'cs': 'dánština',
        'ka': 'დანიური',
        'de': 'Dänisch',
        'hu': 'dán',
        'ca': 'danès',
        'ar': 'الدانمركية',
        'ro': 'daneză',
        'fo': 'danskt',
        'tr': 'Danca',
        'nb': 'dansk',
        'pt': 'dinamarquês',
        'it': 'danese',
        'uk': 'данська',
        'fi': 'tanska',
        'ko': '덴마크어',
        'hr': 'danski',
        'vi': 'Tiếng Đan Mạch',
        'pt_BR': 'dinamarquês',
        'el': 'Δανικά',
        'ru': 'датский',
        'eo': 'dana',
        'ja': 'デンマーク語',
        'sr_Latn': 'danski',
        'sv': 'danska',
        'da': 'dansk',
        'id': 'Dansk',
        'fr': 'danois',
        'es': 'danés',
        'nn': 'dansk',
        'en': 'Danish',
    },
    'de': {
        '_native': 'Deutsch',
        'zh_CN': '德语',
        'is': 'þýska',
        'et': 'saksa',
        'sr': 'немачки',
        'nl': 'Duits',
        'sl': 'nemščina',
        'fa': 'آلمانی',
        'zh_TW': '德文',
        'bg': 'немски',
        'gl': 'alemán',
        'lt': 'vokiečių',
        'eu': 'alemana',
        'he': 'גרמנית',
        'pl': 'niemiecki',
        'sk': 'nemčina',
        'cs': 'němčina',
        'ka': 'გერმანული',
        'de': 'Deutsch',
        'hu': 'német',
        'ca': 'alemany',
        'ar': 'الألمانية',
        'ro': 'germană',
        'fo': 'týskt',
        'tr': 'Almanca',
        'nb': 'tysk',
        'pt': 'alemão',
        'it': 'tedesco',
        'uk': 'німецька',
        'fi': 'saksa',
        'ko': '독일어',
        'hr': 'njemački',
        'vi': 'Tiếng Đức',
        'pt_BR': 'alemão',
        'el': 'Γερμανικά',
        'ru': 'немецкий',
        'eo': 'germana',
        'ja': 'ドイツ語',
        'sr_Latn': 'nemački',
        'sv': 'tyska',
        'da': 'tysk',
        'id': 'Jerman',
        'fr': 'allemand',
        'es': 'alemán',
        'nn': 'tysk',
        'en': 'German',
    },
    'el': {
        '_native': 'Ελληνικά',
        'zh_CN': '希腊语',
        'is': 'gríska',
        'et': 'kreeka',
        'sr': 'грчки',
        'nl': 'Grieks',
        'sl': 'grščina',
        'fa': 'یونانی',
        'zh_TW': '希臘文',
        'bg': 'гръцки',
        'gl': 'grego',
        'lt': 'graikų',
        'eu': 'greziera',
        'he': 'יוונית',
        'pl': 'grecki',
        'sk': 'gréčtina',
        'cs': 'řečtina',
        'ka': 'ბერძნული',
        'de': 'Griechisch',
        'hu': 'görög',
        'ca': 'grec',
        'ar': 'اليونانية',
        'ro': 'greacă',
        'fo': 'grikskt',
        'tr': 'Yunanca',
        'nb': 'gresk',
        'pt': 'grego',
        'it': 'greco',
        'uk': 'грецька',
        'fi': 'kreikka',
        'ko': '그리스어',
        'hr': 'grčki',
        'vi': 'Tiếng Hy Lạp',
        'pt_BR': 'grego',
        'el': 'Ελληνικά',
        'ru': 'греческий',
        'eo': 'greka',
        'ja': 'ギリシャ語',
        'sr_Latn': 'grčki',
        'sv': 'grekiska',
        'da': 'græsk',
        'id': 'Yunani',
        'fr': 'grec',
        'es': 'griego',
        'nn': 'gresk',
        'en': 'Greek',
    },
    'en': {
        '_native': 'English',
        'zh_CN': '英语',
        'is': 'enska',
        'et': 'inglise',
        'sr': 'енглески',
        'nl': 'Engels',
        'sl': 'angleščina',
        'fa': 'انگلیسی',
        'zh_TW': '英文',
        'bg': 'английски',
        'gl': 'inglés',
        'lt': 'anglų',
        'eu': 'ingelesa',
        'he': 'אנגלית',
        'pl': 'angielski',
        'sk': 'angličtina',
        'cs': 'angličtina',
        'ka': 'ინგლისური',
        'de': 'Englisch',
        'hu': 'angol',
        'ca': 'anglès',
        'ar': 'الإنجليزية',
        'ro': 'engleză',
        'fo': 'enskt',
        'tr': 'İngilizce',
        'nb': 'engelsk',
        'pt': 'inglês',
        'it': 'inglese',
        'uk': 'англійська',
        'fi': 'englanti',
        'ko': '영어',
        'hr': 'engleski',
        'vi': 'Tiếng Anh',
        'pt_BR': 'inglês',
        'el': 'Αγγλικά',
        'ru': 'английский',
        'eo': 'angla',
        'ja': '英語',
        'sr_Latn': 'engleski',
        'sv': 'engelska',
        'da': 'engelsk',
        'id': 'Inggris',
        'fr': 'anglais',
        'es': 'inglés',
        'nn': 'engelsk',
        'en': 'English',
    },
    'eo': {
        '_native': 'Esperanto',
        'zh_CN': '世界语',
        'is': 'esperantó',
        'et': 'esperanto',
        'sr': 'есперанто',
        'nl': 'Esperanto',
        'sl': 'esperanto',
        'fa': 'اسپرانتو',
        'zh_TW': '世界文',
        'bg': 'есперанто',
        'gl': 'esperanto',
        'lt': 'esperanto',
        'eu': 'esperantoa',
        'he': 'אספרנטו',
        'pl': 'esperanto',
        'sk': 'esperanto',
        'cs': 'esperanto',
        'ka': 'ესპერანტო',
        'de': 'Esperanto',
        'hu': 'eszperantó',
        'ca': 'esperanto',
        'ar': 'الإسبرانتو',
        'ro': 'esperanto',
        'fo': 'esperanto',
        'tr': 'Esperanto',
        'nb': 'esperanto',
        'pt': 'esperanto',
        'it': 'esperanto',
        'uk': 'есперанто',
        'fi': 'esperanto',
        'ko': '에스페란토어',
        'hr': 'esperanto',
        'vi': 'Tiếng Quốc Tế Ngữ',
        'pt_BR': 'esperanto',
        'el': 'Εσπεράντο',
        'ru': 'эсперанто',
        'eo': 'Esperanto',
        'ja': 'エスペラント語',
        'sr_Latn': 'esperanto',
        'sv': 'esperanto',
        'da': 'esperanto',
        'id': 'Esperanto',
        'fr': 'espéranto',
        'es': 'esperanto',
        'nn': 'esperanto',
        'en': 'Esperanto',
    },
    'es': {
        '_native': 'español',
        'zh_CN': '西班牙语',
        'is': 'spænska',
        'et': 'hispaania',
        'sr': 'шпански',
        'nl': 'Spaans',
        'sl': 'španščina',
        'fa': 'اسپانیایی',
        'zh_TW': '西班牙文',
        'bg': 'испански',
        'gl': 'español',
        'lt': 'ispanų',
        'eu': 'gaztelania',
        'he': 'ספרדית',
        'pl': 'hiszpański',
        'sk': 'španielčina',
        'cs': 'španělština',
        'ka': 'ესპანური',
        'de': 'Spanisch',
        'hu': 'spanyol',
        'ca': 'espanyol',
        'ar': 'الإسبانية',
        'ro': 'spaniolă',
        'fo': 'spanskt',
        'tr': 'İspanyolca',
        'nb': 'spansk',
        'pt': 'espanhol',
        'it': 'spagnolo',
        'uk': 'іспанська',
        'fi': 'espanja',
        'ko': '스페인어',
        'hr': 'španjolski',
        'vi': 'Tiếng Tây Ban Nha',
        'pt_BR': 'espanhol',
        'el': 'Ισπανικά',
        'ru': 'испанский',
        'eo': 'hispana',
        'ja': 'スペイン語',
        'sr_Latn': 'španski',
        'sv': 'spanska',
        'da': 'spansk',
        'id': 'Spanyol',
        'fr': 'espagnol',
        'es': 'español',
        'nn': 'spansk',
        'en': 'Spanish',
    },
    'et': {
        '_native': 'eesti',
        'zh_CN': '爱沙尼亚语',
        'is': 'eistneska',
        'et': 'eesti',
        'sr': 'естонски',
        'nl': 'Estisch',
        'sl': 'estonščina',
        'fa': 'استونیایی',
        'zh_TW': '愛沙尼亞文',
        'bg': 'естонски',
        'gl': 'estoniano',
        'lt': 'estų',
        'eu': 'estoniera',
        'he': 'אסטונית',
        'pl': 'estoński',
        'sk': 'estónčina',
        'cs': 'estonština',
        'ka': 'ესტონური',
        'de': 'Estnisch',
        'hu': 'észt',
        'ca': 'estonià',
        'ar': 'الإستونية',
        'ro': 'estonă',
        'fo': 'estiskt',
        'tr': 'Estonca',
        'nb': 'estisk',
        'pt': 'estoniano',
        'it': 'estone',
        'uk': 'естонська',
        'fi': 'viro',
        'ko': '에스토니아어',
        'hr': 'estonski',
        'vi': 'Tiếng Estonia',
        'pt_BR': 'estoniano',
        'el': 'Εσθονικά',
        'ru': 'эстонский',
        'eo': 'estona',
        'ja': 'エストニア語',
        'sr_Latn': 'estonski',
        'sv': 'estniska',
        'da': 'estisk',
        'id': 'Estonia',
        'fr': 'estonien',
        'es': 'estonio',
        'nn': 'estisk',
        'en': 'Estonian',
    },
    'eu': {
        '_native': 'euskara',
        'zh_CN': '巴斯克语',
        'is': 'baskneska',
        'et': 'baski',
        'sr': 'баскијски',
        'nl': 'Baskisch',
        'sl': 'baskovščina',
        'fa': 'باسکی',
        'zh_TW': '巴斯克文',
        'bg': 'баски',
        'gl': 'éuscaro',
        'lt': 'baskų',
        'eu': 'euskara',
        'he': 'בסקית',
        'pl': 'baskijski',
        'sk': 'baskičtina',
        'cs': 'baskičtina',
        'ka': 'ბასკური',
        'de': 'Baskisch',
        'hu': 'baszk',
        'ca': 'basc',
        'ar': 'الباسكية',
        'ro': 'bască',
        'fo': 'baskiskt',
        'tr': 'Baskça',
        'nb': 'baskisk',
        'pt': 'basco',
        'it': 'basco',
        'uk': 'баскська',
        'fi': 'baski',
        'ko': '바스크어',
        'hr': 'baskijski',
        'vi': 'Tiếng Basque',
        'pt_BR': 'basco',
        'el': 'Βασκικά',
        'ru': 'баскский',
        'eo': 'eŭska',
        'ja': 'バスク語',
        'sr_Latn': 'baskijski',
        'sv': 'baskiska',
        'da': 'baskisk',
        'id': 'Basque',
        'fr': 'basque',
        'es': 'euskera',
        'nn': 'baskisk',
        'en': 'Basque',
    },
    'fa': {
        '_native': 'فارسی',
        'zh_CN': '波斯语',
        'is': 'persneska',
        'et': 'pärsia',
        'sr': 'персијски',
        'nl': 'Perzisch',
        'sl': 'perzijščina',
        'fa': 'فارسی',
        'zh_TW': '波斯文',
        'bg': 'персийски',
        'gl': 'persa',
        'lt': 'persų',
        'eu': 'persiera',
        'he': 'פרסית',
        'pl': 'perski',
        'sk': 'perzština',
        'cs': 'perština',
        'ka': 'სპარსული',
        'de': 'Persisch',
        'hu': 'perzsa',
        'ca': 'persa',
        'ar': 'الفارسية',
        'ro': 'persană',
        'fo': 'persiskt',
        'tr': 'Farsça',
        'nb': 'persisk',
        'pt': 'persa',
        'it': 'persiano',
        'uk': 'перська',
        'fi': 'persia',
        'ko': '페르시아어',
        'hr': 'perzijski',
        'vi': 'Tiếng Ba Tư',
        'pt_BR': 'persa',
        'el': 'Περσικά',
        'ru': 'персидский',
        'eo': 'persa',
        'ja': 'ペルシア語',
        'sr_Latn': 'persijski',
        'sv': 'persiska',
        'da': 'persisk',
        'id': 'Persia',
        'fr': 'persan',
        'es': 'persa',
        'nn': 'persisk',
        'en': 'Persian',
    },
    'fi': {
        '_native': 'suomi',
        'zh_CN': '芬兰语',
        'is': 'finnska',
        'et': 'soome',
        'sr': 'фински',
        'nl': 'Fins',
        'sl': 'finščina',
        'fa': 'فنلاندی',
        'zh_TW': '芬蘭文',
        'bg': 'фински',
        'gl': 'finés',
        'lt': 'suomių',
        'eu': 'finlandiera',
        'he': 'פינית',
        'pl': 'fiński',
        'sk': 'fínčina',
        'cs': 'finština',
        'ka': 'ფინური',
        'de': 'Finnisch',
        'hu': 'finn',
        'ca': 'finès',
        'ar': 'الفنلندية',
        'ro': 'finlandeză',
        'fo': 'finskt',
        'tr': 'Fince',
        'nb': 'finsk',
        'pt': 'finlandês',
        'it': 'finlandese',
        'uk': 'фінська',
        'fi': 'suomi',
        'ko': '핀란드어',
        'hr': 'finski',
        'vi': 'Tiếng Phần Lan',
        'pt_BR': 'finlandês',
        'el': 'Φινλανδικά',
        'ru': 'финский',
        'eo': 'finna',
        'ja': 'フィンランド語',
        'sr_Latn': 'finski',
        'sv': 'finska',
        'da': 'finsk',
        'id': 'Suomi',
        'fr': 'finnois',
        'es': 'finés',
        'nn': 'finsk',
        'en': 'Finnish',
    },
    'fo': {
        '_native': 'føroyskt',
        'zh_CN': '法罗语',
        'is': 'færeyska',
        'et': 'fääri',
        'sr': 'фарски',
        'nl': 'Faeröers',
        'sl': 'ferščina',
        'fa': 'فارویی',
        'zh_TW': '法羅文',
        'bg': 'фарьорски',
        'gl': 'feroés',
        'lt': 'farerų',
        'eu': 'faroera',
        'he': 'פארואזית',
        'pl': 'farerski',
        'sk': 'faerčina',
        'cs': 'faerština',
        'ka': 'ფარერული',
        'de': 'Färöisch',
        'hu': 'feröeri',
        'ca': 'feroès',
        'ar': 'الفاروية',
        'ro': 'feroeză',
        'fo': 'føroyskt',
        'tr': 'Faroe dili',
        'nb': 'færøysk',
        'pt': 'feroês',
        'it': 'faroese',
        'uk': 'фарерська',
        'fi': 'fääri',
        'ko': '페로어',
        'hr': 'ferojski',
        'vi': 'Tiếng Faroe',
        'pt_BR': 'feroês',
        'el': 'Φεροϊκά',
        'ru': 'фарерский',
        'eo': 'feroa',
        'ja': 'フェロー語',
        'sr_Latn': 'farski',
        'sv': 'färöiska',
        'da': 'færøsk',
        'id': 'Faroe',
        'fr': 'féroïen',
        'es': 'feroés',
        'nn': 'færøysk',
        'en': 'Faroese',
    },
    'fr': {
        '_native': 'français',
        'zh_CN': '法语',
        'is': 'franska',
        'et': 'prantsuse',
        'sr': 'француски',
        'nl': 'Frans',
        'sl': 'francoščina',
        'fa': 'فرانسوی',
        'zh_TW': '法文',
        'bg': 'френски',
        'gl': 'francés',
        'lt': 'prancūzų',
        'eu': 'frantsesa',
        'he': 'צרפתית',
        'pl': 'francuski',
        'sk': 'francúzština',
        'cs': 'francouzština',
        'ka': 'ფრანგული',
        'de': 'Französisch',
        'hu': 'francia',
        'ca': 'francès',
        'ar': 'الفرنسية',
        'ro': 'franceză',
        'fo': 'franskt',
        'tr': 'Fransızca',
        'nb': 'fransk',
        'pt': 'francês',
        'it': 'francese',
        'uk': 'французька',
        'fi': 'ranska',
        'ko': '프랑스어',
        'hr': 'francuski',
        'vi': 'Tiếng Pháp',
        'pt_BR': 'francês',
        'el': 'Γαλλικά',
        'ru': 'французский',
        'eo': 'franca',
        'ja': 'フランス語',
        'sr_Latn': 'francuski',
        'sv': 'franska',
        'da': 'fransk',
        'id': 'Prancis',
        'fr': 'français',
        'es': 'francés',
        'nn': 'fransk',
        'en': 'French',
    },
    'gl': {
        '_native': 'galego',
        'zh_CN': '加利西亚语',
        'is': 'galisíska',
        'et': 'galeegi',
        'sr': 'галицијски',
        'nl': 'Galicisch',
        'sl': 'galicijščina',
        'fa': 'گالیسیایی',
        'zh_TW': '加利西亞文',
        'bg': 'галисийски',
        'gl': 'galego',
        'lt': 'galisų',
        'eu': 'galiziera',
        'he': 'גליציאנית',
        'pl': 'galicyjski',
        'sk': 'galícijčina',
        'cs': 'galicijština',
        'ka': 'გალისიური',
        'de': 'Galicisch',
        'hu': 'gallego',
        'ca': 'gallec',
        'ar': 'الجاليكية',
        'ro': 'galiciană',
        'fo': 'galisiskt',
        'tr': 'Galiçyaca',
        'nb': 'galisisk',
        'pt': 'galego',
        'it': 'galiziano',
        'uk': 'галісійська',
        'fi': 'galicia',
        'ko': '갈리시아어',
        'hr': 'galicijski',
        'vi': 'Tiếng Galician',
        'pt_BR': 'galego',
        'el': 'Γαλικιανά',
        'ru': 'галисийский',
        'eo': 'galega',
        'ja': 'ガリシア語',
        'sr_Latn': 'galicijski',
        'sv': 'galiciska',
        'da': 'galicisk',
        'id': 'Galisia',
        'fr': 'galicien',
        'es': 'gallego',
        'nn': 'galisisk',
        'en': 'Galician',
    },
    'he': {
        '_native': 'עברית',
        'zh_CN': '希伯来语',
        'is': 'hebreska',
        'et': 'heebrea',
        'sr': 'хебрејски',
        'nl': 'Hebreeuws',
        'sl': 'hebrejščina',
        'fa': 'عبری',
        'zh_TW': '希伯來文',
        'bg': 'иврит',
        'gl': 'hebreo',
        'lt': 'hebrajų',
        'eu': 'hebreera',
        'he': 'עברית',
        'pl': 'hebrajski',
        'sk': 'hebrejčina',
        'cs': 'hebrejština',
        'ka': 'ებრაული',
        'de': 'Hebräisch',
        'hu': 'héber',
        'ca': 'hebreu',
        'ar': 'العبرية',
        'ro': 'ebraică',
        'fo': 'hebraiskt',
        'tr': 'İbranice',
        'nb': 'hebraisk',
        'pt': 'hebraico',
        'it': 'ebraico',
        'uk': 'іврит',
        'fi': 'heprea',
        'ko': '히브리어',
        'hr': 'hebrejski',
        'vi': 'Tiếng Do Thái',
        'pt_BR': 'hebraico',
        'el': 'Εβραϊκά',
        'ru': 'иврит',
        'eo': 'hebrea',
        'ja': 'ヘブライ語',
        'sr_Latn': 'hebrejski',
        'sv': 'hebreiska',
        'da': 'hebraisk',
        'id': 'Ibrani',
        'fr': 'hébreu',
        'es': 'hebreo',
        'nn': 'hebraisk',
        'en': 'Hebrew',
    },
    'hr': {
        '_native': 'hrvatski',
        'zh_CN': '克罗地亚语',
        'is': 'króatíska',
        'et': 'horvaadi',
        'sr': 'хрватски',
        'nl': 'Kroatisch',
        'sl': 'hrvaščina',
        'fa': 'کروات',
        'zh_TW': '克羅埃西亞文',
        'bg': 'хърватски',
        'gl': 'croata',
        'lt': 'kroatų',
        'eu': 'kroaziera',
        'he': 'קרואטית',
        'pl': 'chorwacki',
        'sk': 'chorvátčina',
        'cs': 'chorvatština',
        'ka': 'ხორვატული',
        'de': 'Kroatisch',
        'hu': 'horvát',
        'ca': 'croat',
        'ar': 'الكرواتية',
        'ro': 'croată',
        'fo': 'kroatiskt',
        'tr': 'Hırvatça',
        'nb': 'kroatisk',
        'pt': 'croata',
        'it': 'croato',
        'uk': 'хорватська',
        'fi': 'kroatia',
        'ko': '크로아티아어',
        'hr': 'hrvatski',
        'vi': 'Tiếng Croatia',
        'pt_BR': 'croata',
        'el': 'Κροατικά',
        'ru': 'хорватский',
        'eo': 'kroata',
        'ja': 'クロアチア語',
        'sr_Latn': 'hrvatski',
        'sv': 'kroatiska',
        'da': 'kroatisk',
        'id': 'Kroasia',
        'fr': 'croate',
        'es': 'croata',
        'nn': 'kroatisk',
        'en': 'Croatian',
    },
    'hu': {
        '_native': 'magyar',
        'zh_CN': '匈牙利语',
        'is': 'ungverska',
        'et': 'ungari',
        'sr': 'мађарски',
        'nl': 'Hongaars',
        'sl': 'madžarščina',
        'fa': 'مجاری',
        'zh_TW': '匈牙利文',
        'bg': 'унгарски',
        'gl': 'húngaro',
        'lt': 'vengrų',
        'eu': 'hungariera',
        'he': 'הונגרית',
        'pl': 'węgierski',
        'sk': 'maďarčina',
        'cs': 'maďarština',
        'ka': 'უნგრული',
        'de': 'Ungarisch',
        'hu': 'magyar',
        'ca': 'hongarès',
        'ar': 'الهنغارية',
        'ro': 'maghiară',
        'fo': 'ungarskt',
        'tr': 'Macarca',
        'nb': 'ungarsk',
        'pt': 'húngaro',
        'it': 'ungherese',
        'uk': 'угорська',
        'fi': 'unkari',
        'ko': '헝가리어',
        'hr': 'mađarski',
        'vi': 'Tiếng Hungary',
        'pt_BR': 'húngaro',
        'el': 'Ουγγρικά',
        'ru': 'венгерский',
        'eo': 'hungara',
        'ja': 'ハンガリー語',
        'sr_Latn': 'mađarski',
        'sv': 'ungerska',
        'da': 'ungarsk',
        'id': 'Hungaria',
        'fr': 'hongrois',
        'es': 'húngaro',
        'nn': 'ungarsk',
        'en': 'Hungarian',
    },
    'id': {
        '_native': 'Indonesia',
        'zh_CN': '印度尼西亚语',
        'is': 'indónesíska',
        'et': 'indoneesia',
        'sr': 'индонежански',
        'nl': 'Indonesisch',
        'sl': 'indonezijščina',
        'fa': 'اندونزیایی',
        'zh_TW': '印尼文',
        'bg': 'индонезийски',
        'gl': 'indonesio',
        'lt': 'indoneziečių',
        'eu': 'indonesiera',
        'he': 'אינדונזית',
        'pl': 'indonezyjski',
        'sk': 'indonézština',
        'cs': 'indonéština',
        'ka': 'ინდონეზიური',
        'de': 'Indonesisch',
        'hu': 'indonéz',
        'ca': 'indonesi',
        'ar': 'الإندونيسية',
        'ro': 'indoneziană',
        'fo': 'indonesiskt',
        'tr': 'Endonezce',
        'nb': 'indonesisk',
        'pt': 'indonésio',
        'it': 'indonesiano',
        'uk': 'індонезійська',
        'fi': 'indonesia',
        'ko': '인도네시아어',
        'hr': 'indonezijski',
        'vi': 'Tiếng Indonesia',
        'pt_BR': 'indonésio',
        'el': 'Ινδονησιακά',
        'ru': 'индонезийский',
        'eo': 'indonezia',
        'ja': 'インドネシア語',
        'sr_Latn': 'indonežanski',
        'sv': 'indonesiska',
        'da': 'indonesisk',
        'id': 'Indonesia',
        'fr': 'indonésien',
        'es': 'indonesio',
        'nn': 'indonesisk',
        'en': 'Indonesian',
    },
    'is': {
        '_native': 'íslenska',
        'zh_CN': '冰岛语',
        'is': 'íslenska',
        'et': 'islandi',
        'sr': 'исландски',
        'nl': 'IJslands',
        'sl': 'islandščina',
        'fa': 'ایسلندی',
        'zh_TW': '冰島文',
        'bg': 'исландски',
        'gl': 'islandés',
        'lt': 'islandų',
        'eu': 'islandiera',
        'he': 'איסלנדית',
        'pl': 'islandzki',
        'sk': 'islandčina',
        'cs': 'islandština',
        'ka': 'ისლანდიური',
        'de': 'Isländisch',
        'hu': 'izlandi',
        'ca': 'islandès',
        'ar': 'الأيسلندية',
        'ro': 'islandeză',
        'fo': 'íslendskt',
        'tr': 'İzlandaca',
        'nb': 'islandsk',
        'pt': 'islandês',
        'it': 'islandese',
        'uk': 'ісландська',
        'fi': 'islanti',
        'ko': '아이슬란드어',
        'hr': 'islandski',
        'vi': 'Tiếng Iceland',
        'pt_BR': 'islandês',
        'el': 'Ισλανδικά',
        'ru': 'исландский',
        'eo': 'islanda',
        'ja': 'アイスランド語',
        'sr_Latn': 'islandski',
        'sv': 'isländska',
        'da': 'islandsk',
        'id': 'Islandia',
        'fr': 'islandais',
        'es': 'islandés',
        'nn': 'islandsk',
        'en': 'Icelandic',
    },
    'it': {
        '_native': 'italiano',
        'zh_CN': '意大利语',
        'is': 'ítalska',
        'et': 'itaalia',
        'sr': 'италијански',
        'nl': 'Italiaans',
        'sl': 'italijanščina',
        'fa': 'ایتالیایی',
        'zh_TW': '義大利文',
        'bg': 'италиански',
        'gl': 'italiano',
        'lt': 'italų',
        'eu': 'italiera',
        'he': 'איטלקית',
        'pl': 'włoski',
        'sk': 'taliančina',
        'cs': 'italština',
        'ka': 'იტალიური',
        'de': 'Italienisch',
        'hu': 'olasz',
        'ca': 'italià',
        'ar': 'الإيطالية',
        'ro': 'italiană',
        'fo': 'italskt',
        'tr': 'İtalyanca',
        'nb': 'italiensk',
        'pt': 'italiano',
        'it': 'italiano',
        'uk': 'італійська',
        'fi': 'italia',
        'ko': '이탈리아어',
        'hr': 'talijanski',
        'vi': 'Tiếng Italy',
        'pt_BR': 'italiano',
        'el': 'Ιταλικά',
        'ru': 'итальянский',
        'eo': 'itala',
        'ja': 'イタリア語',
        'sr_Latn': 'italijanski',
        'sv': 'italienska',
        'da': 'italiensk',
        'id': 'Italia',
        'fr': 'italien',
        'es': 'italiano',
        'nn': 'italiensk',
        'en': 'Italian',
    },
    'ja': {
        '_native': '日本語',
        'zh_CN': '日语',
        'is': 'japanska',
        'et': 'jaapani',
        'sr': 'јапански',
        'nl': 'Japans',
        'sl': 'japonščina',
        'fa': 'ژاپنی',
        'zh_TW': '日文',
        'bg': 'японски',
        'gl': 'xaponés',
        'lt': 'japonų',
        'eu': 'japoniera',
        'he': 'יפנית',
        'pl': 'japoński',
        'sk': 'japončina',
        'cs': 'japonština',
        'ka': 'იაპონური',
        'de': 'Japanisch',
        'hu': 'japán',
        'ca': 'japonès',
        'ar': 'اليابانية',
        'ro': 'japoneză',
        'fo': 'japanskt',
        'tr': 'Japonca',
        'nb': 'japansk',
        'pt': 'japonês',
        'it': 'giapponese',
        'uk': 'японська',
        'fi': 'japani',
        'ko': '일본어',
        'hr': 'japanski',
        'vi': 'Tiếng Nhật',
        'pt_BR': 'japonês',
        'el': 'Ιαπωνικά',
        'ru': 'японский',
        'eo': 'japana',
        'ja': '日本語',
        'sr_Latn': 'japanski',
        'sv': 'japanska',
        'da': 'japansk',
        'id': 'Jepang',
        'fr': 'japonais',
        'es': 'japonés',
        'nn': 'japansk',
        'en': 'Japanese',
    },
    'ka': {
        '_native': 'ქართული',
        'zh_CN': '格鲁吉亚语',
        'is': 'georgíska',
        'et': 'gruusia',
        'sr': 'грузијски',
        'nl': 'Georgisch',
        'sl': 'gruzijščina',
        'fa': 'گرجی',
        'zh_TW': '喬治亞文',
        'bg': 'грузински',
        'gl': 'xeorxiano',
        'lt': 'gruzinų',
        'eu': 'georgiera',
        'he': 'גאורגית',
        'pl': 'gruziński',
        'sk': 'gruzínčina',
        'cs': 'gruzínština',
        'ka': 'ქართული',
        'de': 'Georgisch',
        'hu': 'grúz',
        'ca': 'georgià',
        'ar': 'الجورجية',
        'ro': 'georgiană',
        'fo': 'georgiskt',
        'tr': 'Gürcüce',
        'nb': 'georgisk',
        'pt': 'georgiano',
        'it': 'georgiano',
        'uk': 'грузинська',
        'fi': 'georgia',
        'ko': '조지아어',
        'hr': 'gruzijski',
        'vi': 'Tiếng Georgia',
        'pt_BR': 'georgiano',
        'el': 'Γεωργιανά',
        'ru': 'грузинский',
        'eo': 'kartvela',
        'ja': 'ジョージア語',
        'sr_Latn': 'gruzijski',
        'sv': 'georgiska',
        'da': 'georgisk',
        'id': 'Georgia',
        'fr': 'géorgien',
        'es': 'georgiano',
        'nn': 'georgisk',
        'en': 'Georgian',
    },
    'ko': {
        '_native': '한국어',
        'zh_CN': '韩语',
        'is': 'kóreska',
        'et': 'korea',
        'sr': 'корејски',
        'nl': 'Koreaans',
        'sl': 'korejščina',
        'fa': 'کره‌ای',
        'zh_TW': '韓文',
        'bg': 'корейски',
        'gl': 'coreano',
        'lt': 'korėjiečių',
        'eu': 'koreera',
        'he': 'קוריאנית',
        'pl': 'koreański',
        'sk': 'kórejčina',
        'cs': 'korejština',
        'ka': 'კორეული',
        'de': 'Koreanisch',
        'hu': 'koreai',
        'ca': 'coreà',
        'ar': 'الكورية',
        'ro': 'coreeană',
        'fo': 'koreanskt',
        'tr': 'Korece',
        'nb': 'koreansk',
        'pt': 'coreano',
        'it': 'coreano',
        'uk': 'корейська',
        'fi': 'korea',
        'ko': '한국어',
        'hr': 'korejski',
        'vi': 'Tiếng Hàn',
        'pt_BR': 'coreano',
        'el': 'Κορεατικά',
        'ru': 'корейский',
        'eo': 'korea',
        'ja': '韓国語',
        'sr_Latn': 'korejski',
        'sv': 'koreanska',
        'da': 'koreansk',
        'id': 'Korea',
        'fr': 'coréen',
        'es': 'coreano',
        'nn': 'koreansk',
        'en': 'Korean',
    },
    'lt': {
        '_native': 'lietuvių',
        'zh_CN': '立陶宛语',
        'is': 'litháíska',
        'et': 'leedu',
        'sr': 'литвански',
        'nl': 'Litouws',
        'sl': 'litovščina',
        'fa': 'لیتوانیایی',
        'zh_TW': '立陶宛文',
        'bg': 'литовски',
        'gl': 'lituano',
        'lt': 'lietuvių',
        'eu': 'lituaniera',
        'he': 'ליטאית',
        'pl': 'litewski',
        'sk': 'litovčina',
        'cs': 'litevština',
        'ka': 'ლიეტუვური',
        'de': 'Litauisch',
        'hu': 'litván',
        'ca': 'lituà',
        'ar': 'الليتوانية',
        'ro': 'lituaniană',
        'fo': 'litaviskt',
        'tr': 'Litvanca',
        'nb': 'litauisk',
        'pt': 'lituano',
        'it': 'lituano',
        'uk': 'литовська',
        'fi': 'liettua',
        'ko': '리투아니아어',
        'hr': 'litavski',
        'vi': 'Tiếng Litva',
        'pt_BR': 'lituano',
        'el': 'Λιθουανικά',
        'ru': 'литовский',
        'eo': 'litova',
        'ja': 'リトアニア語',
        'sr_Latn': 'litvanski',
        'sv': 'litauiska',
        'da': 'litauisk',
        'id': 'Lituania',
        'fr': 'lituanien',
        'es': 'lituano',
        'nn': 'litauisk',
        'en': 'Lithuanian',
    },
    'nb': {
        '_native': 'norsk bokmål',
        'zh_CN': '书面挪威语',
        'is': 'norskt bókmál',
        'et': 'norra bokmål',
        'sr': 'норвешки букмол',
        'nl': 'Noors - Bokmål',
        'sl': 'knjižna norveščina',
        'fa': 'نروژی بوک‌مُل',
        'zh_TW': '書面挪威文',
        'bg': 'норвежки (букмол)',
        'gl': 'noruegués bokmål',
        'lt': 'norvegų bukmolas',
        'eu': 'bokmål (norvegiera)',
        'he': 'נורווגית ספרותית',
        'pl': 'norweski (bokmål)',
        'sk': 'nórčina (bokmal)',
        'cs': 'norština (bokmål)',
        'ka': 'ნორვეგიული ბუკმოლი',
        'de': 'Norwegisch (Bokmål)',
        'hu': 'norvég (bokmål)',
        'ca': 'noruec bokmål',
        'ar': 'النرويجية بوكمال',
        'ro': 'norvegiană bokmål',
        'fo': 'norskt bókmál',
        'tr': 'Norveççe Bokmål',
        'nb': 'norsk bokmål',
        'pt': 'bokmål norueguês',
        'it': 'norvegese bokmål',
        'uk': 'норвезька (букмол)',
        'fi': 'norjan bokmål',
        'ko': '노르웨이어(보크말)',
        'hr': 'norveški bokmål',
        'vi': 'Tiếng Na Uy (Bokmål)',
        'pt_BR': 'bokmål norueguês',
        'el': 'Νορβηγικά Μποκμάλ',
        'ru': 'норвежский букмол',
        'eo': 'dannorvega',
        'ja': 'ノルウェー語(ブークモール)',
        'sr_Latn': 'norveški bukmol',
        'sv': 'norskt bokmål',
        'da': 'bokmål',
        'id': 'Bokmål Norwegia',
        'fr': 'norvégien bokmål',
        'es': 'noruego bokmal',
        'nn': 'norsk bokmål',
        'en': 'Norwegian Bokmål',
    },
    'nl': {
        '_native': 'Nederlands',
        'zh_CN': '荷兰语',
        'is': 'hollenska',
        'et': 'hollandi',
        'sr': 'холандски',
        'nl': 'Nederlands',
        'sl': 'nizozemščina',
        'fa': 'هلندی',
        'zh_TW': '荷蘭文',
        'bg': 'нидерландски',
        'gl': 'neerlandés',
        'lt': 'olandų',
        'eu': 'nederlandera',
        'he': 'הולנדית',
        'pl': 'niderlandzki',
        'sk': 'holandčina',
        'cs': 'nizozemština',
        'ka': 'ნიდერლანდური',
        'de': 'Niederländisch',
        'hu': 'holland',
        'ca': 'neerlandès',
        'ar': 'الهولندية',
        'ro': 'neerlandeză',
        'fo': 'hálendskt',
        'tr': 'Felemenkçe',
        'nb': 'nederlandsk',
        'pt': 'holandês',
        'it': 'olandese',
        'uk': 'нідерландська',
        'fi': 'hollanti',
        'ko': '네덜란드어',
        'hr': 'nizozemski',
        'vi': 'Tiếng Hà Lan',
        'pt_BR': 'holandês',
        'el': 'Ολλανδικά',
        'ru': 'нидерландский',
        'eo': 'nederlanda',
        'ja': 'オランダ語',
        'sr_Latn': 'holandski',
        'sv': 'nederländska',
        'da': 'nederlandsk',
        'id': 'Belanda',
        'fr': 'néerlandais',
        'es': 'neerlandés',
        'nn': 'nederlandsk',
        'en': 'Dutch',
    },
    'nn': {
        '_native': 'norsk nynorsk',
        'zh_CN': '挪威尼诺斯克语',
        'is': 'nýnorska',
        'et': 'uusnorra',
        'sr': 'норвешки нинорск',
        'nl': 'Noors - Nynorsk',
        'sl': 'novonorveščina',
        'fa': 'نروژی نی‌نُشک',
        'zh_TW': '新挪威文',
        'bg': 'норвежки (нюношк)',
        'gl': 'noruegués nynorsk',
        'lt': 'naujoji norvegų',
        'eu': 'nynorsk (norvegiera)',
        'he': 'נורווגית חדשה',
        'pl': 'norweski (nynorsk)',
        'sk': 'nórčina (nynorsk)',
        'cs': 'norština (nynorsk)',
        'ka': 'ნორვეგიული ნიუნორსკი',
        'de': 'Norwegisch (Nynorsk)',
        'hu': 'norvég (nynorsk)',
        'ca': 'noruec nynorsk',
        'ar': 'النرويجية نينورسك',
        'ro': 'norvegiană nynorsk',
        'fo': 'nýnorskt',
        'tr': 'Norveççe Nynorsk',
        'nb': 'norsk nynorsk',
        'pt': 'nynorsk norueguês',
        'it': 'norvegese nynorsk',
        'uk': 'норвезька (нюношк)',
        'fi': 'norjan nynorsk',
        'ko': '노르웨이어(니노르스크)',
        'hr': 'norveški nynorsk',
        'vi': 'Tiếng Na Uy (Nynorsk)',
        'pt_BR': 'nynorsk norueguês',
        'el': 'Νορβηγικά Νινόρσκ',
        'ru': 'нюнорск',
        'eo': 'novnorvega',
        'ja': 'ノルウェー語(ニーノシュク)',
        'sr_Latn': 'norveški ninorsk',
        'sv': 'nynorska',
        'da': 'nynorsk',
        'id': 'Nynorsk Norwegia',
        'fr': 'norvégien nynorsk',
        'es': 'noruego nynorsk',
        'nn': 'norsk nynorsk',
        'en': 'Norwegian Nynorsk',
    },
    'pl': {
        '_native': 'polski',
        'zh_CN': '波兰语',
        'is': 'pólska',
        'et': 'poola',
        'sr': 'пољски',
        'nl': 'Pools',
        'sl': 'poljščina',
        'fa': 'لهستانی',
        'zh_TW': '波蘭文',
        'bg': 'полски',
        'gl': 'polaco',
        'lt': 'lenkų',
        'eu': 'poloniera',
        'he': 'פולנית',
        'pl': 'polski',
        'sk': 'poľština',
        'cs': 'polština',
        'ka': 'პოლონური',
        'de': 'Polnisch',
        'hu': 'lengyel',
        'ca': 'polonès',
        'ar': 'البولندية',
        'ro': 'poloneză',
        'fo': 'pólskt',
        'tr': 'Lehçe',
        'nb': 'polsk',
        'pt': 'polonês',
        'it': 'polacco',
        'uk': 'польська',
        'fi': 'puola',
        'ko': '폴란드어',
        'hr': 'poljski',
        'vi': 'Tiếng Ba Lan',
        'pt_BR': 'polonês',
        'el': 'Πολωνικά',
        'ru': 'польский',
        'eo': 'pola',
        'ja': 'ポーランド語',
        'sr_Latn': 'poljski',
        'sv': 'polska',
        'da': 'polsk',
        'id': 'Polski',
        'fr': 'polonais',
        'es': 'polaco',
        'nn': 'polsk',
        'en': 'Polish',
    },
    'pt': {
        '_native': 'português',
        'zh_CN': '葡萄牙语',
        'is': 'portúgalska',
        'et': 'portugali',
        'sr': 'португалски',
        'nl': 'Portugees',
        'sl': 'portugalščina',
        'fa': 'پرتغالی',
        'zh_TW': '葡萄牙文',
        'bg': 'португалски',
        'gl': 'portugués',
        'lt': 'portugalų',
        'eu': 'portugesa',
        'he': 'פורטוגזית',
        'pl': 'portugalski',
        'sk': 'portugalčina',
        'cs': 'portugalština',
        'ka': 'პორტუგალიური',
        'de': 'Portugiesisch',
        'hu': 'portugál',
        'ca': 'portuguès',
        'ar': 'البرتغالية',
        'ro': 'portugheză',
        'fo': 'portugiskiskt',
        'tr': 'Portekizce',
        'nb': 'portugisisk',
        'pt': 'português',
        'it': 'portoghese',
        'uk': 'португальська',
        'fi': 'portugali',
        'ko': '포르투갈어',
        'hr': 'portugalski',
        'vi': 'Tiếng Bồ Đào Nha',
        'pt_BR': 'português',
        'el': 'Πορτογαλικά',
        'ru': 'португальский',
        'eo': 'portugala',
        'ja': 'ポルトガル語',
        'sr_Latn': 'portugalski',
        'sv': 'portugisiska',
        'da': 'portugisisk',
        'id': 'Portugis',
        'fr': 'portugais',
        'es': 'portugués',
        'nn': 'portugisisk',
        'en': 'Portuguese',
    },
    'pt_BR': {
        '_native': 'português (Brasil)',
        'zh_CN': '葡萄牙语 (巴西)',
        'is': 'portúgalska (Brasilía)',
        'et': 'portugali (Brasiilia)',
        'sr': 'португалски (Бразил)',
        'nl': 'Portugees (Brazilië)',
        'sl': 'portugalščina (Brazilija)',
        'fa': 'پرتغالی (برزیل)',
        'zh_TW': '葡萄牙文 (巴西)',
        'bg': 'португалски (Бразилия)',
        'gl': 'portugués (Brasil)',
        'lt': 'portugalų (Brazilija)',
        'eu': 'portugesa (Brasil)',
        'he': 'פורטוגזית (ברזיל)',
        'pl': 'portugalski (Brazylia)',
        'sk': 'portugalčina (Brazília)',
        'cs': 'portugalština (Brazílie)',
        'ka': 'პორტუგალიური (ბრაზილია)',
        'de': 'Portugiesisch (Brasilien)',
        'hu': 'portugál (Brazília)',
        'ca': 'portuguès (Brasil)',
        'ar': 'البرتغالية (البرازيل)',
        'ro': 'portugheză (Brazilia)',
        'fo': 'portugiskiskt (Brasil)',
        'tr': 'Portekizce (Brezilya)',
        'nb': 'portugisisk (Brasil)',
        'pt': 'português (Brasil)',
        'it': 'portoghese (Brasile)',
        'uk': 'португальська (Бразилія)',
        'fi': 'portugali (Brasilia)',
        'ko': '포르투갈어 (브라질)',
        'hr': 'portugalski (Brazil)',
        'vi': 'Tiếng Bồ Đào Nha (Brazil)',
        'pt_BR': 'português (Brasil)',
        'el': 'Πορτογαλικά (Βραζιλία)',
        'ru': 'португальский (Бразилия)',
        'eo': 'portugala (Brazilo)',
        'ja': 'ポルトガル語 (ブラジル)',
        'sr_Latn': 'portugalski (Brazil)',
        'sv': 'portugisiska (Brasilien)',
        'da': 'portugisisk (Brasilien)',
        'id': 'Portugis (Brasil)',
        'fr': 'portugais (Brésil)',
        'es': 'portugués (Brasil)',
        'nn': 'portugisisk (Brasil)',
        'en': 'Portuguese (Brazil)',
    },
    'ro': {
        '_native': 'română',
        'zh_CN': '罗马尼亚语',
        'is': 'rúmenska',
        'et': 'rumeenia',
        'sr': 'румунски',
        'nl': 'Roemeens',
        'sl': 'romunščina',
        'fa': 'رومانیایی',
        'zh_TW': '羅馬尼亞文',
        'bg': 'румънски',
        'gl': 'romanés',
        'lt': 'rumunų',
        'eu': 'errumaniera',
        'he': 'רומנית',
        'pl': 'rumuński',
        'sk': 'rumunčina',
        'cs': 'rumunština',
        'ka': 'რუმინული',
        'de': 'Rumänisch',
        'hu': 'román',
        'ca': 'romanès',
        'ar': 'الرومانية',
        'ro': 'română',
        'fo': 'rumenskt',
        'tr': 'Rumence',
        'nb': 'rumensk',
        'pt': 'romeno',
        'it': 'rumeno',
        'uk': 'румунська',
        'fi': 'romania',
        'ko': '루마니아어',
        'hr': 'rumunjski',
        'vi': 'Tiếng Romania',
        'pt_BR': 'romeno',
        'el': 'Ρουμανικά',
        'ru': 'румынский',
        'eo': 'rumana',
        'ja': 'ルーマニア語',
        'sr_Latn': 'rumunski',
        'sv': 'rumänska',
        'da': 'rumænsk',
        'id': 'Rumania',
        'fr': 'roumain',
        'es': 'rumano',
        'nn': 'rumensk',
        'en': 'Romanian',
    },
    'ru': {
        '_native': 'русский',
        'zh_CN': '俄语',
        'is': 'rússneska',
        'et': 'vene',
        'sr': 'руски',
        'nl': 'Russisch',
        'sl': 'ruščina',
        'fa': 'روسی',
        'zh_TW': '俄文',
        'bg': 'руски',
        'gl': 'ruso',
        'lt': 'rusų',
        'eu': 'errusiera',
        'he': 'רוסית',
        'pl': 'rosyjski',
        'sk': 'ruština',
        'cs': 'ruština',
        'ka': 'რუსული',
        'de': 'Russisch',
        'hu': 'orosz',
        'ca': 'rus',
        'ar': 'الروسية',
        'ro': 'rusă',
        'fo': 'russiskt',
        'tr': 'Rusça',
        'nb': 'russisk',
        'pt': 'russo',
        'it': 'russo',
        'uk': 'російська',
        'fi': 'venäjä',
        'ko': '러시아어',
        'hr': 'ruski',
        'vi': 'Tiếng Nga',
        'pt_BR': 'russo',
        'el': 'Ρωσικά',
        'ru': 'русский',
        'eo': 'rusa',
        'ja': 'ロシア語',
        'sr_Latn': 'ruski',
        'sv': 'ryska',
        'da': 'russisk',
        'id': 'Rusia',
        'fr': 'russe',
        'es': 'ruso',
        'nn': 'russisk',
        'en': 'Russian',
    },
    'sk': {
        '_native': 'slovenčina',
        'zh_CN': '斯洛伐克语',
        'is': 'slóvakíska',
        'et': 'slovaki',
        'sr': 'словачки',
        'nl': 'Slowaaks',
        'sl': 'slovaščina',
        'fa': 'اسلواکی',
        'zh_TW': '斯洛伐克文',
        'bg': 'словашки',
        'gl': 'eslovaco',
        'lt': 'slovakų',
        'eu': 'eslovakiera',
        'he': 'סלובקית',
        'pl': 'słowacki',
        'sk': 'slovenčina',
        'cs': 'slovenština',
        'ka': 'სლოვაკური',
        'de': 'Slowakisch',
        'hu': 'szlovák',
        'ca': 'eslovac',
        'ar': 'السلوفاكية',
        'ro': 'slovacă',
        'fo': 'slovakiskt',
        'tr': 'Slovakça',
        'nb': 'slovakisk',
        'pt': 'eslovaco',
        'it': 'slovacco',
        'uk': 'словацька',
        'fi': 'slovakki',
        'ko': '슬로바키아어',
        'hr': 'slovački',
        'vi': 'Tiếng Slovak',
        'pt_BR': 'eslovaco',
        'el': 'Σλοβακικά',
        'ru': 'словацкий',
        'eo': 'slovaka',
        'ja': 'スロバキア語',
        'sr_Latn': 'slovački',
        'sv': 'slovakiska',
        'da': 'slovakisk',
        'id': 'Slovak',
        'fr': 'slovaque',
        'es': 'eslovaco',
        'nn': 'slovakisk',
        'en': 'Slovak',
    },
    'sl': {
        '_native': 'slovenščina',
        'zh_CN': '斯洛文尼亚语',
        'is': 'slóvenska',
        'et': 'sloveeni',
        'sr': 'словеначки',
        'nl': 'Sloveens',
        'sl': 'slovenščina',
        'fa': 'اسلوونیایی',
        'zh_TW': '斯洛維尼亞文',
        'bg': 'словенски',
        'gl': 'esloveno',
        'lt': 'slovėnų',
        'eu': 'esloveniera',
        'he': 'סלובנית',
        'pl': 'słoweński',
        'sk': 'slovinčina',
        'cs': 'slovinština',
        'ka': 'სლოვენური',
        'de': 'Slowenisch',
        'hu': 'szlovén',
        'ca': 'eslovè',
        'ar': 'السلوفانية',
        'ro': 'slovenă',
        'fo': 'slovenskt',
        'tr': 'Slovence',
        'nb': 'slovensk',
        'pt': 'esloveno',
        'it': 'sloveno',
        'uk': 'словенська',
        'fi': 'sloveeni',
        'ko': '슬로베니아어',
        'hr': 'slovenski',
        'vi': 'Tiếng Slovenia',
        'pt_BR': 'esloveno',
        'el': 'Σλοβενικά',
        'ru': 'словенский',
        'eo': 'slovena',
        'ja': 'スロベニア語',
        'sr_Latn': 'slovenački',
        'sv': 'slovenska',
        'da': 'slovensk',
        'id': 'Slovenia',
        'fr': 'slovène',
        'es': 'esloveno',
        'nn': 'slovensk',
        'en': 'Slovenian',
    },
    'sr': {
        '_native': 'српски',
        'zh_CN': '塞尔维亚语',
        'is': 'serbneska',
        'et': 'serbia',
        'sr': 'српски',
        'nl': 'Servisch',
        'sl': 'srbščina',
        'fa': 'صربی',
        'zh_TW': '塞爾維亞文',
        'bg': 'сръбски',
        'gl': 'serbio',
        'lt': 'serbų',
        'eu': 'serbiera',
        'he': 'סרבית',
        'pl': 'serbski',
        'sk': 'srbčina',
        'cs': 'srbština',
        'ka': 'სერბული',
        'de': 'Serbisch',
        'hu': 'szerb',
        'ca': 'serbi',
        'ar': 'الصربية',
        'ro': 'sârbă',
        'fo': 'serbiskt',
        'tr': 'Sırpça',
        'nb': 'serbisk',
        'pt': 'sérvio',
        'it': 'serbo',
        'uk': 'сербська',
        'fi': 'serbia',
        'ko': '세르비아어',
        'hr': 'srpski',
        'vi': 'Tiếng Serbia',
        'pt_BR': 'sérvio',
        'el': 'Σερβικά',
        'ru': 'сербский',
        'eo': 'serba',
        'ja': 'セルビア語',
        'sr_Latn': 'srpski',
        'sv': 'serbiska',
        'da': 'serbisk',
        'id': 'Serbia',
        'fr': 'serbe',
        'es': 'serbio',
        'nn': 'serbisk',
        'en': 'Serbian',
    },
    'sr_Latn': {
        '_native': 'srpski (latinica)',
        'zh_CN': '塞尔维亚语 (拉丁文)',
        'is': 'serbneska (latneskt)',
        'et': 'serbia (ladina)',
        'sr': 'српски (латиница)',
        'nl': 'Servisch (Latijns)',
        'sl': 'srbščina (latinica)',
        'fa': 'صربی (لاتین)',
        'zh_TW': '塞爾維亞文 (拉丁字母)',
        'bg': 'сръбски (латиница)',
        'gl': 'serbio (latino)',
        'lt': 'serbų (lotynų)',
        'eu': 'serbiera (latinoa)',
        'he': 'סרבית (לטיני)',
        'pl': 'serbski (łacińskie)',
        'sk': 'srbčina (latinka)',
        'cs': 'srbština (latinka)',
        'ka': 'სერბული (ლათინური)',
        'de': 'Serbisch (Lateinisch)',
        'hu': 'szerb (Latin)',
        'ca': 'serbi (llatí)',
        'ar': 'الصربية (اللاتينية)',
        'ro': 'sârbă (latină)',
        'fo': 'serbiskt (latínskt)',
        'tr': 'Sırpça (Latin)',
        'nb': 'serbisk (latinsk)',
        'pt': 'sérvio (latim)',
        'it': 'serbo (latino)',
        'uk': 'сербська (латиниця)',
        'fi': 'serbia (latinalainen)',
        'ko': '세르비아어 (로마자)',
        'hr': 'srpski (latinica)',
        'vi': 'Tiếng Serbia (Chữ La tinh)',
        'pt_BR': 'sérvio (latim)',
        'el': 'Σερβικά (Λατινικό)',
        'ru': 'сербский (латиница)',
        'eo': 'serba (latina)',
        'ja': 'セルビア語 (ラテン文字)',
        'sr_Latn': 'srpski (latinica)',
        'sv': 'serbiska (latinska)',
        'da': 'serbisk (latinsk)',
        'id': 'Serbia (Latin)',
        'fr': 'serbe (latin)',
        'es': 'serbio (latino)',
        'nn': 'serbisk (latinsk)',
        'en': 'Serbian (Latin)',
    },
    'sv': {
        '_native': 'svenska',
        'zh_CN': '瑞典语',
        'is': 'sænska',
        'et': 'rootsi',
        'sr': 'шведски',
        'nl': 'Zweeds',
        'sl': 'švedščina',
        'fa': 'سوئدی',
        'zh_TW': '瑞典文',
        'bg': 'шведски',
        'gl': 'sueco',
        'lt': 'švedų',
        'eu': 'suediera',
        'he': 'שוודית',
        'pl': 'szwedzki',
        'sk': 'švédčina',
        'cs': 'švédština',
        'ka': 'შვედური',
        'de': 'Schwedisch',
        'hu': 'svéd',
        'ca': 'suec',
        'ar': 'السويدية',
        'ro': 'suedeză',
        'fo': 'svenskt',
        'tr': 'İsveççe',
        'nb': 'svensk',
        'pt': 'sueco',
        'it': 'svedese',
        'uk': 'шведська',
        'fi': 'ruotsi',
        'ko': '스웨덴어',
        'hr': 'švedski',
        'vi': 'Tiếng Thụy Điển',
        'pt_BR': 'sueco',
        'el': 'Σουηδικά',
        'ru': 'шведский',
        'eo': 'sveda',
        'ja': 'スウェーデン語',
        'sr_Latn': 'švedski',
        'sv': 'svenska',
        'da': 'svensk',
        'id': 'Swedia',
        'fr': 'suédois',
        'es': 'sueco',
        'nn': 'svensk',
        'en': 'Swedish',
    },
    'tr': {
        '_native': 'Türkçe',
        'zh_CN': '土耳其语',
        'is': 'tyrkneska',
        'et': 'türgi',
        'sr': 'турски',
        'nl': 'Turks',
        'sl': 'turščina',
        'fa': 'ترکی استانبولی',
        'zh_TW': '土耳其文',
        'bg': 'турски',
        'gl': 'turco',
        'lt': 'turkų',
        'eu': 'turkiera',
        'he': 'טורקית',
        'pl': 'turecki',
        'sk': 'turečtina',
        'cs': 'turečtina',
        'ka': 'თურქული',
        'de': 'Türkisch',
        'hu': 'török',
        'ca': 'turc',
        'ar': 'التركية',
        'ro': 'turcă',
        'fo': 'turkiskt',
        'tr': 'Türkçe',
        'nb': 'tyrkisk',
        'pt': 'turco',
        'it': 'turco',
        'uk': 'турецька',
        'fi': 'turkki',
        'ko': '튀르키예어',
        'hr': 'turski',
        'vi': 'Tiếng Thổ Nhĩ Kỳ',
        'pt_BR': 'turco',
        'el': 'Τουρκικά',
        'ru': 'турецкий',
        'eo': 'turka',
        'ja': 'トルコ語',
        'sr_Latn': 'turski',
        'sv': 'turkiska',
        'da': 'tyrkisk',
        'id': 'Turki',
        'fr': 'turc',
        'es': 'turco',
        'nn': 'tyrkisk',
        'en': 'Turkish',
    },
    'uk': {
        '_native': 'українська',
        'zh_CN': '乌克兰语',
        'is': 'úkraínska',
        'et': 'ukraina',
        'sr': 'украјински',
        'nl': 'Oekraïens',
        'sl': 'ukrajinščina',
        'fa': 'اوکراینی',
        'zh_TW': '烏克蘭文',
        'bg': 'украински',
        'gl': 'ucraíno',
        'lt': 'ukrainiečių',
        'eu': 'ukrainera',
        'he': 'אוקראינית',
        'pl': 'ukraiński',
        'sk': 'ukrajinčina',
        'cs': 'ukrajinština',
        'ka': 'უკრაინული',
        'de': 'Ukrainisch',
        'hu': 'ukrán',
        'ca': 'ucraïnès',
        'ar': 'الأوكرانية',
        'ro': 'ucraineană',
        'fo': 'ukrainskt',
        'tr': 'Ukraynaca',
        'nb': 'ukrainsk',
        'pt': 'ucraniano',
        'it': 'ucraino',
        'uk': 'українська',
        'fi': 'ukraina',
        'ko': '우크라이나어',
        'hr': 'ukrajinski',
        'vi': 'Tiếng Ukraina',
        'pt_BR': 'ucraniano',
        'el': 'Ουκρανικά',
        'ru': 'украинский',
        'eo': 'ukraina',
        'ja': 'ウクライナ語',
        'sr_Latn': 'ukrajinski',
        'sv': 'ukrainska',
        'da': 'ukrainsk',
        'id': 'Ukraina',
        'fr': 'ukrainien',
        'es': 'ucraniano',
        'nn': 'ukrainsk',
        'en': 'Ukrainian',
    },
    'vi': {
        '_native': 'Tiếng Việt',
        'zh_CN': '越南语',
        'is': 'víetnamska',
        'et': 'vietnami',
        'sr': 'вијетнамски',
        'nl': 'Vietnamees',
        'sl': 'vietnamščina',
        'fa': 'ویتنامی',
        'zh_TW': '越南文',
        'bg': 'виетнамски',
        'gl': 'vietnamita',
        'lt': 'vietnamiečių',
        'eu': 'vietnamera',
        'he': 'וייטנאמית',
        'pl': 'wietnamski',
        'sk': 'vietnamčina',
        'cs': 'vietnamština',
        'ka': 'ვიეტნამური',
        'de': 'Vietnamesisch',
        'hu': 'vietnámi',
        'ca': 'vietnamita',
        'ar': 'الفيتنامية',
        'ro': 'vietnameză',
        'fo': 'vjetnamesiskt',
        'tr': 'Vietnamca',
        'nb': 'vietnamesisk',
        'pt': 'vietnamita',
        'it': 'vietnamita',
        'uk': 'вʼєтнамська',
        'fi': 'vietnam',
        'ko': '베트남어',
        'hr': 'vijetnamski',
        'vi': 'Tiếng Việt',
        'pt_BR': 'vietnamita',
        'el': 'Βιετναμικά',
        'ru': 'вьетнамский',
        'eo': 'vjetnama',
        'ja': 'ベトナム語',
        'sr_Latn': 'vijetnamski',
        'sv': 'vietnamesiska',
        'da': 'vietnamesisk',
        'id': 'Vietnam',
        'fr': 'vietnamien',
        'es': 'vietnamita',
        'nn': 'vietnamesisk',
        'en': 'Vietnamese',
    },
    'zh_CN': {
        '_native': '中文 (简体, 中国)',
        'zh_CN': '中文 (简体, 中国)',
        'is': 'kínverska (einfaldað, Kína)',
        'et': 'hiina (lihtsustatud, Hiina)',
        'sr': 'кинески (поједностављено кинеско писмо, Кина)',
        'nl': 'Chinees (vereenvoudigd, China)',
        'sl': 'kitajščina (poenostavljena pisava, Kitajska)',
        'fa': 'چینی (ساده‌شده, چین)',
        'zh_TW': '中文 (簡體, 中國)',
        'bg': 'китайски (опростена, Китай)',
        'gl': 'chinés (simplificado, China)',
        'lt': 'kinų (supaprastinti, Kinija)',
        'eu': 'txinera (sinplifikatua, Txina)',
        'he': 'סינית (פשוט, סין)',
        'pl': 'chiński (uproszczone, Chiny)',
        'sk': 'čínština (zjednodušené, Čína)',
        'cs': 'čínština (zjednodušené, Čína)',
        'ka': 'ჩინური (გამარტივებული, ჩინეთი)',
        'de': 'Chinesisch (Vereinfacht, China)',
        'hu': 'kínai (Egyszerűsített, Kína)',
        'ca': 'xinès (simplificat, Xina)',
        'ar': 'الصينية (المبسطة, الصين)',
        'ro': 'chineză (simplificată, China)',
        'fo': 'kinesiskt (einkult, Kina)',
        'tr': 'Çince (Basitleştirilmiş, Çin)',
        'nb': 'kinesisk (forenklet, Kina)',
        'pt': 'chinês (simplificado, China)',
        'it': 'cinese (semplificato, Cina)',
        'uk': 'китайська (спрощена, Китай)',
        'fi': 'kiina (yksinkertaistettu, Kiina)',
        'ko': '중국어 (간체, 중국)',
        'hr': 'kineski (pojednostavljeno pismo, Kina)',
        'vi': 'Tiếng Trung (Giản thể, Trung Quốc)',
        'pt_BR': 'chinês (simplificado, China)',
        'el': 'Κινεζικά (Απλοποιημένο, Κίνα)',
        'ru': 'китайский (упрощенная, Китай)',
        'eo': 'ĉina (simpligita, Ĉinujo)',
        'ja': '中国語 (簡体字, 中国)',
        'sr_Latn': 'kineski (pojednostavljeno kinesko pismo, Kina)',
        'sv': 'kinesiska (förenklad, Kina)',
        'da': 'kinesisk (forenklet, Kina)',
        'id': 'Tionghoa (Sederhana, Tiongkok)',
        'fr': 'chinois (simplifié, Chine)',
        'es': 'chino (simplificado, China)',
        'nn': 'kinesisk (forenkla, Kina)',
        'en': 'Chinese (Simplified, China)',
    },
    'zh_TW': {
        '_native': '中文 (繁體, 台灣)',
        'zh_CN': '中文 (繁体, 台湾)',
        'is': 'kínverska (hefðbundið, Taívan)',
        'et': 'hiina (traditsiooniline, Taiwan)',
        'sr': 'кинески (традиционално кинеско писмо, Тајван)',
        'nl': 'Chinees (traditioneel, Taiwan)',
        'sl': 'kitajščina (tradicionalna pisava, Tajvan)',
        'fa': 'چینی (سنتی, تایوان)',
        'zh_TW': '中文 (繁體, 台灣)',
        'bg': 'китайски (традиционна, Тайван)',
        'gl': 'chinés (tradicional, Taiwán)',
        'lt': 'kinų (tradiciniai, Taivanas)',
        'eu': 'txinera (tradizionala, Taiwan)',
        'he': 'סינית (מסורתי, טייוואן)',
        'pl': 'chiński (tradycyjne, Tajwan)',
        'sk': 'čínština (tradičné, Taiwan)',
        'cs': 'čínština (tradiční, Tchaj-wan)',
        'ka': 'ჩინური (ტრადიციული, ტაივანი)',
        'de': 'Chinesisch (Traditionell, Taiwan)',
        'hu': 'kínai (Hagyományos, Tajvan)',
        'ca': 'xinès (tradicional, Taiwan)',
        'ar': 'الصينية (التقليدية, تايوان)',
        'ro': 'chineză (tradițională, Taiwan)',
        'fo': 'kinesiskt (vanligt, Taivan)',
        'tr': 'Çince (Geleneksel, Tayvan)',
        'nb': 'kinesisk (tradisjonell, Taiwan)',
        'pt': 'chinês (tradicional, Taiwan)',
        'it': 'cinese (tradizionale, Taiwan)',
        'uk': 'китайська (традиційна, Тайвань)',
        'fi': 'kiina (perinteinen, Taiwan)',
        'ko': '중국어 (번체, 대만)',
        'hr': 'kineski (tradicionalno pismo, Tajvan)',
        'vi': 'Tiếng Trung (Phồn thể, Đài Loan)',
        'pt_BR': 'chinês (tradicional, Taiwan)',
        'el': 'Κινεζικά (Παραδοσιακό, Ταϊβάν)',
        'ru': 'китайский (традиционная, Тайвань)',
        'eo': 'ĉina (tradicia, Tajvano)',
        'ja': '中国語 (繁体字, 台湾)',
        'sr_Latn': 'kineski (tradicionalno kinesko pismo, Tajvan)',
        'sv': 'kinesiska (traditionell, Taiwan)',
        'da': 'kinesisk (traditionelt, Taiwan)',
        'id': 'Tionghoa (Tradisional, Taiwan)',
        'fr': 'chinois (traditionnel, Taïwan)',
        'es': 'chino (tradicional, Taiwán)',
        'nn': 'kinesisk (tradisjonell, Taiwan)',
        'en': 'Chinese (Traditional, Taiwan)',
    },
}


completeness = {
    'eo': 100,
    'cs': 100,
    'de': 100,
    'hr': 24,
    'he': 82,
    'it': 100,
    'pt': 100,
    'zh_CN': 100,
    'ja': 100,
    'ru': 100,
    'hu': 100,
    'da': 100,
    'sr_Latn': 55,
    'vi': 35,
    'ca': 82,
    'et': 100,
    'lt': 61,
    'gl': 100,
    'eu': 86,
    'ko': 55,
    'zh_TW': 82,
    'is': 44,
    'id': 97,
    'nb': 62,
    'fo': 18,
    'fi': 88,
    'tr': 100,
    'el': 90,
    'sv': 100,
    'ar': 45,
    'bg': 54,
    'sl': 66,
    'fr': 100,
    'es': 100,
    'nn': 46,
    'sr': 57,
    'nl': 99,
    'fa': 72,
    'uk': 100,
    'sk': 55,
    'ro': 100,
    'ka': 23,
    'pt_BR': 62,
    'pl': 100,
    'en': 100,
}
