/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.compiler.util.CharArray;
import org.eclipse.jdt.internal.compiler.util.CharArrayMapper;

public final class CharArrayHashMap<V>
implements CharArrayMapper<V>,
Serializable {
    private static final long serialVersionUID = -4247853285180184851L;
    private final HashMap<CharArray, V> map;

    public CharArrayHashMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    @Override
    public Collection<V> values() {
        return new ArrayList<V>(this.map.values());
    }

    @Override
    public Collection<char[]> keys() {
        return this.map.keySet().stream().map(CharArray::getKey).collect(Collectors.toList());
    }

    @Override
    public boolean containsKey(char[] key) {
        return this.map.containsKey(new CharArray(key));
    }

    @Override
    public V get(char[] key) {
        return this.map.get(new CharArray(key));
    }

    @Override
    public V put(char[] key, V value) {
        return this.map.put(new CharArray(key), value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }
}

