'' FreeBASIC binding for openal-soft-1.16.0
''
'' based on the C header files:
''
''   OpenAL cross platform audio library
''   Copyright (C) 2008 by authors.
''   This library is free software; you can redistribute it and/or
''    modify it under the terms of the GNU Library General Public
''    License as published by the Free Software Foundation; either
''    version 2 of the License, or (at your option) any later version.
''
''   This library is distributed in the hope that it will be useful,
''    but WITHOUT ANY WARRANTY; without even the implied warranty of
''    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
''    Library General Public License for more details.
''
''   You should have received a copy of the GNU Library General Public
''    License along with this library; if not, write to the
''    Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
''    Boston, MA  02111-1301, USA.
''   Or go to http://www.gnu.org/copyleft/lgpl.html
''
'' translated to FreeBASIC by:
''   FreeBASIC development team

#pragma once

#include once "alc.bi"
#include once "al.bi"

extern "C"

#define AL_EFX_H
#define ALC_EXT_EFX_NAME "ALC_EXT_EFX"
const ALC_EFX_MAJOR_VERSION = &h20001
const ALC_EFX_MINOR_VERSION = &h20002
const ALC_MAX_AUXILIARY_SENDS = &h20003
const AL_METERS_PER_UNIT = &h20004
const AL_DIRECT_FILTER = &h20005
const AL_AUXILIARY_SEND_FILTER = &h20006
const AL_AIR_ABSORPTION_FACTOR = &h20007
const AL_ROOM_ROLLOFF_FACTOR = &h20008
const AL_CONE_OUTER_GAINHF = &h20009
const AL_DIRECT_FILTER_GAINHF_AUTO = &h2000A
const AL_AUXILIARY_SEND_FILTER_GAIN_AUTO = &h2000B
const AL_AUXILIARY_SEND_FILTER_GAINHF_AUTO = &h2000C
const AL_REVERB_DENSITY = &h0001
const AL_REVERB_DIFFUSION = &h0002
const AL_REVERB_GAIN = &h0003
const AL_REVERB_GAINHF = &h0004
const AL_REVERB_DECAY_TIME = &h0005
const AL_REVERB_DECAY_HFRATIO = &h0006
const AL_REVERB_REFLECTIONS_GAIN = &h0007
const AL_REVERB_REFLECTIONS_DELAY = &h0008
const AL_REVERB_LATE_REVERB_GAIN = &h0009
const AL_REVERB_LATE_REVERB_DELAY = &h000A
const AL_REVERB_AIR_ABSORPTION_GAINHF = &h000B
const AL_REVERB_ROOM_ROLLOFF_FACTOR = &h000C
const AL_REVERB_DECAY_HFLIMIT = &h000D
const AL_EAXREVERB_DENSITY = &h0001
const AL_EAXREVERB_DIFFUSION = &h0002
const AL_EAXREVERB_GAIN = &h0003
const AL_EAXREVERB_GAINHF = &h0004
const AL_EAXREVERB_GAINLF = &h0005
const AL_EAXREVERB_DECAY_TIME = &h0006
const AL_EAXREVERB_DECAY_HFRATIO = &h0007
const AL_EAXREVERB_DECAY_LFRATIO = &h0008
const AL_EAXREVERB_REFLECTIONS_GAIN = &h0009
const AL_EAXREVERB_REFLECTIONS_DELAY = &h000A
const AL_EAXREVERB_REFLECTIONS_PAN = &h000B
const AL_EAXREVERB_LATE_REVERB_GAIN = &h000C
const AL_EAXREVERB_LATE_REVERB_DELAY = &h000D
const AL_EAXREVERB_LATE_REVERB_PAN = &h000E
const AL_EAXREVERB_ECHO_TIME = &h000F
const AL_EAXREVERB_ECHO_DEPTH = &h0010
const AL_EAXREVERB_MODULATION_TIME = &h0011
const AL_EAXREVERB_MODULATION_DEPTH = &h0012
const AL_EAXREVERB_AIR_ABSORPTION_GAINHF = &h0013
const AL_EAXREVERB_HFREFERENCE = &h0014
const AL_EAXREVERB_LFREFERENCE = &h0015
const AL_EAXREVERB_ROOM_ROLLOFF_FACTOR = &h0016
const AL_EAXREVERB_DECAY_HFLIMIT = &h0017
const AL_CHORUS_WAVEFORM = &h0001
const AL_CHORUS_PHASE = &h0002
const AL_CHORUS_RATE = &h0003
const AL_CHORUS_DEPTH = &h0004
const AL_CHORUS_FEEDBACK = &h0005
const AL_CHORUS_DELAY = &h0006
const AL_DISTORTION_EDGE = &h0001
const AL_DISTORTION_GAIN = &h0002
const AL_DISTORTION_LOWPASS_CUTOFF = &h0003
const AL_DISTORTION_EQCENTER = &h0004
const AL_DISTORTION_EQBANDWIDTH = &h0005
const AL_ECHO_DELAY = &h0001
const AL_ECHO_LRDELAY = &h0002
const AL_ECHO_DAMPING = &h0003
const AL_ECHO_FEEDBACK = &h0004
const AL_ECHO_SPREAD = &h0005
const AL_FLANGER_WAVEFORM = &h0001
const AL_FLANGER_PHASE = &h0002
const AL_FLANGER_RATE = &h0003
const AL_FLANGER_DEPTH = &h0004
const AL_FLANGER_FEEDBACK = &h0005
const AL_FLANGER_DELAY = &h0006
const AL_FREQUENCY_SHIFTER_FREQUENCY = &h0001
const AL_FREQUENCY_SHIFTER_LEFT_DIRECTION = &h0002
const AL_FREQUENCY_SHIFTER_RIGHT_DIRECTION = &h0003
const AL_VOCAL_MORPHER_PHONEMEA = &h0001
const AL_VOCAL_MORPHER_PHONEMEA_COARSE_TUNING = &h0002
const AL_VOCAL_MORPHER_PHONEMEB = &h0003
const AL_VOCAL_MORPHER_PHONEMEB_COARSE_TUNING = &h0004
const AL_VOCAL_MORPHER_WAVEFORM = &h0005
const AL_VOCAL_MORPHER_RATE = &h0006
const AL_PITCH_SHIFTER_COARSE_TUNE = &h0001
const AL_PITCH_SHIFTER_FINE_TUNE = &h0002
const AL_RING_MODULATOR_FREQUENCY = &h0001
const AL_RING_MODULATOR_HIGHPASS_CUTOFF = &h0002
const AL_RING_MODULATOR_WAVEFORM = &h0003
const AL_AUTOWAH_ATTACK_TIME = &h0001
const AL_AUTOWAH_RELEASE_TIME = &h0002
const AL_AUTOWAH_RESONANCE = &h0003
const AL_AUTOWAH_PEAK_GAIN = &h0004
const AL_COMPRESSOR_ONOFF = &h0001
const AL_EQUALIZER_LOW_GAIN = &h0001
const AL_EQUALIZER_LOW_CUTOFF = &h0002
const AL_EQUALIZER_MID1_GAIN = &h0003
const AL_EQUALIZER_MID1_CENTER = &h0004
const AL_EQUALIZER_MID1_WIDTH = &h0005
const AL_EQUALIZER_MID2_GAIN = &h0006
const AL_EQUALIZER_MID2_CENTER = &h0007
const AL_EQUALIZER_MID2_WIDTH = &h0008
const AL_EQUALIZER_HIGH_GAIN = &h0009
const AL_EQUALIZER_HIGH_CUTOFF = &h000A
const AL_EFFECT_FIRST_PARAMETER = &h0000
const AL_EFFECT_LAST_PARAMETER = &h8000
const AL_EFFECT_TYPE = &h8001
const AL_EFFECT_NULL = &h0000
const AL_EFFECT_REVERB = &h0001
const AL_EFFECT_CHORUS = &h0002
const AL_EFFECT_DISTORTION = &h0003
const AL_EFFECT_ECHO = &h0004
const AL_EFFECT_FLANGER = &h0005
const AL_EFFECT_FREQUENCY_SHIFTER = &h0006
const AL_EFFECT_VOCAL_MORPHER = &h0007
const AL_EFFECT_PITCH_SHIFTER = &h0008
const AL_EFFECT_RING_MODULATOR = &h0009
const AL_EFFECT_AUTOWAH = &h000A
const AL_EFFECT_COMPRESSOR = &h000B
const AL_EFFECT_EQUALIZER = &h000C
const AL_EFFECT_EAXREVERB = &h8000
const AL_EFFECTSLOT_EFFECT = &h0001
const AL_EFFECTSLOT_GAIN = &h0002
const AL_EFFECTSLOT_AUXILIARY_SEND_AUTO = &h0003
const AL_EFFECTSLOT_NULL = &h0000
const AL_LOWPASS_GAIN = &h0001
const AL_LOWPASS_GAINHF = &h0002
const AL_HIGHPASS_GAIN = &h0001
const AL_HIGHPASS_GAINLF = &h0002
const AL_BANDPASS_GAIN = &h0001
const AL_BANDPASS_GAINLF = &h0002
const AL_BANDPASS_GAINHF = &h0003
const AL_FILTER_FIRST_PARAMETER = &h0000
const AL_FILTER_LAST_PARAMETER = &h8000
const AL_FILTER_TYPE = &h8001
const AL_FILTER_NULL = &h0000
const AL_FILTER_LOWPASS = &h0001
const AL_FILTER_HIGHPASS = &h0002
const AL_FILTER_BANDPASS = &h0003

type LPALGENEFFECTS as sub(byval as ALsizei, byval as ALuint ptr)
type LPALDELETEEFFECTS as sub(byval as ALsizei, byval as const ALuint ptr)
type LPALISEFFECT as function(byval as ALuint) as ALboolean
type LPALEFFECTI as sub(byval as ALuint, byval as ALenum, byval as ALint)
type LPALEFFECTIV as sub(byval as ALuint, byval as ALenum, byval as const ALint ptr)
type LPALEFFECTF as sub(byval as ALuint, byval as ALenum, byval as ALfloat)
type LPALEFFECTFV as sub(byval as ALuint, byval as ALenum, byval as const ALfloat ptr)
type LPALGETEFFECTI as sub(byval as ALuint, byval as ALenum, byval as ALint ptr)
type LPALGETEFFECTIV as sub(byval as ALuint, byval as ALenum, byval as ALint ptr)
type LPALGETEFFECTF as sub(byval as ALuint, byval as ALenum, byval as ALfloat ptr)
type LPALGETEFFECTFV as sub(byval as ALuint, byval as ALenum, byval as ALfloat ptr)
type LPALGENFILTERS as sub(byval as ALsizei, byval as ALuint ptr)
type LPALDELETEFILTERS as sub(byval as ALsizei, byval as const ALuint ptr)
type LPALISFILTER as function(byval as ALuint) as ALboolean
type LPALFILTERI as sub(byval as ALuint, byval as ALenum, byval as ALint)
type LPALFILTERIV as sub(byval as ALuint, byval as ALenum, byval as const ALint ptr)
type LPALFILTERF as sub(byval as ALuint, byval as ALenum, byval as ALfloat)
type LPALFILTERFV as sub(byval as ALuint, byval as ALenum, byval as const ALfloat ptr)
type LPALGETFILTERI as sub(byval as ALuint, byval as ALenum, byval as ALint ptr)
type LPALGETFILTERIV as sub(byval as ALuint, byval as ALenum, byval as ALint ptr)
type LPALGETFILTERF as sub(byval as ALuint, byval as ALenum, byval as ALfloat ptr)
type LPALGETFILTERFV as sub(byval as ALuint, byval as ALenum, byval as ALfloat ptr)
type LPALGENAUXILIARYEFFECTSLOTS as sub(byval as ALsizei, byval as ALuint ptr)
type LPALDELETEAUXILIARYEFFECTSLOTS as sub(byval as ALsizei, byval as const ALuint ptr)
type LPALISAUXILIARYEFFECTSLOT as function(byval as ALuint) as ALboolean
type LPALAUXILIARYEFFECTSLOTI as sub(byval as ALuint, byval as ALenum, byval as ALint)
type LPALAUXILIARYEFFECTSLOTIV as sub(byval as ALuint, byval as ALenum, byval as const ALint ptr)
type LPALAUXILIARYEFFECTSLOTF as sub(byval as ALuint, byval as ALenum, byval as ALfloat)
type LPALAUXILIARYEFFECTSLOTFV as sub(byval as ALuint, byval as ALenum, byval as const ALfloat ptr)
type LPALGETAUXILIARYEFFECTSLOTI as sub(byval as ALuint, byval as ALenum, byval as ALint ptr)
type LPALGETAUXILIARYEFFECTSLOTIV as sub(byval as ALuint, byval as ALenum, byval as ALint ptr)
type LPALGETAUXILIARYEFFECTSLOTF as sub(byval as ALuint, byval as ALenum, byval as ALfloat ptr)
type LPALGETAUXILIARYEFFECTSLOTFV as sub(byval as ALuint, byval as ALenum, byval as ALfloat ptr)

const AL_LOWPASS_MIN_GAIN = 0.0f
const AL_LOWPASS_MAX_GAIN = 1.0f
const AL_LOWPASS_DEFAULT_GAIN = 1.0f
const AL_LOWPASS_MIN_GAINHF = 0.0f
const AL_LOWPASS_MAX_GAINHF = 1.0f
const AL_LOWPASS_DEFAULT_GAINHF = 1.0f
const AL_HIGHPASS_MIN_GAIN = 0.0f
const AL_HIGHPASS_MAX_GAIN = 1.0f
const AL_HIGHPASS_DEFAULT_GAIN = 1.0f
const AL_HIGHPASS_MIN_GAINLF = 0.0f
const AL_HIGHPASS_MAX_GAINLF = 1.0f
const AL_HIGHPASS_DEFAULT_GAINLF = 1.0f
const AL_BANDPASS_MIN_GAIN = 0.0f
const AL_BANDPASS_MAX_GAIN = 1.0f
const AL_BANDPASS_DEFAULT_GAIN = 1.0f
const AL_BANDPASS_MIN_GAINHF = 0.0f
const AL_BANDPASS_MAX_GAINHF = 1.0f
const AL_BANDPASS_DEFAULT_GAINHF = 1.0f
const AL_BANDPASS_MIN_GAINLF = 0.0f
const AL_BANDPASS_MAX_GAINLF = 1.0f
const AL_BANDPASS_DEFAULT_GAINLF = 1.0f
const AL_REVERB_MIN_DENSITY = 0.0f
const AL_REVERB_MAX_DENSITY = 1.0f
const AL_REVERB_DEFAULT_DENSITY = 1.0f
const AL_REVERB_MIN_DIFFUSION = 0.0f
const AL_REVERB_MAX_DIFFUSION = 1.0f
const AL_REVERB_DEFAULT_DIFFUSION = 1.0f
const AL_REVERB_MIN_GAIN = 0.0f
const AL_REVERB_MAX_GAIN = 1.0f
const AL_REVERB_DEFAULT_GAIN = 0.32f
const AL_REVERB_MIN_GAINHF = 0.0f
const AL_REVERB_MAX_GAINHF = 1.0f
const AL_REVERB_DEFAULT_GAINHF = 0.89f
const AL_REVERB_MIN_DECAY_TIME = 0.1f
const AL_REVERB_MAX_DECAY_TIME = 20.0f
const AL_REVERB_DEFAULT_DECAY_TIME = 1.49f
const AL_REVERB_MIN_DECAY_HFRATIO = 0.1f
const AL_REVERB_MAX_DECAY_HFRATIO = 2.0f
const AL_REVERB_DEFAULT_DECAY_HFRATIO = 0.83f
const AL_REVERB_MIN_REFLECTIONS_GAIN = 0.0f
const AL_REVERB_MAX_REFLECTIONS_GAIN = 3.16f
const AL_REVERB_DEFAULT_REFLECTIONS_GAIN = 0.05f
const AL_REVERB_MIN_REFLECTIONS_DELAY = 0.0f
const AL_REVERB_MAX_REFLECTIONS_DELAY = 0.3f
const AL_REVERB_DEFAULT_REFLECTIONS_DELAY = 0.007f
const AL_REVERB_MIN_LATE_REVERB_GAIN = 0.0f
const AL_REVERB_MAX_LATE_REVERB_GAIN = 10.0f
const AL_REVERB_DEFAULT_LATE_REVERB_GAIN = 1.26f
const AL_REVERB_MIN_LATE_REVERB_DELAY = 0.0f
const AL_REVERB_MAX_LATE_REVERB_DELAY = 0.1f
const AL_REVERB_DEFAULT_LATE_REVERB_DELAY = 0.011f
const AL_REVERB_MIN_AIR_ABSORPTION_GAINHF = 0.892f
const AL_REVERB_MAX_AIR_ABSORPTION_GAINHF = 1.0f
const AL_REVERB_DEFAULT_AIR_ABSORPTION_GAINHF = 0.994f
const AL_REVERB_MIN_ROOM_ROLLOFF_FACTOR = 0.0f
const AL_REVERB_MAX_ROOM_ROLLOFF_FACTOR = 10.0f
const AL_REVERB_DEFAULT_ROOM_ROLLOFF_FACTOR = 0.0f
const AL_REVERB_MIN_DECAY_HFLIMIT = AL_FALSE
const AL_REVERB_MAX_DECAY_HFLIMIT = AL_TRUE
const AL_REVERB_DEFAULT_DECAY_HFLIMIT = AL_TRUE
const AL_EAXREVERB_MIN_DENSITY = 0.0f
const AL_EAXREVERB_MAX_DENSITY = 1.0f
const AL_EAXREVERB_DEFAULT_DENSITY = 1.0f
const AL_EAXREVERB_MIN_DIFFUSION = 0.0f
const AL_EAXREVERB_MAX_DIFFUSION = 1.0f
const AL_EAXREVERB_DEFAULT_DIFFUSION = 1.0f
const AL_EAXREVERB_MIN_GAIN = 0.0f
const AL_EAXREVERB_MAX_GAIN = 1.0f
const AL_EAXREVERB_DEFAULT_GAIN = 0.32f
const AL_EAXREVERB_MIN_GAINHF = 0.0f
const AL_EAXREVERB_MAX_GAINHF = 1.0f
const AL_EAXREVERB_DEFAULT_GAINHF = 0.89f
const AL_EAXREVERB_MIN_GAINLF = 0.0f
const AL_EAXREVERB_MAX_GAINLF = 1.0f
const AL_EAXREVERB_DEFAULT_GAINLF = 1.0f
const AL_EAXREVERB_MIN_DECAY_TIME = 0.1f
const AL_EAXREVERB_MAX_DECAY_TIME = 20.0f
const AL_EAXREVERB_DEFAULT_DECAY_TIME = 1.49f
const AL_EAXREVERB_MIN_DECAY_HFRATIO = 0.1f
const AL_EAXREVERB_MAX_DECAY_HFRATIO = 2.0f
const AL_EAXREVERB_DEFAULT_DECAY_HFRATIO = 0.83f
const AL_EAXREVERB_MIN_DECAY_LFRATIO = 0.1f
const AL_EAXREVERB_MAX_DECAY_LFRATIO = 2.0f
const AL_EAXREVERB_DEFAULT_DECAY_LFRATIO = 1.0f
const AL_EAXREVERB_MIN_REFLECTIONS_GAIN = 0.0f
const AL_EAXREVERB_MAX_REFLECTIONS_GAIN = 3.16f
const AL_EAXREVERB_DEFAULT_REFLECTIONS_GAIN = 0.05f
const AL_EAXREVERB_MIN_REFLECTIONS_DELAY = 0.0f
const AL_EAXREVERB_MAX_REFLECTIONS_DELAY = 0.3f
const AL_EAXREVERB_DEFAULT_REFLECTIONS_DELAY = 0.007f
const AL_EAXREVERB_DEFAULT_REFLECTIONS_PAN_XYZ = 0.0f
const AL_EAXREVERB_MIN_LATE_REVERB_GAIN = 0.0f
const AL_EAXREVERB_MAX_LATE_REVERB_GAIN = 10.0f
const AL_EAXREVERB_DEFAULT_LATE_REVERB_GAIN = 1.26f
const AL_EAXREVERB_MIN_LATE_REVERB_DELAY = 0.0f
const AL_EAXREVERB_MAX_LATE_REVERB_DELAY = 0.1f
const AL_EAXREVERB_DEFAULT_LATE_REVERB_DELAY = 0.011f
const AL_EAXREVERB_DEFAULT_LATE_REVERB_PAN_XYZ = 0.0f
const AL_EAXREVERB_MIN_ECHO_TIME = 0.075f
const AL_EAXREVERB_MAX_ECHO_TIME = 0.25f
const AL_EAXREVERB_DEFAULT_ECHO_TIME = 0.25f
const AL_EAXREVERB_MIN_ECHO_DEPTH = 0.0f
const AL_EAXREVERB_MAX_ECHO_DEPTH = 1.0f
const AL_EAXREVERB_DEFAULT_ECHO_DEPTH = 0.0f
const AL_EAXREVERB_MIN_MODULATION_TIME = 0.04f
const AL_EAXREVERB_MAX_MODULATION_TIME = 4.0f
const AL_EAXREVERB_DEFAULT_MODULATION_TIME = 0.25f
const AL_EAXREVERB_MIN_MODULATION_DEPTH = 0.0f
const AL_EAXREVERB_MAX_MODULATION_DEPTH = 1.0f
const AL_EAXREVERB_DEFAULT_MODULATION_DEPTH = 0.0f
const AL_EAXREVERB_MIN_AIR_ABSORPTION_GAINHF = 0.892f
const AL_EAXREVERB_MAX_AIR_ABSORPTION_GAINHF = 1.0f
const AL_EAXREVERB_DEFAULT_AIR_ABSORPTION_GAINHF = 0.994f
const AL_EAXREVERB_MIN_HFREFERENCE = 1000.0f
const AL_EAXREVERB_MAX_HFREFERENCE = 20000.0f
const AL_EAXREVERB_DEFAULT_HFREFERENCE = 5000.0f
const AL_EAXREVERB_MIN_LFREFERENCE = 20.0f
const AL_EAXREVERB_MAX_LFREFERENCE = 1000.0f
const AL_EAXREVERB_DEFAULT_LFREFERENCE = 250.0f
const AL_EAXREVERB_MIN_ROOM_ROLLOFF_FACTOR = 0.0f
const AL_EAXREVERB_MAX_ROOM_ROLLOFF_FACTOR = 10.0f
const AL_EAXREVERB_DEFAULT_ROOM_ROLLOFF_FACTOR = 0.0f
const AL_EAXREVERB_MIN_DECAY_HFLIMIT = AL_FALSE
const AL_EAXREVERB_MAX_DECAY_HFLIMIT = AL_TRUE
const AL_EAXREVERB_DEFAULT_DECAY_HFLIMIT = AL_TRUE
const AL_CHORUS_WAVEFORM_SINUSOID = 0
const AL_CHORUS_WAVEFORM_TRIANGLE = 1
const AL_CHORUS_MIN_WAVEFORM = 0
const AL_CHORUS_MAX_WAVEFORM = 1
const AL_CHORUS_DEFAULT_WAVEFORM = 1
const AL_CHORUS_MIN_PHASE = -180
const AL_CHORUS_MAX_PHASE = 180
const AL_CHORUS_DEFAULT_PHASE = 90
const AL_CHORUS_MIN_RATE = 0.0f
const AL_CHORUS_MAX_RATE = 10.0f
const AL_CHORUS_DEFAULT_RATE = 1.1f
const AL_CHORUS_MIN_DEPTH = 0.0f
const AL_CHORUS_MAX_DEPTH = 1.0f
const AL_CHORUS_DEFAULT_DEPTH = 0.1f
const AL_CHORUS_MIN_FEEDBACK = -1.0f
const AL_CHORUS_MAX_FEEDBACK = 1.0f
const AL_CHORUS_DEFAULT_FEEDBACK = 0.25f
const AL_CHORUS_MIN_DELAY = 0.0f
const AL_CHORUS_MAX_DELAY = 0.016f
const AL_CHORUS_DEFAULT_DELAY = 0.016f
const AL_DISTORTION_MIN_EDGE = 0.0f
const AL_DISTORTION_MAX_EDGE = 1.0f
const AL_DISTORTION_DEFAULT_EDGE = 0.2f
const AL_DISTORTION_MIN_GAIN = 0.01f
const AL_DISTORTION_MAX_GAIN = 1.0f
const AL_DISTORTION_DEFAULT_GAIN = 0.05f
const AL_DISTORTION_MIN_LOWPASS_CUTOFF = 80.0f
const AL_DISTORTION_MAX_LOWPASS_CUTOFF = 24000.0f
const AL_DISTORTION_DEFAULT_LOWPASS_CUTOFF = 8000.0f
const AL_DISTORTION_MIN_EQCENTER = 80.0f
const AL_DISTORTION_MAX_EQCENTER = 24000.0f
const AL_DISTORTION_DEFAULT_EQCENTER = 3600.0f
const AL_DISTORTION_MIN_EQBANDWIDTH = 80.0f
const AL_DISTORTION_MAX_EQBANDWIDTH = 24000.0f
const AL_DISTORTION_DEFAULT_EQBANDWIDTH = 3600.0f
const AL_ECHO_MIN_DELAY = 0.0f
const AL_ECHO_MAX_DELAY = 0.207f
const AL_ECHO_DEFAULT_DELAY = 0.1f
const AL_ECHO_MIN_LRDELAY = 0.0f
const AL_ECHO_MAX_LRDELAY = 0.404f
const AL_ECHO_DEFAULT_LRDELAY = 0.1f
const AL_ECHO_MIN_DAMPING = 0.0f
const AL_ECHO_MAX_DAMPING = 0.99f
const AL_ECHO_DEFAULT_DAMPING = 0.5f
const AL_ECHO_MIN_FEEDBACK = 0.0f
const AL_ECHO_MAX_FEEDBACK = 1.0f
const AL_ECHO_DEFAULT_FEEDBACK = 0.5f
const AL_ECHO_MIN_SPREAD = -1.0f
const AL_ECHO_MAX_SPREAD = 1.0f
const AL_ECHO_DEFAULT_SPREAD = -1.0f
const AL_FLANGER_WAVEFORM_SINUSOID = 0
const AL_FLANGER_WAVEFORM_TRIANGLE = 1
const AL_FLANGER_MIN_WAVEFORM = 0
const AL_FLANGER_MAX_WAVEFORM = 1
const AL_FLANGER_DEFAULT_WAVEFORM = 1
const AL_FLANGER_MIN_PHASE = -180
const AL_FLANGER_MAX_PHASE = 180
const AL_FLANGER_DEFAULT_PHASE = 0
const AL_FLANGER_MIN_RATE = 0.0f
const AL_FLANGER_MAX_RATE = 10.0f
const AL_FLANGER_DEFAULT_RATE = 0.27f
const AL_FLANGER_MIN_DEPTH = 0.0f
const AL_FLANGER_MAX_DEPTH = 1.0f
const AL_FLANGER_DEFAULT_DEPTH = 1.0f
const AL_FLANGER_MIN_FEEDBACK = -1.0f
const AL_FLANGER_MAX_FEEDBACK = 1.0f
const AL_FLANGER_DEFAULT_FEEDBACK = -0.5f
const AL_FLANGER_MIN_DELAY = 0.0f
const AL_FLANGER_MAX_DELAY = 0.004f
const AL_FLANGER_DEFAULT_DELAY = 0.002f
const AL_FREQUENCY_SHIFTER_MIN_FREQUENCY = 0.0f
const AL_FREQUENCY_SHIFTER_MAX_FREQUENCY = 24000.0f
const AL_FREQUENCY_SHIFTER_DEFAULT_FREQUENCY = 0.0f
const AL_FREQUENCY_SHIFTER_MIN_LEFT_DIRECTION = 0
const AL_FREQUENCY_SHIFTER_MAX_LEFT_DIRECTION = 2
const AL_FREQUENCY_SHIFTER_DEFAULT_LEFT_DIRECTION = 0
const AL_FREQUENCY_SHIFTER_DIRECTION_DOWN = 0
const AL_FREQUENCY_SHIFTER_DIRECTION_UP = 1
const AL_FREQUENCY_SHIFTER_DIRECTION_OFF = 2
const AL_FREQUENCY_SHIFTER_MIN_RIGHT_DIRECTION = 0
const AL_FREQUENCY_SHIFTER_MAX_RIGHT_DIRECTION = 2
const AL_FREQUENCY_SHIFTER_DEFAULT_RIGHT_DIRECTION = 0
const AL_VOCAL_MORPHER_MIN_PHONEMEA = 0
const AL_VOCAL_MORPHER_MAX_PHONEMEA = 29
const AL_VOCAL_MORPHER_DEFAULT_PHONEMEA = 0
const AL_VOCAL_MORPHER_MIN_PHONEMEA_COARSE_TUNING = -24
const AL_VOCAL_MORPHER_MAX_PHONEMEA_COARSE_TUNING = 24
const AL_VOCAL_MORPHER_DEFAULT_PHONEMEA_COARSE_TUNING = 0
const AL_VOCAL_MORPHER_MIN_PHONEMEB = 0
const AL_VOCAL_MORPHER_MAX_PHONEMEB = 29
const AL_VOCAL_MORPHER_DEFAULT_PHONEMEB = 10
const AL_VOCAL_MORPHER_MIN_PHONEMEB_COARSE_TUNING = -24
const AL_VOCAL_MORPHER_MAX_PHONEMEB_COARSE_TUNING = 24
const AL_VOCAL_MORPHER_DEFAULT_PHONEMEB_COARSE_TUNING = 0
const AL_VOCAL_MORPHER_PHONEME_A = 0
const AL_VOCAL_MORPHER_PHONEME_E = 1
const AL_VOCAL_MORPHER_PHONEME_I = 2
const AL_VOCAL_MORPHER_PHONEME_O = 3
const AL_VOCAL_MORPHER_PHONEME_U = 4
const AL_VOCAL_MORPHER_PHONEME_AA = 5
const AL_VOCAL_MORPHER_PHONEME_AE = 6
const AL_VOCAL_MORPHER_PHONEME_AH = 7
const AL_VOCAL_MORPHER_PHONEME_AO = 8
const AL_VOCAL_MORPHER_PHONEME_EH = 9
const AL_VOCAL_MORPHER_PHONEME_ER = 10
const AL_VOCAL_MORPHER_PHONEME_IH = 11
const AL_VOCAL_MORPHER_PHONEME_IY = 12
const AL_VOCAL_MORPHER_PHONEME_UH = 13
const AL_VOCAL_MORPHER_PHONEME_UW = 14
const AL_VOCAL_MORPHER_PHONEME_B = 15
const AL_VOCAL_MORPHER_PHONEME_D = 16
const AL_VOCAL_MORPHER_PHONEME_F = 17
const AL_VOCAL_MORPHER_PHONEME_G = 18
const AL_VOCAL_MORPHER_PHONEME_J = 19
const AL_VOCAL_MORPHER_PHONEME_K = 20
const AL_VOCAL_MORPHER_PHONEME_L = 21
const AL_VOCAL_MORPHER_PHONEME_M = 22
const AL_VOCAL_MORPHER_PHONEME_N = 23
const AL_VOCAL_MORPHER_PHONEME_P = 24
const AL_VOCAL_MORPHER_PHONEME_R = 25
const AL_VOCAL_MORPHER_PHONEME_S = 26
const AL_VOCAL_MORPHER_PHONEME_T = 27
const AL_VOCAL_MORPHER_PHONEME_V = 28
const AL_VOCAL_MORPHER_PHONEME_Z = 29
const AL_VOCAL_MORPHER_WAVEFORM_SINUSOID = 0
const AL_VOCAL_MORPHER_WAVEFORM_TRIANGLE = 1
const AL_VOCAL_MORPHER_WAVEFORM_SAWTOOTH = 2
const AL_VOCAL_MORPHER_MIN_WAVEFORM = 0
const AL_VOCAL_MORPHER_MAX_WAVEFORM = 2
const AL_VOCAL_MORPHER_DEFAULT_WAVEFORM = 0
const AL_VOCAL_MORPHER_MIN_RATE = 0.0f
const AL_VOCAL_MORPHER_MAX_RATE = 10.0f
const AL_VOCAL_MORPHER_DEFAULT_RATE = 1.41f
const AL_PITCH_SHIFTER_MIN_COARSE_TUNE = -12
const AL_PITCH_SHIFTER_MAX_COARSE_TUNE = 12
const AL_PITCH_SHIFTER_DEFAULT_COARSE_TUNE = 12
const AL_PITCH_SHIFTER_MIN_FINE_TUNE = -50
const AL_PITCH_SHIFTER_MAX_FINE_TUNE = 50
const AL_PITCH_SHIFTER_DEFAULT_FINE_TUNE = 0
const AL_RING_MODULATOR_MIN_FREQUENCY = 0.0f
const AL_RING_MODULATOR_MAX_FREQUENCY = 8000.0f
const AL_RING_MODULATOR_DEFAULT_FREQUENCY = 440.0f
const AL_RING_MODULATOR_MIN_HIGHPASS_CUTOFF = 0.0f
const AL_RING_MODULATOR_MAX_HIGHPASS_CUTOFF = 24000.0f
const AL_RING_MODULATOR_DEFAULT_HIGHPASS_CUTOFF = 800.0f
const AL_RING_MODULATOR_SINUSOID = 0
const AL_RING_MODULATOR_SAWTOOTH = 1
const AL_RING_MODULATOR_SQUARE = 2
const AL_RING_MODULATOR_MIN_WAVEFORM = 0
const AL_RING_MODULATOR_MAX_WAVEFORM = 2
const AL_RING_MODULATOR_DEFAULT_WAVEFORM = 0
const AL_AUTOWAH_MIN_ATTACK_TIME = 0.0001f
const AL_AUTOWAH_MAX_ATTACK_TIME = 1.0f
const AL_AUTOWAH_DEFAULT_ATTACK_TIME = 0.06f
const AL_AUTOWAH_MIN_RELEASE_TIME = 0.0001f
const AL_AUTOWAH_MAX_RELEASE_TIME = 1.0f
const AL_AUTOWAH_DEFAULT_RELEASE_TIME = 0.06f
const AL_AUTOWAH_MIN_RESONANCE = 2.0f
const AL_AUTOWAH_MAX_RESONANCE = 1000.0f
const AL_AUTOWAH_DEFAULT_RESONANCE = 1000.0f
const AL_AUTOWAH_MIN_PEAK_GAIN = 0.00003f
const AL_AUTOWAH_MAX_PEAK_GAIN = 31621.0f
const AL_AUTOWAH_DEFAULT_PEAK_GAIN = 11.22f
const AL_COMPRESSOR_MIN_ONOFF = 0
const AL_COMPRESSOR_MAX_ONOFF = 1
const AL_COMPRESSOR_DEFAULT_ONOFF = 1
const AL_EQUALIZER_MIN_LOW_GAIN = 0.126f
const AL_EQUALIZER_MAX_LOW_GAIN = 7.943f
const AL_EQUALIZER_DEFAULT_LOW_GAIN = 1.0f
const AL_EQUALIZER_MIN_LOW_CUTOFF = 50.0f
const AL_EQUALIZER_MAX_LOW_CUTOFF = 800.0f
const AL_EQUALIZER_DEFAULT_LOW_CUTOFF = 200.0f
const AL_EQUALIZER_MIN_MID1_GAIN = 0.126f
const AL_EQUALIZER_MAX_MID1_GAIN = 7.943f
const AL_EQUALIZER_DEFAULT_MID1_GAIN = 1.0f
const AL_EQUALIZER_MIN_MID1_CENTER = 200.0f
const AL_EQUALIZER_MAX_MID1_CENTER = 3000.0f
const AL_EQUALIZER_DEFAULT_MID1_CENTER = 500.0f
const AL_EQUALIZER_MIN_MID1_WIDTH = 0.01f
const AL_EQUALIZER_MAX_MID1_WIDTH = 1.0f
const AL_EQUALIZER_DEFAULT_MID1_WIDTH = 1.0f
const AL_EQUALIZER_MIN_MID2_GAIN = 0.126f
const AL_EQUALIZER_MAX_MID2_GAIN = 7.943f
const AL_EQUALIZER_DEFAULT_MID2_GAIN = 1.0f
const AL_EQUALIZER_MIN_MID2_CENTER = 1000.0f
const AL_EQUALIZER_MAX_MID2_CENTER = 8000.0f
const AL_EQUALIZER_DEFAULT_MID2_CENTER = 3000.0f
const AL_EQUALIZER_MIN_MID2_WIDTH = 0.01f
const AL_EQUALIZER_MAX_MID2_WIDTH = 1.0f
const AL_EQUALIZER_DEFAULT_MID2_WIDTH = 1.0f
const AL_EQUALIZER_MIN_HIGH_GAIN = 0.126f
const AL_EQUALIZER_MAX_HIGH_GAIN = 7.943f
const AL_EQUALIZER_DEFAULT_HIGH_GAIN = 1.0f
const AL_EQUALIZER_MIN_HIGH_CUTOFF = 4000.0f
const AL_EQUALIZER_MAX_HIGH_CUTOFF = 16000.0f
const AL_EQUALIZER_DEFAULT_HIGH_CUTOFF = 6000.0f
const AL_MIN_AIR_ABSORPTION_FACTOR = 0.0f
const AL_MAX_AIR_ABSORPTION_FACTOR = 10.0f
const AL_DEFAULT_AIR_ABSORPTION_FACTOR = 0.0f
const AL_MIN_ROOM_ROLLOFF_FACTOR = 0.0f
const AL_MAX_ROOM_ROLLOFF_FACTOR = 10.0f
const AL_DEFAULT_ROOM_ROLLOFF_FACTOR = 0.0f
const AL_MIN_CONE_OUTER_GAINHF = 0.0f
const AL_MAX_CONE_OUTER_GAINHF = 1.0f
const AL_DEFAULT_CONE_OUTER_GAINHF = 1.0f
const AL_MIN_DIRECT_FILTER_GAINHF_AUTO = AL_FALSE
const AL_MAX_DIRECT_FILTER_GAINHF_AUTO = AL_TRUE
const AL_DEFAULT_DIRECT_FILTER_GAINHF_AUTO = AL_TRUE
const AL_MIN_AUXILIARY_SEND_FILTER_GAIN_AUTO = AL_FALSE
const AL_MAX_AUXILIARY_SEND_FILTER_GAIN_AUTO = AL_TRUE
const AL_DEFAULT_AUXILIARY_SEND_FILTER_GAIN_AUTO = AL_TRUE
const AL_MIN_AUXILIARY_SEND_FILTER_GAINHF_AUTO = AL_FALSE
const AL_MAX_AUXILIARY_SEND_FILTER_GAINHF_AUTO = AL_TRUE
const AL_DEFAULT_AUXILIARY_SEND_FILTER_GAINHF_AUTO = AL_TRUE
#define AL_MIN_METERS_PER_UNIT FLT_MIN
#define AL_MAX_METERS_PER_UNIT FLT_MAX
const AL_DEFAULT_METERS_PER_UNIT = 1.0f

end extern
