/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jruby.Ruby;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.javasupport.Java;
import org.jruby.management.BeanManager;
import org.jruby.management.CachesMBean;
import org.jruby.management.ConfigMBean;
import org.jruby.management.InlineStats;
import org.jruby.management.ParserStatsMBean;
import org.jruby.management.Runtime;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class BeanManagerImpl
implements BeanManager {
    private static final Logger LOG = LoggerFactory.getLogger(BeanManagerImpl.class);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    public final String base;
    private final boolean managementEnabled;

    public BeanManagerImpl(Ruby ruby, boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
        this.base = "org.jruby:type=Runtime,name=" + FORMAT.format(new Date()) + ruby.getRuntimeNumber() + ",";
    }

    @Override
    public void register(JITCompilerMBean jitCompiler) {
        if (this.managementEnabled) {
            this.register(this.base + "service=JITCompiler", jitCompiler);
        }
    }

    @Override
    public void register(ConfigMBean config2) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Config", config2);
        }
    }

    @Override
    public void register(ParserStatsMBean parserStats) {
        if (this.managementEnabled) {
            this.register(this.base + "service=ParserStats", parserStats);
        }
    }

    @Override
    public void register(CachesMBean caches) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Caches", caches);
        }
    }

    @Override
    public void register(Runtime runtime2) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Runtime", runtime2);
        }
    }

    @Override
    public void register(InlineStats inlineStats) {
        if (this.managementEnabled) {
            this.register(this.base + "service=InlineStats", inlineStats);
        }
    }

    @Override
    public void unregisterCompiler() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=JITCompiler");
        }
    }

    @Override
    public void unregisterConfig() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=Config");
        }
    }

    @Override
    public void unregisterParserStats() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=ParserStats");
        }
    }

    @Override
    public void unregisterMethodCache() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=MethodCache");
        }
    }

    @Override
    public void unregisterRuntime() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=Runtime");
        }
    }

    @Override
    public void unregisterInlineStats() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=InlineStats");
        }
    }

    @Override
    public boolean tryShutdownAgent() {
        try {
            Class<?> agent = Class.forName("sun.management.Agent");
            Method shutdown2 = agent.getDeclaredMethod("stopRemoteManagementAgent", new Class[0]);
            Java.trySetAccessible(shutdown2);
            shutdown2.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean tryRestartAgent() {
        try {
            Class<?> agent = Class.forName("sun.management.Agent");
            Method start2 = agent.getMethod("startAgent", new Class[0]);
            Java.trySetAccessible(start2);
            start2.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void register(String name2, Object bean) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = new ObjectName(name2);
            mbs.registerMBean(bean, beanName);
        }
        catch (InstanceAlreadyExistsException ex) {
            LOG.warn("mbean already registered: {}", name2);
        }
        catch (NullPointerException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException ex) {
            LOG.error(ex);
        }
        catch (SecurityException ex) {
        }
        catch (Error e) {
            LOG.debug(e);
        }
    }

    private void unregister(String name2) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = new ObjectName(name2);
            mbs.unregisterMBean(beanName);
        }
        catch (InstanceNotFoundException mbs) {
        }
        catch (NullPointerException | MBeanRegistrationException | MalformedObjectNameException ex) {
            LOG.error(ex);
        }
        catch (SecurityException ex) {
        }
        catch (Error e) {
            LOG.debug(e);
        }
    }
}

