/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.raft.DefaultExternalKRaftMetrics;
import kafka.raft.KafkaRaftManager;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.Server$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.image.publisher.metrics.SnapshotEmitterMetrics;
import org.apache.kafka.metadata.ListenerInfo;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.BrokerServerMetrics;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rma\u0001\u0002'N\u0001IC\u0001b\u0018\u0001\u0003\u0006\u0004%I\u0001\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005C\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003i\u0011!1\bA!b\u0001\n\u00039\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005\u0005\u0001A!b\u0001\n\u0013\t\u0019\u0001\u0003\u0006\u0002\u0012\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0005\u0001\u0005\u000b\u0007I\u0011AA\u000b\u0011)\tY\u0005\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003\u001b\u0002!Q1A\u0005\u0002\u0005=\u0003BCA,\u0001\t\u0005\t\u0015!\u0003\u0002R!Q\u0011\u0011\f\u0001\u0003\u0006\u0004%\t!a\u0017\t\u0015\u0005\r\u0004A!A!\u0002\u0013\ti\u0006\u0003\u0006\u0002f\u0001\u0011)\u0019!C\u0001\u0003OB!\"a\u001d\u0001\u0005\u0003\u0005\u000b\u0011BA5\u0011\u001d\t)\b\u0001C\u0001\u0003oB\u0011\"a#\u0001\u0005\u0004%I!!$\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001fC\u0011\"a&\u0001\u0001\u0004%I!!'\t\u0013\u0005\u0005\u0006\u00011A\u0005\n\u0005\r\u0006\u0002CAX\u0001\u0001\u0006K!a'\t\u0013\u0005E\u0006\u00011A\u0005\n\u0005e\u0005\"CAZ\u0001\u0001\u0007I\u0011BA[\u0011!\tI\f\u0001Q!\n\u0005m\u0005\"CA^\u0001\u0001\u0007I\u0011BAM\u0011%\ti\f\u0001a\u0001\n\u0013\ty\f\u0003\u0005\u0002D\u0002\u0001\u000b\u0015BAN\u0011!\t)\r\u0001b\u0001\n\u0003\u0001\u0007bBAd\u0001\u0001\u0006I!\u0019\u0005\t\u0003\u0013\u0004!\u0019!C\u0001A\"9\u00111\u001a\u0001!\u0002\u0013\t\u0007\"CA\u0006\u0001\u0001\u0007I\u0011AA\u0002\u0011%\ti\r\u0001a\u0001\n\u0003\ty\r\u0003\u0005\u0002T\u0002\u0001\u000b\u0015BA\u0003\u0011-\ti\u000e\u0001a\u0001\u0002\u0004%\t!a8\t\u0017\u0005]\b\u00011AA\u0002\u0013\u0005\u0011\u0011 \u0005\f\u0003{\u0004\u0001\u0019!A!B\u0013\t\t\u000fC\u0006\u0003\u0002\u0001\u0001\r\u00111A\u0005\u0002\t\r\u0001b\u0003B\b\u0001\u0001\u0007\t\u0019!C\u0001\u0005#A1B!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0006!Y!\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011\u0001B\u000e\u0011-\u0011Y\u0003\u0001a\u0001\u0002\u0004%\tA!\f\t\u0017\tE\u0002\u00011A\u0001B\u0003&!Q\u0004\u0005\f\u0005k\u0001\u0001\u0019!a\u0001\n\u0003\u00119\u0004C\u0006\u0003H\u0001\u0001\r\u00111A\u0005\u0002\t%\u0003b\u0003B'\u0001\u0001\u0007\t\u0011)Q\u0005\u0005sA\u0011B!\u0015\u0001\u0005\u0004%IAa\u0015\t\u0011\t]\u0004\u0001)A\u0005\u0005+B1B!\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003|!Y!\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001BF\u0011-\u0011y\t\u0001a\u0001\u0002\u0003\u0006KA! \t\u0017\tM\u0005\u00011AA\u0002\u0013%!Q\u0013\u0005\f\u0005;\u0003\u0001\u0019!a\u0001\n\u0013\u0011y\nC\u0006\u0003$\u0002\u0001\r\u0011!Q!\n\t]\u0005b\u0003BT\u0001\u0001\u0007\t\u0019!C\u0005\u0005SC1B!.\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00038\"Y!1\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BV\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003DqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003N\u0002!IAa4\t\u000f\tE\u0007\u0001\"\u0001\u0003T\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bs\u0001\u0011\u0005!1\u001b\u0005\b\u0005O\u0004A\u0011\u0001Bj\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005WDqA!?\u0001\t\u0013\u0011Y\u000fC\u0004\u0003|\u0002!\tAa;\t\u000f\tu\b\u0001\"\u0001\u0003l\"9!q \u0001\u0005\u0002\t-\bbBB\u0001\u0001\u0011\u0005!1\u001e\u0005\b\u0007\u0007\u0001A\u0011\u0001Bv\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007\u000fAqaa\u0006\u0001\t\u0003\u0011\u0019\u000eC\u0004\u0004\u001a\u0001!IAa5\u0003\u0019MC\u0017M]3e'\u0016\u0014h/\u001a:\u000b\u00059{\u0015AB:feZ,'OC\u0001Q\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A*Z!\t!v+D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005\u0019\te.\u001f*fMB\u0011!,X\u0007\u00027*\u0011AlT\u0001\u0006kRLGn]\u0005\u0003=n\u0013q\u0001T8hO&tw-\u0001\ntQ\u0006\u0014X\rZ*feZ,'oQ8oM&<W#A1\u0011\u0005\t\u001cW\"A'\n\u0005\u0011l%aC&bM.\f7i\u001c8gS\u001e\f1c\u001d5be\u0016$7+\u001a:wKJ\u001cuN\u001c4jO\u0002\n\u0011#\\3uCB\u0013x\u000e]:F]N,WN\u00197f+\u0005A\u0007CA5t\u001b\u0005Q'BA6m\u0003)\u0001(o\u001c9feRLWm\u001d\u0006\u0003[:\f\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003!>T!\u0001]9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0018aA8sO&\u0011AO\u001b\u0002\u0017\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u000b:\u001cX-\u001c2mK\u0006\u0011R.\u001a;b!J|\u0007o]#og\u0016l'\r\\3!\u0003\u0011!\u0018.\\3\u0016\u0003a\u0004\"!_?\u000e\u0003iT!\u0001X>\u000b\u0005qt\u0017AB2p[6|g.\u0003\u0002\u007fu\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003!yV.\u001a;sS\u000e\u001cXCAA\u0003!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006w\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002BA\b\u0003\u0013\u0011q!T3ue&\u001c7/A\u0005`[\u0016$(/[2tA\u0005a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAA\f!\u0019\tI\"a\n\u0002,5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\t\u0002$\u0005!Q\u000f^5m\u0015\t\t)#\u0001\u0003kCZ\f\u0017\u0002BA\u0015\u00037\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\ti#a\f\u00024\u0005}RBAA\u0010\u0013\u0011\t\t$a\b\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\u0011\tI$a\t\u0002\t1\fgnZ\u0005\u0005\u0003{\t9DA\u0004J]R,w-\u001a:\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u0012\u0002$\u0005\u0019a.\u001a;\n\t\u0005%\u00131\t\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001cXCAA)!\u0019\ti#a\u0015\u0002@%!\u0011QKA\u0010\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u0012E>|Go\u001d;sCB\u001cVM\u001d<feN\u0004\u0013a\u00054bk2$\b*\u00198eY\u0016\u0014h)Y2u_JLXCAA/!\r\u0011\u0017qL\u0005\u0004\u0003Cj%a\u0005$bk2$\b*\u00198eY\u0016\u0014h)Y2u_JL\u0018\u0001\u00064bk2$\b*\u00198eY\u0016\u0014h)Y2u_JL\b%A\u0007t_\u000e\\W\r\u001e$bGR|'/_\u000b\u0003\u0003S\u0002B!a\u001b\u0002p5\u0011\u0011Q\u000e\u0006\u0003\u001d:LA!!\u001d\u0002n\t\u00192+\u001a:wKJ\u001cvnY6fi\u001a\u000b7\r^8ss\u0006q1o\\2lKR4\u0015m\u0019;pef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u0005C\u00012\u0001\u0011\u0015y\u0016\u00031\u0001b\u0011\u00151\u0017\u00031\u0001i\u0011\u00151\u0018\u00031\u0001y\u0011\u001d\t\t!\u0005a\u0001\u0003\u000bAq!a\u0005\u0012\u0001\u0004\t9\u0002C\u0004\u0002NE\u0001\r!!\u0015\t\u000f\u0005e\u0013\u00031\u0001\u0002^!9\u0011QM\tA\u0002\u0005%\u0014A\u00037pO\u000e{g\u000e^3yiV\u0011\u0011q\u0012\t\u0004s\u0006E\u0015bAAJu\nQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\bgR\f'\u000f^3e+\t\tY\nE\u0002U\u0003;K1!a(V\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;beR,Gm\u0018\u0013fcR!\u0011QUAV!\r!\u0016qU\u0005\u0004\u0003S+&\u0001B+oSRD\u0011\"!,\u0016\u0003\u0003\u0005\r!a'\u0002\u0007a$\u0013'\u0001\u0005ti\u0006\u0014H/\u001a3!\u00031)8/\u001a3Cs\n\u0013xn[3s\u0003A)8/\u001a3Cs\n\u0013xn[3s?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0006]\u0006\"CAW1\u0005\u0005\t\u0019AAN\u00035)8/\u001a3Cs\n\u0013xn[3sA\u0005\u0001Ro]3e\u0005f\u001cuN\u001c;s_2dWM]\u0001\u0015kN,GMQ=D_:$(o\u001c7mKJ|F%Z9\u0015\t\u0005\u0015\u0016\u0011\u0019\u0005\n\u0003[[\u0012\u0011!a\u0001\u00037\u000b\u0011#^:fI\nK8i\u001c8ue>dG.\u001a:!\u00031\u0011'o\\6fe\u000e{gNZ5h\u00035\u0011'o\\6fe\u000e{gNZ5hA\u0005\u00012m\u001c8ue>dG.\u001a:D_:4\u0017nZ\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u0004\u0013aC7fiJL7m]0%KF$B!!*\u0002R\"I\u0011Q\u0016\u0012\u0002\u0002\u0003\u0007\u0011QA\u0001\t[\u0016$(/[2tA!\u001a1%a6\u0011\u0007Q\u000bI.C\u0002\u0002\\V\u0013\u0001B^8mCRLG.Z\u0001\fe\u00064G/T1oC\u001e,'/\u0006\u0002\u0002bB1\u00111]Au\u0003[l!!!:\u000b\u0007\u0005\u001dx*\u0001\u0003sC\u001a$\u0018\u0002BAv\u0003K\u0014\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u0011\t\u0005=\u00181_\u0007\u0003\u0003cT1\u0001`A7\u0013\u0011\t)0!=\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0003=\u0011\u0018M\u001a;NC:\fw-\u001a:`I\u0015\fH\u0003BAS\u0003wD\u0011\"!,&\u0003\u0003\u0005\r!!9\u0002\u0019I\fg\r^'b]\u0006<WM\u001d\u0011)\u0007\u0019\n9.A\u0007ce>\\WM]'fiJL7m]\u000b\u0003\u0005\u000b\u0001BAa\u0002\u0003\f5\u0011!\u0011\u0002\u0006\u0005\u0003\u0017\ti'\u0003\u0003\u0003\u000e\t%!a\u0005\"s_.,'oU3sm\u0016\u0014X*\u001a;sS\u000e\u001c\u0018!\u00052s_.,'/T3ue&\u001c7o\u0018\u0013fcR!\u0011Q\u0015B\n\u0011%\ti\u000bKA\u0001\u0002\u0004\u0011)!\u0001\bce>\\WM]'fiJL7m\u001d\u0011)\u0007%\n9.A\fd_:$(o\u001c7mKJ\u001cVM\u001d<fe6+GO]5dgV\u0011!Q\u0004\t\u0005\u0005?\u00119#\u0004\u0002\u0003\")!\u00111\u0002B\u0012\u0015\r\u0011)C\\\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002B\u0015\u0005C\u0011\u0011dQ8oiJ|G\u000e\\3s\u001b\u0016$\u0018\rZ1uC6+GO]5dg\u0006Y2m\u001c8ue>dG.\u001a:TKJ4XM]'fiJL7m]0%KF$B!!*\u00030!I\u0011QV\u0016\u0002\u0002\u0003\u0007!QD\u0001\u0019G>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\u0004\u0003f\u0001\u0017\u0002X\u00061An\\1eKJ,\"A!\u000f\u0011\t\tm\"1I\u0007\u0003\u0005{QAA!\u000e\u0003@)\u0019!\u0011\t8\u0002\u000b%l\u0017mZ3\n\t\t\u0015#Q\b\u0002\u000f\u001b\u0016$\u0018\rZ1uC2{\u0017\rZ3s\u0003)aw.\u00193fe~#S-\u001d\u000b\u0005\u0003K\u0013Y\u0005C\u0005\u0002.:\n\t\u00111\u0001\u0003:\u00059An\\1eKJ\u0004\u0003fA\u0018\u0002X\u000692O\\1qg\"|Go\u001d#jg\u0006\u0014G.\u001a3SK\u0006\u001cxN\\\u000b\u0003\u0005+\u0002bAa\u0016\u0003^\t\u0005TB\u0001B-\u0015\u0011\u0011Y&a\u0007\u0002\r\u0005$x.\\5d\u0013\u0011\u0011yF!\u0017\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004BAa\u0019\u0003r9!!Q\rB7!\r\u00119'V\u0007\u0003\u0005SR1Aa\u001bR\u0003\u0019a$o\\8u}%\u0019!qN+\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019H!\u001e\u0003\rM#(/\u001b8h\u0015\r\u0011y'V\u0001\u0019g:\f\u0007o\u001d5piN$\u0015n]1cY\u0016$'+Z1t_:\u0004\u0013aD:oCB\u001c\bn\u001c;F[&$H/\u001a:\u0016\u0005\tu\u0004\u0003\u0002B@\u0005\u000bk!A!!\u000b\t\t\r%qH\u0001\naV\u0014G.[:iKJLAAa\"\u0003\u0002\ny1K\\1qg\"|G/R7jiR,'/A\nt]\u0006\u00048\u000f[8u\u000b6LG\u000f^3s?\u0012*\u0017\u000f\u0006\u0003\u0002&\n5\u0005\"CAWg\u0005\u0005\t\u0019\u0001B?\u0003A\u0019h.\u00199tQ>$X)\\5ui\u0016\u0014\b\u0005K\u00025\u0003/\f\u0011c\u001d8baNDw\u000e^$f]\u0016\u0014\u0018\r^8s+\t\u00119\n\u0005\u0003\u0003\u0000\te\u0015\u0002\u0002BN\u0005\u0003\u0013\u0011c\u00158baNDw\u000e^$f]\u0016\u0014\u0018\r^8s\u0003U\u0019h.\u00199tQ>$x)\u001a8fe\u0006$xN]0%KF$B!!*\u0003\"\"I\u0011Q\u0016\u001c\u0002\u0002\u0003\u0007!qS\u0001\u0013g:\f\u0007o\u001d5pi\u001e+g.\u001a:bi>\u0014\b\u0005K\u00028\u0003/\fQ#\\3uC\u0012\fG/\u0019'pC\u0012,'/T3ue&\u001c7/\u0006\u0002\u0003,B!!Q\u0016BY\u001b\t\u0011yK\u0003\u0003\u0002\f\tu\u0012\u0002\u0002BZ\u0005_\u0013Q#T3uC\u0012\fG/\u0019'pC\u0012,'/T3ue&\u001c7/A\rnKR\fG-\u0019;b\u0019>\fG-\u001a:NKR\u0014\u0018nY:`I\u0015\fH\u0003BAS\u0005sC\u0011\"!,:\u0003\u0003\u0005\rAa+\u0002-5,G/\u00193bi\u0006du.\u00193fe6+GO]5dg\u0002B3AOAl\u0003%\u0019G.^:uKJLE-\u0006\u0002\u0003b\u00051an\u001c3f\u0013\u0012,\"Aa2\u0011\u0007Q\u0013I-C\u0002\u0003LV\u00131!\u00138u\u0003\u0019I7/V:fIR\u0011\u00111T\u0001\u000fgR\f'\u000f\u001e$pe\n\u0013xn[3s)\t\t)+\u0001\nti\u0006\u0014HOR8s\u0007>tGO]8mY\u0016\u0014H\u0003BAS\u00053DqAa7@\u0001\u0004\u0011i.\u0001\u0007mSN$XM\\3s\u0013:4w\u000e\u0005\u0003\u0003`\n\u0005X\"\u00017\n\u0007\t\rHN\u0001\u0007MSN$XM\\3s\u0013:4w.A\u0007ti>\u0004hi\u001c:Ce>\\WM]\u0001\u0012gR|\u0007OR8s\u0007>tGO]8mY\u0016\u0014\u0018a\u0006:bMRl\u0015M\\1hKJ4\u0015-\u001e7u\u0011\u0006tG\r\\3s+\t\u0011i\u000f\u0005\u0003\u0003p\nUXB\u0001By\u0015\u0011\u0011\u00190!\u001c\u0002\u000b\u0019\fW\u000f\u001c;\n\t\t](\u0011\u001f\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001b[\u0016$\u0018\rZ1uC2{\u0017\rZ3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001eG>tGO]8mY\u0016\u00148\u000b^1siV\u0004h)Y;mi\"\u000bg\u000e\u001a7fe\u0006)\u0013N\\5uS\u0006d'I]8lKJlU\r^1eCR\fGj\\1e\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\"M\u0006$\u0018\r\\)v_J,XnQ8oiJ|G\u000e\\3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001%]>tg)\u0019;bYF+xN];n\u0007>tGO]8mY\u0016\u0014h)Y;mi\"\u000bg\u000e\u001a7fe\u0006qR.\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001b8h\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003K\u001bI\u0001C\u0004\u0004\f%\u0003\ra!\u0004\u0002#1L7\u000f^3oKJ,e\u000e\u001a9pS:$8\u000f\u0005\u0003\u0004\u0010\rMQBAB\t\u0015\r\t9O\\\u0005\u0005\u0007+\u0019\tBA\u0005F]\u0012\u0004x.\u001b8ug\u0006\u0019RM\\:ve\u0016tu\u000e\u001e*bMRdU-\u00193fe\u0006!1\u000f^8q\u0001")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaPropertiesEnsemble metaPropsEnsemble;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final FaultHandlerFactory faultHandlerFactory;
    private final ServerSocketFactory socketFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private volatile MetadataLoaderMetrics metadataLoaderMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaPropertiesEnsemble metaPropsEnsemble() {
        return this.metaPropsEnsemble;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public Collection<InetSocketAddress> bootstrapServers() {
        return this.bootstrapServers;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public ServerSocketFactory socketFactory() {
        return this.socketFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    private AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    private SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    private void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    private MetadataLoaderMetrics metadataLoaderMetrics() {
        return this.metadataLoaderMetrics;
    }

    private void metadataLoaderMetrics_$eq(MetadataLoaderMetrics x$1) {
        this.metadataLoaderMetrics = x$1;
    }

    public String clusterId() {
        return (String)this.metaPropsEnsemble().clusterId().get();
    }

    public int nodeId() {
        return this.metaPropsEnsemble().nodeId().getAsInt();
    }

    private synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start(Endpoints.empty());
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController(ListenerInfo listenerInfo) {
        if (!this.isUsed()) {
            Endpoints endpoints = Endpoints.fromInetSocketAddresses((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(listenerInfo.listeners()).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String listenerName = (String)x0$1._1();
                    Endpoint endpoint = (Endpoint)x0$1._2();
                    return new Tuple2((Object)ListenerName.normalised((String)listenerName), (Object)InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
            this.start(endpoints);
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    private FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    private FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)ProcessRole.ControllerRole), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$8)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$9 -> {
                    x$9.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$10 -> {
                    x$10.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$11)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$12 -> {
                    x$12.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$13 -> {
                    x$13.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$14 -> {
                    x$14.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$15)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$16 -> {
                    x$16.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start(Endpoints listenerEndpoints) {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<ClientMetricsReceiverPlugin>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)ProcessRole.BrokerRole)) {
                this.brokerMetrics_$eq(new BrokerServerMetrics(this.metrics()));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)ProcessRole.ControllerRole)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            DefaultExternalKRaftMetrics externalKRaftMetrics = new DefaultExternalKRaftMetrics((Option<BrokerServerMetrics>)Option$.MODULE$.apply((Object)this.brokerMetrics()), (Option<ControllerMetadataMetrics>)Option$.MODULE$.apply((Object)this.controllerServerMetrics()));
            KafkaRaftManager<ApiMessageAndVersion> _raftManager = new KafkaRaftManager<ApiMessageAndVersion>(this.clusterId(), this.sharedServerConfig(), (Uuid)((MetaProperties)this.metaPropsEnsemble().logDirProps().get(this.metaPropsEnsemble().metadataLogDir().get())).directoryId().get(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), externalKRaftMetrics, (Option<String>)new Some((Object)("kafka-" + this.sharedServerConfig().nodeId() + "-raft")), this.controllerQuorumVotersFuture(), this.bootstrapServers(), listenerEndpoints, this.raftManagerFaultHandler());
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            this.metadataLoaderMetrics_$eq(this.brokerMetrics() != null ? new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), elapsedNs -> this.brokerMetrics().updateBatchProcessingTime(Predef$.MODULE$.Long2long(elapsedNs)), batchSize -> this.brokerMetrics().updateBatchSize(Predef$.MODULE$.Integer2int(batchSize)), this.brokerMetrics().lastAppliedImageProvenance()) : new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), x$17 -> {}, x$18 -> {}, new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY)));
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.nodeId()).setTime(this.time()).setThreadNamePrefix("kafka-" + this.sharedServerConfig().nodeId() + "-").setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetrics(this.metadataLoaderMetrics());
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.nodeId()).setRaftClient(_raftManager.client()).setMetrics(new SnapshotEmitterMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), this.time())).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix("kafka-" + this.sharedServerConfig().nodeId() + "-").build());
            try {
                this.loader().installPublishers(Arrays.asList(this.snapshotGenerator())).get();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            _raftManager.register((RaftClient.Listener<ApiMessageAndVersion>)this.loader());
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.stop();
            throw e;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().beginShutdown(), this, Level.WARN);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().beginShutdown(), this, Level.WARN);
        }
        Utils.closeQuietly((AutoCloseable)this.loader(), (String)"loader");
        this.loader_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.metadataLoaderMetrics(), (String)"metadata loader metrics");
        this.metadataLoaderMetrics_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.snapshotGenerator(), (String)"snapshot generator");
        this.snapshotGenerator_$eq(null);
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this, Level.WARN);
            this.raftManager_$eq(null);
        }
        Utils.closeQuietly((AutoCloseable)this.controllerServerMetrics(), (String)"controller server metrics");
        this.controllerServerMetrics_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.brokerMetrics(), (String)"broker metrics");
        this.brokerMetrics_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.metrics(), (String)"metrics");
        this.metrics_$eq(null);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, Level.WARN);
        this.started_$eq(false);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$8) {
        return x$8.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$11) {
        return x$11.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$15) {
        return x$15.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> _raftManager.shutdown(), $this, Level.WARN);
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaPropertiesEnsemble metaPropsEnsemble, Time time, Metrics _metrics, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, FaultHandlerFactory faultHandlerFactory, ServerSocketFactory socketFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaPropsEnsemble = metaPropsEnsemble;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.faultHandlerFactory = faultHandlerFactory;
        this.socketFactory = socketFactory;
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(sharedServerConfig.originals()));
        KafkaYammerMetrics.INSTANCE.configure(sharedServerConfig.originals());
        this.logContext = new LogContext("[SharedServer id=" + sharedServerConfig.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false);
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
    }
}

