/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.Tag;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.AbstractCheckCaseRule;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ExampleSentence;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestionWithMessage;
import org.languagetool.rules.WordCoherencyDataLoader;
import org.languagetool.rules.WordListValidatorTest;
import org.languagetool.rules.ngrams.FakeLanguageModel;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleTest;

public class LanguageSpecificTest {
    private static final Map<String, Integer> idToExpectedMatches = new HashMap<String, Integer>();

    protected void runTests(Language lang) throws IOException {
        this.runTests(lang, null, "");
    }

    protected void runTests(Language lang, String onlyRunCode) throws IOException {
        this.runTests(lang, onlyRunCode, "");
    }

    protected void runTests(Language lang, String onlyRunCode, String additionalValidationChars) throws IOException {
        new WordListValidatorTest(additionalValidationChars).testWordListValidity(lang);
        this.testNoLineBreaksEtcInMessage(lang);
        this.testNoQuotesAroundSuggestion(lang);
        this.testJavaRules(onlyRunCode);
        this.testConfusionSetLoading();
        this.countTempOffRules(lang);
        this.testCoherencyBaseformIsOtherForm(lang);
        this.testReplaceRuleReplacements(lang);
        try {
            new DisambiguationRuleTest().testDisambiguationRulesFromXML();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void testReplaceRuleReplacements(Language lang) throws IOException {
        JLanguageTool lt = new JLanguageTool(lang);
        SpellingCheckRule spellRule = lang.getDefaultSpellingRule();
        if (lang.getShortCode().matches("nl|km")) {
            System.out.println("Skipping " + lang + " for replace.txt check");
            return;
        }
        if (spellRule != null) {
            for (Rule rule : lt.getAllActiveRules()) {
                AbstractSimpleReplaceRule2 replRule;
                if (rule instanceof AbstractSimpleReplaceRule2) {
                    replRule = (AbstractSimpleReplaceRule2)rule;
                    boolean checkingCase = rule instanceof AbstractCheckCaseRule;
                    List wrongWords = replRule.getWrongWords();
                    for (Map entry : wrongWords) {
                        for (String s : entry.keySet()) {
                            Object[] matches2;
                            String repl = ((SuggestionWithMessage)entry.get(s)).getSuggestion();
                            Object[] matches = spellRule.match(lt.getAnalyzedSentence(repl));
                            if (matches.length > 0) {
                                System.err.println("*** WARNING: replacement '" + repl + "' for '" + s + "' from one of " + replRule.getFileNames() + " isn't known to spell checker of " + lang + ": " + Arrays.toString(matches));
                            }
                            if (replRule.checkKeyWordsAreKnownToSpeller() && (matches2 = spellRule.match(lt.getAnalyzedSentence(s))).length > 0) {
                                System.err.println("*** WARNING: key word '" + s + "' from one of " + replRule.getFileNames() + " isn't known to spell checker of " + lang + ": " + Arrays.toString(matches2));
                            }
                            if (replRule.checkKeyWordsAreUnknownToSpeller() && (matches2 = spellRule.match(lt.getAnalyzedSentence(s))).length == 0) {
                                System.err.println("*** WARNING: key word '" + s + "' from one of " + replRule.getFileNames() + " is known to spell checker of " + lang + ": " + Arrays.toString(matches2));
                            }
                            if (!replRule.separateKeyWordsBySpeller()) continue;
                            matches2 = spellRule.match(lt.getAnalyzedSentence(s));
                            if (matches2.length > 0) {
                                System.err.println("SPELLER_WRONG: " + s + "=" + repl);
                                continue;
                            }
                            System.err.println("SPELLER_OK: " + s + "=" + repl);
                        }
                    }
                }
                if (!(rule instanceof AbstractSimpleReplaceRule)) continue;
                if (lang.getShortCode().equals("ca")) {
                    spellRule = rule.getId().equals("CA_SIMPLE_REPLACE_DNV_SECONDARY") ? Languages.getLanguageForShortCode((String)"ca-ES-valencia").getDefaultSpellingRule() : lang.getDefaultSpellingRule();
                }
                if (lang.getShortCode().equals("de") && rule.getId().equals("DE_DUPLICATED_CHAR")) continue;
                replRule = (AbstractSimpleReplaceRule)rule;
                Map wrongWords = replRule.getWrongWords();
                for (String key : wrongWords.keySet()) {
                    String repl = ((List)wrongWords.get(key)).toString();
                    Object[] matches = spellRule.match(lt.getAnalyzedSentence(repl));
                    if (matches.length <= 0) continue;
                    System.err.println("*** WARNING: replacement '" + repl + "' for '" + key + "' from rule " + rule.getId() + ", files: [\"replace.txt\", \"replace_custom.txt\"] isn't known to spell checker of " + lang + ": " + Arrays.toString(matches));
                }
            }
        } else {
            System.out.println("No speller found for " + lang);
        }
    }

    private void testNoLineBreaksEtcInMessage(Language lang) {
        if (lang.getMaintainedState() == LanguageMaintainedState.LookingForNewMaintainer) {
            System.err.println("Skipping message tests for unmaintained language " + lang);
            return;
        }
        System.out.println("Testing messages for line breaks...");
        JLanguageTool lt = new JLanguageTool(lang);
        for (Rule rule : lt.getAllRules()) {
            if (!(rule instanceof AbstractPatternRule)) continue;
            AbstractPatternRule pRule = (AbstractPatternRule)rule;
            String message = pRule.getMessage();
            String prefix = "*** WARNING: " + lang.getShortCode() + ": " + rule.getFullId() + " from " + pRule.getSourceFile();
            if (message.contains("\n") || message.contains("\r")) {
                System.err.println(prefix + " contains line break (\\n or \\r): " + message.replace("\n", "\\n").replace("\r", "\\r"));
            }
            if (message.contains("\t")) {
                System.err.println(prefix + " contains tab (\\t): " + message.replace("\t", "\\t"));
            }
            if (message.contains("  ")) {
                System.err.println(prefix + " contains two consecutive spaces in message: " + message);
            }
            if (!rule.getDescription().contains("  ")) continue;
            System.err.println(prefix + " contains two consecutive spaces in description: " + rule.getDescription());
        }
    }

    protected void testCoherencyBaseformIsOtherForm(Language lang) throws IOException {
        if (lang.getShortCode().equals("km")) {
            return;
        }
        JLanguageTool lt = new JLanguageTool(lang);
        TestTools.disableAllRulesExcept(lt, "EN_WORD_COHERENCY");
        WordCoherencyDataLoader loader = new WordCoherencyDataLoader();
        String path = "/" + lang.getShortCode() + "/coherency.txt";
        if (!JLanguageTool.getDataBroker().ruleFileExists(path)) {
            System.out.println("File not found (okay for many languages): " + path);
            return;
        }
        System.out.println("Testing coherency.txt...");
        System.out.println("Checking " + path + "...");
        Map map = loader.loadWords(path);
        HashSet<CallSite> invalid = new HashSet<CallSite>();
        Synthesizer synthesizer = lang.getSynthesizer();
        for (String key : map.keySet()) {
            String[] forms;
            if (synthesizer == null) continue;
            for (String form : forms = synthesizer.synthesize(new AnalyzedToken(key, "fake", key), ".*", true)) {
                List matches = lt.check(form);
                if (matches.size() <= 0) continue;
                invalid.add((CallSite)((Object)(form + " (a form of " + key + ")")));
            }
        }
        if (invalid.size() > 0) {
            junit.framework.Assert.fail((String)(lang + ": These words trigger the rule because their base form is one of the forms in coherency.txt, giving false alarms:\n  " + String.join((CharSequence)"\n  ", invalid)));
        }
    }

    private void testJavaRules(String onlyRunCode) throws IOException {
        HashMap<String, String> idsToClassName = new HashMap<String, String>();
        HashSet<Class> ruleClasses = new HashSet<Class>();
        float printLimitSeconds = 0.2f;
        for (Language language : Languages.getWithDemoLanguage()) {
            if (onlyRunCode != null && !language.getShortCodeWithCountryAndVariant().equals(onlyRunCode)) {
                System.out.println("Skipping " + language);
                continue;
            }
            System.out.println("Running for " + language + ", printing only tests that take > " + printLimitSeconds + " seconds:");
            JLanguageTool lt = new JLanguageTool(language);
            List allRules = lt.getAllRules();
            for (Rule rule : allRules) {
                this.assertIdAndDescriptionValidity(language, rule);
                if (rule instanceof AbstractPatternRule) continue;
                long startTime = System.currentTimeMillis();
                this.assertIdUniqueness(idsToClassName, ruleClasses, language, rule);
                this.assertIdValidity(language, rule);
                Assert.assertTrue((boolean)rule.supportsLanguage(language));
                rule.setTags(rule.getTags().stream().filter(k -> !k.equals((Object)Tag.picky)).collect(Collectors.toList()));
                this.testExamples(rule, lt);
                long endTime = System.currentTimeMillis();
                float runTimeSeconds = (float)(endTime - startTime) / 1000.0f;
                if (!(runTimeSeconds > printLimitSeconds)) continue;
                System.out.print("Tested Java rule " + rule.getFullId());
                System.out.printf(Locale.ENGLISH, " ... %.2fs\n", Float.valueOf(runTimeSeconds));
            }
        }
    }

    private void testConfusionSetLoading() {
        for (Language language : Languages.get()) {
            try {
                List rules = language.getRelevantLanguageModelRules(JLanguageTool.getMessageBundle(), (LanguageModel)new FakeLanguageModel(), null);
                if (rules.size() <= 0) continue;
                String path = "/" + language.getShortCode() + "/confusion_sets.txt";
                InputStream confusionSetStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
                try {
                    ConfusionSetLoader confusionSetLoader = new ConfusionSetLoader((Language)new Demo());
                    confusionSetLoader.loadConfusionPairs(confusionSetStream);
                }
                finally {
                    if (confusionSetStream == null) continue;
                    confusionSetStream.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load confusion pairs for " + language.getName(), e);
            }
        }
    }

    private void testExampleAvailable(String onlyRunCode) {
        for (Language language : Languages.getWithDemoLanguage()) {
            if (onlyRunCode != null && !language.getShortCodeWithCountryAndVariant().equals(onlyRunCode)) {
                System.out.println("Skipping " + language);
                continue;
            }
            JLanguageTool lt = new JLanguageTool(language);
            List allRules = lt.getAllRules();
            for (Rule rule : allRules) {
                if (!rule.getIncorrectExamples().isEmpty()) continue;
                System.err.println("*** WARNING: " + language.getShortCodeWithCountryAndVariant() + " rule " + rule.getId() + " has no incorrect examples");
            }
        }
    }

    private void testNoQuotesAroundSuggestion(Language lang) throws IOException {
        if (lang.getShortCode().equals("fa") || lang.getShortCode().equals("zh")) {
            System.out.println("Skipping testNoQuotesAroundSuggestion for " + lang.getName());
            return;
        }
        System.out.println("Testing that there are no quotes around <suggestion>s...");
        for (String ruleFileName : lang.getRuleFileNames()) {
            if (ruleFileName.contains("-test-")) continue;
            InputStream is = this.getClass().getResourceAsStream(ruleFileName);
            List rules = new PatternRuleLoader().getRules(is, ruleFileName, lang);
            for (AbstractPatternRule rule : rules) {
                String message = rule.getMessage();
                if (!message.matches(".*['\"\u00ab\u00bb\u201c\u201d\u2019]<suggestion.*") || !message.matches(".*</suggestion>['\"\u00ab\u00bb\u201c\u201d\u2019].*")) continue;
                junit.framework.Assert.fail((String)(lang.getName() + " rule " + rule.getFullId() + " uses quotes around <suggestion>...<suggestion> in its <message>, this should be avoided: '" + message + "'"));
            }
        }
    }

    protected void testDemoText(Language lang, String text, List<String> expectedMatchIds) throws IOException {
        JLanguageTool lt = new JLanguageTool(lang);
        List matches = lt.check(text);
        int i = 0;
        ArrayList<String> actualRuleIds = new ArrayList<String>();
        for (RuleMatch match : matches) {
            actualRuleIds.add(match.getSpecificRuleId());
        }
        if (expectedMatchIds.size() != actualRuleIds.size()) {
            this.failTest(lang, text, expectedMatchIds, actualRuleIds);
        }
        for (String actualRuleId : actualRuleIds) {
            if (!expectedMatchIds.get(i).equals(actualRuleId)) {
                this.failTest(lang, text, expectedMatchIds, actualRuleIds);
            }
            ++i;
        }
    }

    protected static Set<String> getAllRuleIds(Language ... langs) {
        HashSet<String> ids = new HashSet<String>();
        for (Language lang : langs) {
            JLanguageTool lt = new JLanguageTool(lang);
            for (Rule rule : lt.getAllRules()) {
                ids.add(rule.getId());
            }
        }
        for (Categories cat : Categories.ALL) {
            ids.add(cat.getId().toString());
        }
        return ids;
    }

    private void failTest(Language lang, String text, List<String> expectedMatchIds, List<String> actualRuleIds) {
        junit.framework.Assert.fail((String)("The website demo text matches for " + lang + " have changed. Demo text:\n" + text + "\nExpected rule matches:\n" + expectedMatchIds + "\nActual rule matches:\n" + actualRuleIds));
    }

    private void assertIdUniqueness(Map<String, String> ids, Set<Class> ruleClasses, Language language, Rule rule) {
        String ruleId = rule.getId();
        if (ids.containsKey(ruleId) && !ruleClasses.contains(rule.getClass())) {
            throw new RuntimeException("Rule id occurs more than once: '" + ruleId + "', one of them " + rule.getClass() + ", the other one " + ids.get(ruleId) + ", language: " + language);
        }
        ids.put(ruleId, rule.getClass().getName());
        ruleClasses.add(rule.getClass());
    }

    private void assertIdValidity(Language lang, Rule rule) {
        String ruleId = rule.getId();
        if (!ruleId.matches("^[A-Z_][A-Z0-9_]+$")) {
            throw new RuntimeException("Invalid character in rule id: '" + ruleId + "', language: " + lang + ", only [A-Z0-9_] are allowed and the first character must be in [A-Z_]");
        }
    }

    private void assertIdAndDescriptionValidity(Language lang, Rule rule) {
        String ruleId = rule.getId();
        if (rule.getId().equals(rule.getDescription())) {
            System.err.println("*** WARNING: " + lang.getShortCodeWithCountryAndVariant() + ": " + rule.getFullId() + ": 'id' and 'name' are identical for this rule");
        }
        if (rule.getId().trim().isEmpty()) {
            throw new RuntimeException("Empty rule id: '" + ruleId + "', language: " + lang.getShortCodeWithCountryAndVariant());
        }
        if (rule.getDescription().trim().isEmpty()) {
            throw new RuntimeException("Empty rule description for rule: '" + ruleId + "', language: " + lang.getShortCodeWithCountryAndVariant());
        }
    }

    private void testExamples(Rule rule, JLanguageTool lt) throws IOException {
        this.testCorrectExamples(rule, lt);
        this.testIncorrectExamples(rule, lt);
    }

    private void testCorrectExamples(Rule rule, JLanguageTool lt) throws IOException {
        List correctExamples = rule.getCorrectExamples();
        for (CorrectExample correctExample : correctExamples) {
            String input = ExampleSentence.cleanMarkersInExample((String)correctExample.getExample());
            this.enableOnlyOneRule(lt, rule);
            List ruleMatches = lt.check(input);
            Assert.assertEquals((String)("Got unexpected rule match for correct example sentence:\nText: " + input + "\nRule: " + rule.getId() + "\nMatches: " + ruleMatches), (long)0L, (long)ruleMatches.size());
        }
    }

    private void testIncorrectExamples(Rule rule, JLanguageTool lt) throws IOException {
        List incorrectExamples = rule.getIncorrectExamples();
        for (IncorrectExample incorrectExample : incorrectExamples) {
            String input = ExampleSentence.cleanMarkersInExample((String)incorrectExample.getExample());
            this.enableOnlyOneRule(lt, rule);
            List ruleMatches = lt.check(input);
            Assert.assertEquals((String)("Did not get the expected rule match for the incorrect example sentence:\nText: " + input + "\nRule: " + rule.getId() + "\nMatches: " + ruleMatches), (long)idToExpectedMatches.getOrDefault(rule.getId(), 1).intValue(), (long)ruleMatches.size());
        }
    }

    private void enableOnlyOneRule(JLanguageTool lt, Rule ruleToActivate) {
        for (Rule rule : lt.getAllRules()) {
            lt.disableRule(rule.getId());
        }
        lt.enableRule(ruleToActivate.getId());
    }

    private void countTempOffRules(Language lang) {
        JLanguageTool lt = new JLanguageTool(lang);
        int count = 0;
        TreeMap<String, Integer> fileToCount = new TreeMap<String, Integer>();
        for (Rule rule : lt.getAllRules()) {
            if (!rule.isDefaultTempOff()) continue;
            ++count;
            if (!(rule instanceof AbstractPatternRule)) continue;
            String sourceFile = ((AbstractPatternRule)rule).getSourceFile();
            fileToCount.put(sourceFile, fileToCount.getOrDefault(sourceFile, 0) + 1);
        }
        System.out.println("Number of default='temp_off' rules for " + lang + ": " + count);
        int limit = 20;
        if (count > limit) {
            System.err.println("################################################################################################");
            System.err.println("WARNING: " + count + " default='temp_off' rules for " + lang + ", please make sure to turn on these");
            System.err.println("WARNING: rules after they have been tested (or use default='off' to turn them off permanently)");
            System.err.println("WARNING: (this warning appears if there are more than " + limit + " default='temp_off' rules)");
            System.err.println("WARNING: temp_off rules by file:");
            for (Map.Entry entry : fileToCount.entrySet()) {
                System.err.println("WARNING: " + entry.getValue() + " in " + (String)entry.getKey());
            }
            System.err.println("################################################################################################");
        }
    }

    static {
        idToExpectedMatches.put("EN_CONSISTENT_APOS", 2);
        idToExpectedMatches.put("STYLE_REPEATED_WORD_RULE_DE", 2);
        idToExpectedMatches.put("STYLE_REPEATED_SHORT_SENTENCES", 3);
        idToExpectedMatches.put("STYLE_REPEATED_SENTENCE_BEGINNING", 3);
    }
}

