package Lire::SQLExt::Registry;

use strict;

use vars qw/@EXT_FUNCTIONS @EXT_AGGREGATES/;

use Lire::SQLExt::LrMissingCases;
use Lire::SQLExt::LrFirst;
use Lire::SQLExt::LrLast;
use Lire::SQLExt::LrCountUniq;
use Lire::SQLExt::LrMatch;
use Lire::SQLExt::LrRangegroup;
use Lire::SQLExt::LrTimegroup;
use Lire::SQLExt::LrTimeslot;

@EXT_FUNCTIONS =
  (
   [ 'lr_match', 3, \&Lire::SQLExt::LrMatch::lr_match ],
   [ 'lr_timegroup_sec', 2, \&Lire::SQLExt::LrTimegroup::lr_timegroup_sec ],
   [ 'lr_timegroup_day', 1, \&Lire::SQLExt::LrTimegroup::lr_timegroup_day ],
   [ 'lr_timegroup_week', 2, \&Lire::SQLExt::LrTimegroup::lr_timegroup_week ],
   [ 'lr_timegroup_month', 2, \&Lire::SQLExt::LrTimegroup::lr_timegroup_month],
   [ 'lr_timegroup_year', 2, \&Lire::SQLExt::LrTimegroup::lr_timegroup_year ],
   [ 'lr_timeslot', 3, \&Lire::SQLExt::LrTimeslot::lr_timeslot],
   [ 'lr_timeslot_week', 2, \&Lire::SQLExt::LrTimeslot::lr_timeslot_week ],
   [ 'lr_rangegroup', 5, \&Lire::SQLExt::LrRangegroup::lr_rangegroup],
   [ 'lr_rangegroup_geo', 6, \&Lire::SQLExt::LrRangegroup::lr_rangegroup_geo ],
  );

@EXT_AGGREGATES =
  (
   [ 'lr_missing_cases', -1, 'Lire::SQLExt::LrMissingCases' ],
   [ 'lr_first', -1, new Lire::SQLExt::LrFirst() ],
   [ 'lr_first_key', -1, new Lire::SQLExt::LrFirst( 'key' ) ],
   [ 'lr_last', -1, new Lire::SQLExt::LrLast(  ) ],
   [ 'lr_last_key', -1, new Lire::SQLExt::LrLast( 'key') ],
   [ 'lr_count_uniq', -1, 'Lire::SQLExt::LrCountUniq' ],
  );


sub register_functions {
    my ( $self, $dbh ) = @_;

    foreach my $func_desc ( @EXT_FUNCTIONS ) {
        $dbh->func( $func_desc->[0], $func_desc->[1], $func_desc->[2],
                    "create_function" );
    }

    return;
}

sub register_aggregates {
    my ( $self, $dbh ) = @_;

    foreach my $aggr_desc ( @EXT_AGGREGATES ) {
        $dbh->func( $aggr_desc->[0], $aggr_desc->[1], $aggr_desc->[2],
                    "create_aggregate" );
    }

    return;
}

1;

__END__

=pod

=head1 NAME

Lire::SQLExt::Registry - FILL ME IN

=head1 SYNOPSIS

  FILL ME IN

=head1 DESCRIPTION

  FILL ME IN

=head1 SEE ALSO

Lire::DlfConverter(3pm)

=head1 VERSION

$Id: Registry.pm,v 1.9 2006/07/23 13:16:31 vanbaal Exp $

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut

