/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.LaunchDbSystemBase;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class LaunchDbSystemRequest
extends BmcRequest<LaunchDbSystemBase> {
    private LaunchDbSystemBase launchDbSystemDetails;
    private String opcRetryToken;

    public LaunchDbSystemBase getLaunchDbSystemDetails() {
        return this.launchDbSystemDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public LaunchDbSystemBase getBody$() {
        return this.launchDbSystemDetails;
    }

    public Builder toBuilder() {
        return new Builder().launchDbSystemDetails(this.launchDbSystemDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",launchDbSystemDetails=").append(String.valueOf((Object)this.launchDbSystemDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LaunchDbSystemRequest)) {
            return false;
        }
        LaunchDbSystemRequest other = (LaunchDbSystemRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.launchDbSystemDetails, (Object)other.launchDbSystemDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.launchDbSystemDetails == null ? 43 : this.launchDbSystemDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<LaunchDbSystemRequest, LaunchDbSystemBase> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private LaunchDbSystemBase launchDbSystemDetails = null;
        private String opcRetryToken = null;

        public Builder launchDbSystemDetails(LaunchDbSystemBase launchDbSystemDetails) {
            this.launchDbSystemDetails = launchDbSystemDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(LaunchDbSystemRequest o) {
            this.launchDbSystemDetails(o.getLaunchDbSystemDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public LaunchDbSystemRequest build() {
            LaunchDbSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LaunchDbSystemBase body) {
            this.launchDbSystemDetails(body);
            return this;
        }

        public LaunchDbSystemRequest buildWithoutInvocationCallback() {
            LaunchDbSystemRequest request = new LaunchDbSystemRequest();
            request.launchDbSystemDetails = this.launchDbSystemDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

