/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.IdClass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class IdClassOverridesEqualsAndHashCode {
    public static ErrorDescription apply(HintContext hc) {
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        final JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        boolean hasEquals = false;
        boolean hasHashCode = false;
        final IdClass[] idclass = new IdClass[]{null};
        try {
            MetadataModel<EntityMappingsMetadata> model = ModelUtils.getModel(hc.getInfo().getFileObject());
            model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                public Void run(EntityMappingsMetadata metadata) {
                    if (ctx.getModelElement() instanceof Entity) {
                        idclass[0] = ((Entity)ctx.getModelElement()).getIdClass();
                    } else if (ctx.getModelElement() instanceof MappedSuperclass) {
                        idclass[0] = ((MappedSuperclass)ctx.getModelElement()).getIdClass();
                    }
                    return null;
                }
            });
        }
        catch (IOException model) {
            // empty catch block
        }
        if (idclass[0] == null) {
            return null;
        }
        String className = idclass[0].getClass2();
        if (className == null) {
            return null;
        }
        TypeElement subject = hc.getInfo().getElements().getTypeElement(className);
        if (subject == null) {
            return null;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(subject.getEnclosedElements())) {
            String methodName = method.getSimpleName().toString();
            if ("equals".equals(methodName) && method.getParameters().size() == 1) {
                if ("java.lang.Object".equals(method.getParameters().get(0).asType().toString())) {
                    hasEquals = true;
                }
            } else if ("hashCode".equals(methodName) && method.getParameters().size() == 0) {
                hasHashCode = true;
            }
            if (!hasHashCode || !hasEquals) continue;
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)hc, (TreePath)hc.getPath().getParentPath(), (String)NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_IdClassDoesNotOverrideEquals"), (Fix[])new Fix[0]);
    }
}

