/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.editor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.angular.editor.AngularJsCompletionItem;
import org.netbeans.modules.html.angular.editor.AngularJsElement;
import org.netbeans.modules.html.angular.index.AngularJsController;
import org.netbeans.modules.html.angular.index.AngularJsIndex;
import org.netbeans.modules.html.angular.model.Directive;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.IndexedElement;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class AngularJsCodeCompletion
implements CompletionProvider {
    private static final String MIMETYPE = "text/html/text/javascript";

    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        if (!MIMETYPE.equals(ccContext.getParserResult().getSnapshot().getMimePath().getPath())) {
            return Collections.emptyList();
        }
        TokenSequence<HTMLTokenId> htmlTs = this.getHtmlTs(ccContext);
        if (htmlTs == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        htmlTs.move(ccContext.getCaretOffset());
        if (htmlTs.movePrevious()) {
            AngularContext angularContext = this.findHtmlContext(htmlTs);
            switch (angularContext.ordinal()) {
                case 0: {
                    if (jsCompletionContext != CompletionContext.GLOBAL) break;
                    result.addAll(this.findControllerNames(ccContext));
                    break;
                }
                case 1: {
                    if (jsCompletionContext != CompletionContext.GLOBAL) break;
                    result.addAll(this.findComponentNames(ccContext));
                    break;
                }
            }
        }
        return result;
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        return null;
    }

    private TokenSequence<HTMLTokenId> getHtmlTs(CodeCompletionContext ccContext) {
        final Document document = ccContext.getParserResult().getSnapshot().getSource().getDocument(false);
        TokenSequence result = null;
        if (document != null) {
            final TokenSequence[] value = new TokenSequence[1];
            document.render(new Runnable(){
                final /* synthetic */ AngularJsCodeCompletion this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    TokenHierarchy th = TokenHierarchy.get((Document)document);
                    value[0] = th.tokenSequence(HTMLTokenId.language());
                }
            });
            result = value[0];
        }
        return result;
    }

    private AngularContext findHtmlContext(TokenSequence<HTMLTokenId> htmlTs) {
        Token token = htmlTs.token();
        HTMLTokenId id = (HTMLTokenId)token.id();
        switch (id) {
            case OPERATOR: {
                if (!htmlTs.movePrevious()) break;
                return this.findHtmlContext(htmlTs);
            }
            case ARGUMENT: {
                String argument = token.text().toString();
                Directive directive = Directive.getDirective(argument);
                if (directive == null) break;
                switch (directive) {
                    case controller: {
                        return AngularContext.CONTROLLER;
                    }
                    case link: {
                        return AngularContext.LINK;
                    }
                }
            }
        }
        return AngularContext.UNKNOWN;
    }

    private Collection<? extends CompletionProposal> findControllerNames(CodeCompletionContext ccContext) {
        Index jsIndex;
        FileObject fo = ccContext.getParserResult().getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<AngularJsCompletionItem.AngularFOCompletionItem> result = new ArrayList<AngularJsCompletionItem.AngularFOCompletionItem>();
        AngularJsIndex angularIndex = null;
        try {
            angularIndex = AngularJsIndex.get(project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (angularIndex != null) {
            Collection<AngularJsController> controllers = angularIndex.getControllers(ccContext.getPrefix(), false);
            for (AngularJsController controller : controllers) {
                int anchor = ccContext.getCaretOffset() - ccContext.getPrefix().length();
                String name = controller.getName();
                URL url = controller.getDeclarationFile();
                File file = new File(url.toString());
                AngularJsElement element = new AngularJsElement(name, ElementKind.METHOD);
                result.add(new AngularJsCompletionItem.AngularFOCompletionItem(element, anchor, FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))));
            }
        }
        if ((jsIndex = Index.get((FileObject)fo)) != null) {
            Collection globalVars = jsIndex.getGlobalVar(ccContext.getPrefix());
            for (IndexedElement variable : globalVars) {
                IndexedElement.FunctionIndexedElement function;
                if (variable.isAnonymous() || variable.getJSKind() != JsElement.Kind.FUNCTION && variable.getJSKind() != JsElement.Kind.CONSTRUCTOR && variable.getJSKind() != JsElement.Kind.ARROW_FUNCTION || !(variable instanceof IndexedElement.FunctionIndexedElement) || (function = (IndexedElement.FunctionIndexedElement)variable).isAnonymous() || function.getParameters().size() <= 0 || !function.getParameters().containsKey("$scope")) continue;
                AngularJsElement element = new AngularJsElement(function.getName(), ElementKind.METHOD);
                int anchor = ccContext.getCaretOffset() - ccContext.getPrefix().length();
                result.add(new AngularJsCompletionItem.AngularFOCompletionItem(element, anchor, function.getFileObject()));
            }
        }
        return result;
    }

    private Collection<? extends CompletionProposal> findComponentNames(CodeCompletionContext ccContext) {
        FileObject fo = ccContext.getParserResult().getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<AngularJsCompletionItem.AngularFOCompletionItem> result = new ArrayList<AngularJsCompletionItem.AngularFOCompletionItem>();
        AngularJsIndex angularIndex = null;
        try {
            angularIndex = AngularJsIndex.get(project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (angularIndex != null) {
            Collection<String> components = angularIndex.getComponents(ccContext.getPrefix(), false);
            for (String component : components) {
                int anchor = ccContext.getCaretOffset() - ccContext.getPrefix().length();
                AngularJsElement element = new AngularJsElement(component, ElementKind.METHOD);
                result.add(new AngularJsCompletionItem.AngularFOCompletionItem(element, anchor, null));
            }
        }
        return result;
    }

    private static enum AngularContext {
        CONTROLLER,
        LINK,
        UNKNOWN;

    }
}

