/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.ui;

import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.DependentFileQuery;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Utilities {
    private static final Collection<String> STYLED_MIME_TYPES = new HashSet<String>(Arrays.asList("text/html", "text/xhtml", "text/x-jsp", "text/x-php5"));
    private static final Collection<String> NAVIGATOR_MIME_TYPES = new HashSet<String>(Arrays.asList("text/html", "text/xhtml"));
    private static RequestProcessor RP = new RequestProcessor(Utilities.class);

    static boolean isStyledMimeType(String mimeType) {
        return STYLED_MIME_TYPES.contains(mimeType);
    }

    static boolean isMimeTypeSupportedByNavigator(String mimeType) {
        return NAVIGATOR_MIME_TYPES.contains(mimeType);
    }

    static boolean isServerSideMimeType(String mimeType) {
        return Utilities.isStyledMimeType(mimeType) && !NAVIGATOR_MIME_TYPES.contains(mimeType);
    }

    static FileObject inspectedFileObject(PageModel page) {
        FileObject fob = null;
        Project project = page.getProject();
        if (project != null) {
            String documentURL = page.getDocumentURL();
            try {
                URL url = new URL(documentURL);
                fob = ServerURLMapping.fromServer((Project)project, (URL)url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fob;
    }

    public static void focusInspectedFile(PageModel pageModel) {
        Project project;
        String documentURL = pageModel.getDocumentURL();
        if (documentURL != null && (project = ((WebKitPageModel)pageModel).getProject()) != null) {
            try {
                URL url = new URL(documentURL);
                final FileObject fob = ServerURLMapping.fromServer((Project)project, (URL)url);
                if (fob != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final FileObject selectedFile = Utilities.selectedEditorFile();
                            RP.post(new Runnable(){
                                final /* synthetic */ 1 this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void run() {
                                    if (selectedFile == null || !Utilities.isStyledMimeType(selectedFile.getMIMEType()) || !DependentFileQuery.isDependent((FileObject)fob, (FileObject)selectedFile)) {
                                        EventQueue.invokeLater(new Runnable(){
                                            final /* synthetic */ 1 this$1;
                                            {
                                                this.this$1 = this$1;
                                            }

                                            @Override
                                            public void run() {
                                                try {
                                                    DataObject dob = DataObject.find((FileObject)fob);
                                                    EditorCookie editor = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                                                    if (editor != null) {
                                                        editor.open();
                                                    }
                                                }
                                                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                                    // empty catch block
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    });
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private static FileObject selectedEditorFile() {
        WindowManager manager = WindowManager.getDefault();
        TopComponent.Registry registry = manager.getRegistry();
        TopComponent active = registry.getActivated();
        if (active == null || !manager.isOpenedEditorTopComponent(active)) {
            Mode mode;
            active = null;
            Iterator iterator = manager.getModes().iterator();
            while (iterator.hasNext() && (!manager.isEditorMode(mode = (Mode)iterator.next()) || (active = mode.getSelectedTopComponent()) == null)) {
            }
        }
        FileObject selectedFile = null;
        if (active != null) {
            selectedFile = (FileObject)active.getLookup().lookup(FileObject.class);
        }
        return selectedFile;
    }
}

