/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.target.iterator.spi.TargetPanelUIManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagLibTargetPanelProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class TagLibUIManager
implements TargetPanelUIManager<FileType> {
    private static final String TLD_IN_JAVALIB_FOLDER = "META-INF";
    private static final String TLD_FOLDER = "tlds";
    private JTextField myUriTextField;
    private JTextField myPrefixTextField;
    private JLabel myUriLabel;
    private JLabel myPrefixLabel;
    private boolean myUriWasTyped;
    private boolean myPrefixWasTyped;
    private WebModule myWebModule;

    TagLibUIManager() {
    }

    public void initValues(TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        if (panel.getSourceGroups() != null && panel.getSourceGroups().length > 0) {
            this.myWebModule = WebModule.getWebModule((FileObject)panel.getSourceGroups()[0].getRootFolder());
        }
    }

    public void changeUpdate(DocumentEvent e, TargetChooserPanel<FileType> panel) {
        if (!this.myUriWasTyped) {
            String norm = panel.getComponent().getNormalizedFolder();
            if (this.getWebModule() == null) {
                String pack = this.getPackageNameInMetaInf(panel);
                this.myUriTextField.setText((pack.length() > 0 ? pack + "." : "") + panel.getComponent().getDocumentName());
            } else {
                String selectedFolder = panel.getComponent().getSelectedFolder();
                if ("WEB-INF".equals(selectedFolder)) {
                    this.myUriTextField.setText("/" + selectedFolder + (norm.length() == 0 ? "" : "/" + norm) + "/" + panel.getComponent().getDocumentName());
                } else {
                    this.myUriTextField.setText((norm.length() == 0 ? "" : "/" + norm) + "/" + panel.getComponent().getDocumentName());
                }
            }
        }
        if (!this.myPrefixWasTyped) {
            this.myPrefixTextField.setText(panel.getComponent().getDocumentName().toLowerCase());
        }
    }

    public String getAccessibleDescription() {
        return "tag_library";
    }

    public String getErrorMessage(TargetChooserPanel<FileType> panel) {
        if (this.getWebModule() == null) {
            if (!panel.getComponent().getNormalizedFolder().startsWith(TLD_IN_JAVALIB_FOLDER)) {
                return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"NOTE_TLDInJavalib");
            }
        } else {
            boolean isWebInfLocation = panel.getComponent().getSelectedFolder().equals("WEB-INF");
            if (!panel.getComponent().getNormalizedFolder().startsWith("WEB-INF") && !isWebInfLocation) {
                return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"NOTE_TLDInWeb");
            }
        }
        if (this.getUri().length() == 0) {
            return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"MSG_missingUri");
        }
        if (this.getPrefix().length() == 0) {
            return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"MSG_missingPrefix");
        }
        return null;
    }

    public JPanel getOptionPanel() {
        return null;
    }

    public void initComponents(JPanel mainPanel, final TargetChooserPanel<FileType> panel, final TargetChooserPanelGUI<FileType> uiPanel) {
        this.myUriTextField = new JTextField();
        this.myUriTextField.setColumns(20);
        this.myPrefixTextField = new JTextField();
        this.myPrefixTextField.setColumns(5);
        this.myUriLabel = new JLabel(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"LBL_URI"));
        this.myUriLabel.setToolTipText(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TTT_URI"));
        this.myUriLabel.setLabelFor(this.myUriTextField);
        this.myUriLabel.setDisplayedMnemonic(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_URI_mnem").charAt(0));
        this.myUriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_DESC_URI"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagConstraints.anchor = 17;
        mainPanel.add((Component)this.myUriLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add((Component)this.myUriTextField, gridBagConstraints);
        this.myPrefixLabel = new JLabel(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"LBL_Prefix"));
        this.myPrefixLabel.setLabelFor(this.myPrefixTextField);
        this.myPrefixLabel.setToolTipText(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TTT_prefix"));
        this.myPrefixLabel.setDisplayedMnemonic(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_Prefix_mnem").charAt(0));
        this.myPrefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_DESC_Prefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        mainPanel.add((Component)this.myPrefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        mainPanel.add((Component)this.myPrefixTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 2.0;
        mainPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add((Component)new JPanel(), gridBagConstraints);
        this.myUriTextField.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ TagLibUIManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                this.this$0.myUriWasTyped = true;
                panel.fireChange();
            }
        });
        this.myPrefixTextField.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ TagLibUIManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                this.this$0.myPrefixWasTyped = true;
                panel.fireChange();
            }
        });
        uiPanel.setNameLabel(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"LBL_TldName"));
        uiPanel.addLocationListener(new ActionListener(){
            final /* synthetic */ TagLibUIManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                uiPanel.changedUpdate(null);
            }
        });
    }

    public void initFolderValue(TargetChooserPanel<FileType> panel, String target, JTextField field) {
        if (target != null && !target.startsWith(TLD_IN_JAVALIB_FOLDER)) {
            target = null;
        }
        if (this.getWebModule() == null) {
            field.setText("META-INF/");
        } else {
            field.setText("tlds/");
        }
    }

    public boolean isPanelValid() {
        return this.getUri().length() != 0 && this.getPrefix().length() != 0;
    }

    protected WebModule getWebModule() {
        return this.myWebModule;
    }

    String getUri() {
        if (this.myUriTextField == null) {
            return "";
        }
        return this.myUriTextField.getText();
    }

    String getPrefix() {
        if (this.myPrefixTextField == null) {
            return "";
        }
        return this.myPrefixTextField.getText();
    }

    private String getPackageNameInMetaInf(TargetChooserPanel<FileType> panel) {
        String pack = panel.getComponent().getRelativeTargetFolder();
        if (pack.startsWith(TLD_IN_JAVALIB_FOLDER)) {
            if ((pack = pack.substring(8)).length() == 0) {
                return "";
            }
            if (pack.startsWith("/")) {
                pack = pack.substring(1);
            }
        }
        if (pack.length() == 0) {
            return "";
        }
        pack = pack.replace('/', '.');
        return pack;
    }
}

