/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.modules.java.hints.spiimpl.SPIAccessor;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.pm.BulkSearch;
import org.netbeans.modules.java.hints.spiimpl.pm.PatternCompiler;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.Exceptions;

public class HintsInvoker {
    private static final Logger LOG = Logger.getLogger(HintsInvoker.class.getName());
    private final Map<String, Long> timeLog = new LinkedHashMap<String, Long>();
    private final HintsSettings settings;
    private final int caret;
    private final int from;
    private final int to;
    private final boolean bulkMode;
    private final AtomicBoolean cancel;
    private final Map<String, HintMetric> hint2SpentTime = new HashMap<String, HintMetric>();

    public HintsInvoker(HintsSettings settings, AtomicBoolean cancel) {
        this(settings, false, cancel);
    }

    public HintsInvoker(HintsSettings settings, boolean bulkMode, AtomicBoolean cancel) {
        this(settings, -1, -1, -1, bulkMode, cancel);
    }

    public HintsInvoker(HintsSettings settings, int caret, AtomicBoolean cancel) {
        this(settings, caret, -1, -1, false, cancel);
    }

    public HintsInvoker(HintsSettings settings, int from, int to, AtomicBoolean cancel) {
        this(settings, -1, from, to, false, cancel);
    }

    private HintsInvoker(HintsSettings settings, int caret, int from, int to, boolean bulkMode, AtomicBoolean cancel) {
        this.settings = settings;
        this.caret = caret;
        this.from = from;
        this.to = to;
        this.bulkMode = bulkMode;
        this.cancel = cancel;
    }

    @CheckForNull
    public List<ErrorDescription> computeHints(CompilationInfo info) {
        return this.computeHints(info, new TreePath(info.getCompilationUnit()));
    }

    private List<ErrorDescription> computeHints(CompilationInfo info, TreePath startAt) {
        LinkedList<? extends HintDescription> descs = new LinkedList<HintDescription>();
        Map<HintMetadata, ? extends Collection<? extends HintDescription>> allHints = RulesManager.getInstance().readHints(info, null, this.cancel);
        if (allHints == null || this.cancel.get()) {
            return null;
        }
        SourceVersion sourceLevel = info.getSourceVersion();
        for (Map.Entry<HintMetadata, ? extends Collection<? extends HintDescription>> e : allHints.entrySet()) {
            HintMetadata m = e.getKey();
            SourceVersion hintSourceLevel = m.sourceVersion;
            if (hintSourceLevel != null && sourceLevel.compareTo(hintSourceLevel) < 0 || !this.settings.isEnabled(m)) continue;
            if (this.caret != -1) {
                if (m.kind == Hint.Kind.ACTION) {
                    descs.addAll(e.getValue());
                    continue;
                }
                if (this.settings.getSeverity(m) != Severity.HINT) continue;
                descs.addAll(e.getValue());
                continue;
            }
            if (m.kind != Hint.Kind.INSPECTION || this.settings.getSeverity(m) == Severity.HINT) continue;
            descs.addAll(e.getValue());
        }
        List<ErrorDescription> errors = HintsInvoker.join(this.computeHints(info, startAt, descs, new ArrayList()));
        this.printHintMetrics();
        return errors;
    }

    @CheckForNull
    public List<ErrorDescription> computeHints(CompilationInfo info, Iterable<? extends HintDescription> hints) {
        return this.computeHints(info, hints, new LinkedList());
    }

    @CheckForNull
    public List<ErrorDescription> computeHints(CompilationInfo info, Iterable<? extends HintDescription> hints, Collection<? super MessageImpl> problems) {
        return HintsInvoker.join(this.computeHints(info, new TreePath(info.getCompilationUnit()), hints, problems));
    }

    @CheckForNull
    public Map<HintDescription, List<ErrorDescription>> computeHints(CompilationInfo info, TreePath startAt, Iterable<? extends HintDescription> hints, Collection<? super MessageImpl> problems) {
        return this.computeHints(info, startAt, true, hints, problems);
    }

    @CheckForNull
    public Map<HintDescription, List<ErrorDescription>> computeHints(CompilationInfo info, TreePath startAt, boolean recursive, Iterable<? extends HintDescription> hints, Collection<? super MessageImpl> problems) {
        Map<Class<?>, List<HintDescription>> triggerKind2Hints = Map.of(Trigger.Kinds.class, new ArrayList(), Trigger.PatternDescription.class, new ArrayList());
        SourceVersion srcVersion = info.getSourceVersion();
        for (HintDescription hintDescription : hints) {
            SourceVersion hVersion = hintDescription.getMetadata().sourceVersion;
            if (hVersion != null && srcVersion.compareTo(hVersion) < 0) continue;
            ((List)triggerKind2Hints.get(hintDescription.getTrigger().getClass())).add(hintDescription);
        }
        if (this.caret != -1) {
            TreePath tp = info.getTreeUtilities().pathFor(this.caret);
            return this.computeSuggestions(info, tp, true, triggerKind2Hints, problems);
        }
        if (this.from != -1 && this.to != -1) {
            return this.computeHintsInSpan(info, triggerKind2Hints, problems);
        }
        if (!recursive) {
            return this.computeSuggestions(info, startAt, false, triggerKind2Hints, problems);
        }
        return this.computeHintsImpl(info, startAt, triggerKind2Hints, problems);
    }

    private Map<HintDescription, List<ErrorDescription>> computeHintsImpl(CompilationInfo info, TreePath startAt, Map<Class<?>, List<HintDescription>> triggerKind2Hints, Collection<? super MessageImpl> problems) {
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        List<HintDescription> kindBasedHints = triggerKind2Hints.get(Trigger.Kinds.class);
        this.timeLog.put("[C] Kind Based Hints", Long.valueOf(kindBasedHints.size()));
        if (!kindBasedHints.isEmpty()) {
            long kindStart = System.currentTimeMillis();
            new ScannerImpl(info, this.cancel, HintsInvoker.sortByKinds(kindBasedHints)).scan(startAt, errors);
            long kindEnd = System.currentTimeMillis();
            this.timeLog.put("Kind Based Hints", kindEnd - kindStart);
        }
        if (this.cancel.get()) {
            return null;
        }
        List<HintDescription> patternBasedHints = triggerKind2Hints.get(Trigger.PatternDescription.class);
        this.timeLog.put("[C] Pattern Based Hints", Long.valueOf(patternBasedHints.size()));
        long patternStart = System.currentTimeMillis();
        Map<Trigger.PatternDescription, List<HintDescription>> patternHints = HintsInvoker.sortByPatterns(patternBasedHints);
        Map<String, List<Trigger.PatternDescription>> patternTests = HintsInvoker.computePatternTests(patternHints);
        long bulkPatternStart = System.currentTimeMillis();
        BulkSearch.BulkPattern bulkPattern = BulkSearch.getDefault().create(info, this.cancel, patternTests.keySet());
        if (bulkPattern == null || this.cancel.get()) {
            return null;
        }
        long bulkPatternEnd = System.currentTimeMillis();
        this.timeLog.put("Bulk Pattern preparation", bulkPatternEnd - bulkPatternStart);
        long bulkStart = System.currentTimeMillis();
        Map<String, Collection<TreePath>> occurringPatterns = BulkSearch.getDefault().match(info, this.cancel, startAt, bulkPattern, this.timeLog);
        if (occurringPatterns == null || this.cancel.get()) {
            return null;
        }
        long bulkEnd = System.currentTimeMillis();
        this.timeLog.put("Bulk Search", bulkEnd - bulkStart);
        Map<HintDescription, List<ErrorDescription>> computedHints = this.doComputeHints(info, occurringPatterns, patternTests, patternHints, problems);
        if (computedHints == null || this.cancel.get()) {
            return null;
        }
        HintsInvoker.mergeAll(errors, computedHints);
        long patternEnd = System.currentTimeMillis();
        this.timeLog.put("Pattern Based Hints", patternEnd - patternStart);
        return errors;
    }

    private Map<HintDescription, List<ErrorDescription>> computeHintsInSpan(CompilationInfo info, Map<Class<?>, List<HintDescription>> triggerKind2Hints, Collection<? super MessageImpl> problems) {
        List<HintDescription> patternBasedHints;
        TreePath path = info.getTreeUtilities().pathFor((this.from + this.to) / 2);
        while (path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), path.getLeaf());
            int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), path.getLeaf());
            if (start <= this.from && end >= this.to) break;
            path = path.getParentPath();
        }
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        List<HintDescription> kindBasedHints = triggerKind2Hints.get(Trigger.Kinds.class);
        if (!kindBasedHints.isEmpty()) {
            long kindStart = System.currentTimeMillis();
            new ScannerImpl(info, this.cancel, HintsInvoker.sortByKinds(kindBasedHints)).scan(path, errors);
            long kindEnd = System.currentTimeMillis();
            this.timeLog.put("Kind Based Hints", kindEnd - kindStart);
        }
        if (!(patternBasedHints = triggerKind2Hints.get(Trigger.PatternDescription.class)).isEmpty()) {
            long patternStart = System.currentTimeMillis();
            Map<Trigger.PatternDescription, List<HintDescription>> patternHints = HintsInvoker.sortByPatterns(patternBasedHints);
            Map<String, List<Trigger.PatternDescription>> patternTests = HintsInvoker.computePatternTests(patternHints);
            long bulkStart = System.currentTimeMillis();
            BulkSearch.BulkPattern bulkPattern = BulkSearch.getDefault().create(info, this.cancel, patternTests.keySet());
            if (bulkPattern == null || this.cancel.get()) {
                return null;
            }
            Map<String, Collection<TreePath>> occurringPatterns = BulkSearch.getDefault().match(info, this.cancel, path, bulkPattern, this.timeLog);
            if (occurringPatterns == null || this.cancel.get()) {
                return null;
            }
            long bulkEnd = System.currentTimeMillis();
            this.timeLog.put("Bulk Search", bulkEnd - bulkStart);
            Map<HintDescription, List<ErrorDescription>> computedHints = this.doComputeHints(info, occurringPatterns, patternTests, patternHints, problems);
            if (computedHints == null || this.cancel.get()) {
                return null;
            }
            HintsInvoker.mergeAll(errors, computedHints);
            long patternEnd = System.currentTimeMillis();
            this.timeLog.put("Pattern Based Hints", patternEnd - patternStart);
        }
        if (path != null) {
            Map<HintDescription, List<ErrorDescription>> suggestions = this.computeSuggestions(info, path, true, triggerKind2Hints, problems);
            if (suggestions == null || this.cancel.get()) {
                return null;
            }
            HintsInvoker.mergeAll(errors, suggestions);
        }
        return errors;
    }

    private Map<HintDescription, List<ErrorDescription>> computeSuggestions(CompilationInfo info, TreePath workOn, boolean up, Map<Class<?>, List<HintDescription>> triggerKind2Hints, Collection<? super MessageImpl> problems) {
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        List<HintDescription> kindBasedHints = triggerKind2Hints.get(Trigger.Kinds.class);
        if (!kindBasedHints.isEmpty()) {
            long kindStart = System.currentTimeMillis();
            Map<Tree.Kind, List<HintDescription>> hints = HintsInvoker.sortByKinds(kindBasedHints);
            for (TreePath proc = workOn; proc != null; proc = proc.getParentPath()) {
                new ScannerImpl(info, this.cancel, hints).scanDoNotGoDeeper(proc, errors);
                if (!up) break;
            }
            long kindEnd = System.currentTimeMillis();
            this.timeLog.put("Kind Based Suggestions", kindEnd - kindStart);
        }
        if (this.cancel.get()) {
            return null;
        }
        List<HintDescription> patternBasedHints = triggerKind2Hints.get(Trigger.PatternDescription.class);
        if (!patternBasedHints.isEmpty()) {
            long patternStart = System.currentTimeMillis();
            Map<Trigger.PatternDescription, List<HintDescription>> patternHints = HintsInvoker.sortByPatterns(patternBasedHints);
            Map<String, List<Trigger.PatternDescription>> patternTests = HintsInvoker.computePatternTests(patternHints);
            HashSet<TreePath> paths = new HashSet<TreePath>();
            for (TreePath tp = workOn; tp != null; tp = tp.getParentPath()) {
                paths.add(tp);
                if (!up) break;
            }
            HashMap<String, Collection<TreePath>> occurringPatterns = new HashMap<String, Collection<TreePath>>();
            for (String p : patternTests.keySet()) {
                occurringPatterns.put(p, paths);
            }
            Map<HintDescription, List<ErrorDescription>> computed = this.doComputeHints(info, occurringPatterns, patternTests, patternHints, problems);
            if (computed == null || this.cancel.get()) {
                return null;
            }
            HintsInvoker.mergeAll(errors, computed);
            long patternEnd = System.currentTimeMillis();
            this.timeLog.put("Pattern Based Hints", patternEnd - patternStart);
        }
        return errors;
    }

    public Map<HintDescription, List<ErrorDescription>> doComputeHints(CompilationInfo info, Map<String, Collection<TreePath>> occurringPatterns, Map<String, List<Trigger.PatternDescription>> patterns, Map<Trigger.PatternDescription, List<HintDescription>> patternHints) throws IllegalStateException {
        return this.doComputeHints(info, occurringPatterns, patterns, patternHints, new LinkedList());
    }

    private static Map<Tree.Kind, List<HintDescription>> sortByKinds(List<HintDescription> kindBasedHints) {
        EnumMap<Tree.Kind, List<HintDescription>> result = new EnumMap<Tree.Kind, List<HintDescription>>(Tree.Kind.class);
        for (HintDescription hd : kindBasedHints) {
            for (Tree.Kind kind : ((Trigger.Kinds)hd.getTrigger()).getKinds()) {
                result.computeIfAbsent(kind, l -> new LinkedList()).add(hd);
            }
        }
        return result;
    }

    private static Map<Trigger.PatternDescription, List<HintDescription>> sortByPatterns(List<HintDescription> kindBasedHints) {
        HashMap<Trigger.PatternDescription, List<HintDescription>> result = new HashMap<Trigger.PatternDescription, List<HintDescription>>();
        for (HintDescription hd : kindBasedHints) {
            result.computeIfAbsent((Trigger.PatternDescription)hd.getTrigger(), k -> new LinkedList()).add(hd);
        }
        return result;
    }

    public static Map<String, List<Trigger.PatternDescription>> computePatternTests(Map<Trigger.PatternDescription, List<HintDescription>> patternHints) {
        HashMap<String, List<Trigger.PatternDescription>> patternTests = new HashMap<String, List<Trigger.PatternDescription>>();
        for (Map.Entry<Trigger.PatternDescription, List<HintDescription>> e : patternHints.entrySet()) {
            String p = e.getKey().getPattern();
            patternTests.computeIfAbsent(p, k -> new LinkedList()).add(e.getKey());
        }
        return patternTests;
    }

    private Map<HintDescription, List<ErrorDescription>> doComputeHints(CompilationInfo info, Map<String, Collection<TreePath>> occurringPatterns, Map<String, List<Trigger.PatternDescription>> patterns, Map<Trigger.PatternDescription, List<HintDescription>> patternHints, Collection<? super MessageImpl> problems) throws IllegalStateException {
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        for (Map.Entry<String, Collection<TreePath>> occ : occurringPatterns.entrySet()) {
            block1: for (Trigger.PatternDescription d : patterns.get(occ.getKey())) {
                if (this.cancel.get()) {
                    return null;
                }
                HashMap<String, TypeMirror> constraints = new HashMap<String, TypeMirror>();
                for (Map.Entry<String, String> e : d.getConstraints().entrySet()) {
                    TypeMirror designedType = Hacks.parseFQNType(info, e.getValue());
                    if (designedType == null || designedType.getKind() == TypeKind.ERROR) continue block1;
                    constraints.put(e.getKey(), designedType);
                }
                Pattern pattern = PatternCompiler.compile(info, occ.getKey(), constraints, d.getImports());
                for (TreePath candidate : occ.getValue()) {
                    if (this.cancel.get()) {
                        return null;
                    }
                    Iterator verified = Matcher.create((CompilationInfo)info).setCancel(this.cancel).setSearchRoot(candidate).setTreeTopSearch().setKeepSyntheticTrees().match(pattern).iterator();
                    if (!verified.hasNext()) continue;
                    HashSet<? extends String> suppressedWarnings = new HashSet<String>(Utilities.findSuppressedWarnings(info, candidate));
                    Occurrence verifiedVariables = (Occurrence)verified.next();
                    boolean guarded = HintsInvoker.isInGuarded(info, candidate);
                    for (HintDescription hd : patternHints.get(d)) {
                        Collection<? extends ErrorDescription> workerErrors;
                        HintMetadata hm = hd.getMetadata();
                        if (guarded && !hd.getTrigger().hasOption("processGuarded")) continue;
                        HintContext c = SPIAccessor.getINSTANCE().createHintContext(info, this.settings, hm, candidate, verifiedVariables.getVariables(), verifiedVariables.getMultiVariables(), verifiedVariables.getVariables2Names(), constraints, problems, this.bulkMode, this.cancel, this.caret);
                        if (!Collections.disjoint(suppressedWarnings, hm.suppressWarnings) || (workerErrors = this.runHint(hd, c)) == null) continue;
                        HintsInvoker.merge(errors, hd, workerErrors);
                    }
                }
            }
        }
        return errors;
    }

    public Map<String, Long> getTimeLog() {
        return this.timeLog;
    }

    static boolean isInGuarded(CompilationInfo info, TreePath tree) {
        if (info == null) {
            return false;
        }
        try {
            Document doc = info.getDocument();
            if (doc instanceof GuardedDocument) {
                GuardedDocument gdoc = (GuardedDocument)doc;
                int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree.getLeaf());
                int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree.getLeaf());
                boolean[] ret = new boolean[]{false};
                gdoc.render(() -> {
                    MarkBlockChain guardedBlockChain = gdoc.getGuardedBlockChain();
                    if (guardedBlockChain.compareBlock(start, end) == 4129) {
                        ret[0] = true;
                    }
                });
                return ret[0];
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends ErrorDescription> runHint(HintDescription hd, HintContext ctx) {
        long start = System.nanoTime();
        try {
            Collection<? extends ErrorDescription> collection = hd.getWorker().createErrors(ctx);
            return collection;
        }
        finally {
            long end = System.nanoTime();
            this.reportSpentTime(hd.getMetadata().id, end - start);
        }
    }

    private static <K, V> void merge(Map<K, List<V>> to, K key, Collection<? extends V> value) {
        to.computeIfAbsent(key, k -> new LinkedList()).addAll(value);
    }

    private static <K, V> void mergeAll(Map<K, List<V>> to, Map<? extends K, ? extends Collection<? extends V>> what) {
        for (Map.Entry<K, Collection<V>> e : what.entrySet()) {
            to.computeIfAbsent(e.getKey(), k -> new LinkedList()).addAll(e.getValue());
        }
    }

    private static List<ErrorDescription> join(Map<?, ? extends List<? extends ErrorDescription>> errors) {
        if (errors == null) {
            return null;
        }
        LinkedList<ErrorDescription> result = new LinkedList<ErrorDescription>();
        for (Map.Entry<?, List<ErrorDescription>> e : errors.entrySet()) {
            result.addAll((Collection<ErrorDescription>)e.getValue());
        }
        return result;
    }

    private void reportSpentTime(String id, long nanoTime) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        HintMetric metric = this.hint2SpentTime.computeIfAbsent(id, k -> new HintMetric());
        ++metric.invocations;
        metric.time += nanoTime;
        metric.cancelled = this.cancel.get();
    }

    private void printHintMetrics() {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        this.hint2SpentTime.entrySet().stream().sorted((e1, e2) -> Long.compare(((HintMetric)e2.getValue()).time, ((HintMetric)e1.getValue()).time)).forEach(e -> LOG.fine(String.valueOf(e.getValue()) + ": " + (String)e.getKey()));
        LOG.fine("hint processing " + (this.cancel.get() ? "cancelled" : "complete"));
    }

    private final class ScannerImpl
    extends CancellableTreePathScanner<Void, Map<HintDescription, List<ErrorDescription>>> {
        private final Deque<Set<String>> suppresWarnings;
        private final CompilationInfo info;
        private final ProcessingEnvironment env;
        private final Map<Tree.Kind, List<HintDescription>> hints;

        public ScannerImpl(CompilationInfo info, AtomicBoolean cancel, Map<Tree.Kind, List<HintDescription>> hints) {
            super(cancel);
            this.suppresWarnings = new ArrayDeque<Set<String>>();
            this.info = info;
            this.env = null;
            this.hints = hints;
        }

        private void runAndAdd(TreePath path, List<HintDescription> rules, Map<HintDescription, List<ErrorDescription>> d) {
            if (rules != null) {
                boolean guarded = HintsInvoker.isInGuarded(this.info, path);
                block0: for (HintDescription hd : rules) {
                    if (this.isCanceled()) {
                        return;
                    }
                    if (guarded && !hd.getTrigger().hasOption("processGuarded")) continue;
                    HintMetadata hm = hd.getMetadata();
                    for (String string : hm.suppressWarnings) {
                        if (this.suppresWarnings.isEmpty() || !this.suppresWarnings.peek().contains(string)) continue;
                        continue block0;
                    }
                    HintContext c = SPIAccessor.getINSTANCE().createHintContext(this.info, HintsInvoker.this.settings, hm, path, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), new ArrayList(), HintsInvoker.this.bulkMode, HintsInvoker.this.cancel, HintsInvoker.this.caret);
                    Collection<? extends ErrorDescription> collection = HintsInvoker.this.runHint(hd, c);
                    if (collection == null) continue;
                    HintsInvoker.merge(d, hd, collection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void scan(Tree tree, Map<HintDescription, List<ErrorDescription>> p) {
            if (tree == null) {
                return null;
            }
            TreePath tp = new TreePath(this.getCurrentPath(), tree);
            Tree.Kind k = tree.getKind();
            boolean b = this.pushSuppressWarrnings(tp);
            try {
                this.runAndAdd(tp, this.hints.get((Object)k), p);
                if (this.isCanceled()) {
                    Void void_ = null;
                    return void_;
                }
                Void void_ = (Void)super.scan(tree, p);
                return void_;
            }
            finally {
                if (b) {
                    this.suppresWarnings.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void scan(TreePath path, Map<HintDescription, List<ErrorDescription>> p) {
            Tree.Kind k = path.getLeaf().getKind();
            boolean b = this.pushSuppressWarrnings(path);
            try {
                this.runAndAdd(path, this.hints.get((Object)k), p);
                if (this.isCanceled()) {
                    Void void_ = null;
                    return void_;
                }
                Void void_ = (Void)super.scan(path, p);
                return void_;
            }
            finally {
                if (b) {
                    this.suppresWarnings.pop();
                }
            }
        }

        public void scanDoNotGoDeeper(TreePath path, Map<HintDescription, List<ErrorDescription>> p) {
            Tree.Kind k = path.getLeaf().getKind();
            this.runAndAdd(path, this.hints.get((Object)k), p);
        }

        private boolean pushSuppressWarrnings(TreePath path) {
            switch (path.getLeaf().getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case METHOD: 
                case VARIABLE: {
                    Set<String> current = this.suppresWarnings.isEmpty() ? null : this.suppresWarnings.peek();
                    HashSet<String> nju = current == null ? new HashSet<String>() : new HashSet<String>(current);
                    Element e = this.getTrees().getElement(path);
                    if (e != null) {
                        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                            String name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                            if (!"java.lang.SuppressWarnings".equals(name)) continue;
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                                Iterator iterator;
                                if (!"value".equals(entry.getKey().getSimpleName().toString()) || !((iterator = entry.getValue().getValue()) instanceof List)) continue;
                                List list = (List)((Object)iterator);
                                iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    AnnotationValue av;
                                    Object object;
                                    Object obj = iterator.next();
                                    if (!(obj instanceof AnnotationValue) || !((object = (av = (AnnotationValue)obj).getValue()) instanceof String)) continue;
                                    String str = (String)object;
                                    nju.add(str);
                                }
                            }
                        }
                    }
                    this.suppresWarnings.push(nju);
                    return true;
                }
            }
            return false;
        }

        private Trees getTrees() {
            return this.info != null ? this.info.getTrees() : Trees.instance(this.env);
        }
    }

    private static final class HintMetric {
        private long time;
        private int invocations;
        private boolean cancelled;

        private HintMetric() {
        }

        public String toString() {
            return "{time=" + String.format("%3.2f", (double)this.time / 1000000.0) + "ms, invocations=" + this.invocations + ", cancelled=" + this.cancelled + "}";
        }
    }
}

