/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.spring.api.beans.SpringAnnotations;
import org.netbeans.modules.spring.beans.model.impl.Refreshable;
import org.netbeans.modules.spring.beans.model.impl.SpringBeanImpl;

class ObjectProviders {
    ObjectProviders() {
    }

    private static abstract class AbstractProvider<T extends Refreshable>
    implements ObjectProvider<T> {
        private Set<String> annotationTypeNames;
        private AnnotationModelHelper helper;

        AbstractProvider(AnnotationModelHelper helper, Set<String> annotationTypeNames) {
            this.annotationTypeNames = annotationTypeNames;
            this.helper = helper;
        }

        public List<T> createInitialObjects() throws InterruptedException {
            final LinkedList result = new LinkedList();
            for (String annotationName : this.getAnnotationTypeNames()) {
                this.helper.getAnnotationScanner().findAnnotations(annotationName, EnumSet.of(ElementKind.CLASS), new AnnotationHandler(){
                    final /* synthetic */ AbstractProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                        result.add(this.this$0.createObject(this.this$0.helper, type));
                    }
                });
            }
            return result;
        }

        public List<T> createObjects(TypeElement type) {
            ArrayList<T> result = new ArrayList<T>();
            if ((type.getKind() == ElementKind.CLASS || type.getKind() == ElementKind.INTERFACE) && this.helper.hasAnyAnnotation(type.getAnnotationMirrors(), this.getAnnotationTypeNames())) {
                result.add(this.createObject(this.helper, type));
            }
            return result;
        }

        public boolean modifyObjects(TypeElement type, List<T> objects) {
            boolean isModified = false;
            Iterator<T> it = objects.iterator();
            while (it.hasNext()) {
                Refreshable object = (Refreshable)it.next();
                if (object.refresh(type)) continue;
                it.remove();
                isModified = true;
            }
            return isModified;
        }

        abstract T createObject(AnnotationModelHelper var1, TypeElement var2);

        private Set<String> getAnnotationTypeNames() {
            return this.annotationTypeNames;
        }
    }

    static final class SpringBeanProvider
    extends AbstractProvider<SpringBeanImpl>
    implements ObjectProvider<SpringBeanImpl> {
        SpringBeanProvider(AnnotationModelHelper helper) {
            super(helper, SpringAnnotations.SPRING_COMPONENTS);
        }

        @Override
        public SpringBeanImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new SpringBeanImpl(helper, typeElement);
        }
    }
}

