/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.openide.util.ImageUtilities;

public final class Icons {
    private static final String ICON_BASE = "org/netbeans/modules/csl/source/resources/icons/";
    private static final String GIF_EXTENSION = ".gif";
    private static final String PNG_EXTENSION = ".png";
    private static final String WAIT = "org/netbeans/modules/csl/source/resources/icons/wait.png";

    private Icons() {
    }

    public static ImageIcon getElementIcon(ElementKind elementKind, Collection<Modifier> modifiers) {
        if (modifiers == null) {
            modifiers = Collections.emptyList();
        }
        Icon icon = null;
        switch (elementKind) {
            case FILE: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/emptyfile-icon.png");
                break;
            }
            case ERROR: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/error-glyph.gif");
                break;
            }
            case PACKAGE: 
            case MODULE: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/package.gif");
                break;
            }
            case TEST: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/test.png");
                break;
            }
            case CLASS: 
            case INTERFACE: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/class.png");
                break;
            }
            case TAG: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/html_element.png");
                break;
            }
            case RULE: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/rule.png");
                break;
            }
            case VARIABLE: 
            case PROPERTY: 
            case GLOBAL: 
            case ATTRIBUTE: 
            case FIELD: {
                icon = ImageUtilities.loadIcon((String)Icons.getIconName("org/netbeans/modules/csl/source/resources/icons/field", PNG_EXTENSION, modifiers));
                break;
            }
            case PARAMETER: 
            case CONSTANT: {
                icon = ImageUtilities.loadIcon((String)Icons.getIconName("org/netbeans/modules/csl/source/resources/icons/constant", PNG_EXTENSION, modifiers));
                if (icon != null) break;
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/constantPublic.png");
                break;
            }
            case CONSTRUCTOR: {
                icon = ImageUtilities.loadIcon((String)Icons.getIconName("org/netbeans/modules/csl/source/resources/icons/constructor", PNG_EXTENSION, modifiers));
                break;
            }
            case METHOD: {
                icon = ImageUtilities.loadIcon((String)Icons.getIconName("org/netbeans/modules/csl/source/resources/icons/method", PNG_EXTENSION, modifiers));
                break;
            }
            case DB: {
                icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/csl/source/resources/icons/database.gif");
                break;
            }
            default: {
                icon = null;
            }
        }
        return icon == null ? null : ImageUtilities.icon2ImageIcon((Icon)icon);
    }

    private static String getIconName(String typeName, String extension, Collection<Modifier> modifiers) {
        StringBuffer fileName = new StringBuffer(typeName);
        if (modifiers.contains(Modifier.STATIC)) {
            fileName.append("Static");
        }
        if (modifiers.contains(Modifier.PROTECTED)) {
            return fileName.append("Protected").append(extension).toString();
        }
        if (modifiers.contains(Modifier.PRIVATE)) {
            return fileName.append("Private").append(extension).toString();
        }
        return fileName.append("Public").append(extension).toString();
    }
}

